/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.api.telephony;

import android.os.Messenger;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.aosp.telephony.TranAospTelephonyManagerExt;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.core.telephony.TranThubTelephonyManagerExt;
import com.transsion.hubsdk.interfaces.telephony.ITranTelephonyManagerExtAdapter;

public class TranTelephonyManagerExt {
    private static final String TAG = TranTelephonyManagerExt.class.getSimpleName();
    private static ITranTelephonyManagerExtAdapter mService;
    private TranContext mTranContext;
    private static TranTelephonyManagerExt sInstance;

    public TranTelephonyManagerExt(TranContext tranContext) {
        this.mTranContext = tranContext;
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            mService = new TranThubTelephonyManagerExt();
            TranSdkLog.i((String)TAG, (String)"TranThubTelephonyManagerExt");
        } else {
            mService = new TranAospTelephonyManagerExt();
            TranSdkLog.i((String)TAG, (String)"TranAospTelephonyManagerExt");
        }
    }

    public static synchronized TranTelephonyManagerExt getDefault(TranContext tranContext) {
        if (sInstance == null) {
            sInstance = new TranTelephonyManagerExt(tranContext);
        }
        return sInstance;
    }

    public void sendNwAtCmd(int phoneId) {
        if (mService == null) {
            return;
        }
        mService.sendNwAtCmd(phoneId);
    }

    public void registerNwCallback(Messenger messenger) {
        if (mService == null) {
            return;
        }
        mService.registerNwCallback(messenger);
    }

    public void unregisterNwCallback() {
        if (mService == null) {
            return;
        }
        mService.unregisterNwCallback();
    }

    static {
        sInstance = null;
    }
}

