/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.bp;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.api.app.TranActivityManager;
import com.transsion.hubsdk.bp.ITranThubBp;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.trancare.trancare.TranTrancareManager;
import com.transsion.hubsdk.util.TranLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TranThubBpManager {
    private static final String TAG = TranThubBpManager.class.getSimpleName();
    private static TranContext mTranContext;
    private static ITranThubBp mService;
    private static final long EXCPC_TID = 933860000022L;
    private static final long EXCP_INFO_TID = 933861000041L;
    private static final String EXCP_INFO_TAG = "thub_excp_info";
    private static final int THUB_MP_VERSION = 1;
    private static final int STACK_COUNT = 10;
    private static final int MAX_EXCP_INFO_LEN = 2000;
    private static final String THUB_CORE_VERSION_KEY = "c_v";
    private static final String THUB_SDK_VERSION_KEY = "s_v";
    private static final String TRACE_TIMESTAMP_KEY = "s_t";
    private static final String TRACE_INFO_KEY = "t_i";
    private static ExecutorService mExecutorService;

    public TranThubBpManager(TranContext tranContext) {
        mTranContext = tranContext;
    }

    public static void recordException(TranContext context, String className, Throwable e) {
        if (!TranVersion.isIntegratedThubCore((String)"33101")) {
            TranLog.e((String)TAG, (String)"recordException fail, incompatible version");
            return;
        }
        if (!TranTrancareManager.isEnabled((long)933860000022L)) {
            TranLog.d((String)TAG, (String)"Thub-sdk thub_excpc(933860000022) is not enable!");
            return;
        }
        mExecutorService.submit(() -> {
            TranLog.d((String)TAG, (String)("Catch Thub-sdk Exception form " + className));
            boolean catchEnable = false;
            try {
                catchEnable = mService.recordExcp(className);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            TranLog.d((String)TAG, (String)("recordException.catchEnable=" + catchEnable));
            if (catchEnable) {
                long timestamp = System.currentTimeMillis();
                String sdkVersion = String.valueOf(33010105);
                String coreVersion = String.valueOf(TranVersion.THUBCORE_VERSION);
                String eStr = TranThubBpManager.localExceptionLog(e, className);
                TranLog.d((String)TAG, (String)(eStr.length() + " eStr=" + eStr));
                TranThubBpManager.trancareLog(coreVersion, sdkVersion, timestamp, eStr);
            }
            TranThubBpManager.tneLog(context);
        });
    }

    public static void recordException(String className, Throwable e) {
        if (!TranVersion.isIntegratedThubCore((String)"33101")) {
            TranLog.e((String)TAG, (String)"recordException fail, incompatible version");
            return;
        }
        if (!TranTrancareManager.isEnabled((long)933860000022L)) {
            TranLog.d((String)TAG, (String)"Thub-sdk thub_excpc(933860000022) is not enable!");
            return;
        }
        mExecutorService.submit(() -> {
            TranLog.d((String)TAG, (String)("Catch Thub-sdk Exception form " + className));
            boolean catchEnable = false;
            try {
                catchEnable = mService.recordExcp(className);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            TranLog.d((String)TAG, (String)("recordException.catchEnable=" + catchEnable));
            if (catchEnable) {
                long timestamp = System.currentTimeMillis();
                String sdkVersion = String.valueOf(33010105);
                String coreVersion = String.valueOf(TranVersion.THUBCORE_VERSION);
                String eStr = TranThubBpManager.localExceptionLog(e, className);
                TranLog.d((String)TAG, (String)(eStr.length() + " eStr=" + eStr));
                TranThubBpManager.trancareLog(coreVersion, sdkVersion, timestamp, eStr);
            }
        });
    }

    public static void recordTimeout(TranContext context, String className, long time) {
        if (!TranVersion.isIntegratedThubCore((String)"33101")) {
            TranLog.e((String)TAG, (String)"recordException fail, incompatible version");
            return;
        }
        if (!TranTrancareManager.isEnabled((long)933860000022L)) {
            TranLog.d((String)TAG, (String)"Thub-sdk thub_excpc(933860000022) is not enable!");
            return;
        }
        mExecutorService.submit(() -> {
            TranLog.d((String)TAG, (String)("Thub-sdk Timeout form " + className));
            boolean catchEnable = false;
            try {
                catchEnable = mService.recordTimeout(className);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            TranLog.d((String)TAG, (String)("recordTimeout.catchEnable=" + catchEnable));
            if (catchEnable) {
                long timestamp = System.currentTimeMillis();
                String sdkVersion = String.valueOf(33010105);
                String coreVersion = String.valueOf(TranVersion.THUBCORE_VERSION);
                String eStr = "TimeoutException:" + sdkVersion + " core:" + coreVersion + ", Timeout form " + className + "(" + time + ")" + TranThubBpManager.getStackTrace(new Throwable(), 10);
                if (eStr.length() > 2000) {
                    eStr = eStr.substring(0, 2000);
                }
                TranThubBpManager.trancareLog(coreVersion, sdkVersion, timestamp, eStr);
            }
            TranThubBpManager.tneLog(context);
        });
    }

    public static void recordTimeout(String className, long time) {
        if (!TranVersion.isIntegratedThubCore((String)"33101")) {
            TranLog.e((String)TAG, (String)"recordException fail, incompatible version");
            return;
        }
        if (!TranTrancareManager.isEnabled((long)933860000022L)) {
            TranLog.d((String)TAG, (String)"Thub-sdk thub_excpc(933860000022) is not enable!");
            return;
        }
        mExecutorService.submit(() -> {
            TranLog.d((String)TAG, (String)("Thub-sdk Timeout form " + className));
            boolean catchEnable = false;
            try {
                catchEnable = mService.recordTimeout(className);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            TranLog.d((String)TAG, (String)("recordTimeout.catchEnable=" + catchEnable));
            if (catchEnable) {
                long timestamp = System.currentTimeMillis();
                String sdkVersion = String.valueOf(33010105);
                String coreVersion = String.valueOf(TranVersion.THUBCORE_VERSION);
                String eStr = "TimeoutException:" + sdkVersion + " core:" + coreVersion + ", Timeout form " + className + "(" + time + ")" + TranThubBpManager.getStackTrace(new Throwable(), 10);
                if (eStr.length() > 2000) {
                    eStr = eStr.substring(0, 2000);
                }
                TranThubBpManager.trancareLog(coreVersion, sdkVersion, timestamp, eStr);
            }
        });
    }

    private static void trancareLog(String coreVersion, String sdkVersion, long timestamp, String eStr) {
        Bundle bundle = new Bundle();
        bundle.putString(THUB_CORE_VERSION_KEY, coreVersion);
        bundle.putString(THUB_SDK_VERSION_KEY, sdkVersion);
        bundle.putLong(TRACE_TIMESTAMP_KEY, timestamp);
        bundle.putString(TRACE_INFO_KEY, eStr);
        TranTrancareManager.serverLog((Long)933861000041L, (String)EXCP_INFO_TAG, (int)1, (Bundle)bundle);
    }

    private static void tneLog(TranContext context) {
        TranActivityManager tranActivityManager = new TranActivityManager(context);
        tranActivityManager.startTNE("0x01010001", 512L, Binder.getCallingPid(), "");
    }

    private static String localExceptionLog(Throwable throwable, String className) {
        StringBuilder sb = new StringBuilder();
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss", Locale.getDefault());
        String format = simpleDateFormat.format(date);
        String msg = TranThubBpManager.getExcpInfo(throwable);
        sb.append(format).append(" ").append(className).append(" ").append(msg).append("  \r\n");
        if (sb.length() > 2000) {
            return sb.substring(0, 2000);
        }
        return sb.toString();
    }

    private static String getExcpInfo(Throwable e) {
        StringBuffer buffer = null;
        if (e == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        buffer = stringWriter.getBuffer();
        printWriter.close();
        return buffer.toString();
    }

    private static String getStackTrace(Throwable throwable, int stackCount) {
        try {
            StackTraceElement[] ste = throwable.getStackTrace();
            StringBuilder message = new StringBuilder(throwable.toString());
            int i = 0;
            for (StackTraceElement element : ste) {
                message.append("\n#" + element.getClassName()).append(".").append(element.getMethodName()).append("[" + element.getLineNumber() + "]");
                if (++i >= stackCount) break;
            }
            return message.toString();
        }
        catch (Exception ex) {
            TranLog.w((String)TAG, (String)("getStackTrace Exception" + ex));
            return "";
        }
    }

    static {
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"thub_bp");
        mService = ITranThubBp.Stub.asInterface((IBinder)serviceIBinder);
        mExecutorService = Executors.newCachedThreadPool();
    }
}

