/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.core.net;

import android.os.IBinder;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.bp.TranTimeOutOrExceptionExecute;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.interfaces.net.ITranNetworkPolicyManagerAdapter;
import com.transsion.hubsdk.net.ITranNetworkPolicyManager;

public class TranThubNetworkPolicyManager
implements ITranNetworkPolicyManagerAdapter {
    private static final String TAG = TranThubNetworkPolicyManager.class.getSimpleName();
    private ITranNetworkPolicyManager mService;

    public TranThubNetworkPolicyManager() {
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"netpolicy");
        this.mService = ITranNetworkPolicyManager.Stub.asInterface((IBinder)serviceIBinder);
    }

    @Override
    public boolean getRestrictBackground() {
        boolean restrictBackground = (Boolean)new TranTimeOutOrExceptionExecute().exceptionRun(() -> {
            if (this.mService != null) {
                return this.mService.getRestrictBackground();
            }
            return false;
        }, "netpolicy");
        TranSdkLog.i((String)TAG, (String)("getRestrictBackground restrictBackground:" + restrictBackground));
        return restrictBackground;
    }

    @Override
    public int getUidPolicy(int uid) {
        int uidPolicy = (Integer)new TranTimeOutOrExceptionExecute().exceptionRun(() -> {
            if (this.mService != null) {
                return this.mService.getUidPolicy(uid);
            }
            return 0;
        }, "netpolicy");
        TranSdkLog.i((String)TAG, (String)("getUidPolicy uidPolicy:" + uidPolicy));
        return uidPolicy;
    }

    @Override
    public void setUidPolicy(int uid, int policy) {
        new TranTimeOutOrExceptionExecute().exceptionRun(() -> {
            if (this.mService != null) {
                this.mService.setUidPolicy(uid, policy);
            }
            return null;
        }, "netpolicy");
        TranSdkLog.i((String)TAG, (String)"setUidPolicy");
    }

    @Override
    public void setRestrictBackground(boolean restrictBackground) {
        new TranTimeOutOrExceptionExecute().exceptionRun(() -> {
            if (this.mService != null) {
                this.mService.setRestrictBackground(restrictBackground);
            }
            return null;
        }, "netpolicy");
        TranSdkLog.i((String)TAG, (String)"setRestrictBackground");
    }
}

