/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.core.os;

import android.os.IBinder;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.bp.TranTimeOutOrExceptionExecute;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.interfaces.os.ITranNvramServiceAdapter;
import com.transsion.hubsdk.os.ITranNvramService;
import java.util.List;

public class TranThubNvramManager
implements ITranNvramServiceAdapter {
    private static final String TAG = TranThubNvramManager.class.getSimpleName();
    private static ITranNvramService mService;
    private final TranContext mTranContext;

    public TranThubNvramManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        IBinder iBinder = TranServiceManager.getServiceIBinder((String)"nvram");
        mService = ITranNvramService.Stub.asInterface((IBinder)iBinder);
    }

    @Override
    public String readFileByName(String str, int i3) {
        String result = (String)new TranTimeOutOrExceptionExecute(this.mTranContext).timeOutAndExceptionRun(() -> {
            if (mService != null) {
                return mService.readFileByName(str, i3);
            }
            return 0;
        }, "nvram");
        TranSdkLog.i((String)TAG, (String)("readFileByName result:" + result));
        return result;
    }

    @Override
    public byte writeFileByNamevec(String str, int i3, List arrayList) {
        byte mByteData = (Byte)new TranTimeOutOrExceptionExecute(this.mTranContext).timeOutAndExceptionRun(() -> {
            if (mService != null) {
                return mService.writeFileByNamevec(str, i3, arrayList);
            }
            return 0;
        }, "nvram");
        TranSdkLog.i((String)TAG, (String)("writeFileByNamevec mByteData:" + mByteData));
        return mByteData;
    }
}

