/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.core.os.typeface;

import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.bp.TranTimeOutOrExceptionExecute;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.interfaces.os.typeface.ITranFontManagerAdapter;
import com.transsion.hubsdk.os.typeface.ITranFontManagerService;

public class TranThubFontManager
implements ITranFontManagerAdapter {
    private static final String TAG = TranThubFontManager.class.getSimpleName();
    private static ITranFontManagerService mService;
    private final TranContext mTranContext;

    public TranThubFontManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        IBinder iBinder = TranServiceManager.getServiceIBinder((String)"font");
        mService = ITranFontManagerService.Stub.asInterface((IBinder)iBinder);
    }

    @Override
    public int setDefaultTypeface(String fontPath, String hashCode) {
        int result = (Integer)new TranTimeOutOrExceptionExecute(this.mTranContext).timeOutAndExceptionRun(() -> {
            if (mService != null) {
                return mService.setDefaultTypeface(fontPath, hashCode);
            }
            return 0;
        }, "font");
        TranSdkLog.i((String)TAG, (String)("setDefaultTypeface result:" + result));
        return result;
    }

    @Override
    public int setDefaultTypefaceFromParcelFileDescriptor(ParcelFileDescriptor fontFD, String hashCode) {
        int result = (Integer)new TranTimeOutOrExceptionExecute(this.mTranContext).timeOutAndExceptionRun(() -> {
            if (mService != null) {
                return mService.setDefaultTypefaceFromParcelFileDescriptor(fontFD, hashCode);
            }
            return 0;
        }, "font");
        TranSdkLog.i((String)TAG, (String)("setDefaultTypefaceFromParcelFileDescriptor result:" + result));
        return result;
    }

    @Override
    public boolean bindFontManagerService() {
        boolean isBind = (Boolean)new TranTimeOutOrExceptionExecute(this.mTranContext).timeOutAndExceptionRun(() -> {
            if (mService != null) {
                return mService.bindFontManagerService();
            }
            return false;
        }, "font");
        TranSdkLog.i((String)TAG, (String)("bindFontManagerService isBind:" + isBind));
        return isBind;
    }

    @Override
    public void unbindFontManagerService() {
        new TranTimeOutOrExceptionExecute(this.mTranContext).timeOutAndExceptionRun(() -> {
            if (mService != null) {
                mService.unbindFontManagerService();
            }
            return null;
        }, "font");
    }
}

