/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.hardware.display;

import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.hardware.display.ITranColorDisplayManager;

public class TranColorDisplayManager {
    private static final String TAG = TranColorDisplayManager.class.getSimpleName();
    private ITranColorDisplayManager mService;
    private TranContext mTranContext;

    public TranColorDisplayManager(TranContext tranContext) {
        this.mTranContext = tranContext;
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"color_display");
        this.mService = ITranColorDisplayManager.Stub.asInterface((IBinder)serviceIBinder);
    }

    public boolean isNightDisplayActivated() {
        boolean nightDisplayActivated = false;
        try {
            nightDisplayActivated = this.mService.isNightDisplayActivated();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return nightDisplayActivated;
    }

    public boolean setNightDisplayActivated(boolean activated) {
        try {
            return this.mService.setNightDisplayActivated(activated);
        }
        catch (RemoteException e) {
            TranSdkLog.e((String)TAG, (String)("setNightDisplayActivated:" + (Object)((Object)e)));
            return false;
        }
    }
}

