/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.media;

import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.media.ITranAudioSystem;
import com.transsion.hubsdk.util.TranLog;

public class TranAudioSystem {
    private static final String TAG = TranAudioSystem.class.getSimpleName();
    private static ITranAudioSystem mService;
    private TranContext mTranContext;

    public TranAudioSystem(TranContext tranContext) {
        this.mTranContext = tranContext;
    }

    public static int getForceUse(int usage) {
        if (mService == null) {
            return 0;
        }
        try {
            int use = mService.getForceUse(usage);
            TranLog.e((String)TAG, (String)("use = " + use));
            return use;
        }
        catch (RemoteException e) {
            TranLog.e((String)TAG, (String)("getMethod:" + (Object)((Object)e)));
            return 0;
        }
    }

    public static String getOutputDeviceName(int device) {
        if (mService == null) {
            return "";
        }
        try {
            String deviceName = mService.getOutputDeviceName(device);
            TranLog.e((String)TAG, (String)("deviceName = " + deviceName));
            return deviceName;
        }
        catch (RemoteException e) {
            TranLog.e((String)TAG, (String)("getMethod:" + (Object)((Object)e)));
            return "";
        }
    }

    public static int setForceUse(int usage, int config) {
        if (mService == null) {
            return 0;
        }
        try {
            int result = mService.setForceUse(usage, config);
            TranLog.e((String)TAG, (String)("result = " + result));
            return result;
        }
        catch (RemoteException e) {
            TranLog.e((String)TAG, (String)("getMethod:" + (Object)((Object)e)));
            return 0;
        }
    }

    public static int setParameters(String keyValuePairs) {
        if (mService == null) {
            return 0;
        }
        try {
            int result = mService.setParameters(keyValuePairs);
            TranLog.e((String)TAG, (String)("result = " + result));
            return result;
        }
        catch (RemoteException e) {
            TranLog.e((String)TAG, (String)("getMethod:" + (Object)((Object)e)));
            return 0;
        }
    }

    static {
        IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"audio_system");
        mService = ITranAudioSystem.Stub.asInterface((IBinder)serviceIBinder);
    }
}

