/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.hubsdk.verifykey;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.hubsdk.TranContext;
import com.transsion.hubsdk.TranServiceManager;
import com.transsion.hubsdk.common.util.TranSdkLog;
import com.transsion.hubsdk.common.version.TranVersion;
import com.transsion.hubsdk.util.TranSignUtils;
import com.transsion.hubsdk.verifykey.ITranVerifyKeyManager;

public class TranVerifyKeyManager {
    private static final String TAG = TranVerifyKeyManager.class.getSimpleName();
    public static final int RESULT_ERROR_APP_NOT_VERIFY = -8;
    private static ITranVerifyKeyManager mService;
    private TranContext mTranContext;
    private static Binder mBinder;

    public TranVerifyKeyManager(TranContext tranContext) {
        this.mTranContext = tranContext;
    }

    public static int verify(Context context) {
        if (mService == null || context == null) {
            return -8;
        }
        String pkgName = context.getPackageName();
        String signValue = TranSignUtils.getCertSHA1((Context)context);
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(pkgName, 128);
            if (applicationInfo.metaData == null) {
                TranSdkLog.w((String)TAG, (String)"AppKey is null");
                return mService.verify((IBinder)mBinder, null, pkgName, signValue);
            }
            String appKey = applicationInfo.metaData.getString("com.transsion.appkey");
            return mService.verify((IBinder)mBinder, appKey, pkgName, signValue);
        }
        catch (PackageManager.NameNotFoundException | RemoteException e) {
            TranSdkLog.e((String)TAG, (String)("TranVerifyKeyManager verify Exception:" + e));
            return -8;
        }
    }

    static {
        mBinder = new Binder();
        if (TranVersion.isIntegratedThubCore((String)"33101")) {
            IBinder serviceIBinder = TranServiceManager.getServiceIBinder((String)"verify_key");
            mService = ITranVerifyKeyManager.Stub.asInterface((IBinder)serviceIBinder);
        }
    }
}

