/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.zero.ta.common.R;
import com.zero.ta.common.widget.CountDownTimer;

public class CountTimeView
extends View
implements View.OnClickListener {
    private Paint aQ;
    private Paint aR;
    private long aS = 6L;
    private CountDownTimer aT;
    private int aU;
    private String aV = "5s";
    private CountDownTimerListener aW;
    private Bitmap aX;
    private Rect rect = new Rect();

    public CountTimeView(Context context) {
        this(context, null);
    }

    public CountTimeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CountTimeView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setOnClickListener(this);
        this.aU = context.getResources().getDimensionPixelSize(R.dimen.skip_text_size);
        this.p();
    }

    private void p() {
        this.aQ = new Paint();
        this.aQ.setAntiAlias(true);
        this.aQ.setDither(true);
        this.aQ.setStyle(Paint.Style.FILL);
        this.aR = new Paint();
        this.aR.setAntiAlias(true);
        this.aR.setColor(-1);
        this.aR.setTextSize((float)this.aU);
        this.aR.setStrokeWidth(8.0f);
        this.aR.setTextAlign(Paint.Align.CENTER);
    }

    public void setStartTime(int n) {
        this.aS = (long)(n * 1000) + 400L;
        this.q();
    }

    public void setCountDownTimerListener(CountDownTimerListener countDownTimerListener) {
        this.aW = countDownTimerListener;
    }

    private void q() {
        this.aT = new CountDownTimer(this.aS, 1000L){

            @Override
            public void onTick(long l) {
                CountTimeView.this.aV = "SKIP " + l / 1000L;
                CountTimeView.this.invalidate();
            }

            @Override
            public void onFinish() {
                if (CountTimeView.this.aW != null) {
                    CountTimeView.this.aW.onFinish();
                }
            }
        };
    }

    public void start() {
        this.aT.start();
        if (this.aW != null) {
            this.aW.onStart();
        }
    }

    public void cancel() {
        if (this.aT != null) {
            this.aT.cancel();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.aV)) {
            if (this.aX == null) {
                this.aX = this.getBg();
            }
            Rect rect = new Rect(0, 0, this.aX.getWidth(), this.aX.getHeight());
            canvas.drawBitmap(this.aX, rect, rect, this.aQ);
            Paint.FontMetrics fontMetrics = this.aR.getFontMetrics();
            int n = (int)((float)(this.rect.bottom + this.rect.top) - fontMetrics.bottom - fontMetrics.top) / 2;
            canvas.drawText(this.aV, (float)this.rect.centerX(), (float)n, this.aR);
        }
    }

    private Bitmap getBg() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.skip_button);
        if (drawable2 instanceof BitmapDrawable) {
            this.aX = ((BitmapDrawable)drawable2).getBitmap();
        } else {
            this.aX = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.aX);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        return this.aX;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.rect.set(0, 0, this.getWidth(), this.getHeight());
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void onClick(View view) {
        if (this.aW != null) {
            this.aW.onClick();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.aT.start();
        if (this.aW != null) {
            this.aW.onStart();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.aT != null) {
            this.aT.cancel();
        }
    }

    public static interface CountDownTimerListener {
        public void onStart();

        public void onFinish();

        public void onClick();
    }
}

