/*
 * Decompiled with CFR 0.152.
 */
package com.zero.ta.common.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.zero.ta.common.R;
import com.zero.ta.common.widget.CountDownTimer;

public class CountTimeView
extends View
implements View.OnClickListener {
    private Paint aP;
    private Paint aQ;
    private long aR = 6L;
    private CountDownTimer aS;
    private int aT;
    private String aU = "5s";
    private CountDownTimerListener aV;
    private Bitmap aW;
    private Rect rect = new Rect();

    public CountTimeView(Context context) {
        this(context, null);
    }

    public CountTimeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CountTimeView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setOnClickListener(this);
        this.aT = context.getResources().getDimensionPixelSize(R.dimen.skip_text_size);
        this.p();
    }

    private void p() {
        this.aP = new Paint();
        this.aP.setAntiAlias(true);
        this.aP.setDither(true);
        this.aP.setStyle(Paint.Style.FILL);
        this.aQ = new Paint();
        this.aQ.setAntiAlias(true);
        this.aQ.setColor(-1);
        this.aQ.setTextSize((float)this.aT);
        this.aQ.setStrokeWidth(8.0f);
        this.aQ.setTextAlign(Paint.Align.CENTER);
    }

    public void setStartTime(int n) {
        this.aR = (long)(n * 1000) + 400L;
        this.q();
    }

    public void setCountDownTimerListener(CountDownTimerListener countDownTimerListener) {
        this.aV = countDownTimerListener;
    }

    private void q() {
        this.aS = new CountDownTimer(this.aR, 1000L){

            @Override
            public void onTick(long l) {
                CountTimeView.this.aU = "SKIP " + l / 1000L;
                CountTimeView.this.invalidate();
            }

            @Override
            public void onFinish() {
                if (CountTimeView.this.aV != null) {
                    CountTimeView.this.aV.onFinish();
                }
            }
        };
    }

    public void start() {
        this.aS.start();
        if (this.aV != null) {
            this.aV.onStart();
        }
    }

    public void cancel() {
        if (this.aS != null) {
            this.aS.cancel();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!TextUtils.isEmpty((CharSequence)this.aU)) {
            if (this.aW == null) {
                this.aW = this.getBg();
            }
            Rect rect = new Rect(0, 0, this.aW.getWidth(), this.aW.getHeight());
            canvas.drawBitmap(this.aW, rect, rect, this.aP);
            Paint.FontMetrics fontMetrics = this.aQ.getFontMetrics();
            int n = (int)((float)(this.rect.bottom + this.rect.top) - fontMetrics.bottom - fontMetrics.top) / 2;
            canvas.drawText(this.aU, (float)this.rect.centerX(), (float)n, this.aQ);
        }
    }

    private Bitmap getBg() {
        Drawable drawable2 = this.getResources().getDrawable(R.drawable.skip_button);
        if (drawable2 instanceof BitmapDrawable) {
            this.aW = ((BitmapDrawable)drawable2).getBitmap();
        } else {
            this.aW = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.aW);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        return this.aW;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.rect.set(0, 0, this.getWidth(), this.getHeight());
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void onClick(View view) {
        if (this.aV != null) {
            this.aV.onClick();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.aS.start();
        if (this.aV != null) {
            this.aV.onStart();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.aS != null) {
            this.aS.cancel();
        }
    }

    public static interface CountDownTimerListener {
        public void onStart();

        public void onFinish();

        public void onClick();
    }
}

