/*
 * Decompiled with CFR 0.152.
 */
package com.zero.tan.data.remote.bean.request;

import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import com.transsion.core.CoreUtil;
import com.zero.ta.common.util.AdLogUtil;
import java.util.List;

public class GPSTracker {
    private static final String TAG = "GPSTracker";
    private boolean isNetworkEnabled = false;
    private Location location;
    private static final int TYPE_GPS = 1;
    private static final int TYPE_NETWORK = 2;
    private static final int TYPE_OTHER = 3;
    private double latitude;
    private double longitude;
    private int accu = 0;
    private int type = 3;
    private String countryName = "";
    private String countryCode = "";
    private String adminArea = "";
    private String locality = "";
    private static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 0L;
    private static final long MIN_TIME_BW_UPDATES = 0L;
    protected LocationManager locationManager;

    public GPSTracker() {
        this.getLocation();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public int getAccu() {
        return this.accu;
    }

    public int getType() {
        return this.type;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getAdminArea() {
        return this.adminArea;
    }

    public String getLocality() {
        return this.locality;
    }

    public Location getLocation() {
        try {
            if (CoreUtil.getContext() == null) {
                return null;
            }
            this.locationManager = (LocationManager)CoreUtil.getContext().getSystemService("location");
            boolean bl = this.locationManager.isProviderEnabled("gps");
            this.isNetworkEnabled = this.locationManager.isProviderEnabled("network");
            if (!bl && !this.isNetworkEnabled) {
                this.type = 0;
            } else {
                boolean bl2 = true;
                if (bl) {
                    if (this.locationManager != null) {
                        this.location = this.locationManager.getLastKnownLocation("gps");
                    }
                    if (this.location != null) {
                        this.type = 1;
                    }
                }
                if (this.isNetworkEnabled) {
                    if (this.location == null) {
                        AdLogUtil.TAN.d((Object)"Positioning through the network");
                        if (this.locationManager != null) {
                            this.location = this.locationManager.getLastKnownLocation("network");
                        }
                    }
                    if (this.location != null) {
                        this.type = 2;
                    }
                }
            }
        }
        catch (Exception exception) {
            AdLogUtil.TAN.e((Object)exception.getMessage());
            AdLogUtil.TAN.e((Object)"Error : Location Impossible to connect to LocationManager");
        }
        if (this.location != null) {
            this.updateGPSCoordinates(this.location);
        }
        return this.location;
    }

    private void updateGPSCoordinates(Location location) {
        if (location != null) {
            this.latitude = location.getLatitude();
            this.longitude = location.getLongitude();
            this.accu = (int)location.getAccuracy();
        }
    }

    private void updateGeoCityLocation(Location location) {
        try {
            List list = null;
            Geocoder geocoder = new Geocoder(CoreUtil.getContext());
            list = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
            if (list != null && list.size() > 0) {
                Address address = (Address)list.get(0);
                this.adminArea = address.getAdminArea();
                this.countryCode = address.getCountryCode();
                this.countryName = address.getCountryName();
                this.locality = address.getLocality();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

