/*
 * Decompiled with CFR 0.152.
 */
package com.zero.tan.data.remote.bean.request;

import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import com.transsion.core.CoreUtil;
import com.zero.ta.common.util.AdLogUtil;
import java.util.List;

public class GPSTracker {
    public static final String TAG = "GPSTracker";
    public boolean isNetworkEnabled = false;
    public Location location;
    public static final int TYPE_GPS = 1;
    public static final int TYPE_NETWORK = 2;
    public static final int TYPE_OTHER = 3;
    public double latitude;
    public double longitude;
    public int accu = 0;
    public int type = 3;
    public String countryName = "";
    public String countryCode = "";
    public String adminArea = "";
    public String locality = "";
    public static final long MIN_DISTANCE_CHANGE_FOR_UPDATES = 0L;
    public static final long MIN_TIME_BW_UPDATES = 0L;
    protected LocationManager locationManager;

    public GPSTracker() {
        this.getLocation();
    }

    public Location getLocation() {
        try {
            if (CoreUtil.getContext() == null) {
                return null;
            }
            this.locationManager = (LocationManager)CoreUtil.getContext().getSystemService("location");
            boolean bl = this.locationManager.isProviderEnabled("gps");
            this.isNetworkEnabled = this.locationManager.isProviderEnabled("network");
            if (!bl && !this.isNetworkEnabled) {
                this.type = 0;
            } else {
                boolean bl2 = true;
                if (bl) {
                    if (this.locationManager != null) {
                        this.location = this.locationManager.getLastKnownLocation("gps");
                    }
                    if (this.location != null) {
                        this.type = 1;
                    }
                }
                if (this.isNetworkEnabled) {
                    if (this.location == null) {
                        AdLogUtil.TAN.d((Object)"Positioning through the network");
                        if (this.locationManager != null) {
                            this.location = this.locationManager.getLastKnownLocation("network");
                        }
                    }
                    if (this.location != null) {
                        this.type = 2;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            AdLogUtil.TAN.e((Object)throwable.getMessage());
            AdLogUtil.TAN.e((Object)"Error : Location Impossible to connect to LocationManager");
        }
        if (this.location != null) {
            this.updateGPSCoordinates(this.location);
        }
        return this.location;
    }

    public void updateGPSCoordinates(Location location) {
        if (location != null) {
            this.latitude = location.getLatitude();
            this.longitude = location.getLongitude();
            this.accu = (int)location.getAccuracy();
        }
    }

    public void updateGeoCityLocation(Location location) {
        try {
            List list = null;
            Geocoder geocoder = new Geocoder(CoreUtil.getContext());
            list = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
            if (list != null && list.size() > 0) {
                Address address = (Address)list.get(0);
                this.adminArea = address.getAdminArea();
                this.countryCode = address.getCountryCode();
                this.countryName = address.getCountryName();
                this.locality = address.getLocality();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

