/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer;

import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Handler;
import com.tencent.qgame.animplayer.AnimPlayer;
import com.tencent.qgame.animplayer.Decoder;
import com.tencent.qgame.animplayer.HandlerHolder;
import com.tencent.qgame.animplayer.file.IFileContainer;
import com.tencent.qgame.animplayer.util.ALog;
import com.tencent.qgame.animplayer.util.MediaUtil;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 92\u00020\u0001:\u00019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020&H\u0002J\b\u00102\u001a\u00020\u001cH\u0002J\b\u00103\u001a\u00020.H\u0002J\u000e\u00104\u001a\u00020.2\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020.2\u0006\u00105\u001a\u000206H\u0002J\u0006\u00108\u001a\u00020.R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001d\"\u0004\b!\u0010\u001fR\u001a\u0010\"\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001d\"\u0004\b$\u0010\u001fR\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006:"}, d2={"Lcom/tencent/qgame/animplayer/AudioPlayer;", "", "player", "Lcom/tencent/qgame/animplayer/AnimPlayer;", "(Lcom/tencent/qgame/animplayer/AnimPlayer;)V", "audioTrack", "Landroid/media/AudioTrack;", "getAudioTrack", "()Landroid/media/AudioTrack;", "setAudioTrack", "(Landroid/media/AudioTrack;)V", "decodeThread", "Lcom/tencent/qgame/animplayer/HandlerHolder;", "getDecodeThread", "()Lcom/tencent/qgame/animplayer/HandlerHolder;", "decoder", "Landroid/media/MediaCodec;", "getDecoder", "()Landroid/media/MediaCodec;", "setDecoder", "(Landroid/media/MediaCodec;)V", "extractor", "Landroid/media/MediaExtractor;", "getExtractor", "()Landroid/media/MediaExtractor;", "setExtractor", "(Landroid/media/MediaExtractor;)V", "isRunning", "", "()Z", "setRunning", "(Z)V", "isStopReq", "setStopReq", "needDestroy", "getNeedDestroy", "setNeedDestroy", "playLoop", "", "getPlayLoop", "()I", "setPlayLoop", "(I)V", "getPlayer", "()Lcom/tencent/qgame/animplayer/AnimPlayer;", "destroy", "", "destroyInner", "getChannelConfig", "channelCount", "prepareThread", "release", "start", "fileContainer", "Lcom/tencent/qgame/animplayer/file/IFileContainer;", "startPlay", "stop", "Companion", "animplayer_release"})
public final class AudioPlayer {
    @Nullable
    private MediaExtractor extractor;
    @Nullable
    private MediaCodec decoder;
    @Nullable
    private AudioTrack audioTrack;
    @NotNull
    private final HandlerHolder decodeThread;
    private boolean isRunning;
    private int playLoop;
    private boolean isStopReq;
    private boolean needDestroy;
    @NotNull
    private final AnimPlayer player;
    private static final String TAG = "AnimPlayer.AudioPlayer";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final MediaExtractor getExtractor() {
        return this.extractor;
    }

    public final void setExtractor(@Nullable MediaExtractor mediaExtractor) {
        this.extractor = mediaExtractor;
    }

    @Nullable
    public final MediaCodec getDecoder() {
        return this.decoder;
    }

    public final void setDecoder(@Nullable MediaCodec mediaCodec) {
        this.decoder = mediaCodec;
    }

    @Nullable
    public final AudioTrack getAudioTrack() {
        return this.audioTrack;
    }

    public final void setAudioTrack(@Nullable AudioTrack audioTrack) {
        this.audioTrack = audioTrack;
    }

    @NotNull
    public final HandlerHolder getDecodeThread() {
        return this.decodeThread;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    public final int getPlayLoop() {
        return this.playLoop;
    }

    public final void setPlayLoop(int n) {
        this.playLoop = n;
    }

    public final boolean isStopReq() {
        return this.isStopReq;
    }

    public final void setStopReq(boolean bl) {
        this.isStopReq = bl;
    }

    public final boolean getNeedDestroy() {
        return this.needDestroy;
    }

    public final void setNeedDestroy(boolean bl) {
        this.needDestroy = bl;
    }

    private final boolean prepareThread() {
        return Decoder.Companion.createThread(this.decodeThread, "anim_audio_thread");
    }

    public final void start(@NotNull IFileContainer fileContainer) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)fileContainer, (String)"fileContainer");
            this.isStopReq = false;
            this.needDestroy = false;
            if (!this.prepareThread()) {
                return;
            }
            if (this.isRunning) {
                this.stop();
            }
            this.isRunning = true;
            Handler handler = this.decodeThread.getHandler();
            if (handler == null) break block2;
            handler.post(new Runnable(this, fileContainer){
                final /* synthetic */ AudioPlayer this$0;
                final /* synthetic */ IFileContainer $fileContainer;

                public final void run() {
                    try {
                        AudioPlayer.access$startPlay(this.this$0, this.$fileContainer);
                    }
                    catch (Throwable e) {
                        ALog.INSTANCE.e("AnimPlayer.AudioPlayer", "Audio exception=" + e, e);
                        AudioPlayer.access$release(this.this$0);
                    }
                }
                {
                    this.this$0 = audioPlayer;
                    this.$fileContainer = iFileContainer;
                }
            });
        }
    }

    public final void stop() {
        this.isStopReq = true;
    }

    private final void startPlay(IFileContainer fileContainer) {
        AudioTrack audioTrack;
        MediaCodec decoder;
        MediaExtractor extractor;
        this.extractor = extractor = MediaUtil.INSTANCE.getExtractor(fileContainer);
        int audioIndex = MediaUtil.INSTANCE.selectAudioTrack(extractor);
        if (audioIndex < 0) {
            ALog.INSTANCE.e(TAG, "cannot find audio track");
            this.release();
            return;
        }
        extractor.selectTrack(audioIndex);
        MediaFormat format = extractor.getTrackFormat(audioIndex);
        String string = format.getString("mime");
        if (string == null) {
            string = "";
        }
        String mime = string;
        ALog.INSTANCE.i(TAG, "audio mime=" + mime);
        if (!MediaUtil.INSTANCE.checkSupportCodec(mime)) {
            ALog.INSTANCE.e(TAG, "mime=" + mime + " not support");
            this.release();
            return;
        }
        MediaCodec mediaCodec = MediaCodec.createDecoderByType((String)mime);
        boolean bl = false;
        boolean bl2 = false;
        MediaCodec $this$apply = mediaCodec;
        boolean bl3 = false;
        $this$apply.configure(format, null, null, 0);
        $this$apply.start();
        this.decoder = decoder = mediaCodec;
        MediaCodec mediaCodec2 = decoder;
        Intrinsics.checkExpressionValueIsNotNull((Object)mediaCodec2, (String)"decoder");
        ByteBuffer[] decodeInputBuffers = mediaCodec2.getInputBuffers();
        ByteBuffer[] decodeOutputBuffers = decoder.getOutputBuffers();
        MediaCodec.BufferInfo bufferInfo2 = new MediaCodec.BufferInfo();
        int sampleRate = format.getInteger("sample-rate");
        int channelConfig = this.getChannelConfig(format.getInteger("channel-count"));
        int bufferSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
        this.audioTrack = audioTrack = new AudioTrack(3, sampleRate, channelConfig, 2, bufferSize, 1);
        int state = audioTrack.getState();
        if (state != 1) {
            this.release();
            ALog.INSTANCE.e(TAG, "init audio track failure");
            return;
        }
        audioTrack.play();
        long timeOutUs = 1000L;
        boolean isEOS = false;
        while (!this.isStopReq) {
            int outputIndex;
            int inputIndex;
            if (!isEOS && (inputIndex = decoder.dequeueInputBuffer(timeOutUs)) >= 0) {
                ByteBuffer inputBuffer = decodeInputBuffers[inputIndex];
                inputBuffer.clear();
                int sampleSize = extractor.readSampleData(inputBuffer, 0);
                if (sampleSize < 0) {
                    isEOS = true;
                    decoder.queueInputBuffer(inputIndex, 0, 0, 0L, 4);
                } else {
                    decoder.queueInputBuffer(inputIndex, 0, sampleSize, 0L, 0);
                    extractor.advance();
                }
            }
            if ((outputIndex = decoder.dequeueOutputBuffer(bufferInfo2, 0L)) == -2) {
                decodeOutputBuffers = decoder.getOutputBuffers();
            }
            if (outputIndex >= 0) {
                ByteBuffer outputBuffer = decodeOutputBuffers[outputIndex];
                byte[] chunkPCM = new byte[bufferInfo2.size];
                outputBuffer.get(chunkPCM);
                outputBuffer.clear();
                audioTrack.write(chunkPCM, 0, bufferInfo2.size);
                decoder.releaseOutputBuffer(outputIndex, false);
            }
            if (!isEOS || (bufferInfo2.flags & 4) == 0) continue;
            AudioPlayer audioPlayer = this;
            audioPlayer.playLoop += -1;
            if (audioPlayer.playLoop > 0) {
                ALog.INSTANCE.d(TAG, "Reached EOS, looping -> playLoop");
                extractor.seekTo(0L, 2);
                decoder.flush();
                isEOS = false;
                continue;
            }
            ALog.INSTANCE.i(TAG, "decode finish");
            this.release();
            break;
        }
        this.release();
    }

    private final void release() {
        try {
            MediaCodec $this$apply;
            boolean bl;
            boolean bl2;
            MediaCodec mediaCodec;
            MediaCodec mediaCodec2 = this.decoder;
            if (mediaCodec2 != null) {
                mediaCodec = mediaCodec2;
                bl2 = false;
                bl = false;
                $this$apply = mediaCodec;
                boolean bl3 = false;
                $this$apply.stop();
                $this$apply.release();
            }
            this.decoder = null;
            MediaExtractor mediaExtractor = this.extractor;
            if (mediaExtractor != null) {
                mediaExtractor.release();
            }
            this.extractor = null;
            AudioTrack audioTrack = this.audioTrack;
            if (audioTrack != null) {
                mediaCodec = audioTrack;
                bl2 = false;
                bl = false;
                $this$apply = mediaCodec;
                boolean bl4 = false;
                $this$apply.pause();
                $this$apply.flush();
                $this$apply.stop();
                $this$apply.release();
            }
            this.audioTrack = null;
        }
        catch (Throwable e) {
            ALog.INSTANCE.e(TAG, "release exception=" + e, e);
        }
        this.isRunning = false;
        if (this.needDestroy) {
            this.destroyInner();
        }
    }

    public final void destroy() {
        if (this.isRunning) {
            this.needDestroy = true;
            this.stop();
        } else {
            this.destroyInner();
        }
    }

    private final void destroyInner() {
        if (this.player.isDetachedFromWindow()) {
            ALog.INSTANCE.i(TAG, "destroyThread");
            Handler handler = this.decodeThread.getHandler();
            if (handler != null) {
                handler.removeCallbacksAndMessages(null);
            }
            this.decodeThread.setThread(Decoder.Companion.quitSafely(this.decodeThread.getThread()));
        }
    }

    private final int getChannelConfig(int channelCount) {
        int n;
        switch (channelCount) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 12;
                break;
            }
            case 3: {
                n = 28;
                break;
            }
            case 4: {
                n = 204;
                break;
            }
            case 5: {
                n = 220;
                break;
            }
            case 6: {
                n = 252;
                break;
            }
            case 7: {
                n = 1276;
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("Unsupported channel count: " + channelCount);
            }
        }
        return n;
    }

    @NotNull
    public final AnimPlayer getPlayer() {
        return this.player;
    }

    public AudioPlayer(@NotNull AnimPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.player = player;
        this.decodeThread = new HandlerHolder(null, null);
    }

    public static final /* synthetic */ void access$startPlay(AudioPlayer $this, IFileContainer fileContainer) {
        $this.startPlay(fileContainer);
    }

    public static final /* synthetic */ void access$release(AudioPlayer $this) {
        $this.release();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/AudioPlayer$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

