/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.view.Surface;
import com.tencent.qgame.animplayer.AnimPlayer;
import com.tencent.qgame.animplayer.Decoder;
import com.tencent.qgame.animplayer.HardDecoder;
import com.tencent.qgame.animplayer.IRenderListener;
import com.tencent.qgame.animplayer.file.IFileContainer;
import com.tencent.qgame.animplayer.util.ALog;
import com.tencent.qgame.animplayer.util.MediaUtil;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\r\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0012\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0016J\u001c\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\b\u0010$\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J@\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u0007H\u0002J\u0018\u00105\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u00106\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/tencent/qgame/animplayer/HardDecoder;", "Lcom/tencent/qgame/animplayer/Decoder;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "player", "Lcom/tencent/qgame/animplayer/AnimPlayer;", "(Lcom/tencent/qgame/animplayer/AnimPlayer;)V", "alignHeight", "", "alignWidth", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "getBufferInfo", "()Landroid/media/MediaCodec$BufferInfo;", "bufferInfo$delegate", "Lkotlin/Lazy;", "glTexture", "Landroid/graphics/SurfaceTexture;", "needDestroy", "", "needYUV", "outputFormat", "Landroid/media/MediaFormat;", "surface", "Landroid/view/Surface;", "videoHeight", "videoWidth", "destroy", "", "destroyInner", "onFrameAvailable", "surfaceTexture", "release", "decoder", "Landroid/media/MediaCodec;", "extractor", "Landroid/media/MediaExtractor;", "renderData", "start", "fileContainer", "Lcom/tencent/qgame/animplayer/file/IFileContainer;", "startDecode", "startPlay", "yuv420spTop", "", "yuv420sp", "yuvCopy", "src", "srcOffset", "inWidth", "inHeight", "dest", "outWidth", "outHeight", "yuvProcess", "outputIndex", "Companion", "animplayer_release"})
public final class HardDecoder
extends Decoder
implements SurfaceTexture.OnFrameAvailableListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private Surface surface;
    private SurfaceTexture glTexture;
    private final Lazy bufferInfo$delegate;
    private boolean needDestroy;
    private int videoWidth;
    private int videoHeight;
    private int alignWidth;
    private int alignHeight;
    private boolean needYUV;
    private MediaFormat outputFormat;
    private static final String TAG = "AnimPlayer.HardDecoder";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HardDecoder.class), "bufferInfo", "getBufferInfo()Landroid/media/MediaCodec$BufferInfo;"))};
        Companion = new Companion(null);
    }

    private final MediaCodec.BufferInfo getBufferInfo() {
        Lazy lazy = this.bufferInfo$delegate;
        HardDecoder hardDecoder = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (MediaCodec.BufferInfo)lazy.getValue();
    }

    @Override
    public void start(@NotNull IFileContainer fileContainer) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)fileContainer, (String)"fileContainer");
            this.setStopReq(false);
            this.needDestroy = false;
            this.setRunning(true);
            Handler handler = this.getRenderThread().getHandler();
            if (handler == null) break block0;
            handler.post(new Runnable(this, fileContainer){
                final /* synthetic */ HardDecoder this$0;
                final /* synthetic */ IFileContainer $fileContainer;

                public final void run() {
                    HardDecoder.access$startPlay(this.this$0, this.$fileContainer);
                }
                {
                    this.this$0 = hardDecoder;
                    this.$fileContainer = iFileContainer;
                }
            });
        }
    }

    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        if (this.isStopReq()) {
            return;
        }
        ALog.INSTANCE.d(TAG, "onFrameAvailable");
        this.renderData();
    }

    private final void renderData() {
        block0: {
            Handler handler = this.getRenderThread().getHandler();
            if (handler == null) break block0;
            handler.post(new Runnable(this){
                final /* synthetic */ HardDecoder this$0;

                public final void run() {
                    try {
                        SurfaceTexture surfaceTexture = HardDecoder.access$getGlTexture$p(this.this$0);
                        if (surfaceTexture != null) {
                            SurfaceTexture surfaceTexture2 = surfaceTexture;
                            boolean bl = false;
                            boolean bl2 = false;
                            SurfaceTexture $this$apply = surfaceTexture2;
                            boolean bl3 = false;
                            $this$apply.updateTexImage();
                            IRenderListener iRenderListener = this.this$0.getRender();
                            if (iRenderListener != null) {
                                iRenderListener.renderFrame();
                            }
                            this.this$0.getPlayer().getPluginManager().onRendering();
                            IRenderListener iRenderListener2 = this.this$0.getRender();
                            if (iRenderListener2 != null) {
                                iRenderListener2.swapBuffers();
                            }
                        }
                    }
                    catch (Throwable e) {
                        ALog.INSTANCE.e("AnimPlayer.HardDecoder", "render exception=" + e, e);
                    }
                }
                {
                    this.this$0 = hardDecoder;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startPlay(IFileContainer fileContainer) {
        void decoder;
        boolean bl;
        void format;
        void extractor;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        int trackIndex = 0;
        try {
            extractor.element = MediaUtil.INSTANCE.getExtractor(fileContainer);
            trackIndex = MediaUtil.INSTANCE.selectVideoTrack((MediaExtractor)extractor.element);
            if (trackIndex < 0) {
                throw (Throwable)new RuntimeException("No video track found");
            }
            ((MediaExtractor)extractor.element).selectTrack(trackIndex);
            format.element = ((MediaExtractor)extractor.element).getTrackFormat(trackIndex);
            if ((MediaFormat)format.element == null) {
                throw (Throwable)new RuntimeException("format is null");
            }
            if (MediaUtil.INSTANCE.checkIsHevc((MediaFormat)format.element) && (Build.VERSION.SDK_INT < 21 || !MediaUtil.INSTANCE.checkSupportCodec("video/hevc"))) {
                this.onFailed(10008, "0x8 hevc not support " + "sdk:" + Build.VERSION.SDK_INT + ",support hevc:" + MediaUtil.INSTANCE.checkSupportCodec("video/hevc"));
                this.release(null, null);
                return;
            }
            this.videoWidth = ((MediaFormat)format.element).getInteger("width");
            this.videoHeight = ((MediaFormat)format.element).getInteger("height");
            this.alignWidth = this.videoWidth;
            this.alignHeight = this.videoHeight;
            ALog.INSTANCE.i(TAG, "Video size is " + this.videoWidth + " x " + this.videoHeight);
            this.needYUV = this.videoWidth % 16 != 0 && this.getPlayer().getEnableVersion1();
            try {
                if (!this.prepareRender(this.needYUV)) {
                    throw (Throwable)new RuntimeException("render create fail");
                }
            }
            catch (Throwable t) {
                this.onFailed(10004, "0x4 render create fail e=" + t);
                this.release(null, null);
                return;
            }
            this.preparePlay(this.videoWidth, this.videoHeight);
            IRenderListener iRenderListener = this.getRender();
            if (iRenderListener != null) {
                SurfaceTexture surfaceTexture;
                IRenderListener t = iRenderListener;
                boolean bl2 = false;
                bl = false;
                IRenderListener $this$apply = t;
                boolean bl3 = false;
                SurfaceTexture surfaceTexture2 = new SurfaceTexture($this$apply.getExternalTexture());
                HardDecoder hardDecoder = this;
                boolean bl4 = false;
                boolean bl5 = false;
                SurfaceTexture $this$apply2 = surfaceTexture2;
                boolean bl6 = false;
                $this$apply2.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
                $this$apply2.setDefaultBufferSize(this.videoWidth, this.videoHeight);
                hardDecoder.glTexture = surfaceTexture = surfaceTexture2;
                $this$apply.clearFrame();
            }
        }
        catch (Throwable e) {
            ALog.INSTANCE.e(TAG, "MediaExtractor exception e=" + e, e);
            this.onFailed(10001, "0x1 MediaExtractor exception e=" + e);
            this.release((MediaCodec)decoder.element, (MediaExtractor)extractor.element);
            return;
        }
        try {
            String string = ((MediaFormat)format.element).getString("mime");
            if (string == null) {
                string = "";
            }
            String mime = string;
            ALog.INSTANCE.i(TAG, "Video MIME is " + mime);
            MediaCodec mediaCodec = MediaCodec.createDecoderByType((String)mime);
            void var18_25 = decoder;
            bl = false;
            boolean bl7 = false;
            MediaCodec $this$apply = mediaCodec;
            boolean bl8 = false;
            if (this.needYUV) {
                ((MediaFormat)format.element).setInteger("color-format", 19);
                $this$apply.configure((MediaFormat)format.element, null, null, 0);
            } else {
                this.surface = new Surface(this.glTexture);
                $this$apply.configure((MediaFormat)format.element, this.surface, null, 0);
            }
            $this$apply.start();
            Handler handler = this.getDecodeThread().getHandler();
            if (handler != null) {
                handler.post(new Runnable($this$apply, this, (Ref.ObjectRef)format, (Ref.ObjectRef)extractor, (Ref.ObjectRef)decoder){
                    final /* synthetic */ MediaCodec $this_apply;
                    final /* synthetic */ HardDecoder this$0;
                    final /* synthetic */ Ref.ObjectRef $format$inlined;
                    final /* synthetic */ Ref.ObjectRef $extractor$inlined;
                    final /* synthetic */ Ref.ObjectRef $decoder$inlined;
                    {
                        this.$this_apply = mediaCodec;
                        this.this$0 = hardDecoder;
                        this.$format$inlined = objectRef;
                        this.$extractor$inlined = objectRef2;
                        this.$decoder$inlined = objectRef3;
                    }

                    public final void run() {
                        try {
                            MediaExtractor mediaExtractor = (MediaExtractor)this.$extractor$inlined.element;
                            MediaCodec mediaCodec = this.$this_apply;
                            Intrinsics.checkExpressionValueIsNotNull((Object)mediaCodec, (String)"this");
                            HardDecoder.access$startDecode(this.this$0, mediaExtractor, mediaCodec);
                        }
                        catch (Throwable e) {
                            ALog.INSTANCE.e("AnimPlayer.HardDecoder", "MediaCodec exception e=" + e, e);
                            this.this$0.onFailed(10002, "0x2 MediaCodec exception e=" + e);
                            HardDecoder.access$release(this.this$0, (MediaCodec)this.$decoder$inlined.element, (MediaExtractor)this.$extractor$inlined.element);
                        }
                    }
                });
            }
            MediaCodec mediaCodec2 = mediaCodec;
            var18_25.element = mediaCodec2;
        }
        catch (Throwable e) {
            ALog.INSTANCE.e(TAG, "MediaCodec configure exception e=" + e, e);
            this.onFailed(10002, "0x2 MediaCodec exception e=" + e);
            this.release((MediaCodec)decoder.element, (MediaExtractor)extractor.element);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startDecode(MediaExtractor extractor, MediaCodec decoder) {
        long TIMEOUT_USEC = 10000L;
        int inputChunk = 0;
        boolean outputDone = false;
        boolean inputDone = false;
        int frameIndex = 0;
        boolean isLoop = false;
        ByteBuffer[] decoderInputBuffers = decoder.getInputBuffers();
        while (!outputDone) {
            boolean doRender;
            int chunkSize;
            ByteBuffer inputBuf;
            if (this.isStopReq()) {
                ALog.INSTANCE.i(TAG, "stop decode");
                this.release(decoder, extractor);
                return;
            }
            if (!inputDone) {
                int inputBufIndex = decoder.dequeueInputBuffer(TIMEOUT_USEC);
                if (inputBufIndex >= 0) {
                    inputBuf = decoderInputBuffers[inputBufIndex];
                    chunkSize = extractor.readSampleData(inputBuf, 0);
                    if (chunkSize < 0) {
                        decoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                        inputDone = true;
                        ALog.INSTANCE.d(TAG, "decode EOS");
                    } else {
                        long presentationTimeUs = extractor.getSampleTime();
                        decoder.queueInputBuffer(inputBufIndex, 0, chunkSize, presentationTimeUs, 0);
                        ALog.INSTANCE.d(TAG, "submitted frame " + inputChunk + " to dec, size=" + chunkSize);
                        ++inputChunk;
                        extractor.advance();
                    }
                } else {
                    ALog.INSTANCE.d(TAG, "input buffer not available");
                }
            }
            if (outputDone) continue;
            int decoderStatus = decoder.dequeueOutputBuffer(this.getBufferInfo(), TIMEOUT_USEC);
            if (decoderStatus == -1) {
                ALog.INSTANCE.d(TAG, "no output from decoder available");
                continue;
            }
            if (decoderStatus == -3) {
                ALog.INSTANCE.d(TAG, "decoder output buffers changed");
                continue;
            }
            if (decoderStatus == -2) {
                this.outputFormat = decoder.getOutputFormat();
                if (this.outputFormat != null) {
                    chunkSize = 0;
                    boolean bl = false;
                    ByteBuffer $this$apply = inputBuf;
                    boolean bl2 = false;
                    try {
                        int stride = $this$apply.getInteger("stride");
                        int sliceHeight = $this$apply.getInteger("slice-height");
                        if (stride > 0 && sliceHeight > 0) {
                            this.alignWidth = stride;
                            this.alignHeight = sliceHeight;
                        }
                    }
                    catch (Throwable t) {
                        ALog.INSTANCE.e(TAG, String.valueOf(t), t);
                    }
                }
                ALog.INSTANCE.i(TAG, "decoder output format changed: " + this.outputFormat);
                continue;
            }
            if (decoderStatus < 0) {
                throw (Throwable)new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
            }
            int loop = 0;
            if ((this.getBufferInfo().flags & 4) != 0) {
                HardDecoder hardDecoder = this;
                hardDecoder.setPlayLoop(hardDecoder.getPlayLoop() + -1);
                loop = hardDecoder.getPlayLoop();
                this.getPlayer().setPlayLoop(this.getPlayLoop());
                outputDone = this.getPlayLoop() <= 0;
            }
            boolean bl = doRender = !outputDone;
            if (doRender) {
                this.getSpeedControlUtil().preRender(this.getBufferInfo().presentationTimeUs);
            }
            if (this.needYUV && doRender) {
                this.yuvProcess(decoder, decoderStatus);
            }
            decoder.releaseOutputBuffer(decoderStatus, doRender && !this.needYUV);
            if (frameIndex == 0 && !isLoop) {
                this.onVideoStart();
            }
            this.getPlayer().getPluginManager().onDecoding(frameIndex);
            this.onVideoRender(frameIndex, this.getPlayer().getConfigManager().getConfig());
            ALog.INSTANCE.d(TAG, "decode frameIndex=" + ++frameIndex);
            if (loop > 0) {
                ALog.INSTANCE.d(TAG, "Reached EOD, looping");
                this.getPlayer().getPluginManager().onLoopStart();
                extractor.seekTo(0L, 2);
                inputDone = false;
                decoder.flush();
                this.getSpeedControlUtil().reset();
                frameIndex = 0;
                isLoop = true;
            }
            if (!outputDone) continue;
            this.release(decoder, extractor);
        }
        return;
    }

    private final void yuvProcess(MediaCodec decoder, int outputIndex) {
        block4: {
            ByteBuffer outputBuffer;
            ByteBuffer byteBuffer = outputBuffer = decoder.getOutputBuffers()[outputIndex];
            if (byteBuffer == null) break block4;
            ByteBuffer byteBuffer2 = byteBuffer;
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer it = byteBuffer2;
            boolean bl3 = false;
            it.position(0);
            it.limit(this.getBufferInfo().offset + this.getBufferInfo().size);
            byte[] yuvData = new byte[outputBuffer.remaining()];
            outputBuffer.get(yuvData);
            byte[] byArray = yuvData;
            boolean bl4 = false;
            byte[] byArray2 = byArray;
            boolean bl5 = false;
            if (!(byArray2.length == 0)) {
                byte[] yData = new byte[this.videoWidth * this.videoHeight];
                byte[] uData = new byte[this.videoWidth * this.videoHeight / 4];
                byte[] vData = new byte[this.videoWidth * this.videoHeight / 4];
                MediaFormat mediaFormat = this.outputFormat;
                if (mediaFormat != null) {
                    if (mediaFormat.getInteger("color-format") == 21) {
                        yuvData = this.yuv420spTop(yuvData);
                    }
                }
                this.yuvCopy(yuvData, 0, this.alignWidth, this.alignHeight, yData, this.videoWidth, this.videoHeight);
                this.yuvCopy(yuvData, this.alignWidth * this.alignHeight, this.alignWidth / 2, this.alignHeight / 2, uData, this.videoWidth / 2, this.videoHeight / 2);
                this.yuvCopy(yuvData, this.alignWidth * this.alignHeight * 5 / 4, this.alignWidth / 2, this.alignHeight / 2, vData, this.videoWidth / 2, this.videoHeight / 2);
                IRenderListener iRenderListener = this.getRender();
                if (iRenderListener != null) {
                    iRenderListener.setYUVData(this.videoWidth, this.videoHeight, yData, uData, vData);
                }
                this.renderData();
            }
        }
    }

    private final byte[] yuv420spTop(byte[] yuv420sp) {
        byte[] yuv420p = new byte[yuv420sp.length];
        int ySize = this.alignWidth * this.alignHeight;
        System.arraycopy(yuv420sp, 0, yuv420p, 0, this.alignWidth * this.alignHeight);
        int i = ySize;
        int j = ySize;
        while (i < ySize * 3 / 2) {
            yuv420p[j] = yuv420sp[i];
            yuv420p[j + ySize / 4] = yuv420sp[i + 1];
            i += 2;
            ++j;
        }
        return yuv420p;
    }

    /*
     * WARNING - void declaration
     */
    private final void yuvCopy(byte[] src, int srcOffset, int inWidth, int inHeight, byte[] dest, int outWidth, int outHeight) {
        int n = 0;
        int n2 = inHeight;
        while (n < n2) {
            void h;
            if (h < outHeight) {
                System.arraycopy(src, srcOffset + h * inWidth, dest, (int)(h * outWidth), outWidth);
            }
            ++h;
        }
    }

    private final void release(MediaCodec decoder, MediaExtractor extractor) {
        block0: {
            Handler handler = this.getRenderThread().getHandler();
            if (handler == null) break block0;
            handler.post(new Runnable(this, decoder, extractor){
                final /* synthetic */ HardDecoder this$0;
                final /* synthetic */ MediaCodec $decoder;
                final /* synthetic */ MediaExtractor $extractor;

                public final void run() {
                    if (this.this$0.getPlayer().getAutoDismiss()) {
                        IRenderListener iRenderListener = this.this$0.getRender();
                        if (iRenderListener != null) {
                            iRenderListener.clearFrame();
                        }
                    }
                    try {
                        ALog.INSTANCE.i("AnimPlayer.HardDecoder", "release");
                        MediaCodec mediaCodec = this.$decoder;
                        if (mediaCodec != null) {
                            MediaCodec mediaCodec2 = mediaCodec;
                            boolean bl = false;
                            boolean bl2 = false;
                            MediaCodec $this$apply = mediaCodec2;
                            boolean bl3 = false;
                            $this$apply.stop();
                            $this$apply.release();
                        }
                        MediaExtractor mediaExtractor = this.$extractor;
                        if (mediaExtractor != null) {
                            mediaExtractor.release();
                        }
                        SurfaceTexture surfaceTexture = HardDecoder.access$getGlTexture$p(this.this$0);
                        if (surfaceTexture != null) {
                            surfaceTexture.release();
                        }
                        HardDecoder.access$setGlTexture$p(this.this$0, null);
                        this.this$0.getSpeedControlUtil().reset();
                        this.this$0.getPlayer().getPluginManager().onRelease();
                        IRenderListener iRenderListener = this.this$0.getRender();
                        if (iRenderListener != null) {
                            iRenderListener.releaseTexture();
                        }
                        Surface surface = HardDecoder.access$getSurface$p(this.this$0);
                        if (surface != null) {
                            surface.release();
                        }
                        HardDecoder.access$setSurface$p(this.this$0, null);
                    }
                    catch (Throwable e) {
                        ALog.INSTANCE.e("AnimPlayer.HardDecoder", "release e=" + e, e);
                    }
                    this.this$0.setRunning(false);
                    this.this$0.onVideoComplete();
                    if (HardDecoder.access$getNeedDestroy$p(this.this$0)) {
                        HardDecoder.access$destroyInner(this.this$0);
                    }
                }
                {
                    this.this$0 = hardDecoder;
                    this.$decoder = mediaCodec;
                    this.$extractor = mediaExtractor;
                }
            });
        }
    }

    @Override
    public void destroy() {
        if (this.isRunning()) {
            this.needDestroy = true;
            this.stop();
        } else {
            this.destroyInner();
        }
    }

    private final void destroyInner() {
        block0: {
            ALog.INSTANCE.i(TAG, "destroyInner");
            Handler handler = this.getRenderThread().getHandler();
            if (handler == null) break block0;
            handler.post(new Runnable(this){
                final /* synthetic */ HardDecoder this$0;

                public final void run() {
                    this.this$0.getPlayer().getPluginManager().onDestroy();
                    IRenderListener iRenderListener = this.this$0.getRender();
                    if (iRenderListener != null) {
                        iRenderListener.destroyRender();
                    }
                    this.this$0.setRender(null);
                    this.this$0.onVideoDestroy();
                    this.this$0.destroyThread();
                }
                {
                    this.this$0 = hardDecoder;
                }
            });
        }
    }

    public HardDecoder(@NotNull AnimPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        super(player);
        this.bufferInfo$delegate = LazyKt.lazy((Function0)bufferInfo.2.INSTANCE);
    }

    public static final /* synthetic */ void access$startPlay(HardDecoder $this, IFileContainer fileContainer) {
        $this.startPlay(fileContainer);
    }

    public static final /* synthetic */ SurfaceTexture access$getGlTexture$p(HardDecoder $this) {
        return $this.glTexture;
    }

    public static final /* synthetic */ void access$setGlTexture$p(HardDecoder $this, SurfaceTexture surfaceTexture) {
        $this.glTexture = surfaceTexture;
    }

    public static final /* synthetic */ void access$startDecode(HardDecoder $this, MediaExtractor extractor, MediaCodec decoder) {
        $this.startDecode(extractor, decoder);
    }

    public static final /* synthetic */ void access$release(HardDecoder $this, MediaCodec decoder, MediaExtractor extractor) {
        $this.release(decoder, extractor);
    }

    public static final /* synthetic */ Surface access$getSurface$p(HardDecoder $this) {
        return $this.surface;
    }

    public static final /* synthetic */ void access$setSurface$p(HardDecoder $this, Surface surface) {
        $this.surface = surface;
    }

    public static final /* synthetic */ boolean access$getNeedDestroy$p(HardDecoder $this) {
        return $this.needDestroy;
    }

    public static final /* synthetic */ void access$setNeedDestroy$p(HardDecoder $this, boolean bl) {
        $this.needDestroy = bl;
    }

    public static final /* synthetic */ void access$destroyInner(HardDecoder $this) {
        $this.destroyInner();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/HardDecoder$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

