/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer.mix;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.SparseArray;
import android.view.MotionEvent;
import com.tencent.qgame.animplayer.AnimConfig;
import com.tencent.qgame.animplayer.AnimPlayer;
import com.tencent.qgame.animplayer.inter.IFetchResource;
import com.tencent.qgame.animplayer.inter.OnResourceClickListener;
import com.tencent.qgame.animplayer.mix.Frame;
import com.tencent.qgame.animplayer.mix.FrameAll;
import com.tencent.qgame.animplayer.mix.FrameSet;
import com.tencent.qgame.animplayer.mix.MixAnimPlugin$WhenMappings;
import com.tencent.qgame.animplayer.mix.MixRender;
import com.tencent.qgame.animplayer.mix.MixTouch;
import com.tencent.qgame.animplayer.mix.Resource;
import com.tencent.qgame.animplayer.mix.Src;
import com.tencent.qgame.animplayer.mix.SrcMap;
import com.tencent.qgame.animplayer.plugin.IAnimPlugin;
import com.tencent.qgame.animplayer.util.ALog;
import com.tencent.qgame.animplayer.util.BitmapUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 J2\u00020\u0001:\u0001JB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00107\u001a\u00020\u0006H\u0002J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000209H\u0002J\b\u0010;\u001a\u000209H\u0002J\u0010\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020>H\u0016J\b\u0010?\u001a\u000209H\u0016J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u000209H\u0016J\b\u0010D\u001a\u000209H\u0016J\u0010\u0010E\u001a\u0002092\u0006\u0010F\u001a\u00020\fH\u0016J\u0010\u0010G\u001a\u0002092\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010H\u001a\u0002092\u0006\u0010=\u001a\u00020>H\u0002J\b\u0010I\u001a\u000209H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00101\u001a\u0004\u0018\u000102X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u0006K"}, d2={"Lcom/tencent/qgame/animplayer/mix/MixAnimPlugin;", "Lcom/tencent/qgame/animplayer/plugin/IAnimPlugin;", "player", "Lcom/tencent/qgame/animplayer/AnimPlayer;", "(Lcom/tencent/qgame/animplayer/AnimPlayer;)V", "autoTxtColorFill", "", "getAutoTxtColorFill", "()Z", "setAutoTxtColorFill", "(Z)V", "curFrameIndex", "", "getCurFrameIndex", "()I", "setCurFrameIndex", "(I)V", "forceStopLock", "frameAll", "Lcom/tencent/qgame/animplayer/mix/FrameAll;", "getFrameAll", "()Lcom/tencent/qgame/animplayer/mix/FrameAll;", "setFrameAll", "(Lcom/tencent/qgame/animplayer/mix/FrameAll;)V", "lock", "Ljava/lang/Object;", "mixRender", "Lcom/tencent/qgame/animplayer/mix/MixRender;", "mixTouch", "Lcom/tencent/qgame/animplayer/mix/MixTouch;", "getMixTouch", "()Lcom/tencent/qgame/animplayer/mix/MixTouch;", "mixTouch$delegate", "Lkotlin/Lazy;", "getPlayer", "()Lcom/tencent/qgame/animplayer/AnimPlayer;", "resourceClickListener", "Lcom/tencent/qgame/animplayer/inter/OnResourceClickListener;", "getResourceClickListener", "()Lcom/tencent/qgame/animplayer/inter/OnResourceClickListener;", "setResourceClickListener", "(Lcom/tencent/qgame/animplayer/inter/OnResourceClickListener;)V", "resourceRequest", "Lcom/tencent/qgame/animplayer/inter/IFetchResource;", "getResourceRequest", "()Lcom/tencent/qgame/animplayer/inter/IFetchResource;", "setResourceRequest", "(Lcom/tencent/qgame/animplayer/inter/IFetchResource;)V", "resultCbCount", "srcMap", "Lcom/tencent/qgame/animplayer/mix/SrcMap;", "getSrcMap", "()Lcom/tencent/qgame/animplayer/mix/SrcMap;", "setSrcMap", "(Lcom/tencent/qgame/animplayer/mix/SrcMap;)V", "createBitmap", "destroy", "", "fetchResourceSync", "forceStopLockThread", "onConfigCreate", "config", "Lcom/tencent/qgame/animplayer/AnimConfig;", "onDestroy", "onDispatchTouchEvent", "ev", "Landroid/view/MotionEvent;", "onRelease", "onRenderCreate", "onRendering", "frameIndex", "parseFrame", "parseSrc", "resultCall", "Companion", "animplayer_release"})
public final class MixAnimPlugin
implements IAnimPlugin {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private IFetchResource resourceRequest;
    @Nullable
    private OnResourceClickListener resourceClickListener;
    @Nullable
    private SrcMap srcMap;
    @Nullable
    private FrameAll frameAll;
    private int curFrameIndex;
    private int resultCbCount;
    private MixRender mixRender;
    private final Lazy mixTouch$delegate;
    private boolean autoTxtColorFill;
    private final Object lock;
    private boolean forceStopLock;
    @NotNull
    private final AnimPlayer player;
    private static final String TAG = "AnimPlayer.MixAnimPlugin";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MixAnimPlugin.class), "mixTouch", "getMixTouch()Lcom/tencent/qgame/animplayer/mix/MixTouch;"))};
        Companion = new Companion(null);
    }

    @Nullable
    public final IFetchResource getResourceRequest() {
        return this.resourceRequest;
    }

    public final void setResourceRequest(@Nullable IFetchResource iFetchResource) {
        this.resourceRequest = iFetchResource;
    }

    @Nullable
    public final OnResourceClickListener getResourceClickListener() {
        return this.resourceClickListener;
    }

    public final void setResourceClickListener(@Nullable OnResourceClickListener onResourceClickListener) {
        this.resourceClickListener = onResourceClickListener;
    }

    @Nullable
    public final SrcMap getSrcMap() {
        return this.srcMap;
    }

    public final void setSrcMap(@Nullable SrcMap srcMap) {
        this.srcMap = srcMap;
    }

    @Nullable
    public final FrameAll getFrameAll() {
        return this.frameAll;
    }

    public final void setFrameAll(@Nullable FrameAll frameAll) {
        this.frameAll = frameAll;
    }

    public final int getCurFrameIndex() {
        return this.curFrameIndex;
    }

    public final void setCurFrameIndex(int n) {
        this.curFrameIndex = n;
    }

    private final MixTouch getMixTouch() {
        Lazy lazy = this.mixTouch$delegate;
        MixAnimPlugin mixAnimPlugin = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (MixTouch)lazy.getValue();
    }

    public final boolean getAutoTxtColorFill() {
        return this.autoTxtColorFill;
    }

    public final void setAutoTxtColorFill(boolean bl) {
        this.autoTxtColorFill = bl;
    }

    @Override
    public int onConfigCreate(@NotNull AnimConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        if (!config.isMix()) {
            return 0;
        }
        if (this.resourceRequest == null) {
            ALog.INSTANCE.e(TAG, "IFetchResource is empty");
            return 0;
        }
        this.parseSrc(config);
        this.parseFrame(config);
        this.fetchResourceSync();
        boolean result = this.createBitmap();
        if (!result) {
            return 10006;
        }
        ALog.INSTANCE.i(TAG, "load resource " + this.resultCbCount);
        Object object = this.srcMap;
        if (object != null && (object = ((SrcMap)object).getMap()) != null && (object = ((HashMap)object).values()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Src it = (Src)element$iv;
                boolean bl = false;
                if (it.getBitmap() == null) {
                    ALog.INSTANCE.e(TAG, "missing src " + it);
                    return 10006;
                }
                Bitmap bitmap = it.getBitmap();
                if ((bitmap != null ? bitmap.getConfig() : null) != Bitmap.Config.ALPHA_8) continue;
                ALog.INSTANCE.e(TAG, "src " + it + " bitmap must not be ALPHA_8");
                return 10006;
            }
        }
        return 0;
    }

    @Override
    public void onRenderCreate() {
        block2: {
            AnimConfig animConfig = this.player.getConfigManager().getConfig();
            if (animConfig != null) {
                if (!animConfig.isMix()) {
                    return;
                }
            }
            ALog.INSTANCE.i(TAG, "mix render init");
            MixRender mixRender = this.mixRender = new MixRender(this);
            if (mixRender == null) break block2;
            mixRender.init();
        }
    }

    @Override
    public void onRendering(int frameIndex) {
        AnimConfig animConfig = this.player.getConfigManager().getConfig();
        if (animConfig == null) {
            return;
        }
        AnimConfig config = animConfig;
        if (!config.isMix()) {
            return;
        }
        this.curFrameIndex = frameIndex;
        Object object = this.frameAll;
        if (object == null || (object = ((FrameAll)object).getMap()) == null || (object = (FrameSet)object.get(frameIndex)) == null || (object = ((FrameSet)object).getList()) == null) {
            return;
        }
        Object list = object;
        Iterable $this$forEach$iv = (Iterable)list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Frame frame = (Frame)element$iv;
            boolean bl = false;
            Object object2 = this.srcMap;
            if (object2 == null || (object2 = ((SrcMap)object2).getMap()) == null || (object2 = (Src)((HashMap)object2).get(frame.getSrcId())) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"srcMap?.map?.get(frame.srcId) ?: return@forEach");
            Object src = object2;
            MixRender mixRender = this.mixRender;
            if (mixRender == null) continue;
            mixRender.renderFrame(config, frame, (Src)src);
        }
    }

    @Override
    public void onRelease() {
        this.destroy();
    }

    @Override
    public void onDestroy() {
        this.destroy();
    }

    @Override
    public boolean onDispatchTouchEvent(@NotNull MotionEvent ev) {
        block4: {
            block3: {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
                    AnimConfig animConfig = this.player.getConfigManager().getConfig();
                    if (animConfig != null && !animConfig.isMix()) break block2;
                    if (this.resourceClickListener != null) break block3;
                }
                return IAnimPlugin.DefaultImpls.onDispatchTouchEvent(this, ev);
            }
            Resource resource = this.getMixTouch().onTouchEvent(ev);
            if (resource == null) break block4;
            Resource resource2 = resource;
            boolean bl = false;
            boolean bl2 = false;
            Resource resource3 = resource2;
            boolean bl3 = false;
            new Handler(Looper.getMainLooper()).post(new Runnable(resource3, this){
                final /* synthetic */ Resource $resource;
                final /* synthetic */ MixAnimPlugin this$0;
                {
                    this.$resource = resource;
                    this.this$0 = mixAnimPlugin;
                }

                public final void run() {
                    block0: {
                        OnResourceClickListener onResourceClickListener = this.this$0.getResourceClickListener();
                        if (onResourceClickListener == null) break block0;
                        onResourceClickListener.onClick(this.$resource);
                    }
                }
            });
        }
        return true;
    }

    private final void destroy() {
        block11: {
            SparseArray<FrameSet> sparseArray;
            this.forceStopLockThread();
            AnimConfig animConfig = this.player.getConfigManager().getConfig();
            if (animConfig != null) {
                if (!animConfig.isMix()) {
                    return;
                }
            }
            ArrayList<Resource> resources = new ArrayList<Resource>();
            Object object = this.srcMap;
            if (object != null && (object = ((SrcMap)object).getMap()) != null && (object = ((HashMap)object).values()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Src src = (Src)element$iv;
                    boolean bl = false;
                    MixRender mixRender = this.mixRender;
                    if (mixRender != null) {
                        mixRender.release(src.getSrcTextureId());
                    }
                    switch (MixAnimPlugin$WhenMappings.$EnumSwitchMapping$0[src.getSrcType().ordinal()]) {
                        case 1: {
                            Src src2 = src;
                            Intrinsics.checkExpressionValueIsNotNull((Object)src2, (String)"src");
                            resources.add(new Resource(src2));
                            break;
                        }
                        case 2: {
                            Bitmap bitmap = src.getBitmap();
                            if (bitmap == null) break;
                            bitmap.recycle();
                            break;
                        }
                    }
                }
            }
            IFetchResource iFetchResource = this.resourceRequest;
            if (iFetchResource != null) {
                iFetchResource.releaseResource((List<Resource>)resources);
            }
            this.curFrameIndex = -1;
            Object object2 = this.srcMap;
            if (object2 != null && (object2 = ((SrcMap)object2).getMap()) != null) {
                ((HashMap)object2).clear();
            }
            if ((sparseArray = this.frameAll) == null || (sparseArray = sparseArray.getMap()) == null) break block11;
            sparseArray.clear();
        }
    }

    private final void parseSrc(AnimConfig config) {
        block0: {
            JSONObject jSONObject = config.getJsonConfig();
            if (jSONObject == null) break block0;
            JSONObject jSONObject2 = jSONObject;
            boolean bl = false;
            boolean bl2 = false;
            JSONObject $this$apply = jSONObject2;
            boolean bl3 = false;
            this.srcMap = new SrcMap($this$apply);
        }
    }

    private final void parseFrame(AnimConfig config) {
        block0: {
            JSONObject jSONObject = config.getJsonConfig();
            if (jSONObject == null) break block0;
            JSONObject jSONObject2 = jSONObject;
            boolean bl = false;
            boolean bl2 = false;
            JSONObject $this$apply = jSONObject2;
            boolean bl3 = false;
            this.frameAll = new FrameAll($this$apply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fetchResourceSync() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.forceStopLock = false;
            Unit unit = Unit.INSTANCE;
        }
        long time = SystemClock.elapsedRealtime();
        Object object2 = this.srcMap;
        int totalSrc = object2 != null && (object2 = ((SrcMap)object2).getMap()) != null ? ((HashMap)object2).size() : 0;
        ALog.INSTANCE.i(TAG, "load resource totalSrc = " + totalSrc);
        this.resultCbCount = 0;
        Object object3 = this.srcMap;
        if (object3 != null && (object3 = ((SrcMap)object3).getMap()) != null && (object3 = ((HashMap)object3).values()) != null) {
            Iterable $this$forEach$iv = (Iterable)object3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Src src = (Src)element$iv;
                boolean bl4 = false;
                if (src.getSrcType() == Src.SrcType.IMG) {
                    ALog.INSTANCE.i(TAG, "fetch image " + src.getSrcId());
                    IFetchResource iFetchResource = this.resourceRequest;
                    if (iFetchResource != null) {
                        Src src2 = src;
                        Intrinsics.checkExpressionValueIsNotNull((Object)src2, (String)"src");
                        iFetchResource.fetchImage(new Resource(src2), (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(src, this){
                            final /* synthetic */ Src $src;
                            final /* synthetic */ MixAnimPlugin this$0;
                            {
                                this.$src = src;
                                this.this$0 = mixAnimPlugin;
                                super(1);
                            }

                            public final void invoke(@Nullable Bitmap it) {
                                Bitmap bitmap;
                                if (it == null) {
                                    ALog.INSTANCE.e("AnimPlayer.MixAnimPlugin", "fetch image " + this.$src.getSrcId() + " bitmap return null");
                                    bitmap = BitmapUtil.INSTANCE.createEmptyBitmap();
                                } else {
                                    bitmap = it;
                                }
                                this.$src.setBitmap(bitmap);
                                Bitmap bitmap2 = it;
                                ALog.INSTANCE.i("AnimPlayer.MixAnimPlugin", "fetch image " + this.$src.getSrcId() + " finish bitmap is " + (bitmap2 != null ? Integer.valueOf(bitmap2.hashCode()) : null));
                                MixAnimPlugin.access$resultCall(this.this$0);
                            }
                        }));
                    }
                    continue;
                }
                if (src.getSrcType() != Src.SrcType.TXT) continue;
                ALog.INSTANCE.i(TAG, "fetch txt " + src.getSrcId());
                IFetchResource iFetchResource = this.resourceRequest;
                if (iFetchResource != null) {
                    Src src3 = src;
                    Intrinsics.checkExpressionValueIsNotNull((Object)src3, (String)"src");
                    iFetchResource.fetchText(new Resource(src3), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(src, this){
                        final /* synthetic */ Src $src;
                        final /* synthetic */ MixAnimPlugin this$0;
                        {
                            this.$src = src;
                            this.this$0 = mixAnimPlugin;
                            super(1);
                        }

                        public final void invoke(@Nullable String it) {
                            String string = it;
                            if (string == null) {
                                string = "";
                            }
                            this.$src.setTxt(string);
                            ALog.INSTANCE.i("AnimPlayer.MixAnimPlugin", "fetch text " + this.$src.getSrcId() + " finish txt is " + it);
                            MixAnimPlugin.access$resultCall(this.this$0);
                        }
                    }));
                }
            }
        }
        Object object4 = this.lock;
        boolean bl5 = false;
        boolean bl6 = false;
        synchronized (object4) {
            boolean bl7 = false;
            while (this.resultCbCount < totalSrc && !this.forceStopLock) {
                this.lock.wait();
            }
            Unit unit = Unit.INSTANCE;
        }
        ALog.INSTANCE.i(TAG, "fetchResourceSync cost=" + (SystemClock.elapsedRealtime() - time) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forceStopLockThread() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.forceStopLock = true;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resultCall() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            int n = this.resultCbCount;
            this.resultCbCount = n + 1;
            this.lock.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean createBitmap() {
        boolean bl;
        try {
            Object object = this.srcMap;
            if (object != null && (object = ((SrcMap)object).getMap()) != null && (object = ((HashMap)object).values()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Src src = (Src)element$iv;
                    boolean bl2 = false;
                    if (src.getSrcType() != Src.SrcType.TXT) continue;
                    Src src2 = src;
                    Intrinsics.checkExpressionValueIsNotNull((Object)src2, (String)"src");
                    src.setBitmap(BitmapUtil.INSTANCE.createTxtBitmap(src2));
                }
            }
            bl = true;
        }
        catch (OutOfMemoryError e) {
            ALog.INSTANCE.e(TAG, "draw text OOM " + e, e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final AnimPlayer getPlayer() {
        return this.player;
    }

    public MixAnimPlugin(@NotNull AnimPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.player = player;
        this.curFrameIndex = -1;
        this.mixTouch$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MixTouch>(this){
            final /* synthetic */ MixAnimPlugin this$0;

            @NotNull
            public final MixTouch invoke() {
                return new MixTouch(this.this$0);
            }
            {
                this.this$0 = mixAnimPlugin;
                super(0);
            }
        }));
        this.autoTxtColorFill = true;
        this.lock = new Object();
    }

    @Override
    public void onDecoding(int decodeIndex) {
        IAnimPlugin.DefaultImpls.onDecoding(this, decodeIndex);
    }

    public static final /* synthetic */ void access$resultCall(MixAnimPlugin $this) {
        $this.resultCall();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/mix/MixAnimPlugin$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

