/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer.util;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import com.tencent.qgame.animplayer.file.IFileContainer;
import com.tencent.qgame.animplayer.util.ALog;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\tj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/tencent/qgame/animplayer/util/MediaUtil;", "", "()V", "MIME_HEVC", "", "TAG", "isTypeMapInit", "", "supportTypeMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "checkIsHevc", "videoFormat", "Landroid/media/MediaFormat;", "checkSupportCodec", "mimeType", "getExtractor", "Landroid/media/MediaExtractor;", "file", "Lcom/tencent/qgame/animplayer/file/IFileContainer;", "getSupportType", "", "selectAudioTrack", "", "extractor", "selectVideoTrack", "animplayer_release"})
public final class MediaUtil {
    private static final String TAG = "AnimPlayer.MediaUtil";
    private static boolean isTypeMapInit;
    private static final HashMap<String, Boolean> supportTypeMap;
    @NotNull
    public static final String MIME_HEVC = "video/hevc";
    public static final MediaUtil INSTANCE;

    @NotNull
    public final MediaExtractor getExtractor(@NotNull IFileContainer file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        MediaExtractor extractor = new MediaExtractor();
        file.setDataSource(extractor);
        return extractor;
    }

    public final boolean checkIsHevc(@NotNull MediaFormat videoFormat) {
        Intrinsics.checkParameterIsNotNull((Object)videoFormat, (String)"videoFormat");
        String string = videoFormat.getString("mime");
        if (string == null) {
            string = "";
        }
        String mime = string;
        return StringsKt.contains$default((CharSequence)mime, (CharSequence)"hevc", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final int selectVideoTrack(@NotNull MediaExtractor extractor) {
        Intrinsics.checkParameterIsNotNull((Object)extractor, (String)"extractor");
        int numTracks = extractor.getTrackCount();
        int n = 0;
        int n2 = numTracks;
        while (n < n2) {
            String mime;
            void i;
            MediaFormat format = extractor.getTrackFormat((int)i);
            String string = format.getString("mime");
            if (string == null) {
                string = mime = "";
            }
            if (StringsKt.startsWith$default((String)mime, (String)"video/", (boolean)false, (int)2, null)) {
                ALog.INSTANCE.i(TAG, "Extractor selected track " + (int)i + " (" + mime + "): " + format);
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int selectAudioTrack(@NotNull MediaExtractor extractor) {
        Intrinsics.checkParameterIsNotNull((Object)extractor, (String)"extractor");
        int numTracks = extractor.getTrackCount();
        int n = 0;
        int n2 = numTracks;
        while (n < n2) {
            String mime;
            void i;
            MediaFormat format = extractor.getTrackFormat((int)i);
            String string = format.getString("mime");
            if (string == null) {
                string = mime = "";
            }
            if (StringsKt.startsWith$default((String)mime, (String)"audio/", (boolean)false, (int)2, null)) {
                ALog.INSTANCE.i(TAG, "Extractor selected track " + (int)i + " (" + mime + "): " + format);
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    public final synchronized boolean checkSupportCodec(@NotNull String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        if (!isTypeMapInit) {
            isTypeMapInit = true;
            this.getSupportType();
        }
        String string = mimeType;
        HashMap<String, Boolean> hashMap = supportTypeMap;
        boolean bl = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        return hashMap.containsKey(string3);
    }

    /*
     * WARNING - void declaration
     */
    private final void getSupportType() {
        try {
            int numCodecs = MediaCodecList.getCodecCount();
            int n = 0;
            int n2 = numCodecs;
            while (n < n2) {
                void i;
                MediaCodecInfo codecInfo;
                MediaCodecInfo mediaCodecInfo = codecInfo = MediaCodecList.getCodecInfoAt((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)mediaCodecInfo, (String)"codecInfo");
                if (!mediaCodecInfo.isEncoder()) {
                    String[] types = codecInfo.getSupportedTypes();
                    int n3 = 0;
                    Intrinsics.checkExpressionValueIsNotNull((Object)types, (String)"types");
                    int n4 = types.length;
                    while (n3 < n4) {
                        String string;
                        String string2;
                        void j;
                        Map map = supportTypeMap;
                        Intrinsics.checkExpressionValueIsNotNull((Object)types[j], (String)"types[j]");
                        Map map2 = map;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                        map2.put(string, true);
                        ++j;
                    }
                }
                ++i;
            }
            ALog.INSTANCE.i(TAG, "supportType=" + supportTypeMap.keySet());
        }
        catch (Throwable t) {
            ALog.INSTANCE.e(TAG, "getSupportType " + t);
        }
    }

    private MediaUtil() {
    }

    static {
        MediaUtil mediaUtil;
        INSTANCE = mediaUtil = new MediaUtil();
        supportTypeMap = new HashMap();
    }
}

