/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer.util;

import android.opengl.GLES20;
import com.tencent.qgame.animplayer.util.ALog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/tencent/qgame/animplayer/util/ShaderUtil;", "", "()V", "TAG", "", "compileShader", "", "shaderType", "shaderSource", "createAndLinkProgram", "vertexShaderHandle", "fragmentShaderHandle", "createProgram", "vertexSource", "fragmentSource", "animplayer_release"})
public final class ShaderUtil {
    private static final String TAG = "AnimPlayer.ShaderUtil";
    public static final ShaderUtil INSTANCE;

    public final int createProgram(@NotNull String vertexSource, @NotNull String fragmentSource) {
        Intrinsics.checkParameterIsNotNull((Object)vertexSource, (String)"vertexSource");
        Intrinsics.checkParameterIsNotNull((Object)fragmentSource, (String)"fragmentSource");
        int vertexShaderHandle = this.compileShader(35633, vertexSource);
        int fragmentShaderHandle = this.compileShader(35632, fragmentSource);
        return this.createAndLinkProgram(vertexShaderHandle, fragmentShaderHandle);
    }

    private final int compileShader(int shaderType, String shaderSource) {
        int shaderHandle = GLES20.glCreateShader((int)shaderType);
        if (shaderHandle != 0) {
            GLES20.glShaderSource((int)shaderHandle, (String)shaderSource);
            GLES20.glCompileShader((int)shaderHandle);
            int[] compileStatus = new int[1];
            GLES20.glGetShaderiv((int)shaderHandle, (int)35713, (int[])compileStatus, (int)0);
            if (compileStatus[0] == 0) {
                ALog.INSTANCE.e(TAG, "Error compiling shader: " + GLES20.glGetShaderInfoLog((int)shaderHandle));
                GLES20.glDeleteShader((int)shaderHandle);
                shaderHandle = 0;
            }
        }
        if (shaderHandle == 0) {
            throw (Throwable)new RuntimeException("Error creating shader.");
        }
        return shaderHandle;
    }

    private final int createAndLinkProgram(int vertexShaderHandle, int fragmentShaderHandle) {
        int programHandle = GLES20.glCreateProgram();
        if (programHandle != 0) {
            GLES20.glAttachShader((int)programHandle, (int)vertexShaderHandle);
            GLES20.glAttachShader((int)programHandle, (int)fragmentShaderHandle);
            GLES20.glLinkProgram((int)programHandle);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)programHandle, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] == 0) {
                ALog.INSTANCE.e(TAG, "Error compiling program: " + GLES20.glGetProgramInfoLog((int)programHandle));
                GLES20.glDeleteProgram((int)programHandle);
                programHandle = 0;
            }
        }
        if (programHandle == 0) {
            throw (Throwable)new RuntimeException("Error creating program.");
        }
        return programHandle;
    }

    private ShaderUtil() {
    }

    static {
        ShaderUtil shaderUtil;
        INSTANCE = shaderUtil = new ShaderUtil();
    }
}

