/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer.util;

import com.tencent.qgame.animplayer.util.ALog;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/tencent/qgame/animplayer/util/SpeedControlUtil;", "", "()V", "ONE_MILLION", "", "fixedFrameDurationUsec", "loopReset", "", "prevMonoUsec", "prevPresentUsec", "preRender", "", "presentationTimeUsec", "reset", "setFixedPlaybackRate", "fps", "", "Companion", "animplayer_release"})
public final class SpeedControlUtil {
    private final long ONE_MILLION = 1000000L;
    private long prevPresentUsec;
    private long prevMonoUsec;
    private long fixedFrameDurationUsec;
    private boolean loopReset = true;
    private static final String TAG = "AnimPlayer.SpeedControlUtil";
    public static final Companion Companion = new Companion(null);

    public final void setFixedPlaybackRate(int fps) {
        if (fps <= 0) {
            return;
        }
        this.fixedFrameDurationUsec = this.ONE_MILLION / (long)fps;
    }

    public final void preRender(long presentationTimeUsec) {
        if (this.prevMonoUsec == 0L) {
            this.prevMonoUsec = System.nanoTime() / (long)1000;
            this.prevPresentUsec = presentationTimeUsec;
        } else {
            long frameDelta = 0L;
            if (this.loopReset) {
                this.prevPresentUsec = presentationTimeUsec - this.ONE_MILLION / (long)30;
                this.loopReset = false;
            }
            frameDelta = this.fixedFrameDurationUsec != 0L ? this.fixedFrameDurationUsec : presentationTimeUsec - this.prevPresentUsec;
            if (frameDelta < 0L) {
                frameDelta = 0L;
            } else if (frameDelta > (long)10 * this.ONE_MILLION) {
                frameDelta = (long)5 * this.ONE_MILLION;
            }
            long desiredUsec = this.prevMonoUsec + frameDelta;
            long nowUsec = System.nanoTime() / (long)1000;
            while (nowUsec < desiredUsec - (long)100) {
                long sleepTimeUsec = desiredUsec - nowUsec;
                if (sleepTimeUsec > (long)500000) {
                    sleepTimeUsec = 500000L;
                }
                try {
                    Thread.sleep(sleepTimeUsec / (long)1000, (int)(sleepTimeUsec % (long)1000) * 1000);
                }
                catch (InterruptedException e) {
                    ALog.INSTANCE.e(TAG, "e=" + e, e);
                }
                nowUsec = System.nanoTime() / (long)1000;
            }
            this.prevMonoUsec += frameDelta;
            this.prevPresentUsec += frameDelta;
        }
    }

    public final void reset() {
        this.prevPresentUsec = 0L;
        this.prevMonoUsec = 0L;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/util/SpeedControlUtil$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

