/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal;

import com.mq.mgmi.client.message.a;
import com.mq.mgmi.client.message.a.b;
import com.mq.mgmi.client.message.c;
import com.mq.mgmi.client.message.d;
import com.mq.mgmi.client.message.e;
import com.mq.mgmi.client.message.f;
import com.mq.mgmi.client.message.i;
import com.mq.mgmi.client.message.internal.ClientState;
import com.mq.mgmi.client.message.internal.CommsCallback;
import com.mq.mgmi.client.message.internal.CommsReceiver;
import com.mq.mgmi.client.message.internal.CommsSender;
import com.mq.mgmi.client.message.internal.CommsTokenStore;
import com.mq.mgmi.client.message.internal.DisconnectedMessageBuffer;
import com.mq.mgmi.client.message.internal.ExceptionHelper;
import com.mq.mgmi.client.message.internal.IDiscardedBufferMessageCallback;
import com.mq.mgmi.client.message.internal.IDisconnectedBufferCallback;
import com.mq.mgmi.client.message.internal.NetworkModule;
import com.mq.mgmi.client.message.internal.wire.MqttConnack;
import com.mq.mgmi.client.message.internal.wire.MqttConnect;
import com.mq.mgmi.client.message.internal.wire.MqttDisconnect;
import com.mq.mgmi.client.message.internal.wire.MqttPublish;
import com.mq.mgmi.client.message.internal.wire.MqttWireMessage;
import com.mq.mgmi.client.message.j;
import com.mq.mgmi.client.message.k;
import com.mq.mgmi.client.message.l;
import com.mq.mgmi.client.message.m;
import com.mq.mgmi.client.message.n;
import com.mq.mgmi.client.message.o;
import com.mq.mgmi.client.message.r;
import com.mq.mgmi.client.message.t;
import com.mq.mgmi.client.message.u;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ClientComms {
    public static String VERSION = "${project.version}";
    public static String BUILD_LEVEL = "L${build.level}";
    private final String CLASS_NAME = ClientComms.class.getName();
    private final b log = com.mq.mgmi.client.message.a.c.a("com.mq.mgmi.client.message.internal.nls.logcat", this.CLASS_NAME);
    private static final byte CONNECTED = 0;
    private static final byte CONNECTING = 1;
    private static final byte DISCONNECTING = 2;
    private static final byte DISCONNECTED = 3;
    private static final byte CLOSED = 4;
    private d client;
    private int networkModuleIndex;
    private NetworkModule[] networkModules;
    private CommsReceiver receiver;
    private CommsSender sender;
    private CommsCallback callback;
    private ClientState clientState;
    private l conOptions;
    private k persistence;
    private r pingSender;
    private CommsTokenStore tokenStore;
    private boolean stoppingComms = false;
    private byte conState = (byte)3;
    private final Object conLock = new Object();
    private boolean closePending = false;
    private boolean resting = false;
    private DisconnectedMessageBuffer disconnectedMessageBuffer;
    private ExecutorService executorService;

    public ClientComms(d d2, k k2, r r2, ExecutorService executorService) {
        this.conState = (byte)3;
        this.client = d2;
        this.persistence = k2;
        this.pingSender = r2;
        this.pingSender.a(this);
        this.executorService = executorService;
        this.tokenStore = new CommsTokenStore(this.getClient().b());
        this.callback = new CommsCallback(this);
        this.clientState = new ClientState(k2, this.tokenStore, this.callback, this, r2);
        this.callback.setClientState(this.clientState);
        this.log.a(this.getClient().b());
    }

    CommsReceiver getReceiver() {
        return this.receiver;
    }

    private void shutdownExecutorService() {
        String string = "shutdownExecutorService";
        this.executorService.shutdown();
        try {
            if (this.executorService != null && this.conOptions != null && !this.executorService.awaitTermination(this.conOptions.r, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(this.conOptions.r, TimeUnit.SECONDS)) {
                    this.log.a(this.CLASS_NAME, string, "executorService did not terminate");
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
            return;
        }
    }

    void internalSend(MqttWireMessage mqttWireMessage, t t2) {
        this.log.c(this.CLASS_NAME, "internalSend", "200", new Object[]{mqttWireMessage.getKey(), mqttWireMessage, t2});
        if (t2.a.getClient() != null) {
            this.log.c(this.CLASS_NAME, "internalSend", "213", new Object[]{mqttWireMessage.getKey(), mqttWireMessage, t2});
            throw new n(32201);
        }
        t2.a.setClient(this.getClient());
        try {
            this.clientState.send(mqttWireMessage, t2);
            return;
        }
        catch (n n2) {
            t2.a.setClient(null);
            if (mqttWireMessage instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)mqttWireMessage);
            }
            throw n2;
        }
    }

    public void sendNoWait(MqttWireMessage mqttWireMessage, t t2) {
        if (this.isConnected() || !this.isConnected() && mqttWireMessage instanceof MqttConnect || this.isDisconnecting() && mqttWireMessage instanceof MqttDisconnect) {
            if (this.disconnectedMessageBuffer != null && this.disconnectedMessageBuffer.getMessageCount() != 0) {
                this.log.c(this.CLASS_NAME, "sendNoWait", "507", new Object[]{mqttWireMessage.getKey()});
                if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                    this.clientState.persistBufferedMessage(mqttWireMessage);
                }
                this.disconnectedMessageBuffer.putMessage(mqttWireMessage, t2);
                return;
            }
            this.internalSend(mqttWireMessage, t2);
            return;
        }
        if (this.disconnectedMessageBuffer != null) {
            this.log.c(this.CLASS_NAME, "sendNoWait", "508", new Object[]{mqttWireMessage.getKey()});
            if (this.disconnectedMessageBuffer.isPersistBuffer()) {
                this.clientState.persistBufferedMessage(mqttWireMessage);
            }
            this.disconnectedMessageBuffer.putMessage(mqttWireMessage, t2);
            return;
        }
        this.log.a(this.CLASS_NAME, "sendNoWait", "208");
        throw ExceptionHelper.createMqttException(32104);
    }

    public boolean removeMessage(e e2) {
        return this.clientState.removeMessage(e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) {
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected() || bl) {
                    this.log.a(this.CLASS_NAME, "close", "224");
                    if (this.isConnecting()) {
                        throw new n(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.pingSender = null;
                this.receiver = null;
                this.networkModules = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(l object, t t2) {
        Object object2 = this.conLock;
        synchronized (object2) {
            if (!this.isDisconnected() || this.closePending) {
                this.log.c(this.CLASS_NAME, "connect", "207", new Object[]{this.conState});
                if (this.isClosed() || this.closePending) {
                    throw new n(32111);
                }
                if (this.isConnecting()) {
                    throw new n(32110);
                }
                if (this.isDisconnecting()) {
                    throw new n(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            this.log.a(this.CLASS_NAME, "connect", "214");
            this.conState = 1;
            this.conOptions = object;
            object = new MqttConnect(this.client.b(), this.conOptions.n, this.conOptions.k, this.conOptions.a, this.conOptions.e, this.conOptions.f, this.conOptions.d, this.conOptions.c);
            this.clientState.setKeepAliveSecs(this.conOptions.a);
            this.clientState.setCleanSession(this.conOptions.k);
            this.clientState.setMaxInflight(this.conOptions.b);
            this.tokenStore.open();
            ClientComms clientComms = this;
            clientComms.new ConnectBG(clientComms, t2, (MqttConnect)object, this.executorService).start();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectComplete(MqttConnack mqttConnack, n n2) {
        int n3 = mqttConnack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (n3 == 0) {
                this.log.a(this.CLASS_NAME, "connectComplete", "215");
                this.conState = 0;
                return;
            }
        }
        this.log.c(this.CLASS_NAME, "connectComplete", "204", new Object[]{n3});
        throw n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownConnection(t t2, n n2) {
        boolean bl;
        Object object = this.conLock;
        synchronized (object) {
            if (this.stoppingComms || this.closePending || this.isClosed()) {
                return;
            }
            this.stoppingComms = true;
            this.log.a(this.CLASS_NAME, "shutdownConnection", "216");
            bl = this.isConnected() || this.isDisconnecting();
            this.conState = (byte)2;
        }
        if (t2 != null && !t2.a.isComplete()) {
            t2.a.setException(n2);
        }
        if (this.callback != null) {
            this.callback.stop();
        }
        if (this.receiver != null) {
            this.receiver.stop();
        }
        try {
            if (this.networkModules != null && (object = this.networkModules[this.networkModuleIndex]) != null) {
                object.stop();
            }
        }
        catch (Exception exception) {}
        this.tokenStore.quiesce(new n(32102));
        t2 = this.handleOldTokens(t2, n2);
        try {
            this.clientState.disconnected(n2);
            if (this.clientState.getCleanSession()) {
                this.callback.removeMessageListeners();
            }
        }
        catch (Exception exception) {}
        if (this.sender != null) {
            this.sender.stop();
        }
        if (this.pingSender != null) {
            this.pingSender.b();
        }
        try {
            if (this.disconnectedMessageBuffer == null && this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception exception) {}
        object = this.conLock;
        synchronized (object) {
            this.log.a(this.CLASS_NAME, "shutdownConnection", "217");
            this.conState = (byte)3;
            this.stoppingComms = false;
        }
        if (t2 != null && this.callback != null) {
            this.callback.asyncOperationComplete(t2);
        }
        if (bl && this.callback != null) {
            this.callback.connectionLost(n2);
        }
        object = this.conLock;
        synchronized (object) {
            if (this.closePending) {
                try {
                    this.close(true);
                }
                catch (Exception exception) {}
            }
            return;
        }
    }

    private t handleOldTokens(t object, n object2) {
        this.log.a(this.CLASS_NAME, "handleOldTokens", "222");
        Object object3 = null;
        try {
            if (object != null && !((t)object).a.isComplete() && this.tokenStore.getToken(((t)object).a.getKey()) == null) {
                Object object4 = object;
                this.tokenStore.saveToken((t)object4, ((t)object4).a.getKey());
            }
            object = this.clientState.resolveOldTokens((n)object2).elements();
            while (object.hasMoreElements()) {
                object2 = (t)object.nextElement();
                if (((t)object2).a.getKey().equals("Disc") || ((t)object2).a.getKey().equals("Con")) {
                    object3 = object2;
                    continue;
                }
                this.callback.asyncOperationComplete((t)object2);
            }
        }
        catch (Exception exception) {}
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MqttDisconnect mqttDisconnect, long l2, t t2) {
        Object object = this.conLock;
        synchronized (object) {
            if (this.isClosed()) {
                this.log.a(this.CLASS_NAME, "disconnect", "223");
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                this.log.a(this.CLASS_NAME, "disconnect", "211");
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                this.log.a(this.CLASS_NAME, "disconnect", "219");
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                this.log.a(this.CLASS_NAME, "disconnect", "210");
                throw ExceptionHelper.createMqttException(32107);
            }
            this.log.a(this.CLASS_NAME, "disconnect", "218");
            this.conState = (byte)2;
            new DisconnectBG(mqttDisconnect, l2, t2, this.executorService).start();
            return;
        }
    }

    public void disconnectForcibly(long l2, long l3) {
        this.disconnectForcibly(l2, l3, true);
    }

    public void disconnectForcibly(long l2, long l3, boolean bl) {
        this.conState = (byte)2;
        if (this.clientState != null) {
            this.clientState.quiesce(l2);
        }
        t t2 = new t(this.client.b());
        try {
            if (bl) {
                this.internalSend(new MqttDisconnect(), t2);
                t2.a.waitForCompletion(l3);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            t2.a.markComplete(null, null);
            this.shutdownConnection(t2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.resting;
        }
    }

    public void setCallback(i i2) {
        this.callback.setCallback(i2);
    }

    public void setReconnectCallback(j j2) {
        this.callback.setReconnectCallback(j2);
    }

    public void setManualAcks(boolean bl) {
        this.callback.setManualAcks(bl);
    }

    public void messageArrivedComplete(int n2, int n3) {
        this.callback.messageArrivedComplete(n2, n3);
    }

    public void setMessageListener(String string, f f2) {
        this.callback.setMessageListener(string, f2);
    }

    public void removeMessageListener(String string) {
        this.callback.removeMessageListener(string);
    }

    protected u getTopic(String string) {
        return new u(string, this);
    }

    public void setNetworkModuleIndex(int n2) {
        this.networkModuleIndex = n2;
    }

    public int getNetworkModuleIndex() {
        return this.networkModuleIndex;
    }

    public NetworkModule[] getNetworkModules() {
        return this.networkModules;
    }

    public void setNetworkModules(NetworkModule[] networkModuleArray) {
        this.networkModules = (NetworkModule[])networkModuleArray.clone();
    }

    public m[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish mqttPublish) {
        this.clientState.deliveryComplete(mqttPublish);
    }

    protected void deliveryComplete(int n2) {
        this.clientState.deliveryComplete(n2);
    }

    public d getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.clientState.getKeepAlive();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public l getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties properties = new Properties();
        properties.put("conState", (Object)this.conState);
        properties.put("serverURI", this.getClient().c());
        properties.put("callback", this.callback);
        properties.put("stoppingComms", (Object)this.stoppingComms);
        return properties;
    }

    public t checkForActivity() {
        return this.checkForActivity(null);
    }

    public t checkForActivity(c c2) {
        t t2 = null;
        try {
            t2 = this.clientState.checkForActivity(c2);
        }
        catch (n n2) {
            this.handleRunException(n2);
        }
        catch (Exception exception) {
            this.handleRunException(exception);
        }
        return t2;
    }

    private void handleRunException(Exception exception) {
        this.log.b(this.CLASS_NAME, "handleRunException", "804", null, exception);
        exception = !(exception instanceof n) ? new n(32109, (Throwable)exception) : (n)exception;
        this.shutdownConnection(null, (n)exception);
    }

    public void setRestingState(boolean bl) {
        this.resting = bl;
    }

    public void setDisconnectedMessageBuffer(DisconnectedMessageBuffer disconnectedMessageBuffer) {
        this.disconnectedMessageBuffer = disconnectedMessageBuffer;
    }

    public int getBufferedMessageCount() {
        return this.disconnectedMessageBuffer.getMessageCount();
    }

    public o getBufferedMessage(int n2) {
        return ((MqttPublish)this.disconnectedMessageBuffer.getMessage((int)n2).a).getMessage();
    }

    public void deleteBufferedMessage(int n2) {
        this.disconnectedMessageBuffer.deleteMessage(n2);
    }

    public void notifyConnect() {
        if (this.disconnectedMessageBuffer != null) {
            this.log.c(this.CLASS_NAME, "notifyConnect", "509", null);
            this.disconnectedMessageBuffer.setPublishCallback(new ReconnectDisconnectedBufferCallback("notifyConnect"));
            this.disconnectedMessageBuffer.setMessageDiscardedCallBack(new MessageDiscardedCallback());
            if (this.executorService == null) {
                new Thread(this.disconnectedMessageBuffer).start();
                return;
            }
            this.executorService.execute(this.disconnectedMessageBuffer);
        }
    }

    public int getActualInFlight() {
        return this.clientState.getActualInFlight();
    }

    class ReconnectDisconnectedBufferCallback
    implements IDisconnectedBufferCallback {
        final String methodName;

        ReconnectDisconnectedBufferCallback(String string) {
            this.methodName = string;
        }

        @Override
        public void publishBufferedMessage(a a2) {
            if (ClientComms.this.isConnected()) {
                while (ClientComms.this.clientState.getActualInFlight() >= ClientComms.this.clientState.getMaxInFlight() - 3) {
                    Thread.yield();
                }
                ClientComms.this.log.c(ClientComms.this.CLASS_NAME, this.methodName, "510", new Object[]{a2.a.getKey()});
                ClientComms.this.internalSend(a2.a, a2.b);
                ClientComms.this.clientState.unPersistBufferedMessage(a2.a);
                return;
            }
            ClientComms.this.log.a(ClientComms.this.CLASS_NAME, this.methodName, "208");
            throw ExceptionHelper.createMqttException(32104);
        }
    }

    class MessageDiscardedCallback
    implements IDiscardedBufferMessageCallback {
        MessageDiscardedCallback() {
        }

        @Override
        public void messageDiscarded(MqttWireMessage mqttWireMessage) {
            if (ClientComms.this.disconnectedMessageBuffer.isPersistBuffer()) {
                ClientComms.this.clientState.unPersistBufferedMessage(mqttWireMessage);
            }
        }
    }

    class DisconnectBG
    implements Runnable {
        MqttDisconnect disconnect;
        long quiesceTimeout;
        t token;
        private String threadName;

        DisconnectBG(MqttDisconnect mqttDisconnect, long l2, t t2, ExecutorService executorService) {
            this.disconnect = mqttDisconnect;
            this.quiesceTimeout = l2;
            this.token = t2;
        }

        void start() {
            this.threadName = "MQTT Disc: " + ClientComms.this.getClient().b();
            if (ClientComms.this.executorService == null) {
                new Thread(this).start();
                return;
            }
            ClientComms.this.executorService.execute(this);
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.threadName);
            ClientComms.this.log.a(ClientComms.this.CLASS_NAME, "disconnectBG:run", "221");
            ClientComms.this.clientState.quiesce(this.quiesceTimeout);
            try {
                ClientComms.this.internalSend(this.disconnect, this.token);
                if (ClientComms.this.sender != null && ClientComms.this.sender.isRunning()) {
                    this.token.a.waitUntilSent();
                }
                return;
            }
            catch (n n2) {
                return;
            }
            finally {
                this.token.a.markComplete(null, null);
                if (ClientComms.this.sender == null || !ClientComms.this.sender.isRunning()) {
                    this.token.a.notifyComplete();
                }
                ClientComms.this.shutdownConnection(this.token, null);
            }
        }
    }

    class ConnectBG
    implements Runnable {
        ClientComms clientComms = null;
        t conToken;
        MqttConnect conPacket;
        private String threadName;

        ConnectBG(ClientComms clientComms2, t t2, MqttConnect mqttConnect, ExecutorService executorService) {
            this.clientComms = clientComms2;
            this.conToken = t2;
            this.conPacket = mqttConnect;
            this.threadName = "MQTT Con: " + ClientComms.this.getClient().b();
        }

        void start() {
            if (ClientComms.this.executorService == null) {
                new Thread(this).start();
                return;
            }
            ClientComms.this.executorService.execute(this);
        }

        @Override
        public void run() {
            Thread.currentThread().setName(this.threadName);
            n n2 = null;
            ClientComms.this.log.a(ClientComms.this.CLASS_NAME, "connectBG:run", "220");
            try {
                Object object = ClientComms.this.tokenStore.getOutstandingDelTokens();
                int n3 = ((m[])object).length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    object[i2].a.setException(null);
                }
                ClientComms.this.tokenStore.saveToken(this.conToken, this.conPacket);
                object = ClientComms.this.networkModules[ClientComms.this.networkModuleIndex];
                object.start();
                ClientComms.this.receiver = new CommsReceiver(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, object.getInputStream());
                ClientComms.this.receiver.start("MQTT Rec: " + ClientComms.this.getClient().b(), ClientComms.this.executorService);
                ClientComms.this.sender = new CommsSender(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, object.getOutputStream());
                ClientComms.this.sender.start("MQTT Snd: " + ClientComms.this.getClient().b(), ClientComms.this.executorService);
                ClientComms.this.callback.start("MQTT Call: " + ClientComms.this.getClient().b(), ClientComms.this.executorService);
                ClientComms.this.internalSend(this.conPacket, this.conToken);
            }
            catch (n n4) {
                ClientComms.this.log.b(ClientComms.this.CLASS_NAME, "connectBG:run", "212", null, n4);
                n2 = n4;
            }
            catch (Exception exception) {
                ClientComms.this.log.b(ClientComms.this.CLASS_NAME, "connectBG:run", "209", null, exception);
                n2 = ExceptionHelper.createMqttException(exception);
            }
            if (n2 != null) {
                ClientComms.this.shutdownConnection(this.conToken, n2);
            }
        }
    }
}

