/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal;

import com.mq.mgmi.client.message.a.b;
import com.mq.mgmi.client.message.c;
import com.mq.mgmi.client.message.e;
import com.mq.mgmi.client.message.internal.ClientComms;
import com.mq.mgmi.client.message.internal.CommsCallback;
import com.mq.mgmi.client.message.internal.CommsTokenStore;
import com.mq.mgmi.client.message.internal.ExceptionHelper;
import com.mq.mgmi.client.message.internal.wire.MqttAck;
import com.mq.mgmi.client.message.internal.wire.MqttConnack;
import com.mq.mgmi.client.message.internal.wire.MqttConnect;
import com.mq.mgmi.client.message.internal.wire.MqttPersistableWireMessage;
import com.mq.mgmi.client.message.internal.wire.MqttPingReq;
import com.mq.mgmi.client.message.internal.wire.MqttPingResp;
import com.mq.mgmi.client.message.internal.wire.MqttPubAck;
import com.mq.mgmi.client.message.internal.wire.MqttPubComp;
import com.mq.mgmi.client.message.internal.wire.MqttPubRec;
import com.mq.mgmi.client.message.internal.wire.MqttPubRel;
import com.mq.mgmi.client.message.internal.wire.MqttPublish;
import com.mq.mgmi.client.message.internal.wire.MqttSuback;
import com.mq.mgmi.client.message.internal.wire.MqttSubscribe;
import com.mq.mgmi.client.message.internal.wire.MqttUnsubAck;
import com.mq.mgmi.client.message.internal.wire.MqttUnsubscribe;
import com.mq.mgmi.client.message.internal.wire.MqttWireMessage;
import com.mq.mgmi.client.message.k;
import com.mq.mgmi.client.message.m;
import com.mq.mgmi.client.message.n;
import com.mq.mgmi.client.message.o;
import com.mq.mgmi.client.message.p;
import com.mq.mgmi.client.message.q;
import com.mq.mgmi.client.message.r;
import com.mq.mgmi.client.message.t;
import java.io.EOFException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

public class ClientState {
    private static final String CLASS_NAME = ClientState.class.getName();
    private b log = com.mq.mgmi.client.message.a.c.a("com.mq.mgmi.client.message.internal.nls.logcat", CLASS_NAME);
    private static final String PERSISTENCE_SENT_PREFIX = "s-";
    private static final String PERSISTENCE_SENT_BUFFERED_PREFIX = "sb-";
    private static final String PERSISTENCE_CONFIRMED_PREFIX = "sc-";
    private static final String PERSISTENCE_RECEIVED_PREFIX = "r-";
    private static final int MIN_MSG_ID = 1;
    private static final int MAX_MSG_ID = 65535;
    private int nextMsgId = 0;
    private Hashtable inUseMsgIds;
    private volatile Vector pendingMessages;
    private volatile Vector pendingFlows;
    private CommsTokenStore tokenStore;
    private ClientComms clientComms = null;
    private CommsCallback callback = null;
    private long keepAliveNanos;
    private boolean cleanSession;
    private k persistence;
    private int maxInflight = 0;
    private int actualInFlight = 0;
    private int inFlightPubRels = 0;
    private final Object queueLock = new Object();
    private final Object quiesceLock = new Object();
    private boolean quiescing = false;
    private long lastOutboundActivity = 0L;
    private long lastInboundActivity = 0L;
    private long lastPing = 0L;
    private MqttWireMessage pingCommand;
    private final Object pingOutstandingLock = new Object();
    private int pingOutstanding = 0;
    private boolean connected = false;
    private Hashtable outboundQoS2 = null;
    private Hashtable outboundQoS1 = null;
    private Hashtable outboundQoS0 = null;
    private Hashtable inboundQoS2 = null;
    private r pingSender = null;

    protected ClientState(k k2, CommsTokenStore commsTokenStore, CommsCallback commsCallback, ClientComms clientComms, r r2) {
        this.log.a(clientComms.getClient().b());
        this.log.b(CLASS_NAME, "<Init>", "");
        this.inUseMsgIds = new Hashtable();
        this.pendingFlows = new Vector();
        this.outboundQoS2 = new Hashtable();
        this.outboundQoS1 = new Hashtable();
        this.outboundQoS0 = new Hashtable();
        this.inboundQoS2 = new Hashtable();
        this.pingCommand = new MqttPingReq();
        this.inFlightPubRels = 0;
        this.actualInFlight = 0;
        this.persistence = k2;
        this.callback = commsCallback;
        this.tokenStore = commsTokenStore;
        this.clientComms = clientComms;
        this.pingSender = r2;
        this.restoreState();
    }

    protected void setMaxInflight(int n2) {
        this.maxInflight = n2;
        this.pendingMessages = new Vector(this.maxInflight);
    }

    protected void setKeepAliveSecs(long l2) {
        this.keepAliveNanos = TimeUnit.SECONDS.toNanos(l2);
    }

    protected long getKeepAlive() {
        return TimeUnit.NANOSECONDS.toMillis(this.keepAliveNanos);
    }

    protected void setCleanSession(boolean bl) {
        this.cleanSession = bl;
    }

    protected boolean getCleanSession() {
        return this.cleanSession;
    }

    private String getSendPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_SENT_PREFIX + mqttWireMessage.getMessageId();
    }

    private String getSendPersistenceKey(int n2) {
        return PERSISTENCE_SENT_PREFIX.concat(String.valueOf(n2));
    }

    private String getSendConfirmPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_CONFIRMED_PREFIX + mqttWireMessage.getMessageId();
    }

    private String getReceivedPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_RECEIVED_PREFIX + mqttWireMessage.getMessageId();
    }

    private String getReceivedPersistenceKey(int n2) {
        return PERSISTENCE_RECEIVED_PREFIX.concat(String.valueOf(n2));
    }

    private String getSendBufferedPersistenceKey(MqttWireMessage mqttWireMessage) {
        return PERSISTENCE_SENT_BUFFERED_PREFIX + mqttWireMessage.getMessageId();
    }

    protected void clearState() {
        this.log.a(CLASS_NAME, "clearState", ">");
        this.persistence.b();
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.outboundQoS0.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
    }

    private MqttWireMessage restoreMessage(String string, p p2) {
        MqttWireMessage mqttWireMessage = null;
        try {
            mqttWireMessage = MqttWireMessage.createWireMessage(p2);
        }
        catch (n n2) {
            this.log.b(CLASS_NAME, "restoreMessage", "602", new Object[]{string}, n2);
            if (n2.getCause() instanceof EOFException) {
                if (string != null) {
                    this.persistence.b(string);
                }
            }
            throw n2;
        }
        this.log.c(CLASS_NAME, "restoreMessage", "601", new Object[]{string, mqttWireMessage});
        return mqttWireMessage;
    }

    private void insertInOrder(Vector vector, MqttWireMessage mqttWireMessage) {
        int n2 = mqttWireMessage.getMessageId();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            if (((MqttWireMessage)vector.elementAt(i2)).getMessageId() <= n2) continue;
            vector.insertElementAt(mqttWireMessage, i2);
            return;
        }
        vector.addElement(mqttWireMessage);
    }

    private Vector reOrder(Vector vector) {
        int n2;
        int n3;
        Vector vector2 = new Vector();
        if (vector.size() == 0) {
            return vector2;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < vector.size(); ++n3) {
            n2 = ((MqttWireMessage)vector.elementAt(n3)).getMessageId();
            if (n2 - n4 > n5) {
                n5 = n2 - n4;
                n6 = n3;
            }
            n4 = n2;
        }
        n2 = n4;
        n3 = ((MqttWireMessage)vector.elementAt(0)).getMessageId();
        if (65535 - n2 + n3 > n5) {
            n6 = 0;
        }
        for (n4 = n6; n4 < vector.size(); ++n4) {
            vector2.addElement(vector.elementAt(n4));
        }
        for (n4 = 0; n4 < n6; ++n4) {
            vector2.addElement(vector.elementAt(n4));
        }
        return vector2;
    }

    protected void restoreState() {
        String string;
        Enumeration enumeration = this.persistence.a();
        int n2 = this.nextMsgId;
        Vector<String> vector = new Vector<String>();
        this.log.a(CLASS_NAME, "restoreState", "600");
        while (enumeration.hasMoreElements()) {
            MqttPersistableWireMessage mqttPersistableWireMessage;
            string = (String)enumeration.nextElement();
            Object object = this.persistence.a(string);
            if ((object = this.restoreMessage(string, (p)object)) == null) continue;
            if (string.startsWith(PERSISTENCE_RECEIVED_PREFIX)) {
                this.log.c(CLASS_NAME, "restoreState", "604", new Object[]{string, object});
                this.inboundQoS2.put(((MqttWireMessage)object).getMessageId(), object);
                continue;
            }
            if (string.startsWith(PERSISTENCE_SENT_PREFIX)) {
                mqttPersistableWireMessage = (MqttPublish)object;
                n2 = Math.max(mqttPersistableWireMessage.getMessageId(), n2);
                if (this.persistence.c(this.getSendConfirmPersistenceKey(mqttPersistableWireMessage))) {
                    p p2 = this.persistence.a(this.getSendConfirmPersistenceKey(mqttPersistableWireMessage));
                    if ((p2 = (MqttPubRel)this.restoreMessage(string, p2)) != null) {
                        this.log.c(CLASS_NAME, "restoreState", "605", new Object[]{string, object});
                        this.outboundQoS2.put(((MqttWireMessage)((Object)p2)).getMessageId(), p2);
                    } else {
                        this.log.c(CLASS_NAME, "restoreState", "606", new Object[]{string, object});
                    }
                } else {
                    mqttPersistableWireMessage.setDuplicate(true);
                    if (((MqttPublish)mqttPersistableWireMessage).getMessage().getQos() == 2) {
                        this.log.c(CLASS_NAME, "restoreState", "607", new Object[]{string, object});
                        this.outboundQoS2.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                    } else {
                        this.log.c(CLASS_NAME, "restoreState", "608", new Object[]{string, object});
                        this.outboundQoS1.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                    }
                }
                this.tokenStore.restoreToken((MqttPublish)mqttPersistableWireMessage).a.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage.getMessageId());
                continue;
            }
            if (string.startsWith(PERSISTENCE_SENT_BUFFERED_PREFIX)) {
                mqttPersistableWireMessage = (MqttPublish)object;
                n2 = Math.max(mqttPersistableWireMessage.getMessageId(), n2);
                if (((MqttPublish)mqttPersistableWireMessage).getMessage().getQos() == 2) {
                    this.log.c(CLASS_NAME, "restoreState", "607", new Object[]{string, object});
                    this.outboundQoS2.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                } else if (((MqttPublish)mqttPersistableWireMessage).getMessage().getQos() == 1) {
                    this.log.c(CLASS_NAME, "restoreState", "608", new Object[]{string, object});
                    this.outboundQoS1.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                } else {
                    this.log.c(CLASS_NAME, "restoreState", "511", new Object[]{string, object});
                    this.outboundQoS0.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage);
                    this.persistence.b(string);
                }
                this.tokenStore.restoreToken((MqttPublish)mqttPersistableWireMessage).a.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(mqttPersistableWireMessage.getMessageId(), mqttPersistableWireMessage.getMessageId());
                continue;
            }
            if (!string.startsWith(PERSISTENCE_CONFIRMED_PREFIX) || this.persistence.c(this.getSendPersistenceKey(mqttPersistableWireMessage = (MqttPubRel)object))) continue;
            vector.addElement(string);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.log.c(CLASS_NAME, "restoreState", "609", new Object[]{string});
            this.persistence.b(string);
        }
        this.nextMsgId = n2;
    }

    private void restoreInflightMessages() {
        MqttWireMessage mqttWireMessage;
        Object k2;
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        Enumeration enumeration = this.outboundQoS2.keys();
        while (enumeration.hasMoreElements()) {
            k2 = enumeration.nextElement();
            mqttWireMessage = (MqttWireMessage)this.outboundQoS2.get(k2);
            if (mqttWireMessage instanceof MqttPublish) {
                this.log.c(CLASS_NAME, "restoreInflightMessages", "610", new Object[]{k2});
                mqttWireMessage.setDuplicate(true);
                ClientState clientState = this;
                clientState.insertInOrder(clientState.pendingMessages, (MqttPublish)mqttWireMessage);
                continue;
            }
            if (!(mqttWireMessage instanceof MqttPubRel)) continue;
            this.log.c(CLASS_NAME, "restoreInflightMessages", "611", new Object[]{k2});
            ClientState clientState = this;
            clientState.insertInOrder(clientState.pendingFlows, (MqttPubRel)mqttWireMessage);
        }
        enumeration = this.outboundQoS1.keys();
        while (enumeration.hasMoreElements()) {
            k2 = enumeration.nextElement();
            mqttWireMessage = (MqttPublish)this.outboundQoS1.get(k2);
            mqttWireMessage.setDuplicate(true);
            this.log.c(CLASS_NAME, "restoreInflightMessages", "612", new Object[]{k2});
            ClientState clientState = this;
            clientState.insertInOrder(clientState.pendingMessages, mqttWireMessage);
        }
        enumeration = this.outboundQoS0.keys();
        while (enumeration.hasMoreElements()) {
            k2 = enumeration.nextElement();
            mqttWireMessage = (MqttPublish)this.outboundQoS0.get(k2);
            this.log.c(CLASS_NAME, "restoreInflightMessages", "512", new Object[]{k2});
            ClientState clientState = this;
            clientState.insertInOrder(clientState.pendingMessages, mqttWireMessage);
        }
        this.pendingFlows = this.reOrder(this.pendingFlows);
        this.pendingMessages = this.reOrder(this.pendingMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MqttWireMessage mqttWireMessage, t t2) {
        if (mqttWireMessage.isMessageIdRequired() && mqttWireMessage.getMessageId() == 0 && (mqttWireMessage instanceof MqttPublish && ((MqttPublish)mqttWireMessage).getMessage().getQos() != 0 || mqttWireMessage instanceof MqttPubAck || mqttWireMessage instanceof MqttPubRec || mqttWireMessage instanceof MqttPubRel || mqttWireMessage instanceof MqttPubComp || mqttWireMessage instanceof MqttSubscribe || mqttWireMessage instanceof MqttSuback || mqttWireMessage instanceof MqttUnsubscribe || mqttWireMessage instanceof MqttUnsubAck)) {
            mqttWireMessage.setMessageId(this.getNextMessageId());
        }
        if (t2 != null) {
            mqttWireMessage.setToken(t2);
            try {
                t2.a.setMessageID(mqttWireMessage.getMessageId());
            }
            catch (Exception exception) {}
        }
        if (mqttWireMessage instanceof MqttPublish) {
            Object object = this.queueLock;
            synchronized (object) {
                if (this.actualInFlight >= this.maxInflight) {
                    this.log.c(CLASS_NAME, "send", "613", new Object[]{this.actualInFlight});
                    throw new n(32202);
                }
                o o2 = ((MqttPublish)mqttWireMessage).getMessage();
                this.log.c(CLASS_NAME, "send", "628", new Object[]{mqttWireMessage.getMessageId(), o2.getQos(), mqttWireMessage});
                switch (o2.getQos()) {
                    case 2: {
                        this.outboundQoS2.put(mqttWireMessage.getMessageId(), mqttWireMessage);
                        this.persistence.a(this.getSendPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                        this.tokenStore.saveToken(t2, mqttWireMessage);
                        break;
                    }
                    case 1: {
                        this.outboundQoS1.put(mqttWireMessage.getMessageId(), mqttWireMessage);
                        this.persistence.a(this.getSendPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                        this.tokenStore.saveToken(t2, mqttWireMessage);
                    }
                }
                this.pendingMessages.addElement(mqttWireMessage);
                this.queueLock.notifyAll();
                return;
            }
        }
        this.log.c(CLASS_NAME, "send", "615", new Object[]{mqttWireMessage.getMessageId(), mqttWireMessage});
        if (mqttWireMessage instanceof MqttConnect) {
            Object object = this.queueLock;
            synchronized (object) {
                this.tokenStore.saveToken(t2, mqttWireMessage);
                this.pendingFlows.insertElementAt(mqttWireMessage, 0);
                this.queueLock.notifyAll();
                return;
            }
        }
        if (mqttWireMessage instanceof MqttPingReq) {
            this.pingCommand = mqttWireMessage;
        } else if (mqttWireMessage instanceof MqttPubRel) {
            this.outboundQoS2.put(mqttWireMessage.getMessageId(), mqttWireMessage);
            this.persistence.a(this.getSendConfirmPersistenceKey(mqttWireMessage), (MqttPubRel)mqttWireMessage);
        } else if (mqttWireMessage instanceof MqttPubComp) {
            this.persistence.b(this.getReceivedPersistenceKey(mqttWireMessage));
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (!(mqttWireMessage instanceof MqttAck)) {
                this.tokenStore.saveToken(t2, mqttWireMessage);
            }
            this.pendingFlows.addElement(mqttWireMessage);
            this.queueLock.notifyAll();
            return;
        }
    }

    public void persistBufferedMessage(MqttWireMessage mqttWireMessage) {
        String string = this.getSendBufferedPersistenceKey(mqttWireMessage);
        try {
            mqttWireMessage.setMessageId(this.getNextMessageId());
            string = this.getSendBufferedPersistenceKey(mqttWireMessage);
            try {
                this.persistence.a(string, (MqttPublish)mqttWireMessage);
            }
            catch (q q2) {
                this.log.a(CLASS_NAME, "persistBufferedMessage", "515");
                this.persistence.a(this.clientComms.getClient().b(), this.clientComms.getClient().c());
                this.persistence.a(string, (MqttPublish)mqttWireMessage);
            }
            this.log.c(CLASS_NAME, "persistBufferedMessage", "513", new Object[]{string});
            return;
        }
        catch (n n2) {
            this.log.b(CLASS_NAME, "persistBufferedMessage", "513", new Object[]{string});
            return;
        }
    }

    public void unPersistBufferedMessage(MqttWireMessage mqttWireMessage) {
        try {
            this.log.c(CLASS_NAME, "unPersistBufferedMessage", "517", new Object[]{mqttWireMessage.getKey()});
            this.persistence.b(this.getSendBufferedPersistenceKey(mqttWireMessage));
            return;
        }
        catch (q q2) {
            this.log.c(CLASS_NAME, "unPersistBufferedMessage", "518", new Object[]{mqttWireMessage.getKey()});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undo(MqttPublish mqttPublish) {
        Object object = this.queueLock;
        synchronized (object) {
            this.log.c(CLASS_NAME, "undo", "618", new Object[]{mqttPublish.getMessageId(), mqttPublish.getMessage().getQos()});
            if (mqttPublish.getMessage().getQos() == 1) {
                this.outboundQoS1.remove(mqttPublish.getMessageId());
            } else {
                this.outboundQoS2.remove(mqttPublish.getMessageId());
            }
            this.pendingMessages.removeElement(mqttPublish);
            this.persistence.b(this.getSendPersistenceKey(mqttPublish));
            this.tokenStore.removeToken(mqttPublish);
            if (mqttPublish.getMessage().getQos() > 0) {
                this.releaseMessageId(mqttPublish.getMessageId());
                mqttPublish.setMessageId(0);
            }
            this.checkQuiesceLock();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeMessage(e e2) {
        Object object = e2.a();
        int n2 = e2.f();
        boolean bl = false;
        Object object2 = this.queueLock;
        synchronized (object2) {
            if (((o)object).getQos() == 1 && this.outboundQoS1.remove(n2) != null) {
                bl = true;
            }
            if (((o)object).getQos() == 2 && this.outboundQoS2.remove(n2) != null) {
                bl = true;
            }
            if (this.pendingMessages.removeElement(object)) {
                bl = true;
            }
            this.persistence.b(this.getSendPersistenceKey(n2));
            object = Integer.toString(n2);
            this.tokenStore.removeToken((String)object);
            this.releaseMessageId(n2);
            this.decrementInFlight();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public t checkForActivity(c c2) {
        this.log.c(CLASS_NAME, "checkForActivity", "616", new Object[0]);
        Object object = this.quiesceLock;
        synchronized (object) {
            if (this.quiescing) {
                return null;
            }
        }
        object = null;
        TimeUnit.NANOSECONDS.toMillis(this.keepAliveNanos);
        if (this.connected && this.keepAliveNanos > 0L) {
            long l2;
            long l3 = System.nanoTime();
            Object object2 = this.pingOutstandingLock;
            synchronized (object2) {
                if (this.pingOutstanding > 0 && l3 - this.lastInboundActivity >= this.keepAliveNanos + 100000L) {
                    this.log.a(CLASS_NAME, "checkForActivity", "619", new Object[]{this.keepAliveNanos, this.lastOutboundActivity, this.lastInboundActivity, l3, this.lastPing});
                    throw ExceptionHelper.createMqttException(32000);
                }
                if (this.pingOutstanding == 0 && l3 - this.lastOutboundActivity >= 2L * this.keepAliveNanos) {
                    this.log.a(CLASS_NAME, "checkForActivity", "642", new Object[]{this.keepAliveNanos, this.lastOutboundActivity, this.lastInboundActivity, l3, this.lastPing});
                    throw ExceptionHelper.createMqttException(32002);
                }
                if (this.pingOutstanding == 0 && l3 - this.lastInboundActivity >= this.keepAliveNanos - 100000L || l3 - this.lastOutboundActivity >= this.keepAliveNanos - 100000L) {
                    this.log.c(CLASS_NAME, "checkForActivity", "620", new Object[]{this.keepAliveNanos, this.lastOutboundActivity, this.lastInboundActivity});
                    object = new t(this.clientComms.getClient().b());
                    if (c2 != null) {
                        ((t)object).a(c2);
                    }
                    this.tokenStore.saveToken((t)object, this.pingCommand);
                    this.pendingFlows.insertElementAt(this.pingCommand, 0);
                    l2 = this.getKeepAlive();
                    this.notifyQueueLock();
                } else {
                    this.log.c(CLASS_NAME, "checkForActivity", "634", null);
                    long l4 = l3 - this.lastOutboundActivity;
                    long l5 = TimeUnit.NANOSECONDS.toMillis(l4);
                    l2 = Math.max(1L, this.getKeepAlive() - l5);
                }
            }
            this.log.c(CLASS_NAME, "checkForActivity", "624", new Object[]{l2});
            this.pingSender.a(l2);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttWireMessage get() {
        MqttWireMessage mqttWireMessage = null;
        Object object = this.queueLock;
        synchronized (object) {
            while (mqttWireMessage == null) {
                if (this.pendingMessages.isEmpty() && this.pendingFlows.isEmpty() || this.pendingFlows.isEmpty() && this.actualInFlight >= this.maxInflight) {
                    try {
                        this.log.a(CLASS_NAME, "get", "644");
                        this.queueLock.wait();
                        this.log.a(CLASS_NAME, "get", "647");
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.pendingFlows == null || !this.connected && (this.pendingFlows.isEmpty() || !((MqttWireMessage)this.pendingFlows.elementAt(0) instanceof MqttConnect))) {
                    this.log.a(CLASS_NAME, "get", "621");
                    return null;
                }
                if (!this.pendingFlows.isEmpty()) {
                    mqttWireMessage = (MqttWireMessage)this.pendingFlows.remove(0);
                    if (mqttWireMessage instanceof MqttPubRel) {
                        ++this.inFlightPubRels;
                        this.log.c(CLASS_NAME, "get", "617", new Object[]{this.inFlightPubRels});
                    }
                    this.checkQuiesceLock();
                    continue;
                }
                if (this.pendingMessages.isEmpty()) continue;
                if (this.actualInFlight < this.maxInflight) {
                    mqttWireMessage = (MqttWireMessage)this.pendingMessages.elementAt(0);
                    this.pendingMessages.removeElementAt(0);
                    ++this.actualInFlight;
                    this.log.c(CLASS_NAME, "get", "623", new Object[]{this.actualInFlight});
                    continue;
                }
                this.log.a(CLASS_NAME, "get", "622");
            }
        }
        return mqttWireMessage;
    }

    public void setKeepAliveInterval(long l2) {
        this.keepAliveNanos = TimeUnit.MILLISECONDS.toNanos(l2);
    }

    public void notifySentBytes(int n2) {
        if (n2 > 0) {
            this.lastOutboundActivity = System.nanoTime();
        }
        this.log.c(CLASS_NAME, "notifySentBytes", "643", new Object[]{n2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySent(MqttWireMessage object) {
        this.lastOutboundActivity = System.nanoTime();
        this.log.c(CLASS_NAME, "notifySent", "625", new Object[]{((MqttWireMessage)object).getKey()});
        Object object2 = ((MqttWireMessage)object).getToken();
        if (object2 == null && (object2 = this.tokenStore.getToken((MqttWireMessage)object)) == null) {
            return;
        }
        ((t)object2).a.notifySent();
        if (object instanceof MqttPingReq) {
            object = this.pingOutstandingLock;
            synchronized (object) {
                long l2 = System.nanoTime();
                object2 = this.pingOutstandingLock;
                synchronized (object2) {
                    this.lastPing = l2;
                    ++this.pingOutstanding;
                }
                this.log.c(CLASS_NAME, "notifySent", "635", new Object[]{this.pingOutstanding});
                return;
            }
        }
        if (object instanceof MqttPublish && ((MqttPublish)object).getMessage().getQos() == 0) {
            ((t)object2).a.markComplete(null, null);
            this.callback.asyncOperationComplete((t)object2);
            this.decrementInFlight();
            this.releaseMessageId(((MqttWireMessage)object).getMessageId());
            this.tokenStore.removeToken((MqttWireMessage)object);
            this.checkQuiesceLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementInFlight() {
        Object object = this.queueLock;
        synchronized (object) {
            --this.actualInFlight;
            this.log.c(CLASS_NAME, "decrementInFlight", "646", new Object[]{this.actualInFlight});
            if (!this.checkQuiesceLock()) {
                this.queueLock.notifyAll();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkQuiesceLock() {
        int n2 = this.tokenStore.count();
        if (this.quiescing && n2 == 0 && this.pendingFlows.size() == 0 && this.callback.isQuiesced()) {
            this.log.c(CLASS_NAME, "checkQuiesceLock", "626", new Object[]{this.quiescing, this.actualInFlight, this.pendingFlows.size(), this.inFlightPubRels, this.callback.isQuiesced(), n2});
            Object object = this.quiesceLock;
            synchronized (object) {
                this.quiesceLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    public void notifyReceivedBytes(int n2) {
        if (n2 > 0) {
            this.lastInboundActivity = System.nanoTime();
        }
        this.log.c(CLASS_NAME, "notifyReceivedBytes", "630", new Object[]{n2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceivedAck(MqttAck mqttAck) {
        this.lastInboundActivity = System.nanoTime();
        this.log.c(CLASS_NAME, "notifyReceivedAck", "627", new Object[]{mqttAck.getMessageId(), mqttAck});
        t t2 = this.tokenStore.getToken(mqttAck);
        if (t2 == null) {
            this.log.c(CLASS_NAME, "notifyReceivedAck", "662", new Object[]{mqttAck.getMessageId()});
        } else if (mqttAck instanceof MqttPubRec) {
            MqttPubRel mqttPubRel = new MqttPubRel((MqttPubRec)mqttAck);
            this.send(mqttPubRel, t2);
        } else if (mqttAck instanceof MqttPubAck || mqttAck instanceof MqttPubComp) {
            this.notifyResult(mqttAck, t2, null);
        } else if (mqttAck instanceof MqttPingResp) {
            Object object = this.pingOutstandingLock;
            synchronized (object) {
                this.pingOutstanding = Math.max(0, this.pingOutstanding - 1);
                this.notifyResult(mqttAck, t2, null);
                if (this.pingOutstanding == 0) {
                    this.tokenStore.removeToken(mqttAck);
                }
            }
            this.log.c(CLASS_NAME, "notifyReceivedAck", "636", new Object[]{this.pingOutstanding});
        } else if (mqttAck instanceof MqttConnack) {
            Object object;
            int n2 = ((MqttConnack)mqttAck).getReturnCode();
            if (n2 == 0) {
                object = this.queueLock;
                synchronized (object) {
                    if (this.cleanSession) {
                        this.clearState();
                        this.tokenStore.saveToken(t2, mqttAck);
                    }
                    this.inFlightPubRels = 0;
                    this.actualInFlight = 0;
                    this.restoreInflightMessages();
                    this.connected();
                }
            } else {
                throw ExceptionHelper.createMqttException(n2);
            }
            this.clientComms.connectComplete((MqttConnack)mqttAck, null);
            this.notifyResult(mqttAck, t2, null);
            this.tokenStore.removeToken(mqttAck);
            object = this.queueLock;
            synchronized (object) {
                this.queueLock.notifyAll();
            }
        } else {
            this.notifyResult(mqttAck, t2, null);
            this.releaseMessageId(mqttAck.getMessageId());
            this.tokenStore.removeToken(mqttAck);
        }
        this.checkQuiesceLock();
    }

    protected void notifyReceivedMsg(MqttWireMessage mqttWireMessage) {
        this.lastInboundActivity = System.nanoTime();
        this.log.c(CLASS_NAME, "notifyReceivedMsg", "651", new Object[]{mqttWireMessage.getMessageId(), mqttWireMessage});
        if (!this.quiescing) {
            if (mqttWireMessage instanceof MqttPublish) {
                MqttPublish mqttPublish = (MqttPublish)mqttWireMessage;
                switch (mqttPublish.getMessage().getQos()) {
                    case 0: 
                    case 1: {
                        if (this.callback == null) break;
                        this.callback.messageArrived(mqttPublish);
                        return;
                    }
                    case 2: {
                        this.persistence.a(this.getReceivedPersistenceKey(mqttWireMessage), (MqttPublish)mqttWireMessage);
                        this.inboundQoS2.put(mqttPublish.getMessageId(), mqttPublish);
                        this.send(new MqttPubRec(mqttPublish), null);
                    }
                }
                return;
            }
            if (mqttWireMessage instanceof MqttPubRel) {
                MqttPublish mqttPublish = (MqttPublish)this.inboundQoS2.get(mqttWireMessage.getMessageId());
                if (mqttPublish != null) {
                    if (this.callback != null) {
                        this.callback.messageArrived(mqttPublish);
                        return;
                    }
                } else {
                    mqttWireMessage = new MqttPubComp(mqttWireMessage.getMessageId());
                    this.send(mqttWireMessage, null);
                }
            }
        }
    }

    protected void notifyComplete(t object) {
        MqttWireMessage mqttWireMessage = ((t)object).a.getWireMessage();
        if (mqttWireMessage != null && mqttWireMessage instanceof MqttAck) {
            this.log.c(CLASS_NAME, "notifyComplete", "629", new Object[]{mqttWireMessage.getMessageId(), object, mqttWireMessage});
            object = (MqttAck)mqttWireMessage;
            if (object instanceof MqttPubAck) {
                this.persistence.b(this.getSendPersistenceKey(mqttWireMessage));
                this.persistence.b(this.getSendBufferedPersistenceKey(mqttWireMessage));
                this.outboundQoS1.remove(((MqttWireMessage)object).getMessageId());
                this.decrementInFlight();
                this.releaseMessageId(mqttWireMessage.getMessageId());
                this.tokenStore.removeToken(mqttWireMessage);
                this.log.c(CLASS_NAME, "notifyComplete", "650", new Object[]{((MqttWireMessage)object).getMessageId()});
            } else if (object instanceof MqttPubComp) {
                this.persistence.b(this.getSendPersistenceKey(mqttWireMessage));
                this.persistence.b(this.getSendConfirmPersistenceKey(mqttWireMessage));
                this.persistence.b(this.getSendBufferedPersistenceKey(mqttWireMessage));
                this.outboundQoS2.remove(((MqttWireMessage)object).getMessageId());
                --this.inFlightPubRels;
                this.decrementInFlight();
                this.releaseMessageId(mqttWireMessage.getMessageId());
                this.tokenStore.removeToken(mqttWireMessage);
                this.log.c(CLASS_NAME, "notifyComplete", "645", new Object[]{((MqttWireMessage)object).getMessageId(), this.inFlightPubRels});
            }
            this.checkQuiesceLock();
        }
    }

    protected void notifyResult(MqttWireMessage mqttWireMessage, t t2, n n2) {
        t2.a.markComplete(mqttWireMessage, n2);
        t2.a.notifyComplete();
        if (mqttWireMessage != null && mqttWireMessage instanceof MqttAck && !(mqttWireMessage instanceof MqttPubRec)) {
            this.log.c(CLASS_NAME, "notifyResult", "648", new Object[]{t2.a.getKey(), mqttWireMessage, n2});
            this.callback.asyncOperationComplete(t2);
        }
        if (mqttWireMessage == null) {
            this.log.c(CLASS_NAME, "notifyResult", "649", new Object[]{t2.a.getKey(), n2});
            this.callback.asyncOperationComplete(t2);
        }
    }

    public void connected() {
        this.log.a(CLASS_NAME, "connected", "631");
        this.connected = true;
        this.pingSender.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Vector resolveOldTokens(n serializable) {
        this.log.c(CLASS_NAME, "resolveOldTokens", "632", new Object[]{serializable});
        Serializable serializable2 = serializable;
        if (serializable == null) {
            serializable2 = new n(32102);
        }
        serializable = this.tokenStore.getOutstandingTokens();
        Enumeration enumeration = ((Vector)serializable).elements();
        while (enumeration.hasMoreElements()) {
            t t2;
            t t3 = t2 = (t)enumeration.nextElement();
            // MONITORENTER : t2
            if (!t2.a.isComplete() && !t2.a.isCompletePending() && t2.a.getException() == null) {
                t2.a.setException((n)serializable2);
            }
            // MONITOREXIT : t3
            if (t2 instanceof m) continue;
            this.tokenStore.removeToken(t2.a.getKey());
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(n object) {
        this.log.c(CLASS_NAME, "disconnected", "633", new Object[]{object});
        this.connected = false;
        try {
            if (this.cleanSession) {
                this.clearState();
            }
            this.pendingMessages.clear();
            this.pendingFlows.clear();
            object = this.pingOutstandingLock;
            synchronized (object) {
                this.pingOutstanding = 0;
                return;
            }
        }
        catch (n n2) {
            return;
        }
    }

    private synchronized void releaseMessageId(int n2) {
        this.inUseMsgIds.remove(n2);
    }

    private synchronized int getNextMessageId() {
        Integer n2;
        int n3 = this.nextMsgId;
        int n4 = 0;
        do {
            ++this.nextMsgId;
            if (this.nextMsgId > 65535) {
                this.nextMsgId = 1;
            }
            if (this.nextMsgId != n3 || ++n4 != 2) continue;
            throw ExceptionHelper.createMqttException(32001);
        } while (this.inUseMsgIds.containsKey(this.nextMsgId));
        Integer n5 = n2 = Integer.valueOf(this.nextMsgId);
        this.inUseMsgIds.put(n5, n5);
        return this.nextMsgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(long l2) {
        if (l2 > 0L) {
            this.log.c(CLASS_NAME, "quiesce", "637", new Object[]{l2});
            Object object = this.queueLock;
            synchronized (object) {
                this.quiescing = true;
            }
            this.callback.quiesce();
            this.notifyQueueLock();
            object = this.quiesceLock;
            synchronized (object) {
                try {
                    int n2 = this.tokenStore.count();
                    if (n2 > 0 || this.pendingFlows.size() > 0 || !this.callback.isQuiesced()) {
                        this.log.c(CLASS_NAME, "quiesce", "639", new Object[]{this.actualInFlight, this.pendingFlows.size(), this.inFlightPubRels, n2});
                        this.quiesceLock.wait(l2);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            object = this.queueLock;
            synchronized (object) {
                this.pendingMessages.clear();
                this.pendingFlows.clear();
                this.quiescing = false;
                this.actualInFlight = 0;
            }
            this.log.a(CLASS_NAME, "quiesce", "640");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyQueueLock() {
        Object object = this.queueLock;
        synchronized (object) {
            this.log.a(CLASS_NAME, "notifyQueueLock", "638");
            this.queueLock.notifyAll();
            return;
        }
    }

    protected void deliveryComplete(MqttPublish mqttPublish) {
        this.log.c(CLASS_NAME, "deliveryComplete", "641", new Object[]{mqttPublish.getMessageId()});
        this.persistence.b(this.getReceivedPersistenceKey(mqttPublish));
        this.inboundQoS2.remove(mqttPublish.getMessageId());
    }

    protected void deliveryComplete(int n2) {
        this.log.c(CLASS_NAME, "deliveryComplete", "641", new Object[]{n2});
        this.persistence.b(this.getReceivedPersistenceKey(n2));
        this.inboundQoS2.remove(n2);
    }

    public int getActualInFlight() {
        return this.actualInFlight;
    }

    public int getMaxInFlight() {
        return this.maxInflight;
    }

    protected void close() {
        this.inUseMsgIds.clear();
        if (this.pendingMessages != null) {
            this.pendingMessages.clear();
        }
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.outboundQoS0.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
        this.inUseMsgIds = null;
        this.pendingMessages = null;
        this.pendingFlows = null;
        this.outboundQoS2 = null;
        this.outboundQoS1 = null;
        this.outboundQoS0 = null;
        this.inboundQoS2 = null;
        this.tokenStore = null;
        this.callback = null;
        this.clientComms = null;
        this.persistence = null;
        this.pingCommand = null;
    }

    public Properties getDebug() {
        Properties properties = new Properties();
        properties.put("In use msgids", this.inUseMsgIds);
        properties.put("pendingMessages", this.pendingMessages);
        properties.put("pendingFlows", this.pendingFlows);
        properties.put("maxInflight", (Object)this.maxInflight);
        properties.put("nextMsgID", (Object)this.nextMsgId);
        properties.put("actualInFlight", (Object)this.actualInFlight);
        properties.put("inFlightPubRels", (Object)this.inFlightPubRels);
        properties.put("quiescing", (Object)this.quiescing);
        properties.put("pingoutstanding", (Object)this.pingOutstanding);
        properties.put("lastOutboundActivity", (Object)this.lastOutboundActivity);
        properties.put("lastInboundActivity", (Object)this.lastInboundActivity);
        properties.put("outboundQoS2", this.outboundQoS2);
        properties.put("outboundQoS1", this.outboundQoS1);
        properties.put("outboundQoS0", this.outboundQoS0);
        properties.put("inboundQoS2", this.inboundQoS2);
        properties.put("tokens", this.tokenStore);
        return properties;
    }
}

