/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal;

import com.mq.mgmi.client.message.a.b;
import com.mq.mgmi.client.message.c;
import com.mq.mgmi.client.message.f;
import com.mq.mgmi.client.message.i;
import com.mq.mgmi.client.message.internal.ClientComms;
import com.mq.mgmi.client.message.internal.ClientState;
import com.mq.mgmi.client.message.internal.wire.MqttPubAck;
import com.mq.mgmi.client.message.internal.wire.MqttPubComp;
import com.mq.mgmi.client.message.internal.wire.MqttPublish;
import com.mq.mgmi.client.message.internal.wire.MqttWireMessage;
import com.mq.mgmi.client.message.j;
import com.mq.mgmi.client.message.m;
import com.mq.mgmi.client.message.n;
import com.mq.mgmi.client.message.o;
import com.mq.mgmi.client.message.t;
import com.mq.mgmi.client.message.u;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class CommsCallback
implements Runnable {
    private static final String CLASS_NAME = CommsCallback.class.getName();
    private final b log = com.mq.mgmi.client.message.a.c.a("com.mq.mgmi.client.message.internal.nls.logcat", CLASS_NAME);
    private static final int INBOUND_QUEUE_SIZE = 10;
    private i mqttCallback;
    private j reconnectInternalCallback;
    private Hashtable<String, f> callbacks;
    private ClientComms clientComms;
    private final Vector<MqttWireMessage> messageQueue;
    private final Vector<t> completeQueue;
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private Thread callbackThread;
    private String threadName;
    private Future<?> callbackFuture;
    private final Object workAvailable = new Object();
    private final Object spaceAvailable = new Object();
    private ClientState clientState;
    private boolean manualAcks = false;

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(10);
        this.completeQueue = new Vector(10);
        this.callbacks = new Hashtable();
        this.log.a(clientComms.getClient().b());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String object, ExecutorService executorService) {
        this.threadName = object;
        object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.STOPPED) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.callbackFuture = executorService.submit(this);
                }
            }
        }
        while (!this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.callbackFuture != null) {
                this.callbackFuture.cancel(true);
            }
        }
        if (this.isRunning()) {
            this.log.a(CLASS_NAME, "stop", "700");
            object = this.lifecycle;
            synchronized (object) {
                this.target_state = State.STOPPED;
            }
            if (!Thread.currentThread().equals(this.callbackThread)) {
                object = this.workAvailable;
                synchronized (object) {
                    this.log.a(CLASS_NAME, "stop", "701");
                    this.workAvailable.notifyAll();
                }
                while (this.isRunning()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    this.clientState.notifyQueueLock();
                }
            }
            this.log.a(CLASS_NAME, "stop", "703");
        }
    }

    public void setCallback(i i2) {
        this.mqttCallback = i2;
    }

    public void setReconnectCallback(j j2) {
        this.reconnectInternalCallback = j2;
    }

    public void setManualAcks(boolean bl) {
        this.manualAcks = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.callbackThread = Thread.currentThread();
        this.callbackThread.setName(this.threadName);
        Object object = this.lifecycle;
        synchronized (object) {
            this.current_state = State.RUNNING;
        }
        while (this.isRunning()) {
            try {
                try {
                    object = this.workAvailable;
                    synchronized (object) {
                        if (this.isRunning() && this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                            this.log.a(CLASS_NAME, "run", "704");
                            this.workAvailable.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
                if (this.isRunning()) {
                    object = null;
                    Object object2 = this.completeQueue;
                    synchronized (object2) {
                        if (!this.completeQueue.isEmpty()) {
                            object = this.completeQueue.elementAt(0);
                            this.completeQueue.removeElementAt(0);
                        }
                    }
                    if (object != null) {
                        this.handleActionComplete((t)object);
                    }
                    object2 = null;
                    Vector<MqttWireMessage> vector = this.messageQueue;
                    synchronized (vector) {
                        if (!this.messageQueue.isEmpty()) {
                            object2 = (MqttPublish)this.messageQueue.elementAt(0);
                            this.messageQueue.removeElementAt(0);
                        }
                    }
                    if (object2 != null) {
                        this.handleMessage((MqttPublish)object2);
                    }
                }
                if (!this.isQuiescing()) continue;
                this.clientState.checkQuiesceLock();
            }
            catch (Throwable throwable) {
                this.log.b(CLASS_NAME, "run", "714", null, throwable);
                this.clientComms.shutdownConnection(null, new n(throwable));
            }
            finally {
                object = this.spaceAvailable;
                synchronized (object) {
                    this.log.a(CLASS_NAME, "run", "706");
                    this.spaceAvailable.notifyAll();
                }
            }
        }
        object = this.lifecycle;
        synchronized (object) {
            this.current_state = State.STOPPED;
        }
        this.callbackThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(t t2) {
        t t3 = t2;
        synchronized (t3) {
            this.log.c(CLASS_NAME, "handleActionComplete", "705", new Object[]{t2.a.getKey()});
            if (t2.a.isComplete()) {
                this.clientState.notifyComplete(t2);
            }
            t2.a.notifyComplete();
            if (!t2.a.isNotified()) {
                if (this.mqttCallback != null && t2 instanceof m && t2.a.isComplete()) {
                    this.mqttCallback.a((m)t2);
                }
                this.fireActionEvent(t2);
            }
            if (t2.a.isComplete() && t2 instanceof m) {
                t2.a.setNotified(true);
            }
            return;
        }
    }

    public void connectionLost(n n2) {
        try {
            if (this.mqttCallback != null && n2 != null) {
                this.log.c(CLASS_NAME, "connectionLost", "708", new Object[]{n2});
                this.mqttCallback.a(n2);
            }
            if (this.reconnectInternalCallback != null && n2 != null) {
                this.reconnectInternalCallback.a(n2);
            }
            return;
        }
        catch (Throwable throwable) {
            this.log.c(CLASS_NAME, "connectionLost", "720", new Object[]{throwable});
            return;
        }
    }

    public void fireActionEvent(t t2) {
        c c2;
        if (t2 != null && (c2 = t2.a.getActionCallback()) != null) {
            if (t2.a.getException() == null) {
                this.log.c(CLASS_NAME, "fireActionEvent", "716", new Object[]{t2.a.getKey()});
                c2.onSuccess(t2);
                return;
            }
            this.log.c(CLASS_NAME, "fireActionEvent", "716", new Object[]{t2.a.getKey()});
            t t3 = t2;
            c2.onFailure(t3, t3.a.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(MqttPublish mqttPublish) {
        if (this.mqttCallback != null || this.callbacks.size() > 0) {
            Object object = this.spaceAvailable;
            synchronized (object) {
                while (this.isRunning() && !this.isQuiescing() && this.messageQueue.size() >= 10) {
                    try {
                        this.log.a(CLASS_NAME, "messageArrived", "709");
                        this.spaceAvailable.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.isQuiescing()) {
                this.messageQueue.addElement(mqttPublish);
                object = this.workAvailable;
                synchronized (object) {
                    this.log.a(CLASS_NAME, "messageArrived", "710");
                    this.workAvailable.notifyAll();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.RUNNING) {
                this.current_state = State.QUIESCING;
            }
        }
        object = this.spaceAvailable;
        synchronized (object) {
            this.log.a(CLASS_NAME, "quiesce", "711");
            this.spaceAvailable.notifyAll();
            return;
        }
    }

    public boolean isQuiesced() {
        return this.isQuiescing() && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish mqttWireMessage) {
        String string = mqttWireMessage.getTopicName();
        this.log.c(CLASS_NAME, "handleMessage", "713", new Object[]{mqttWireMessage.getMessageId(), string});
        this.deliverMessage(string, mqttWireMessage.getMessageId(), mqttWireMessage.getMessage());
        if (!this.manualAcks) {
            if (mqttWireMessage.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck((MqttPublish)mqttWireMessage), new t(this.clientComms.getClient().b()));
                return;
            }
            if (mqttWireMessage.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete((MqttPublish)mqttWireMessage);
                mqttWireMessage = new MqttPubComp((MqttPublish)mqttWireMessage);
                this.clientComms.internalSend(mqttWireMessage, new t(this.clientComms.getClient().b()));
            }
        }
    }

    public void messageArrivedComplete(int n2, int n3) {
        if (n3 == 1) {
            this.clientComms.internalSend(new MqttPubAck(n2), new t(this.clientComms.getClient().b()));
            return;
        }
        if (n3 == 2) {
            this.clientComms.deliveryComplete(n2);
            MqttPubComp mqttPubComp = new MqttPubComp(n2);
            this.clientComms.internalSend(mqttPubComp, new t(this.clientComms.getClient().b()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(t t2) {
        if (this.isRunning()) {
            this.completeQueue.addElement(t2);
            Object object = this.workAvailable;
            synchronized (object) {
                this.log.c(CLASS_NAME, "asyncOperationComplete", "715", new Object[]{t2.a.getKey()});
                this.workAvailable.notifyAll();
                return;
            }
        }
        try {
            this.handleActionComplete(t2);
            return;
        }
        catch (Throwable throwable) {
            this.log.b(CLASS_NAME, "asyncOperationComplete", "719", null, throwable);
            this.clientComms.shutdownConnection(null, new n(throwable));
            return;
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }

    public void setMessageListener(String string, f f2) {
        this.callbacks.put(string, f2);
    }

    public void removeMessageListener(String string) {
        this.callbacks.remove(string);
    }

    public void removeMessageListeners() {
        this.callbacks.clear();
    }

    protected boolean deliverMessage(String string, int n2, o o2) {
        boolean bl = false;
        Enumeration<String> enumeration = this.callbacks.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (this.callbacks.get(string2) == null || !u.a(string2, string)) continue;
            o2.setId(n2);
            bl = true;
        }
        if (this.mqttCallback != null && !bl) {
            o2.setId(n2);
            this.mqttCallback.a(string, o2);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = (this.current_state == State.RUNNING || this.current_state == State.QUIESCING) && this.target_state == State.RUNNING;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuiescing() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = this.current_state == State.QUIESCING;
        }
        return bl;
    }

    static enum State {
        STOPPED,
        RUNNING,
        QUIESCING;

    }
}

