/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal;

import com.mq.mgmi.client.message.a.b;
import com.mq.mgmi.client.message.a.c;
import com.mq.mgmi.client.message.internal.ClientComms;
import com.mq.mgmi.client.message.internal.ClientState;
import com.mq.mgmi.client.message.internal.CommsTokenStore;
import com.mq.mgmi.client.message.internal.wire.MqttAck;
import com.mq.mgmi.client.message.internal.wire.MqttInputStream;
import com.mq.mgmi.client.message.internal.wire.MqttPubAck;
import com.mq.mgmi.client.message.internal.wire.MqttPubComp;
import com.mq.mgmi.client.message.internal.wire.MqttPubRec;
import com.mq.mgmi.client.message.internal.wire.MqttWireMessage;
import com.mq.mgmi.client.message.n;
import com.mq.mgmi.client.message.t;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class CommsReceiver
implements Runnable {
    private static final String CLASS_NAME = CommsReceiver.class.getName();
    private b log = c.a("com.mq.mgmi.client.message.internal.nls.logcat", CLASS_NAME);
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private String threadName;
    private Future<?> receiverFuture;
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore commsTokenStore, InputStream inputStream) {
        this.in = new MqttInputStream(clientState, inputStream);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = commsTokenStore;
        this.log.a(clientComms.getClient().b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String object, ExecutorService executorService) {
        this.threadName = object;
        this.log.a(CLASS_NAME, "start", "855");
        object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.STOPPED && this.target_state == State.STOPPED) {
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.receiverFuture = executorService.submit(this);
                }
            }
        }
        while (!this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.receiverFuture != null) {
                this.receiverFuture.cancel(true);
            }
            this.log.a(CLASS_NAME, "stop", "850");
            if (this.isRunning()) {
                this.target_state = State.STOPPED;
            }
        }
        while (this.isRunning()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.log.a(CLASS_NAME, "stop", "851");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.recThread = Thread.currentThread();
        this.recThread.setName(this.threadName);
        t t2 = null;
        Object object = this.lifecycle;
        // MONITORENTER : object
        this.current_state = State.RUNNING;
        // MONITOREXIT : object
        try {
            Object object2 = this.lifecycle;
            // MONITORENTER : object2
            object = this.target_state;
            // MONITOREXIT : object2
            while (object == State.RUNNING && this.in != null) {
                block47: {
                    try {
                        this.log.a(CLASS_NAME, "run", "852");
                        if (this.in.available() > 0) {
                            object2 = this.lifecycle;
                            // MONITORENTER : object2
                            this.current_state = State.RECEIVING;
                            // MONITOREXIT : object2
                        }
                        object2 = this.in.readMqttWireMessage();
                        object = this.lifecycle;
                        // MONITORENTER : object
                        this.current_state = State.RUNNING;
                        // MONITOREXIT : object
                        if (object2 instanceof MqttAck) {
                            t2 = this.tokenStore.getToken((MqttWireMessage)object2);
                            if (t2 != null) {
                                object = t2;
                                // MONITORENTER : object
                                this.clientState.notifyReceivedAck((MqttAck)object2);
                                // MONITOREXIT : object
                                break block47;
                            } else {
                                if (!(object2 instanceof MqttPubRec) && !(object2 instanceof MqttPubComp)) {
                                    if (!(object2 instanceof MqttPubAck)) throw new n(6);
                                }
                                this.log.a(CLASS_NAME, "run", "857");
                            }
                            break block47;
                        }
                        if (object2 != null) {
                            this.clientState.notifyReceivedMsg((MqttWireMessage)object2);
                        } else if (!this.clientComms.isConnected()) {
                            throw new IOException("Connection is lost.");
                        }
                    }
                    catch (n n2) {
                        this.log.b(CLASS_NAME, "run", "856", null, n2);
                        object = this.lifecycle;
                        // MONITORENTER : object
                        this.target_state = State.STOPPED;
                        // MONITOREXIT : object
                        this.clientComms.shutdownConnection(t2, n2);
                    }
                    catch (IOException iOException) {
                        try {
                            this.log.a(CLASS_NAME, "run", "853");
                            if (this.target_state == State.STOPPED) break block47;
                            object = this.lifecycle;
                            // MONITORENTER : object
                            this.target_state = State.STOPPED;
                            // MONITOREXIT : object
                            if (!this.clientComms.isDisconnecting()) {
                                this.clientComms.shutdownConnection(t2, new n(32109, (Throwable)iOException));
                            }
                        }
                        catch (Throwable throwable) {
                            object = this.lifecycle;
                            // MONITORENTER : object
                            this.current_state = State.RUNNING;
                            // MONITOREXIT : object
                            throw throwable;
                        }
                    }
                    finally {
                        object2 = this.lifecycle;
                    }
                }
                object2 = this.lifecycle;
                // MONITORENTER : object2
                object = this.target_state;
                // MONITOREXIT : object2
            }
            object = this.lifecycle;
        }
        catch (Throwable throwable) {
            object = this.lifecycle;
            // MONITORENTER : object
            this.current_state = State.STOPPED;
            // MONITOREXIT : object
            throw throwable;
        }
        this.current_state = State.STOPPED;
        // MONITOREXIT : object
        this.recThread = null;
        this.log.a(CLASS_NAME, "run", "854");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = (this.current_state == State.RUNNING || this.current_state == State.RECEIVING) && this.target_state == State.RUNNING;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceiving() {
        boolean bl;
        Object object = this.lifecycle;
        synchronized (object) {
            bl = this.current_state == State.RECEIVING;
        }
        return bl;
    }

    static enum State {
        STOPPED,
        RUNNING,
        STARTING,
        RECEIVING;

    }
}

