/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal;

import com.mq.mgmi.client.message.a.b;
import com.mq.mgmi.client.message.a.c;
import com.mq.mgmi.client.message.internal.NetworkModule;
import com.mq.mgmi.client.message.l;
import com.mq.mgmi.client.message.spi.NetworkModuleFactory;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetworkModuleService {
    private static b LOG = c.a("com.mq.mgmi.client.message.internal.nls.logcat", NetworkModuleService.class.getSimpleName());
    private static final ServiceLoader<NetworkModuleFactory> FACTORY_SERVICE_LOADER = ServiceLoader.load(NetworkModuleFactory.class, NetworkModuleService.class.getClassLoader());
    private static final Pattern AUTHORITY_PATTERN = Pattern.compile("((.+)@)?([^:]*)(:(\\d+))?");
    private static final int AUTH_GROUP_USERINFO = 2;
    private static final int AUTH_GROUP_HOST = 3;
    private static final int AUTH_GROUP_PORT = 5;

    private NetworkModuleService() {
    }

    public static synchronized void validateURI(String string) {
        try {
            URI uRI = new URI(string);
            String string2 = uRI.getScheme();
            if (string2 == null || string2.isEmpty()) {
                throw new IllegalArgumentException("missing scheme in broker URI: ".concat(String.valueOf(string)));
            }
            string2 = string2.toLowerCase();
            for (NetworkModuleFactory networkModuleFactory : FACTORY_SERVICE_LOADER) {
                if (!networkModuleFactory.getSupportedUriSchemes().contains(string2)) continue;
                networkModuleFactory.validateURI(uRI);
                return;
            }
            throw new IllegalArgumentException("no NetworkModule installed for scheme \"" + string2 + "\" of URI \"" + string + "\"");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Can't parse string to URI \"" + string + "\"", uRISyntaxException);
        }
    }

    public static NetworkModule createInstance(String string, l l2, String string2) {
        try {
            URI uRI = new URI(string);
            NetworkModuleService.applyRFC3986AuthorityPatch(uRI);
            String string3 = uRI.getScheme().toLowerCase();
            for (NetworkModuleFactory networkModuleFactory : FACTORY_SERVICE_LOADER) {
                if (!networkModuleFactory.getSupportedUriSchemes().contains(string3)) continue;
                return networkModuleFactory.createNetworkModule(uRI, l2, string2);
            }
            throw new IllegalArgumentException(uRI.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(string, uRISyntaxException);
        }
    }

    public static void applyRFC3986AuthorityPatch(URI uRI) {
        if (uRI == null || uRI.getHost() != null || uRI.getAuthority() == null || uRI.getAuthority().isEmpty()) {
            return;
        }
        Object object = AUTHORITY_PATTERN.matcher(uRI.getAuthority());
        if (((Matcher)object).find()) {
            NetworkModuleService.setURIField(uRI, "userInfo", ((Matcher)object).group(2));
            NetworkModuleService.setURIField(uRI, "host", ((Matcher)object).group(3));
            object = ((Matcher)object).group(5);
            NetworkModuleService.setURIField(uRI, "port", object != null ? Integer.parseInt((String)object) : -1);
        }
    }

    private static void setURIField(URI uRI, String object, Object object2) {
        try {
            object = URI.class.getDeclaredField((String)object);
            ((Field)object).setAccessible(true);
            ((Field)object).set(uRI, object2);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            LOG.a(NetworkModuleService.class.getName(), "setURIField", "115", new Object[]{uRI.toString()}, exception);
            return;
        }
    }
}

