/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal.security;

import com.mq.mgmi.client.message.a.b;
import com.mq.mgmi.client.message.internal.security.SimpleBase64Encoder;
import com.mq.mgmi.client.message.s;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLSocketFactoryFactory {
    private static final String CLASS_NAME = "com.mq.mgmi.client.message.internal.security.SSLSocketFactoryFactory";
    public static final String SSLPROTOCOL = "com.ibm.ssl.protocol";
    public static final String JSSEPROVIDER = "com.ibm.ssl.contextProvider";
    public static final String KEYSTORE = "com.ibm.ssl.keyStore";
    public static final String KEYSTOREPWD = "com.ibm.ssl.keyStorePassword";
    public static final String KEYSTORETYPE = "com.ibm.ssl.keyStoreType";
    public static final String KEYSTOREPROVIDER = "com.ibm.ssl.keyStoreProvider";
    public static final String KEYSTOREMGR = "com.ibm.ssl.keyManager";
    public static final String TRUSTSTORE = "com.ibm.ssl.trustStore";
    public static final String TRUSTSTOREPWD = "com.ibm.ssl.trustStorePassword";
    public static final String TRUSTSTORETYPE = "com.ibm.ssl.trustStoreType";
    public static final String TRUSTSTOREPROVIDER = "com.ibm.ssl.trustStoreProvider";
    public static final String TRUSTSTOREMGR = "com.ibm.ssl.trustManager";
    public static final String CIPHERSUITES = "com.ibm.ssl.enabledCipherSuites";
    public static final String CLIENTAUTH = "com.ibm.ssl.clientAuthentication";
    public static final String SYSKEYSTORE = "javax.net.ssl.keyStore";
    public static final String SYSKEYSTORETYPE = "javax.net.ssl.keyStoreType";
    public static final String SYSKEYSTOREPWD = "javax.net.ssl.keyStorePassword";
    public static final String SYSTRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String SYSTRUSTSTORETYPE = "javax.net.ssl.trustStoreType";
    public static final String SYSTRUSTSTOREPWD = "javax.net.ssl.trustStorePassword";
    public static final String SYSKEYMGRALGO = "ssl.KeyManagerFactory.algorithm";
    public static final String SYSTRUSTMGRALGO = "ssl.TrustManagerFactory.algorithm";
    public static final String DEFAULT_PROTOCOL = "TLS";
    private static final String[] propertyKeys = new String[]{"com.ibm.ssl.protocol", "com.ibm.ssl.contextProvider", "com.ibm.ssl.keyStore", "com.ibm.ssl.keyStorePassword", "com.ibm.ssl.keyStoreType", "com.ibm.ssl.keyStoreProvider", "com.ibm.ssl.keyManager", "com.ibm.ssl.trustStore", "com.ibm.ssl.trustStorePassword", "com.ibm.ssl.trustStoreType", "com.ibm.ssl.trustStoreProvider", "com.ibm.ssl.trustManager", "com.ibm.ssl.enabledCipherSuites", "com.ibm.ssl.clientAuthentication"};
    private Hashtable configs = new Hashtable();
    private Properties defaultProperties;
    private static final byte[] key = new byte[]{-99, -89, -39, -128, 5, -72, -119, -100};
    private static final String xorTag = "{xor}";
    private b logger = null;

    public static boolean isSupportedOnJVM() {
        String string = "javax.net.ssl.SSLServerSocketFactory";
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public SSLSocketFactoryFactory() {
    }

    public SSLSocketFactoryFactory(b b2) {
        this();
        this.logger = b2;
    }

    private boolean keyValid(String string) {
        int n2;
        for (n2 = 0; n2 < propertyKeys.length && !propertyKeys[n2].equals(string); ++n2) {
        }
        return n2 < propertyKeys.length;
    }

    private void checkPropertyKeys(Properties object) {
        for (String string : ((Properties)((Object)object)).keySet()) {
            if (this.keyValid(string)) continue;
            throw new IllegalArgumentException(string + " is not a valid IBM SSL property key.");
        }
    }

    public static char[] toChar(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            cArray[n3++] = (char)((byArray[n2++] & 0xFF) + ((byArray[n2++] & 0xFF) << 8));
        }
        return cArray;
    }

    public static byte[] toByte(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            byArray[n2++] = (byte)(cArray[n3] & 0xFF);
            byArray[n2++] = (byte)(cArray[n3++] >> 8 & 0xFF);
        }
        return byArray;
    }

    public static String obfuscate(char[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        objectArray = SSLSocketFactoryFactory.toByte(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = (char)((objectArray[i2] ^ key[i2 % key.length]) & 0xFF);
        }
        return xorTag + new String(SimpleBase64Encoder.encode((byte[])objectArray));
    }

    public static char[] deObfuscate(String object) {
        if (object == null) {
            return null;
        }
        try {
            object = SimpleBase64Encoder.decode(((String)object).substring(5));
        }
        catch (Exception exception) {
            return null;
        }
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            object[i2] = (byte)((object[i2] ^ key[i2 % key.length]) & 0xFF);
        }
        return SSLSocketFactoryFactory.toChar((byte[])object);
    }

    public static String packCipherSuites(String[] stringArray) {
        CharSequence charSequence = null;
        if (stringArray != null) {
            charSequence = new StringBuffer();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                ((StringBuffer)charSequence).append(stringArray[i2]);
                if (i2 >= stringArray.length - 1) continue;
                ((StringBuffer)charSequence).append(',');
            }
            charSequence = ((StringBuffer)charSequence).toString();
        }
        return charSequence;
    }

    public static String[] unpackCipherSuites(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = stringArray.indexOf(44);
        int n3 = 0;
        while (n2 >= 0) {
            vector.add(stringArray.substring(n3, n2));
            n3 = n2 + 1;
            n2 = stringArray.indexOf(44, n3);
        }
        vector.add(stringArray.substring(n3));
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private void convertPassword(Properties properties) {
        String string = properties.getProperty(KEYSTOREPWD);
        if (string != null && !string.startsWith(xorTag)) {
            string = SSLSocketFactoryFactory.obfuscate(string.toCharArray());
            properties.put(KEYSTOREPWD, string);
        }
        if ((string = properties.getProperty(TRUSTSTOREPWD)) != null && !string.startsWith(xorTag)) {
            string = SSLSocketFactoryFactory.obfuscate(string.toCharArray());
            properties.put(TRUSTSTOREPWD, string);
        }
    }

    public void initialize(Properties properties, String string) {
        this.checkPropertyKeys(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        this.convertPassword(properties2);
        if (string != null) {
            this.configs.put(string, properties2);
            return;
        }
        this.defaultProperties = properties2;
    }

    public void merge(Properties properties, String string) {
        this.checkPropertyKeys(properties);
        Properties properties2 = this.defaultProperties;
        if (string != null) {
            properties2 = (Properties)this.configs.get(string);
        }
        if (properties2 == null) {
            properties2 = new Properties();
        }
        this.convertPassword(properties);
        properties2.putAll((Map<?, ?>)properties);
        if (string != null) {
            this.configs.put(string, properties2);
            return;
        }
        this.defaultProperties = properties2;
    }

    public boolean remove(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.configs.remove(string) != null;
        } else if (this.defaultProperties != null) {
            bl = true;
            this.defaultProperties = null;
        }
        return bl;
    }

    public Properties getConfiguration(String string) {
        return string == null ? this.defaultProperties : this.configs.get(string);
    }

    private String getProperty(String string, String string2, String string3) {
        if ((string = this.getPropertyFromConfig(string, string2)) != null) {
            return string;
        }
        if (string3 != null) {
            string = System.getProperty(string3);
        }
        return string;
    }

    private String getPropertyFromConfig(String string, String string2) {
        String string3 = null;
        Properties properties = null;
        if (string != null) {
            properties = (Properties)this.configs.get(string);
        }
        if (properties != null && (string3 = properties.getProperty(string2)) != null) {
            return string3;
        }
        properties = this.defaultProperties;
        if (properties != null && (string3 = properties.getProperty(string2)) != null) {
            return string3;
        }
        return string3;
    }

    public String getSSLProtocol(String string) {
        return this.getProperty(string, SSLPROTOCOL, null);
    }

    public String getJSSEProvider(String string) {
        return this.getProperty(string, JSSEPROVIDER, null);
    }

    public String getKeyStore(String string) {
        String string2 = KEYSTORE;
        String string3 = SYSKEYSTORE;
        if ((string = this.getPropertyFromConfig(string, string2)) != null) {
            return string;
        }
        return System.getProperty(string3);
    }

    public char[] getKeyStorePassword(String string) {
        string = this.getProperty(string, KEYSTOREPWD, SYSKEYSTOREPWD);
        char[] cArray = null;
        if (string != null) {
            cArray = string.startsWith(xorTag) ? SSLSocketFactoryFactory.deObfuscate(string) : string.toCharArray();
        }
        return cArray;
    }

    public String getKeyStoreType(String string) {
        return this.getProperty(string, KEYSTORETYPE, SYSKEYSTORETYPE);
    }

    public String getKeyStoreProvider(String string) {
        return this.getProperty(string, KEYSTOREPROVIDER, null);
    }

    public String getKeyManager(String string) {
        return this.getProperty(string, KEYSTOREMGR, SYSKEYMGRALGO);
    }

    public String getTrustStore(String string) {
        string = this.getProperty(string, TRUSTSTORE, SYSTRUSTSTORE);
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (Exception exception) {
            return string;
        }
    }

    public char[] getTrustStorePassword(String string) {
        string = this.getProperty(string, TRUSTSTOREPWD, SYSTRUSTSTOREPWD);
        char[] cArray = null;
        if (string != null) {
            cArray = string.startsWith(xorTag) ? SSLSocketFactoryFactory.deObfuscate(string) : string.toCharArray();
        }
        return cArray;
    }

    public String getTrustStoreType(String string) {
        return this.getProperty(string, TRUSTSTORETYPE, null);
    }

    public String getTrustStoreProvider(String string) {
        return this.getProperty(string, TRUSTSTOREPROVIDER, null);
    }

    public String getTrustManager(String string) {
        return this.getProperty(string, TRUSTSTOREMGR, SYSTRUSTMGRALGO);
    }

    public String[] getEnabledCipherSuites(String string) {
        return SSLSocketFactoryFactory.unpackCipherSuites(this.getProperty(string, CIPHERSUITES, null));
    }

    public boolean getClientAuthentication(String string) {
        string = this.getProperty(string, CLIENTAUTH, null);
        boolean bl = false;
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    private SSLContext getSSLContext(String string) {
        Object object = this.getSSLProtocol(string);
        if (object == null) {
            object = DEFAULT_PROTOCOL;
        }
        if (this.logger != null) {
            this.logger.c(CLASS_NAME, "getSSLContext", "12000", new Object[]{string != null ? string : "null (broker defaults)", object});
        }
        Object object2 = this.getJSSEProvider(string);
        try {
            Object object3;
            object = object2 == null ? SSLContext.getInstance((String)object) : SSLContext.getInstance((String)object, (String)object2);
            if (this.logger != null) {
                this.logger.c(CLASS_NAME, "getSSLContext", "12001", new Object[]{string != null ? string : "null (broker defaults)", ((SSLContext)object).getProvider().getName()});
            }
            object2 = this.getProperty(string, KEYSTORE, null);
            KeyManager[] keyManagerArray = null;
            if (object2 == null) {
                object2 = this.getProperty(string, KEYSTORE, SYSKEYSTORE);
            }
            if (this.logger != null) {
                this.logger.c(CLASS_NAME, "getSSLContext", "12004", new Object[]{string != null ? string : "null (broker defaults)", object2 != null ? object2 : "null"});
            }
            Object object4 = this.getKeyStorePassword(string);
            if (this.logger != null) {
                this.logger.c(CLASS_NAME, "getSSLContext", "12005", new Object[]{string != null ? string : "null (broker defaults)", object4 != null ? SSLSocketFactoryFactory.obfuscate((char[])object4) : "null"});
            }
            if ((object3 = this.getKeyStoreType(string)) == null) {
                object3 = KeyStore.getDefaultType();
            }
            if (this.logger != null) {
                this.logger.c(CLASS_NAME, "getSSLContext", "12006", new Object[]{string != null ? string : "null (broker defaults)", object3 != null ? object3 : "null"});
            }
            Object object5 = KeyManagerFactory.getDefaultAlgorithm();
            TrustManager[] trustManagerArray = this.getKeyStoreProvider(string);
            Object object6 = this.getKeyManager(string);
            if (object6 != null) {
                object5 = object6;
            }
            if (object2 != null && object3 != null && object5 != null) {
                try {
                    keyManagerArray = KeyStore.getInstance((String)object3);
                    keyManagerArray.load(new FileInputStream((String)object2), (char[])object4);
                    object2 = trustManagerArray != null ? KeyManagerFactory.getInstance((String)object5, (String)trustManagerArray) : KeyManagerFactory.getInstance((String)object5);
                    if (this.logger != null) {
                        this.logger.c(CLASS_NAME, "getSSLContext", "12010", new Object[]{string != null ? string : "null (broker defaults)", object5 != null ? object5 : "null"});
                        this.logger.c(CLASS_NAME, "getSSLContext", "12009", new Object[]{string != null ? string : "null (broker defaults)", ((KeyManagerFactory)object2).getProvider().getName()});
                    }
                    ((KeyManagerFactory)object2).init((KeyStore)keyManagerArray, (char[])object4);
                    keyManagerArray = ((KeyManagerFactory)object2).getKeyManagers();
                }
                catch (KeyStoreException keyStoreException) {
                    throw new s(keyStoreException);
                }
                catch (CertificateException certificateException) {
                    throw new s(certificateException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new s(fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new s(iOException);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    throw new s(unrecoverableKeyException);
                }
            }
            object4 = this.getTrustStore(string);
            if (this.logger != null) {
                this.logger.c(CLASS_NAME, "getSSLContext", "12011", new Object[]{string != null ? string : "null (broker defaults)", (char[])(object4 != null ? object4 : (char[])"null")});
            }
            trustManagerArray = null;
            object6 = this.getTrustStorePassword(string);
            if (this.logger != null) {
                this.logger.c(CLASS_NAME, "getSSLContext", "12012", new Object[]{string != null ? string : "null (broker defaults)", object6 != null ? SSLSocketFactoryFactory.obfuscate((char[])object6) : "null"});
            }
            if ((object2 = this.getTrustStoreType(string)) == null) {
                object2 = KeyStore.getDefaultType();
            }
            if (this.logger != null) {
                this.logger.c(CLASS_NAME, "getSSLContext", "12013", new Object[]{string != null ? string : "null (broker defaults)", object2 != null ? object2 : "null"});
            }
            String string2 = TrustManagerFactory.getDefaultAlgorithm();
            object5 = this.getTrustStoreProvider(string);
            object3 = this.getTrustManager(string);
            if (object3 != null) {
                string2 = object3;
            }
            if (object4 != null && object2 != null && string2 != null) {
                try {
                    object3 = KeyStore.getInstance((String)object2);
                    ((KeyStore)object3).load(new FileInputStream((String)object4), (char[])object6);
                    object5 = object5 != null ? TrustManagerFactory.getInstance(string2, (String)object5) : TrustManagerFactory.getInstance(string2);
                    if (this.logger != null) {
                        this.logger.c(CLASS_NAME, "getSSLContext", "12017", new Object[]{string != null ? string : "null (broker defaults)", string2 != null ? string2 : "null"});
                        this.logger.c(CLASS_NAME, "getSSLContext", "12016", new Object[]{string != null ? string : "null (broker defaults)", ((TrustManagerFactory)object5).getProvider().getName()});
                    }
                    ((TrustManagerFactory)object5).init((KeyStore)object3);
                    trustManagerArray = ((TrustManagerFactory)object5).getTrustManagers();
                }
                catch (KeyStoreException keyStoreException) {
                    throw new s(keyStoreException);
                }
                catch (CertificateException certificateException) {
                    throw new s(certificateException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new s(fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new s(iOException);
                }
            }
            ((SSLContext)object).init(keyManagerArray, trustManagerArray, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new s(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new s(noSuchProviderException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new s(keyManagementException);
        }
        return object;
    }

    public SSLSocketFactory createSocketFactory(String string) {
        SSLContext sSLContext = this.getSSLContext(string);
        if (this.logger != null) {
            this.logger.c(CLASS_NAME, "createSocketFactory", "12020", new Object[]{string != null ? string : "null (broker defaults)", this.getEnabledCipherSuites(string) != null ? this.getProperty(string, CIPHERSUITES, null) : "null (using platform-enabled cipher suites)"});
        }
        return sSLContext.getSocketFactory();
    }
}

