/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.SecureRandom;

public class WebSocketFrame {
    public static final int frameLengthOverhead = 6;
    private byte opcode;
    private boolean fin;
    private byte[] payload;
    private boolean closeFlag = false;

    public byte getOpcode() {
        return this.opcode;
    }

    public boolean isFin() {
        return this.fin;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean isCloseFlag() {
        return this.closeFlag;
    }

    public WebSocketFrame(byte by, boolean bl, byte[] byArray) {
        this.opcode = by;
        this.fin = bl;
        if (byArray != null) {
            this.payload = (byte[])byArray.clone();
        }
    }

    public WebSocketFrame(byte[] object) {
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object);
        object = byteBuffer;
        byte by = byteBuffer.get();
        this.setFinAndOpCode(by);
        by = ((ByteBuffer)object).get();
        boolean bl = (by & 0x80) != 0;
        int n2 = 0x7F & by;
        int n3 = 0;
        if (n2 == 127) {
            n3 = 8;
        } else if (n2 == 126) {
            n3 = 2;
        }
        while (--n3 > 0) {
            by = ((ByteBuffer)object).get();
            n2 |= (by & 0xFF) << 8 * n3;
        }
        byte[] byArray = null;
        if (bl) {
            byArray = new byte[4];
            ((ByteBuffer)object).get(byArray, 0, 4);
        }
        this.payload = new byte[n2];
        ((ByteBuffer)object).get(this.payload, 0, n2);
        if (bl) {
            for (int i2 = 0; i2 < this.payload.length; ++i2) {
                int n4 = i2;
                this.payload[n4] = (byte)(this.payload[n4] ^ byArray[i2 % 4]);
            }
        }
    }

    private void setFinAndOpCode(byte by) {
        this.fin = (by & 0x80) != 0;
        this.opcode = (byte)(by & 0xF);
    }

    public WebSocketFrame(InputStream inputStream) {
        byte by = (byte)inputStream.read();
        this.setFinAndOpCode(by);
        if (this.opcode == 2) {
            by = (byte)inputStream.read();
            boolean bl = (by & 0x80) != 0;
            int n2 = 0x7F & by;
            int n3 = 0;
            if (n2 == 127) {
                n3 = 8;
            } else if (n2 == 126) {
                n3 = 2;
            }
            if (n3 > 0) {
                n2 = 0;
            }
            while (--n3 >= 0) {
                by = (byte)inputStream.read();
                n2 |= (by & 0xFF) << 8 * n3;
            }
            byte[] byArray = null;
            if (bl) {
                byArray = new byte[4];
                inputStream.read(byArray, 0, 4);
            }
            this.payload = new byte[n2];
            n3 = 0;
            int n4 = n2;
            while (n3 != n2) {
                int n5 = inputStream.read(this.payload, n3, n4);
                n3 += n5;
                n4 -= n5;
            }
            if (bl) {
                for (int i2 = 0; i2 < this.payload.length; ++i2) {
                    int n6 = i2;
                    this.payload[n6] = (byte)(this.payload[n6] ^ byArray[i2 % 4]);
                }
            }
            return;
        }
        if (this.opcode == 8) {
            this.closeFlag = true;
            return;
        }
        throw new IOException("Invalid Frame: Opcode: " + this.opcode);
    }

    public byte[] encodeFrame() {
        int n2 = this.payload.length + 6;
        if (this.payload.length > 65535) {
            n2 += 8;
        } else if (this.payload.length >= 126) {
            n2 += 2;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        WebSocketFrame.appendFinAndOpCode(byteBuffer, this.opcode, this.fin);
        byte[] byArray = WebSocketFrame.generateMaskingKey();
        WebSocketFrame.appendLengthAndMask(byteBuffer, this.payload.length, byArray);
        for (int i2 = 0; i2 < this.payload.length; ++i2) {
            int n3 = i2;
            byte by = (byte)(this.payload[n3] ^ byArray[i2 % 4]);
            this.payload[n3] = by;
            byteBuffer.put(by);
        }
        byteBuffer.flip();
        return byteBuffer.array();
    }

    public static void appendLengthAndMask(ByteBuffer byteBuffer, int n2, byte[] byArray) {
        if (byArray != null) {
            WebSocketFrame.appendLength(byteBuffer, n2, true);
            byteBuffer.put(byArray);
            return;
        }
        WebSocketFrame.appendLength(byteBuffer, n2, false);
    }

    private static void appendLength(ByteBuffer byteBuffer, int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Length cannot be negative");
        }
        int n3 = (bl = bl ? -128 : 0) ? 1 : 0;
        if (n2 > 65535) {
            byteBuffer.put((byte)(bl | 0x7F));
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)(n2 >> 24 & 0xFF));
            byteBuffer.put((byte)(n2 >> 16 & 0xFF));
            byteBuffer.put((byte)(n2 >> 8 & 0xFF));
            byteBuffer.put((byte)(n2 & 0xFF));
            return;
        }
        if (n2 >= 126) {
            byteBuffer.put((byte)(bl | 0x7E));
            byteBuffer.put((byte)(n2 >> 8));
            byteBuffer.put((byte)(n2 & 0xFF));
            return;
        }
        byteBuffer.put((byte)(bl | n2));
    }

    public static void appendFinAndOpCode(ByteBuffer byteBuffer, byte by, boolean bl) {
        byte by2 = 0;
        if (bl) {
            by2 = -128;
        }
        by2 = (byte)(by2 | by & 0xF);
        byteBuffer.put(by2);
    }

    public static byte[] generateMaskingKey() {
        SecureRandom secureRandom = new SecureRandom();
        int n2 = secureRandom.nextInt(255);
        int n3 = secureRandom.nextInt(255);
        int n4 = secureRandom.nextInt(255);
        int n5 = secureRandom.nextInt(255);
        return new byte[]{(byte)n2, (byte)n3, (byte)n4, (byte)n5};
    }
}

