/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal.websocket;

import com.mq.mgmi.client.message.internal.websocket.Base64;
import com.mq.mgmi.client.message.internal.websocket.HandshakeFailedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class WebSocketHandshake {
    private static final String ACCEPT_SALT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String SHA1_PROTOCOL = "SHA1";
    private static final String HTTP_HEADER_SEC_WEBSOCKET_ACCEPT = "sec-websocket-accept";
    private static final String HTTP_HEADER_UPGRADE = "upgrade";
    private static final String HTTP_HEADER_UPGRADE_WEBSOCKET = "websocket";
    private static final String EMPTY = "";
    private static final String LINE_SEPARATOR = "\r\n";
    private static final String HTTP_HEADER_CONNECTION = "connection";
    private static final String HTTP_HEADER_CONNECTION_VALUE = "upgrade";
    private static final String HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL = "sec-websocket-protocol";
    InputStream input;
    OutputStream output;
    String uri;
    String host;
    int port;
    Properties customWebSocketHeaders;

    public WebSocketHandshake(InputStream inputStream, OutputStream outputStream, String string, String string2, int n2, Properties properties) {
        this.input = inputStream;
        this.output = outputStream;
        this.uri = string;
        this.host = string2;
        this.port = n2;
        this.customWebSocketHeaders = properties;
    }

    public void execute() {
        Object object = new byte[16];
        System.arraycopy(UUID.randomUUID().toString().getBytes(), 0, object, 0, 16);
        object = Base64.encodeBytes(object);
        this.sendHandshakeRequest((String)object);
        this.receiveHandshakeResponse((String)object);
    }

    private void sendHandshakeRequest(String object) {
        try {
            String string = "/mqtt";
            URI uRI = new URI(this.uri);
            if (uRI.getRawPath() != null && !uRI.getRawPath().isEmpty()) {
                string = uRI.getRawPath();
                if (uRI.getRawQuery() != null && !uRI.getRawQuery().isEmpty()) {
                    string = string + "?" + uRI.getRawQuery();
                }
            }
            PrintWriter printWriter = new PrintWriter(this.output);
            printWriter.print("GET " + string + " HTTP/1.1\r\n");
            if (this.port != 80) {
                printWriter.print("Host: " + this.host + ":" + this.port + LINE_SEPARATOR);
            } else {
                printWriter.print("Host: " + this.host + LINE_SEPARATOR);
            }
            printWriter.print("Upgrade: websocket\r\n");
            printWriter.print("Connection: Upgrade\r\n");
            printWriter.print("Sec-WebSocket-Key: " + (String)object + LINE_SEPARATOR);
            printWriter.print("Sec-WebSocket-Protocol: mqtt\r\n");
            printWriter.print("Sec-WebSocket-Version: 13\r\n");
            if (this.customWebSocketHeaders != null) {
                object = this.customWebSocketHeaders.keySet().iterator();
                while (object.hasNext()) {
                    string = (String)object.next();
                    String string2 = this.customWebSocketHeaders.getProperty(string);
                    printWriter.print(string + ": " + string2 + LINE_SEPARATOR);
                }
            }
            if ((object = uRI.getUserInfo()) != null) {
                printWriter.print("Authorization: Basic " + Base64.encode((String)object) + LINE_SEPARATOR);
            }
            printWriter.print(LINE_SEPARATOR);
            printWriter.flush();
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException.getMessage());
        }
    }

    private void receiveHandshakeResponse(String string) {
        Map<String, String> map = new BufferedReader(new InputStreamReader(this.input));
        Object object = new ArrayList<String>();
        String string2 = ((BufferedReader)((Object)map)).readLine();
        if (string2 == null) {
            throw new IOException("WebSocket Response header: Invalid response from Server, It may not support WebSockets.");
        }
        while (!string2.equals(EMPTY)) {
            ((ArrayList)object).add(string2);
            string2 = ((BufferedReader)((Object)map)).readLine();
        }
        map = this.getHeaders((ArrayList<String>)object);
        if ((object = map.get(HTTP_HEADER_CONNECTION)) == null || ((String)object).equalsIgnoreCase("upgrade")) {
            throw new IOException("WebSocket Response header: Incorrect connection header");
        }
        object = (String)map.get("upgrade");
        if (object == null || !((String)object).toLowerCase().contains(HTTP_HEADER_UPGRADE_WEBSOCKET)) {
            throw new IOException("WebSocket Response header: Incorrect upgrade.");
        }
        if ((String)map.get(HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL) == null) {
            throw new IOException("WebSocket Response header: empty sec-websocket-protocol");
        }
        if (!map.containsKey(HTTP_HEADER_SEC_WEBSOCKET_ACCEPT)) {
            throw new IOException("WebSocket Response header: Missing Sec-WebSocket-Accept");
        }
        try {
            this.verifyWebSocketKey(string, (String)map.get(HTTP_HEADER_SEC_WEBSOCKET_ACCEPT));
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException(noSuchAlgorithmException.getMessage());
        }
        catch (HandshakeFailedException handshakeFailedException) {
            throw new IOException("WebSocket Response header: Incorrect Sec-WebSocket-Key");
        }
    }

    private Map<String, String> getHeaders(ArrayList<String> arrayList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i2 = 1; i2 < arrayList.size(); ++i2) {
            String[] stringArray = arrayList.get(i2).split(":");
            hashMap.put(stringArray[0].toLowerCase(), stringArray[1]);
        }
        return hashMap;
    }

    private void verifyWebSocketKey(String string, String string2) {
        if (!Base64.encodeBytes(this.sha1(string + ACCEPT_SALT)).trim().equals(string2.trim())) {
            throw new HandshakeFailedException();
        }
    }

    private byte[] sha1(String string) {
        return MessageDigest.getInstance(SHA1_PROTOCOL).digest(string.getBytes());
    }
}

