/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal.wire;

import com.mq.mgmi.client.message.internal.wire.MqttWireMessage;
import com.mq.mgmi.client.message.n;
import com.mq.mgmi.client.message.o;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MqttConnect
extends MqttWireMessage {
    public static final String KEY = "Con";
    private String clientId;
    private boolean cleanSession;
    private o willMessage;
    private String userName;
    private char[] password;
    private int keepAliveInterval;
    private String willDestination;
    private int mqttVersion;

    public MqttConnect(byte by, byte[] byArray) {
        super((byte)1);
        InputStream inputStream = new ByteArrayInputStream(byArray);
        inputStream = new DataInputStream(inputStream);
        MqttConnect.decodeUTF8((DataInputStream)inputStream);
        ((DataInputStream)inputStream).readByte();
        ((DataInputStream)inputStream).readByte();
        this.keepAliveInterval = ((DataInputStream)inputStream).readUnsignedShort();
        this.clientId = MqttConnect.decodeUTF8((DataInputStream)inputStream);
        ((FilterInputStream)inputStream).close();
    }

    public MqttConnect(String string, int n2, boolean bl, int n3, String string2, char[] cArray, o o2, String string3) {
        super((byte)1);
        this.clientId = string;
        this.cleanSession = bl;
        this.keepAliveInterval = n3;
        this.userName = string2;
        if (cArray != null) {
            this.password = (char[])cArray.clone();
        }
        this.willMessage = o2;
        this.willDestination = string3;
        this.mqttVersion = n2;
    }

    @Override
    public String toString() {
        String string = super.toString();
        return string + " clientId " + this.clientId + " keepAliveInterval " + this.keepAliveInterval;
    }

    @Override
    protected byte getMessageInfo() {
        return 0;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    @Override
    protected byte[] getVariableHeader() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (this.mqttVersion == 3) {
                MqttConnect.encodeUTF8(dataOutputStream, "MQIsdp");
            } else if (this.mqttVersion == 4) {
                MqttConnect.encodeUTF8(dataOutputStream, "MQTT");
            }
            dataOutputStream.write(this.mqttVersion);
            int n2 = 0;
            if (this.cleanSession) {
                n2 = 2;
            }
            if (this.willMessage != null) {
                n2 = (byte)((byte)(n2 | 4) | this.willMessage.getQos() << 3);
                if (this.willMessage.isRetained()) {
                    n2 = (byte)(n2 | 0x20);
                }
            }
            if (this.userName != null) {
                n2 = (byte)(n2 | 0x80);
                if (this.password != null) {
                    n2 = (byte)(n2 | 0x40);
                }
            }
            dataOutputStream.write(n2);
            dataOutputStream.writeShort(this.keepAliveInterval);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new n(iOException);
        }
    }

    @Override
    public byte[] getPayload() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            MqttConnect.encodeUTF8(dataOutputStream, this.clientId);
            if (this.willMessage != null) {
                MqttConnect.encodeUTF8(dataOutputStream, this.willDestination);
                dataOutputStream.writeShort(this.willMessage.getPayload().length);
                dataOutputStream.write(this.willMessage.getPayload());
            }
            if (this.userName != null) {
                MqttConnect.encodeUTF8(dataOutputStream, this.userName);
                if (this.password != null) {
                    MqttConnect.encodeUTF8(dataOutputStream, new String(this.password));
                }
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new n(iOException);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return false;
    }

    @Override
    public String getKey() {
        return KEY;
    }
}

