/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal.wire;

import com.mq.mgmi.client.message.a.b;
import com.mq.mgmi.client.message.a.c;
import com.mq.mgmi.client.message.internal.ClientState;
import com.mq.mgmi.client.message.internal.ExceptionHelper;
import com.mq.mgmi.client.message.internal.wire.MqttWireMessage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class MqttInputStream
extends InputStream {
    private final String CLASS_NAME = MqttInputStream.class.getName();
    private final b log = c.a("com.mq.mgmi.client.message.internal.nls.logcat", this.CLASS_NAME);
    private ClientState clientState = null;
    private DataInputStream in;
    private ByteArrayOutputStream bais;
    private int remLen;
    private int packetLen;
    private byte[] packet;

    public MqttInputStream(ClientState clientState, InputStream inputStream) {
        this.clientState = clientState;
        this.in = new DataInputStream(inputStream);
        this.bais = new ByteArrayOutputStream();
        this.remLen = -1;
    }

    @Override
    public int read() {
        return this.in.read();
    }

    @Override
    public int available() {
        return this.in.available();
    }

    @Override
    public void close() {
        this.in.close();
    }

    public MqttWireMessage readMqttWireMessage() {
        MqttWireMessage mqttWireMessage = null;
        try {
            if (this.remLen < 0) {
                this.bais.reset();
                byte by = this.in.readByte();
                this.clientState.notifyReceivedBytes(1);
                byte by2 = (byte)(by >>> 4 & 0xF);
                if (by2 <= 0 || by2 > 14) {
                    throw ExceptionHelper.createMqttException(32108);
                }
                this.remLen = MqttWireMessage.readMBI(this.in).getValue();
                this.bais.write(by);
                this.bais.write(MqttWireMessage.encodeMBI(this.remLen));
                this.packet = new byte[this.bais.size() + this.remLen];
                this.packetLen = 0;
            }
            if (this.remLen >= 0) {
                this.readFully();
                this.remLen = -1;
                byte[] byArray = this.bais.toByteArray();
                System.arraycopy(byArray, 0, this.packet, 0, byArray.length);
                mqttWireMessage = MqttWireMessage.createWireMessage(this.packet);
                this.log.c(this.CLASS_NAME, "readMqttWireMessage", "301", new Object[]{mqttWireMessage});
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {}
        return mqttWireMessage;
    }

    private void readFully() {
        int n2;
        int n3 = this.bais.size() + this.packetLen;
        int n4 = this.remLen - this.packetLen;
        if (n4 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i2 = 0; i2 < n4; i2 += n2) {
            try {
                n2 = this.in.read(this.packet, n3 + i2, n4 - i2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.packetLen += i2;
                throw socketTimeoutException;
            }
            if (n2 < 0) {
                throw new EOFException();
            }
            this.clientState.notifyReceivedBytes(n2);
        }
    }
}

