/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal.wire;

import com.mq.mgmi.client.message.a.b;
import com.mq.mgmi.client.message.a.c;
import com.mq.mgmi.client.message.internal.ClientState;
import com.mq.mgmi.client.message.internal.wire.MqttWireMessage;
import java.io.BufferedOutputStream;
import java.io.OutputStream;

public class MqttOutputStream
extends OutputStream {
    private static final String CLASS_NAME = MqttOutputStream.class.getName();
    private b log = c.a("com.mq.mgmi.client.message.internal.nls.logcat", CLASS_NAME);
    private ClientState clientState = null;
    private BufferedOutputStream out;

    public MqttOutputStream(ClientState clientState, OutputStream outputStream) {
        this.clientState = clientState;
        this.out = new BufferedOutputStream(outputStream);
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void write(byte[] byArray) {
        this.out.write(byArray);
        this.clientState.notifySentBytes(byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.out.write(byArray, n2, n3);
        this.clientState.notifySentBytes(n3);
    }

    @Override
    public void write(int n2) {
        this.out.write(n2);
    }

    public void write(MqttWireMessage mqttWireMessage) {
        byte[] byArray = mqttWireMessage.getHeader();
        byte[] byArray2 = mqttWireMessage.getPayload();
        this.out.write(byArray, 0, byArray.length);
        this.clientState.notifySentBytes(byArray.length);
        for (int i2 = 0; i2 < byArray2.length; i2 += 1024) {
            int n2 = Math.min(1024, byArray2.length - i2);
            this.out.write(byArray2, i2, n2);
            this.clientState.notifySentBytes(n2);
        }
        this.log.c(CLASS_NAME, "write", "529", new Object[]{mqttWireMessage});
    }
}

