/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal.wire;

import com.mq.mgmi.client.message.internal.wire.CountingInputStream;
import com.mq.mgmi.client.message.internal.wire.MqttPersistableWireMessage;
import com.mq.mgmi.client.message.internal.wire.MqttReceivedMessage;
import com.mq.mgmi.client.message.n;
import com.mq.mgmi.client.message.o;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MqttPublish
extends MqttPersistableWireMessage {
    private o message;
    private String topicName;
    private byte[] encodedPayload = null;

    public MqttPublish(String string, o o2) {
        super((byte)3);
        this.topicName = string;
        this.message = o2;
    }

    public MqttPublish(byte by, byte[] byArray) {
        super((byte)3);
        this.message = new MqttReceivedMessage();
        this.message.setQos(by >> 1 & 3);
        if ((by & 1) == 1) {
            this.message.setRetained(true);
        }
        if ((by & 8) == 8) {
            ((MqttReceivedMessage)this.message).setDuplicate(true);
        }
        Object object = new ByteArrayInputStream(byArray);
        object = new CountingInputStream((InputStream)object);
        DataInputStream dataInputStream = new DataInputStream((InputStream)object);
        this.topicName = MqttPublish.decodeUTF8(dataInputStream);
        if (this.message.getQos() > 0) {
            this.msgId = dataInputStream.readUnsignedShort();
        }
        object = new byte[byArray.length - ((CountingInputStream)object).getCounter()];
        dataInputStream.readFully((byte[])object);
        dataInputStream.close();
        this.message.setPayload((byte[])object);
    }

    @Override
    public String toString() {
        String string;
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.message.getPayload();
        int n2 = Math.min(byArray.length, 20);
        for (int i2 = 0; i2 < n2; ++i2) {
            charSequence = Integer.toHexString(byArray[i2]);
            if (((String)charSequence).length() == 1) {
                charSequence = "0".concat(String.valueOf(charSequence));
            }
            stringBuffer.append((String)charSequence);
        }
        try {
            string = new String(byArray, 0, n2, "UTF-8");
        }
        catch (Exception exception) {
            string = "?";
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append(super.toString());
        ((StringBuffer)charSequence).append(" qos:").append(this.message.getQos());
        if (this.message.getQos() > 0) {
            ((StringBuffer)charSequence).append(" msgId:").append(this.msgId);
        }
        ((StringBuffer)charSequence).append(" retained:").append(this.message.isRetained());
        ((StringBuffer)charSequence).append(" dup:").append(this.duplicate);
        ((StringBuffer)charSequence).append(" topic:\"").append(this.topicName).append("\"");
        ((StringBuffer)charSequence).append(" payload:[hex:").append(stringBuffer);
        ((StringBuffer)charSequence).append(" utf8:\"").append(string).append("\"");
        ((StringBuffer)charSequence).append(" length:").append(byArray.length).append("]");
        return ((StringBuffer)charSequence).toString();
    }

    @Override
    protected byte getMessageInfo() {
        byte by = (byte)(this.message.getQos() << 1);
        if (this.message.isRetained()) {
            by = (byte)(by | 1);
        }
        if (this.message.isDuplicate() || this.duplicate) {
            by = (byte)(by | 8);
        }
        return by;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public o getMessage() {
        return this.message;
    }

    protected static byte[] encodePayload(o o2) {
        return o2.getPayload();
    }

    @Override
    public byte[] getPayload() {
        if (this.encodedPayload == null) {
            this.encodedPayload = MqttPublish.encodePayload(this.message);
        }
        return this.encodedPayload;
    }

    @Override
    public int getPayloadLength() {
        int n2 = 0;
        try {
            n2 = this.getPayload().length;
        }
        catch (n n3) {}
        return n2;
    }

    @Override
    public void setMessageId(int n2) {
        super.setMessageId(n2);
        if (this.message instanceof MqttReceivedMessage) {
            ((MqttReceivedMessage)this.message).setMessageId(n2);
        }
    }

    @Override
    protected byte[] getVariableHeader() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            MqttPublish.encodeUTF8(dataOutputStream, this.topicName);
            if (this.message.getQos() > 0) {
                dataOutputStream.writeShort(this.msgId);
            }
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new n(iOException);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return true;
    }
}

