/*
 * Decompiled with CFR 0.152.
 */
package com.mq.mgmi.client.message.internal.wire;

import com.mq.mgmi.client.message.internal.ExceptionHelper;
import com.mq.mgmi.client.message.internal.wire.CountingInputStream;
import com.mq.mgmi.client.message.internal.wire.MqttConnack;
import com.mq.mgmi.client.message.internal.wire.MqttConnect;
import com.mq.mgmi.client.message.internal.wire.MqttDisconnect;
import com.mq.mgmi.client.message.internal.wire.MqttPingReq;
import com.mq.mgmi.client.message.internal.wire.MqttPingResp;
import com.mq.mgmi.client.message.internal.wire.MqttPubAck;
import com.mq.mgmi.client.message.internal.wire.MqttPubComp;
import com.mq.mgmi.client.message.internal.wire.MqttPubRec;
import com.mq.mgmi.client.message.internal.wire.MqttPubRel;
import com.mq.mgmi.client.message.internal.wire.MqttPublish;
import com.mq.mgmi.client.message.internal.wire.MqttSuback;
import com.mq.mgmi.client.message.internal.wire.MqttSubscribe;
import com.mq.mgmi.client.message.internal.wire.MqttUnsubAck;
import com.mq.mgmi.client.message.internal.wire.MqttUnsubscribe;
import com.mq.mgmi.client.message.internal.wire.MultiByteArrayInputStream;
import com.mq.mgmi.client.message.internal.wire.MultiByteInteger;
import com.mq.mgmi.client.message.n;
import com.mq.mgmi.client.message.p;
import com.mq.mgmi.client.message.t;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class MqttWireMessage {
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    protected static final Charset STRING_ENCODING = StandardCharsets.UTF_8;
    private static final String[] PACKET_NAMES = new String[]{"reserved", "CONNECT", "CONNACK", "PUBLISH", "PUBACK", "PUBREC", "PUBREL", "PUBCOMP", "SUBSCRIBE", "SUBACK", "UNSUBSCRIBE", "UNSUBACK", "PINGREQ", "PINGRESP", "DISCONNECT"};
    private static final long FOUR_BYTE_INT_MAX = 0xFFFFFFFFL;
    private static final int VARIABLE_BYTE_INT_MAX = 0xFFFFFFF;
    private byte type;
    protected int msgId;
    protected boolean duplicate = false;
    private t token;

    public MqttWireMessage(byte by) {
        this.type = by;
        this.msgId = 0;
    }

    protected abstract byte getMessageInfo();

    public byte[] getPayload() {
        return new byte[0];
    }

    public byte getType() {
        return this.type;
    }

    public int getMessageId() {
        return this.msgId;
    }

    public void setMessageId(int n2) {
        this.msgId = n2;
    }

    public String getKey() {
        return Integer.toString(this.getMessageId());
    }

    public byte[] getHeader() {
        try {
            int n2 = (this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF;
            byte[] byArray = this.getVariableHeader();
            int n3 = byArray.length + this.getPayload().length;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(n2);
            dataOutputStream.write(MqttWireMessage.encodeMBI(n3));
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new n(iOException);
        }
    }

    protected abstract byte[] getVariableHeader();

    public boolean isMessageIdRequired() {
        return true;
    }

    public static MqttWireMessage createWireMessage(p p2) {
        byte[] byArray = p2.getPayloadBytes();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return MqttWireMessage.createWireMessage(new MultiByteArrayInputStream(p2.getHeaderBytes(), p2.getHeaderOffset(), p2.getHeaderLength(), byArray, p2.getPayloadOffset(), p2.getPayloadLength()));
    }

    public static MqttWireMessage createWireMessage(byte[] byArray) {
        return MqttWireMessage.createWireMessage(new ByteArrayInputStream(byArray));
    }

    private static MqttWireMessage createWireMessage(InputStream object) {
        try {
            object = new CountingInputStream((InputStream)object);
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            int by = dataInputStream.readUnsignedByte();
            byte by2 = (byte)(by >> 4);
            byte by3 = (byte)(by & 0xF);
            long l2 = MqttWireMessage.readMBI(dataInputStream).getValue();
            long l3 = (long)((CountingInputStream)object).getCounter() + l2 - (long)((CountingInputStream)object).getCounter();
            object = new byte[0];
            if (l3 > 0L) {
                object = new byte[(int)l3];
                dataInputStream.readFully((byte[])object, 0, ((Object)object).length);
            }
            if (by2 == 1) {
                object = new MqttConnect(by3, (byte[])object);
            } else if (by2 == 3) {
                object = new MqttPublish(by3, (byte[])object);
            } else if (by2 == 4) {
                object = new MqttPubAck(by3, (byte[])object);
            } else if (by2 == 7) {
                object = new MqttPubComp(by3, (byte[])object);
            } else if (by2 == 2) {
                object = new MqttConnack(by3, (byte[])object);
            } else if (by2 == 12) {
                object = new MqttPingReq(by3, (byte[])object);
            } else if (by2 == 13) {
                object = new MqttPingResp(by3, (byte[])object);
            } else if (by2 == 8) {
                object = new MqttSubscribe(by3, (byte[])object);
            } else if (by2 == 9) {
                object = new MqttSuback(by3, (byte[])object);
            } else if (by2 == 10) {
                object = new MqttUnsubscribe(by3, (byte[])object);
            } else if (by2 == 11) {
                object = new MqttUnsubAck(by3, (byte[])object);
            } else if (by2 == 6) {
                object = new MqttPubRel(by3, (byte[])object);
            } else if (by2 == 5) {
                object = new MqttPubRec(by3, (byte[])object);
            } else if (by2 == 14) {
                object = new MqttDisconnect(by3, (byte[])object);
            } else {
                throw ExceptionHelper.createMqttException(6);
            }
            return object;
        }
        catch (IOException iOException) {
            throw new n(iOException);
        }
    }

    public static byte[] encodeMBI(long l2) {
        MqttWireMessage.validateVariableByteInt((int)l2);
        int n2 = 0;
        long l3 = l2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            byte by = (byte)(l3 % 128L);
            if ((l3 /= 128L) > 0L) {
                by = (byte)(by | 0x80);
            }
            byteArrayOutputStream.write(by);
        } while (l3 > 0L && ++n2 < 4);
        return byteArrayOutputStream.toByteArray();
    }

    public static MultiByteInteger readMBI(DataInputStream dataInputStream) {
        byte by;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        do {
            by = dataInputStream.readByte();
            ++n4;
            n2 += (by & 0x7F) * n3;
            n3 *= 128;
        } while ((by & 0x80) != 0);
        if (n2 < 0 || n2 > 0xFFFFFFF) {
            throw new IOException("This property must be a number between 0 and 268435455. Read value was: ".concat(String.valueOf(n2)));
        }
        return new MultiByteInteger(n2, n4);
    }

    protected byte[] encodeMessageId() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(this.msgId);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new n(iOException);
        }
    }

    public boolean isRetryable() {
        return false;
    }

    public void setDuplicate(boolean bl) {
        this.duplicate = bl;
    }

    public static void encodeUTF8(DataOutputStream dataOutputStream, String object) {
        MqttWireMessage.validateUTF8String((String)object);
        try {
            byte[] byArray = ((String)object).getBytes(STRING_ENCODING);
            object = byArray;
            byte by = (byte)(byArray.length >>> 8 & 0xFF);
            byte by2 = (byte)(((Object)object).length >>> 0 & 0xFF);
            dataOutputStream.write(by);
            dataOutputStream.write(by2);
            dataOutputStream.write((byte[])object);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new n(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new n(iOException);
        }
    }

    public static String decodeUTF8(DataInputStream object) {
        try {
            byte[] byArray = new byte[((DataInputStream)object).readUnsignedShort()];
            ((DataInputStream)object).readFully(byArray);
            object = new String(byArray, STRING_ENCODING);
            MqttWireMessage.validateUTF8String((String)object);
            return object;
        }
        catch (IOException iOException) {
            throw new n(iOException);
        }
    }

    private static void validateUTF8String(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2;
            boolean bl;
            block8: {
                block7: {
                    block9: {
                        block6: {
                            bl = false;
                            c2 = string.charAt(i2);
                            if (!Character.isHighSurrogate(c2)) break block6;
                            if (++i2 == string.length()) break block7;
                            int n2 = string.charAt(i2);
                            if (Character.isLowSurrogate((char)n2) || ((n2 = (c2 & 0x3FF) << 10 | n2 & 0x3FF) & 0xFFFF) == 65535 || (n2 & 0xFFFF) == 65534) {
                                bl = true;
                            }
                            break block8;
                        }
                        if (!Character.isISOControl(c2) && !Character.isLowSurrogate(c2)) break block9;
                        bl = true;
                        break block8;
                    }
                    if (c2 < '\ufdd0' || c2 != '\ufffe' && c2 < '\ufdd0' && c2 > '\ufddf') break block8;
                }
                bl = true;
            }
            if (!bl) continue;
            throw new IllegalArgumentException(String.format("Invalid UTF-8 char: [%x]", c2));
        }
    }

    public static void validateVariableByteInt(int n2) {
        if (n2 >= 0 && n2 <= 0xFFFFFFF) {
            return;
        }
        throw new IllegalArgumentException("This property must be a number between 0 and 268435455");
    }

    public t getToken() {
        return this.token;
    }

    public void setToken(t t2) {
        this.token = t2;
    }

    public String toString() {
        return PACKET_NAMES[this.type];
    }
}

