/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.alpha;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.view.Surface;
import com.hunantv.media.alpha.Renderer;
import com.hunantv.media.player.pragma.DebugLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class AlphaRenderer
implements SurfaceTexture.OnFrameAvailableListener,
Renderer {
    private static String TAG = "AlphaRenderer";
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 16;
    private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
    private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 2;
    private final float[] triangleVerticesData = new float[]{-1.0f, 1.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.5f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    private FloatBuffer triangleVertices = ByteBuffer.allocateDirect(this.triangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final String vertexShader = "attribute vec2 a_position;\nattribute vec2 a_texCoord;\nvarying vec2 v_texcoord;\nvoid main(void) {\n  gl_Position = vec4(a_position, 0.0, 0.998);\n  v_texcoord = a_texCoord;\n}\n";
    private final String alphaShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 v_texcoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = vec4(texture2D(sTexture, v_texcoord).rgb, texture2D(sTexture, v_texcoord + vec2(-0.5, 0)).r);\n}\n";
    private int program;
    private int textureID;
    private int aPositionHandle;
    private int aTextureHandle;
    private SurfaceTexture surface;
    private boolean updateSurface = false;
    private static int GL_TEXTURE_EXTERNAL_OES = 36197;
    private OnSurfacePrepareListener onSurfacePrepareListener;
    private OnSurfaceErrorListener onSurfaceErrorListener;
    private int mCurrentVideoWidth;
    private int mCurrentVideoHeight;
    private int mCurrentViewWidth;
    private int mCurrentViewHeight;

    AlphaRenderer() {
        this.triangleVertices.put(this.triangleVerticesData).position(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDrawFrame(GL10 gL10) {
        AlphaRenderer alphaRenderer = this;
        synchronized (alphaRenderer) {
            if (this.updateSurface) {
                this.surface.updateTexImage();
                this.updateSurface = false;
            }
        }
        GLES20.glClear((int)16640);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glUseProgram((int)this.program);
        this.checkGlWarning(-110, "glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)GL_TEXTURE_EXTERNAL_OES, (int)this.textureID);
        this.triangleVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.aPositionHandle, (int)2, (int)5126, (boolean)false, (int)16, (Buffer)this.triangleVertices);
        this.checkGlWarning(-111, "glVertexAttribPointer maPosition");
        GLES20.glEnableVertexAttribArray((int)this.aPositionHandle);
        this.checkGlWarning(-112, "glEnableVertexAttribArray aPositionHandle");
        this.triangleVertices.position(2);
        GLES20.glVertexAttribPointer((int)this.aTextureHandle, (int)2, (int)5126, (boolean)false, (int)16, (Buffer)this.triangleVertices);
        this.checkGlWarning(-113, "glVertexAttribPointer aTextureHandle");
        GLES20.glEnableVertexAttribArray((int)this.aTextureHandle);
        this.checkGlWarning(-114, "glEnableVertexAttribArray aTextureHandle");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.checkGlWarning(-115, "glDrawArrays");
        GLES20.glFinish();
    }

    @Override
    public void onSurfaceDestroyed(GL10 gL10) {
    }

    @Override
    public void onSurfaceChanged(GL10 gL10, int n2, int n3) {
        DebugLog.i(TAG, "onSufaceChanged w " + n2 + " h " + n3);
        GLES20.glViewport((int)0, (int)0, (int)n2, (int)n3);
    }

    @Override
    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        this.program = this.createProgram("attribute vec2 a_position;\nattribute vec2 a_texCoord;\nvarying vec2 v_texcoord;\nvoid main(void) {\n  gl_Position = vec4(a_position, 0.0, 0.998);\n  v_texcoord = a_texCoord;\n}\n", "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 v_texcoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = vec4(texture2D(sTexture, v_texcoord).rgb, texture2D(sTexture, v_texcoord + vec2(-0.5, 0)).r);\n}\n");
        if (this.program == 0) {
            return;
        }
        this.aPositionHandle = GLES20.glGetAttribLocation((int)this.program, (String)"a_position");
        if (0 != this.checkGlError(-116, "glGetAttribLocation aPosition")) {
            return;
        }
        if (this.aPositionHandle == -1) {
            throw new RuntimeException("Could not get attrib location for aPosition");
        }
        this.aTextureHandle = GLES20.glGetAttribLocation((int)this.program, (String)"a_texCoord");
        if (0 != this.checkGlError(-117, "glGetAttribLocation aTextureCoord")) {
            return;
        }
        if (this.aTextureHandle == -1) {
            throw new RuntimeException("Could not get attrib location for aTextureCoord");
        }
        this.prepareSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSurface() {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.textureID = nArray[0];
        GLES20.glBindTexture((int)GL_TEXTURE_EXTERNAL_OES, (int)this.textureID);
        if (0 != this.checkGlError(-118, "glBindTexture textureID")) {
            return;
        }
        GLES20.glTexParameterf((int)GL_TEXTURE_EXTERNAL_OES, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)GL_TEXTURE_EXTERNAL_OES, (int)10240, (float)9729.0f);
        this.surface = new SurfaceTexture(this.textureID);
        this.surface.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        Surface surface = new Surface(this.surface);
        this.onSurfacePrepareListener.surfacePrepared(surface);
        AlphaRenderer alphaRenderer = this;
        synchronized (alphaRenderer) {
            this.updateSurface = false;
        }
    }

    public synchronized void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.updateSurface = true;
    }

    private int loadShader(int n2, String string) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 != 0) {
            GLES20.glShaderSource((int)n3, (String)string);
            GLES20.glCompileShader((int)n3);
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n3, (int)35713, (int[])nArray, (int)0);
            if (nArray[0] == 0) {
                DebugLog.i(TAG, "Could not compile shader " + n2 + ":\n" + GLES20.glGetShaderInfoLog((int)n3));
                GLES20.glDeleteShader((int)n3);
                n3 = 0;
            }
        }
        return n3;
    }

    private int createProgram(String string, String string2) {
        int n2 = this.loadShader(35633, string);
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.loadShader(35632, string2);
        if (n3 == 0) {
            return 0;
        }
        int n4 = GLES20.glCreateProgram();
        if (n4 != 0) {
            GLES20.glAttachShader((int)n4, (int)n2);
            if (0 != this.checkGlError(-119, "glAttachShader")) {
                return 0;
            }
            GLES20.glAttachShader((int)n4, (int)n3);
            if (0 != this.checkGlError(-120, "glAttachShader")) {
                return 0;
            }
            GLES20.glLinkProgram((int)n4);
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
            if (nArray[0] != 1) {
                DebugLog.i(TAG, "Could not link program: " + GLES20.glGetProgramInfoLog((int)n4));
                GLES20.glDeleteProgram((int)n4);
                n4 = 0;
            }
        }
        return n4;
    }

    private int checkGlError(int n2, String string) {
        int n3 = GLES20.glGetError();
        if (n3 != 0) {
            DebugLog.e(TAG, "error checkGlError errCode:" + n2 + ",msg:" + string);
            if (this.onSurfaceErrorListener != null) {
                this.onSurfaceErrorListener.surfaceError(n2, string);
            }
        }
        return n3;
    }

    private int checkGlWarning(int n2, String string) {
        int n3 = GLES20.glGetError();
        if (n3 != 0) {
            DebugLog.e(TAG, "warning checkGlWarning errCode:" + n2 + ",msg:" + string);
        }
        return n3;
    }

    void setOnSurfacePrepareListener(OnSurfacePrepareListener onSurfacePrepareListener) {
        this.onSurfacePrepareListener = onSurfacePrepareListener;
    }

    public void updateRadio(int n2, int n3, int n4, int n5) {
        if (this.mCurrentVideoWidth == n2 && this.mCurrentVideoHeight == n3 && this.mCurrentViewWidth == n4 && this.mCurrentViewHeight == n5) {
            return;
        }
        this.mCurrentVideoWidth = n2;
        this.mCurrentVideoHeight = n3;
        this.mCurrentViewWidth = n4;
        this.mCurrentViewHeight = n5;
        if (this.triangleVertices == null) {
            this.triangleVertices = ByteBuffer.allocateDirect(this.triangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        this.triangleVertices.put(this.triangleVerticesData).position(0);
        float f2 = (float)n2 * 1.0f / (float)n3;
        float f3 = (float)n4 * 1.0f / (float)n5;
        if (f2 > f3) {
            float f4 = (float)n2 - 1.0f * (float)n4 * (float)n3 / (float)n5;
            float f5 = f4 / (float)n2;
            FloatBuffer floatBuffer = this.triangleVertices;
            int n6 = 2;
            float f6 = floatBuffer.get(n6);
            floatBuffer.put(n6, f6 += f5 / 2.0f);
            float f7 = floatBuffer.get(n6 += 4);
            floatBuffer.put(n6, f7 -= f5 / 2.0f);
            float f8 = floatBuffer.get(n6 += 4);
            floatBuffer.put(n6, f8 += f5 / 2.0f);
            float f9 = floatBuffer.get(n6 += 4);
            floatBuffer.put(n6, f9 -= f5 / 2.0f);
        } else {
            float f10 = (float)n3 - 1.0f * (float)n5 * (float)n2 / (float)n4;
            float f11 = f10 / (float)n3;
            FloatBuffer floatBuffer = this.triangleVertices;
            int n7 = 3;
            float f12 = floatBuffer.get(n7);
            floatBuffer.put(n7, f12 += f11 / 2.0f);
            float f13 = floatBuffer.get(n7 += 4);
            floatBuffer.put(n7, f13 += f11 / 2.0f);
            float f14 = floatBuffer.get(n7 += 4);
            floatBuffer.put(n7, f14 -= f11 / 2.0f);
            float f15 = floatBuffer.get(n7 += 4);
            floatBuffer.put(n7, f15 -= f11 / 2.0f);
        }
    }

    public void setOnSurfaceErrorListener(OnSurfaceErrorListener onSurfaceErrorListener) {
        this.onSurfaceErrorListener = onSurfaceErrorListener;
    }

    static interface OnSurfaceErrorListener {
        public void surfaceError(int var1, String var2);
    }

    static interface OnSurfacePrepareListener {
        public void surfacePrepared(Surface var1);
    }
}

