/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.audio;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.loader.c;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.statistic.FlowDataStatistic;
import com.hunantv.media.report.ReportParams;
import java.io.IOException;
import java.text.NumberFormat;

public class MgtvAudioPlayer {
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_PLAYING = 3;
    private static final int STATE_PAUSED = 4;
    private static final int STATE_PLAYBACK_COMPLETED = 5;
    private Context mContext;
    private MgtvMediaPlayer mMediaPlayer;
    private int mCurrentState = 0;
    private int mTargetState = 0;
    private Uri mCurrentUri = null;
    private boolean mAutoPlay = false;
    private String mErrorMsg = "";
    private int mSeekWhenPrepared;
    private MgtvPlayerListener.OnPreparedListener mOnPreparedListener;
    private MgtvPlayerListener.OnStartListener mOnStartListener;
    private MgtvPlayerListener.OnPauseListener mOnPauseListener;
    private MgtvPlayerListener.OnErrorListener mOnErrorListener;
    private MgtvPlayerListener.OnCompletionListener mOnCompletionListener;
    private MgtvPlayerListener.OnInfoListener mOnInfoListener;
    int mConnectTimeOut;
    int mReciveDataTimeOut;
    int mBufferTimeoutMs;
    ReportParams mReportParams;
    float mLeftVolume = -1.0f;
    float mRightVolume = -1.0f;
    FlowDataStatistic mFlowDataStatistic = new FlowDataStatistic();
    private boolean mEnableLiveMode = false;
    private int mLiveStartIndex = 0;

    public MgtvAudioPlayer(Context context) {
        this.mContext = context;
        if (context != null && context instanceof Activity) {
            ((Activity)context).setVolumeControlStream(3);
        }
    }

    public MgtvAudioPlayer(Context context, boolean bl) {
        this(context);
        this.mEnableLiveMode = bl;
    }

    public String getLogTagKey() {
        return this.getClass().getSimpleName() + "-" + this.hashCode();
    }

    private void openPlayer() {
        if (this.mMediaPlayer != null) {
            this.reset();
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("BUNDLE_KEY_LOG_TAG_KEY", this.getLogTagKey());
        bundle.putBoolean("BUNDLE_KEY_BOOLEAN_AUDIO_MODE", true);
        this.mMediaPlayer = new MgtvMediaPlayer(1, this.mContext, bundle);
        this.mMediaPlayer.setConfig(201507067, 1);
        this.mMediaPlayer.setOnPreparedListener(new MgtvPlayerListener.OnPreparedListener(){

            @Override
            public void onPrepared() {
                MgtvAudioPlayer.this.onPreparedImpl();
            }
        });
        this.mMediaPlayer.setOnErrorListener(new MgtvPlayerListener.OnErrorListener(){

            @Override
            public boolean onError(int n2, int n3) {
                return MgtvAudioPlayer.this.onErrorImpl(n2, n3);
            }
        });
        this.mMediaPlayer.setOnCompletionListener(new MgtvPlayerListener.OnCompletionListener(){

            @Override
            public void onCompletion(int n2, int n3) {
                MgtvAudioPlayer.this.onCompletionImpl(n2, n3);
            }
        });
        this.mMediaPlayer.setOnInfoListener(new MgtvPlayerListener.OnInfoListener(){

            @Override
            public boolean onInfo(int n2, int n3) {
                return MgtvAudioPlayer.this.onInfoImpl(n2, n3);
            }
        });
        this.mMediaPlayer.setOnBufferingTimeoutListener(new MgtvPlayerListener.OnBufferingTimeoutListener(){

            @Override
            public boolean onBufferingTimeout(int n2, int n3) {
                return MgtvAudioPlayer.this.onBufferingTimeoutImpl(n2, n3);
            }
        });
    }

    private void configPlayer() {
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mMediaPlayer.setTimeout(this.mConnectTimeOut, this.mReciveDataTimeOut, this.mBufferTimeoutMs);
        this.mMediaPlayer.setReportParams(this.mReportParams);
        if (this.mLeftVolume >= 0.0f && this.mRightVolume >= 0.0f) {
            this.mMediaPlayer.setVolume(this.mLeftVolume, this.mRightVolume);
        }
        this.mMediaPlayer.setFlowDataStatistic(this.mFlowDataStatistic);
        if (this.mEnableLiveMode) {
            this.mMediaPlayer.setEnablePlayerMode(MgtvMediaPlayer.PlayerModeType.TYPE_PLAYER_MODE_LIVE);
        } else {
            this.mMediaPlayer.setEnablePlayerMode(MgtvMediaPlayer.PlayerModeType.TYPE_PLAYER_MODE_NORMAL);
        }
        this.mMediaPlayer.setLiveStartIndex(this.mLiveStartIndex);
        DebugLog.i(this.getLogTag(), "configPlayer mEnableLiveMode:" + this.mEnableLiveMode + ",mLiveStartIndex:" + this.mLiveStartIndex);
        if (this.mFlowDataStatistic != null) {
            this.mFlowDataStatistic.setLogTag(this.getLogTag());
        }
    }

    public void prepare(String string, boolean bl) {
        this.mCurrentUri = Uri.parse((String)string.trim());
        this.mAutoPlay = bl;
        try {
            this.openPlayer();
            this.configPlayer();
            DebugLog.i(this.getLogTag(), "prepare path" + string);
            this.mMediaPlayer.setDataSource(this.mCurrentUri.toString());
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setScreenOnWhilePlaying(true);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = 1;
        }
        catch (IOException iOException) {
            DebugLog.e(this.getLogTag(), "Unable to open content: " + this.mCurrentUri, iOException);
            this.mErrorMsg = iOException.getMessage();
            this.onErrorImpl(7001004, 0);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugLog.e(this.getLogTag(), "Unable to open content: " + this.mCurrentUri, illegalArgumentException);
            this.mErrorMsg = illegalArgumentException.getMessage();
            this.onErrorImpl(7000001, 0);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            DebugLog.e(this.getLogTag(), "Unable to open content: " + this.mCurrentUri, illegalStateException);
            this.mErrorMsg = illegalStateException.getMessage();
            this.onErrorImpl(7000002, 0);
            return;
        }
        catch (SecurityException securityException) {
            DebugLog.e(this.getLogTag(), "SecurityException: " + this.mCurrentUri + "details:" + securityException.getMessage());
            this.mErrorMsg = securityException.getMessage();
            this.onErrorImpl(7000004, 0);
            return;
        }
        catch (NullPointerException nullPointerException) {
            DebugLog.e(this.getLogTag(), "NullPointerException: " + this.mCurrentUri + "details:" + nullPointerException.getMessage());
            this.mErrorMsg = nullPointerException.getMessage();
            this.onErrorImpl(7000005, 0);
            return;
        }
        catch (Exception exception) {
            DebugLog.e(this.getLogTag(), "Unable to open content: " + this.mCurrentUri, exception);
            this.mErrorMsg = exception.getMessage();
            this.onErrorImpl(7000003, 0);
            return;
        }
        catch (c c2) {
            DebugLog.e(this.getLogTag(), "LibLoaderError: " + this.mCurrentUri + "details:" + c2.getMessage() + ",extra:" + c2.a());
            this.mErrorMsg = c2.getMessage();
            this.onErrorImpl(7000010, c2.a());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            DebugLog.e(this.getLogTag(), "UnsatisfiedLinkError: " + this.mCurrentUri + "details:" + unsatisfiedLinkError.getMessage());
            this.mErrorMsg = unsatisfiedLinkError.getMessage();
            this.onErrorImpl(7000010, 0);
            return;
        }
        catch (Throwable throwable) {
            DebugLog.e(this.getLogTag(), "Throwable: " + this.mCurrentUri + "details:" + throwable.getMessage());
            this.mErrorMsg = throwable.getMessage();
            this.onErrorImpl(7000003, 1);
            return;
        }
    }

    public void play() {
        if (this.isInPlaybackState() && this.mCurrentState != 3) {
            this.mMediaPlayer.start();
            DebugLog.i(this.getLogTag(), "play");
            if (this.mOnStartListener != null) {
                this.mOnStartListener.onStart();
            }
            this.mCurrentState = 3;
        }
        this.mTargetState = 3;
    }

    public void pause() {
        if (this.isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            DebugLog.i(this.getLogTag(), "pause");
            this.mMediaPlayer.pause();
            if (this.mOnPauseListener != null) {
                this.mOnPauseListener.onPause();
            }
            this.mCurrentState = 4;
        }
        this.mTargetState = 4;
    }

    public void seekTo(int n2) {
        if (this.isInPlaybackState()) {
            if (n2 >= 0) {
                DebugLog.i(this.getLogTag(), "seekTo msec:" + n2);
                this.mMediaPlayer.seekTo(n2);
            }
            this.mSeekWhenPrepared = 0;
        } else {
            this.mSeekWhenPrepared = n2;
        }
    }

    public void stop() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
        }
    }

    public boolean isPlaying() {
        return this.isInPlaybackState() && this.mMediaPlayer != null && this.mMediaPlayer.isPlaying();
    }

    public int getBufferingPercentage() {
        if (this.isInPlaybackState()) {
            return this.mMediaPlayer.getBufferingPercent();
        }
        return 0;
    }

    public int getTotalBuffering() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getBufferedPercentage();
        }
        return 0;
    }

    public boolean isPrepared() {
        return this.isInPlaybackState();
    }

    public boolean isRendered() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isRendered();
        }
        return false;
    }

    public boolean isCompletion() {
        return this.mCurrentState == 5;
    }

    public void setTimeout(int n2, int n3) {
        this.mConnectTimeOut = n2;
        this.mReciveDataTimeOut = n3;
    }

    public void setBufferTimeout(int n2) {
        this.mBufferTimeoutMs = n2;
    }

    private boolean isInPlaybackState() {
        return this.mCurrentState != -1 && this.mCurrentState != 0 && this.mCurrentState != 1;
    }

    public void reset() {
        if (this.mMediaPlayer != null) {
            this.resetData();
            this.mMediaPlayer.reset();
            this.mCurrentState = 0;
            this.mTargetState = 0;
        }
    }

    private void resetData() {
        this.mSeekWhenPrepared = 0;
        if (this.mFlowDataStatistic != null && this.mFlowDataStatistic.isBindPlayerLifecycle()) {
            this.mFlowDataStatistic.reset();
        }
    }

    public void release() {
        DebugLog.i(this.getLogTag(), "release");
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 0;
            this.mTargetState = 0;
        }
    }

    public int getDuration() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getDuration();
        }
        return 0;
    }

    public int getCurrentPosition() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void setPlaybackSpeed(float f2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setPlaybackSpeed(f2);
        }
    }

    public float getPlaybackSpeed() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getPlaybackSpeed();
        }
        return 1.0f;
    }

    public String getDLSpeedFormat() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(1);
        float f2 = 0.0f;
        if (this.mMediaPlayer != null) {
            f2 = (float)this.mMediaPlayer.getCurDLSpeed() / 1000.0f;
        }
        return numberFormat.format(f2) + "KB/S";
    }

    public int getDLSpeedB() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getCurDLSpeed();
        }
        return 0;
    }

    public String getPlayerVersion() {
        return "MGTV_1.22.0";
    }

    public void setReportParams(ReportParams reportParams) {
        this.mReportParams = reportParams;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setReportParams(this.mReportParams);
        }
    }

    public void setVolume(float f2, float f3) {
        this.mLeftVolume = f2;
        this.mRightVolume = f3;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.setVolume(f2, f3);
        }
    }

    public int getCurrentStatus() {
        return this.mCurrentState;
    }

    public FlowDataStatistic getFlowDataStatistic() {
        return this.mFlowDataStatistic;
    }

    public void setFlowDataStatistic(FlowDataStatistic flowDataStatistic) {
        this.mFlowDataStatistic = flowDataStatistic;
    }

    public String getVideoPath() {
        if (this.mCurrentUri != null) {
            return this.mCurrentUri.toString();
        }
        return null;
    }

    public MgtvMediaPlayer.PlayerExtraInfo getPlayerExtraInfo() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getPlayerExtraInfo();
        }
        return null;
    }

    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    private String getLogTag() {
        return this.getClass().getName() + "@" + this.hashCode();
    }

    private void onPreparedImpl() {
        this.mCurrentState = 2;
        if (this.mAutoPlay || this.mTargetState == 3) {
            this.play();
        }
        if (this.mSeekWhenPrepared > 0) {
            this.seekTo(this.mSeekWhenPrepared);
        }
        if (this.mOnPreparedListener != null) {
            this.mOnPreparedListener.onPrepared();
        }
    }

    private boolean onErrorImpl(int n2, int n3) {
        DebugLog.w(this.getLogTag(), "onErrorImpl what:" + n2 + ",extra:" + n3);
        this.mCurrentState = -1;
        this.mTargetState = -1;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
        }
        return this.mOnErrorListener != null && this.mOnErrorListener.onError(n2, n3);
    }

    private boolean onBufferingTimeoutImpl(int n2, int n3) {
        this.onErrorImpl(n2, n3);
        return true;
    }

    private void onCompletionImpl(int n2, int n3) {
        DebugLog.w(this.getLogTag(), "onCompletion what:" + n2 + ",extra:" + n3);
        this.mCurrentState = 5;
        this.mTargetState = 5;
        if (this.mOnCompletionListener != null) {
            this.mOnCompletionListener.onCompletion(n2, n3);
        }
    }

    private boolean onInfoImpl(int n2, int n3) {
        if (this.mOnInfoListener != null) {
            return this.mOnInfoListener.onInfo(n2, n3);
        }
        return true;
    }

    public void setOnPreparedListener(MgtvPlayerListener.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setOnStartListener(MgtvPlayerListener.OnStartListener onStartListener) {
        this.mOnStartListener = onStartListener;
    }

    public void setOnPauseListener(MgtvPlayerListener.OnPauseListener onPauseListener) {
        this.mOnPauseListener = onPauseListener;
    }

    public void setOnErrorListener(MgtvPlayerListener.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnCompletionListener(MgtvPlayerListener.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnInfoListener(MgtvPlayerListener.OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    public void setLiveMode(boolean bl) {
        this.mEnableLiveMode = bl;
    }

    public void setLiveStartIndex(int n2) {
        this.mLiveStartIndex = n2;
    }

    public void setLiveReopen() {
        if (this.mEnableLiveMode && this.mMediaPlayer != null) {
            this.mMediaPlayer.setLiveReopen();
        }
    }
}

