/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.config;

import android.content.Context;
import com.google.gson.Gson;
import com.hunantv.media.config.NetPlayConfigWrapper;
import com.hunantv.media.player.helper.MediaCodecHelp;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.player.utils.SystemUtil;
import com.hunantv.media.report.c.d;
import com.hunantv.media.utils.NumericUtil;

public class NetPlayConfig {
    private static final String TAG = NetPlayConfig.class.getSimpleName();
    private static volatile NetPlayConfig sGlobalNetPlayConfig;
    private static volatile String sGlobalNetPlayConfigStr;
    private static boolean sDrmProxyEnable;
    private static boolean sNativeOpenglEnable;
    private static boolean sAudioTimestampEnable;
    private static boolean sSmoothSwitchEnable;
    private static boolean sExDefEnable;
    private static boolean sAlphaPlayEnable;
    private static boolean sReportModeSingleEnable;
    private static boolean sReportModeBatchEnable;
    private static boolean sWanosAudioEnable;
    private static boolean sAACExAudioEnable;
    private static boolean sImgoVsrEnable;
    private static boolean sCtxModifyErrEnable;
    public static final int CONFIG_DEFAULT = 0;
    public static final int CONFIG_CLOSE = 9;
    public static int sConfigH265;
    public static int sConfigDnsType;
    public static int sConfigDnsCache;
    public static int sConfigFastMode;
    public static int sConfigP2pHttpDns;
    public static int sConfigMgtvMediaCodec;
    public static int sConfigRenderOpengl;
    public static int sConfigChunkRequest;
    public static int sConfigHdr;
    public static int sConfig4K;
    public static int sConfigCodecSWRender;
    public static int sConfigOppoSr;
    public static final int DRM_TYPE_CENC_HLS = 4;
    public static final int DRM_TYPE_SM4_HLS = 5;
    public static int sConfigPreferDrmType;
    public static int sConfigCodecBgStop;
    public static int sPlayercoreVersion;
    public static int sConfigSWRenderType;
    private static String[] sCodecBgStopWhiteList;
    public int mp_type = -1;
    public int is_soft = -1;
    public int render_type = -1;
    public int decodetype = -1;
    public int accurate_seek = -1;
    public int open_timeout = -1;
    public int rw_timeout = -1;
    public String addrinfo_type;
    public int addrinfo_timeout = -1;
    public int buffer_timeout = -1;
    public int ts_not_skip = -1;
    public int load_retry_time = -1;
    public int datasource_async = -1;
    public int weak_net_speed = -1;
    public int dns_family_type = -1;
    public int http_persistent = -1;
    public int http_multiple = -1;
    public int m3u8_gzip = -1;
    public String player_support;
    private static String sNetworkType;

    public static synchronized void setGlobalNetPlayConfig(NetPlayConfig netPlayConfig) {
        DebugLog.i(TAG, "setGlobalNetPlayConfig " + netPlayConfig);
        sGlobalNetPlayConfig = netPlayConfig;
        if (sGlobalNetPlayConfig != null) {
            NetPlayConfig.parseAddrInfoType(netPlayConfig.addrinfo_type);
            NetPlayConfig.parsePlayerSupport(NetPlayConfig.sGlobalNetPlayConfig.player_support);
        }
    }

    public static synchronized String getPrst() {
        if (sGlobalNetPlayConfig != null) {
            return NetPlayConfig.sGlobalNetPlayConfig.player_support;
        }
        return "";
    }

    public static NetPlayConfig getsGlobalNetPlayConfig() {
        return sGlobalNetPlayConfig;
    }

    public static synchronized void parsePlayerSupport(String string) {
        if (StringUtil.isEmpty(string)) {
            return;
        }
        try {
            String[] stringArray = string.split("-");
            if (stringArray == null || stringArray.length < 2) {
                return;
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            if (!NetPlayConfig.validBooleanStr(string2) || StringUtil.isEmpty(string3)) {
                DebugLog.i(TAG, "player_support invalid s1 or s2");
                return;
            }
            char[] cArray = string3.toCharArray();
            if (cArray == null || cArray.length <= 0) {
                return;
            }
            int n2 = 1;
            for (char c2 : cArray) {
                NetPlayConfig.mapPlayerSupportS2Value(c2, n2);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized void mapPlayerSupportS2Value(char c2, int n2) {
        if (!NetPlayConfig.validBooleanChar(c2)) {
            DebugLog.i(TAG, "mapPlayerSupportS2Value invalid." + c2 + "-" + n2);
            return;
        }
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                if ('0' == c2) {
                    sDrmProxyEnable = false;
                    DebugLog.i(TAG, "sDrmProxyEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sDrmProxyEnable = true;
                    DebugLog.i(TAG, "sDrmProxyEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sDrmProxyEnable value:" + c2 + ":" + sDrmProxyEnable);
                break;
            }
            case 3: {
                if ('0' == c2) {
                    sNativeOpenglEnable = false;
                    DebugLog.i(TAG, "sNativeOpenglEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sNativeOpenglEnable = true;
                    DebugLog.i(TAG, "sNativeOpenglEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sNativeOpenglEnable value:" + c2 + ":" + sNativeOpenglEnable);
                break;
            }
            case 4: {
                if ('0' == c2) {
                    sAudioTimestampEnable = false;
                    DebugLog.i(TAG, "sAudioTimestampEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sAudioTimestampEnable = true;
                    DebugLog.i(TAG, "sAudioTimestampEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sAudioTimestampEnable value:" + c2 + ":" + sAudioTimestampEnable);
                break;
            }
            case 5: {
                if ('0' == c2) {
                    sSmoothSwitchEnable = false;
                    DebugLog.i(TAG, "sSmoothSwitchEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sSmoothSwitchEnable = true;
                    DebugLog.i(TAG, "sSmoothSwitchEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sSmoothSwitchEnable value:" + c2 + ":" + sSmoothSwitchEnable);
                break;
            }
            case 6: {
                if ('0' == c2) {
                    sExDefEnable = false;
                    DebugLog.i(TAG, "sExDefEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sExDefEnable = true;
                    DebugLog.i(TAG, "sExDefEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sExDefEnable value:" + c2 + ":" + sExDefEnable);
                break;
            }
            case 7: {
                if ('0' == c2) {
                    sAlphaPlayEnable = false;
                    DebugLog.i(TAG, "sAlphaPlayEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sAlphaPlayEnable = true;
                    DebugLog.i(TAG, "sAlphaPlayEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sAlphaPlayEnable value:" + c2 + ":" + sAlphaPlayEnable);
                break;
            }
            case 8: {
                if ('0' == c2) {
                    sReportModeSingleEnable = false;
                    DebugLog.i(TAG, "sReportModeSingleEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sReportModeSingleEnable = true;
                    DebugLog.i(TAG, "sReportModeSingleEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sReportModeSingleEnable value:" + c2 + ":" + sReportModeSingleEnable);
                break;
            }
            case 9: {
                if ('0' == c2) {
                    sReportModeBatchEnable = false;
                    DebugLog.i(TAG, "sReportModeBatchEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sReportModeBatchEnable = true;
                    DebugLog.i(TAG, "sReportModeBatchEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sReportModeBatchEnable value:" + c2 + ":" + sReportModeBatchEnable);
                break;
            }
            case 10: {
                if ('0' == c2) {
                    sWanosAudioEnable = false;
                    DebugLog.i(TAG, "sWanosAudioEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sWanosAudioEnable = true;
                    DebugLog.i(TAG, "sWanosAudioEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sWanosAudioEnable value:" + c2 + ":" + sWanosAudioEnable);
                break;
            }
            case 11: {
                if ('0' == c2) {
                    sAACExAudioEnable = false;
                    DebugLog.i(TAG, "sAACExAudioEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sAACExAudioEnable = true;
                    DebugLog.i(TAG, "sAACExAudioEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sAACExAudioEnable value:" + c2 + ":" + sAACExAudioEnable);
                break;
            }
            case 12: {
                if ('0' == c2) {
                    sImgoVsrEnable = false;
                    DebugLog.i(TAG, "sImgoVsrEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sImgoVsrEnable = true;
                    DebugLog.i(TAG, "sImgoVsrEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sImgoVsrEnable value:" + c2 + ":" + sImgoVsrEnable);
                break;
            }
            case 13: {
                if ('0' == c2) {
                    sCtxModifyErrEnable = false;
                    DebugLog.i(TAG, "sCtxModifyErrEnable = false");
                    break;
                }
                if ('1' == c2) {
                    sCtxModifyErrEnable = true;
                    DebugLog.i(TAG, "sCtxModifyErrEnable = true");
                    break;
                }
                DebugLog.i(TAG, "invalid sCtxModifyErrEnable value:" + c2 + ":" + sAACExAudioEnable);
            }
        }
    }

    public static synchronized void parseAddrInfoType(String string) {
        if (StringUtil.isEmpty(string)) {
            return;
        }
        char[] cArray = string.toCharArray();
        if (cArray == null || cArray.length <= 0) {
            return;
        }
        DebugLog.i(TAG, "parseAddrInfoType:" + string);
        int n2 = 1;
        for (char c2 : cArray) {
            switch (n2) {
                case 1: {
                    sConfigH265 = NumericUtil.parseInt(String.valueOf(c2), 0);
                    if ('9' == c2) {
                        DebugLog.i(TAG, "sH265Enable = false");
                        MediaCodecHelp.sH265Enable = false;
                        break;
                    }
                    DebugLog.i(TAG, "sH265Enable = true");
                    MediaCodecHelp.sH265Enable = true;
                    break;
                }
                case 2: {
                    sConfigDnsType = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 3: {
                    sConfigDnsCache = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 4: {
                    sConfigFastMode = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 5: {
                    sConfigP2pHttpDns = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 6: {
                    sConfigMgtvMediaCodec = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 7: {
                    sConfigRenderOpengl = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 8: {
                    sConfigChunkRequest = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 9: {
                    sConfigHdr = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 10: {
                    sConfig4K = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 11: {
                    sConfigCodecSWRender = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 12: {
                    sConfigOppoSr = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 13: {
                    sConfigPreferDrmType = NumericUtil.parseInt(String.valueOf(c2), 0);
                    break;
                }
                case 14: {
                    break;
                }
                case 16: {
                    sConfigSWRenderType = NumericUtil.parseInt(String.valueOf(c2), 0);
                }
            }
            ++n2;
        }
        DebugLog.i(TAG, "parseAddrInfoType sConfigH265:" + sConfigH265 + ",sConfigDnsType:" + sConfigDnsType + ",sConfigDnsCache:" + sConfigDnsCache + ",sConfigFastMode:" + sConfigFastMode + ",sConfigP2pHttpDns:" + sConfigP2pHttpDns + ",sConfigMgtvMediaCodec:" + sConfigMgtvMediaCodec + ",sConfigPreferDrmType:" + sConfigPreferDrmType + ",sConfigSWRenderType:" + sConfigSWRenderType);
    }

    public static boolean isHdrOpen() {
        return sConfigHdr == 1;
    }

    public static boolean is4KOpen() {
        return sConfig4K == 1;
    }

    public static int getPreferDrmType() {
        return sConfigPreferDrmType;
    }

    public static boolean isChunkRequestOpen() {
        return sConfigChunkRequest == 1;
    }

    public static boolean isCodecSWRenderOpen() {
        return sConfigCodecSWRender == 1 || sConfigCodecSWRender == 2;
    }

    public static boolean isCodecSWRenderMark() {
        return sConfigCodecSWRender == 2;
    }

    public static boolean isOppoSrOpen() {
        return sConfigOppoSr == 1;
    }

    public static boolean isEnableSWOpengl() {
        return sConfigSWRenderType == 1;
    }

    public static int getPlayercoreVersion() {
        return sPlayercoreVersion;
    }

    public static void setPlayercoreVersion(int n2) {
        DebugLog.i(TAG, "setPlayercoreVersion : " + n2);
        sPlayercoreVersion = n2;
    }

    public static boolean isRenderOpenglOpen() {
        return sConfigRenderOpengl != 9;
    }

    public static boolean validBooleanStr(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return "0".equalsIgnoreCase(string) || "1".equalsIgnoreCase(string);
    }

    public static boolean validBooleanChar(char c2) {
        return c2 == '0' || c2 == '1';
    }

    public static boolean isDrmProxyEnable() {
        return sDrmProxyEnable;
    }

    public static boolean isNativeOpenglEnable() {
        return sNativeOpenglEnable;
    }

    public static boolean isAudioTimestampEnable() {
        return sAudioTimestampEnable || SystemUtil.getHwEmuiAPILevel() >= 25;
    }

    public static boolean isSmoothSwitchEnable() {
        return sSmoothSwitchEnable;
    }

    public static boolean isExDefEnable() {
        return sExDefEnable;
    }

    public static boolean isAlphaPlayEnable() {
        return sAlphaPlayEnable;
    }

    public static int getFlowReportMode() {
        if (sReportModeSingleEnable && sReportModeBatchEnable || !sReportModeSingleEnable && !sReportModeBatchEnable) {
            return 0;
        }
        if (sReportModeSingleEnable) {
            return 2;
        }
        if (sReportModeBatchEnable) {
            return 1;
        }
        return 0;
    }

    public static boolean isWanosAudioEnable() {
        return sWanosAudioEnable || sAACExAudioEnable;
    }

    public static boolean isWanosAudioInnerEnable() {
        return sWanosAudioEnable;
    }

    public static boolean isAACExAudioEnable() {
        return sAACExAudioEnable;
    }

    public static boolean isImgoVsrEnable() {
        return sImgoVsrEnable;
    }

    public static boolean isCtxModifyErrEnable() {
        return sCtxModifyErrEnable;
    }

    public static synchronized void setGlobalNetPlayConfigStr(String string) {
        DebugLog.i(TAG, "setGlobalNetPlayConfigStr :" + string);
        sGlobalNetPlayConfigStr = string;
        NetPlayConfigWrapper netPlayConfigWrapper = (NetPlayConfigWrapper)new Gson().fromJson(string, NetPlayConfigWrapper.class);
        sGlobalNetPlayConfig = netPlayConfigWrapper.data;
        NetPlayConfig.setGlobalNetPlayConfig(sGlobalNetPlayConfig);
        DebugLog.i(TAG, "setGlobalNetPlayConfigStr wrapper.data :" + netPlayConfigWrapper.data);
    }

    public static synchronized String getGlobalNetPlayConfigStr() {
        return sGlobalNetPlayConfigStr;
    }

    public int getMp_type() {
        return this.mp_type;
    }

    public NetPlayConfig setMp_type(int n2) {
        this.mp_type = n2;
        return this;
    }

    public int getIs_soft() {
        return this.is_soft;
    }

    public NetPlayConfig setIs_soft(int n2) {
        this.is_soft = n2;
        return this;
    }

    public int getRender_type() {
        return this.render_type;
    }

    public NetPlayConfig setRender_type(int n2) {
        this.render_type = n2;
        return this;
    }

    public int getDecodetype() {
        return this.decodetype;
    }

    public NetPlayConfig setDecodetype(int n2) {
        this.decodetype = n2;
        return this;
    }

    public int getAccurate_seek() {
        return this.accurate_seek;
    }

    public NetPlayConfig setAccurate_seek(int n2) {
        this.accurate_seek = n2;
        return this;
    }

    public int getOpen_timeout() {
        return this.open_timeout;
    }

    public NetPlayConfig setOpen_timeout(int n2) {
        this.open_timeout = n2;
        return this;
    }

    public int getRw_timeout() {
        return this.rw_timeout;
    }

    public NetPlayConfig setRw_timeout(int n2) {
        this.rw_timeout = n2;
        return this;
    }

    public String getAddrinfo_type() {
        return this.addrinfo_type;
    }

    @Deprecated
    public NetPlayConfig setAddrinfo_type(int n2) {
        return this;
    }

    public NetPlayConfig setAddrinfo_type(String string) {
        this.addrinfo_type = string;
        return this;
    }

    public int getAddrinfo_timeout() {
        return this.addrinfo_timeout;
    }

    public NetPlayConfig setAddrinfo_timeout(int n2) {
        this.addrinfo_timeout = n2;
        return this;
    }

    public int getBuffer_timeout() {
        return this.buffer_timeout;
    }

    public NetPlayConfig setBuffer_timeout(int n2) {
        this.buffer_timeout = n2;
        return this;
    }

    public int getTs_not_skip() {
        return this.ts_not_skip;
    }

    public NetPlayConfig setTs_not_skip(int n2) {
        this.ts_not_skip = n2;
        return this;
    }

    public int getLoad_retry_time() {
        return this.load_retry_time;
    }

    public NetPlayConfig setLoad_retry_time(int n2) {
        this.load_retry_time = n2;
        return this;
    }

    public int getDatasource_async() {
        return this.datasource_async;
    }

    public NetPlayConfig setDatasource_async(int n2) {
        this.datasource_async = n2;
        return this;
    }

    public int getWeak_net_speed() {
        return this.weak_net_speed;
    }

    public NetPlayConfig setWeak_net_speed(int n2) {
        this.weak_net_speed = n2;
        return this;
    }

    public int getDns_family_type() {
        return this.dns_family_type;
    }

    public NetPlayConfig setDns_family_type(int n2) {
        this.dns_family_type = n2;
        return this;
    }

    public int getHttp_persistent() {
        return this.http_persistent;
    }

    public NetPlayConfig setHttp_persistent(int n2) {
        this.http_persistent = n2;
        return this;
    }

    public int getHttp_multiple() {
        return this.http_multiple;
    }

    public NetPlayConfig setHttp_multiple(int n2) {
        this.http_multiple = n2;
        return this;
    }

    public int getM3u8_gzip() {
        return this.m3u8_gzip;
    }

    public NetPlayConfig setM3u8_gzip(int n2) {
        this.m3u8_gzip = n2;
        return this;
    }

    public String getPlayer_support() {
        return this.player_support;
    }

    public NetPlayConfig setPlayer_support(String string) {
        this.player_support = string;
        return this;
    }

    public static synchronized void updateNetworkType(Context context) {
        sNetworkType = d.a(context);
    }

    public static synchronized String getNetworkType() {
        return sNetworkType;
    }

    public static synchronized void setNetworkType(String string) {
        sNetworkType = string;
    }

    public String toString() {
        return "NetPlayConfig{mp_type=" + this.mp_type + ", is_soft=" + this.is_soft + ", render_type=" + this.render_type + ", decodetype=" + this.decodetype + ", accurate_seek=" + this.accurate_seek + ", open_timeout=" + this.open_timeout + ", rw_timeout=" + this.rw_timeout + ", addrinfo_type=" + this.addrinfo_type + ", addrinfo_timeout=" + this.addrinfo_timeout + ", buffer_timeout=" + this.buffer_timeout + ", ts_not_skip=" + this.ts_not_skip + ", load_retry_time=" + this.load_retry_time + ", datasource_async=" + this.datasource_async + ", weak_net_speed=" + this.weak_net_speed + ", dns_family_type=" + this.dns_family_type + ", http_persistent=" + this.http_persistent + ", http_multiple=" + this.http_multiple + ", m3u8_gzip=" + this.m3u8_gzip + ", player_support=" + this.player_support + '}';
    }

    static {
        sDrmProxyEnable = false;
        sNativeOpenglEnable = false;
        sAudioTimestampEnable = false;
        sSmoothSwitchEnable = true;
        sExDefEnable = false;
        sAlphaPlayEnable = false;
        sReportModeSingleEnable = false;
        sReportModeBatchEnable = false;
        sWanosAudioEnable = false;
        sAACExAudioEnable = false;
        sImgoVsrEnable = false;
        sCtxModifyErrEnable = false;
        sPlayercoreVersion = 2;
        sCodecBgStopWhiteList = new String[]{"sdm710", "sm8350", "sm4350"};
        sNetworkType = "None";
    }
}

