/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.drm;

import android.app.Application;
import com.hunantv.media.drm.IDrmSession;
import com.hunantv.media.drm.MgtvDrmParams;
import java.util.List;

public interface IDrmManager {
    public static final int STATUS_NONE = 0;
    public static final int STATUS_INITING = 1;
    public static final int STATUS_INITED = 2;
    public static final int STATUS_ERROR = 3;
    public static final int ERROR_NULL = -10;
    public static final int ERROR_NULLPOINT = -11;

    public int init(Application var1, InitConfig var2);

    public void setOnInitListener(OnInitListener var1);

    public boolean isInited();

    public boolean isIniting();

    public String getErrorCode();

    public int getCurrentStatus();

    public IDrmSession genDrmSession(SessionConfig var1);

    public String getVersion();

    public int release();

    public static interface OnInitListener {
        public void onInitSuccess();

        public void onInitError(String var1, String var2);
    }

    public static class SessionConfig {
        public static final String STR_DRM_TYPE_MARLIN_BBTS = "0";
        public static final String STR_DRM_TYPE_CENC_HLS = "4";
        public static final String STR_DRM_TYPE_SM4_HLS = "5";
        public static final String STR_DRM_SOLUTION_WISEPLAY = "4";
        public String drmToken;
        public String drmCid;
        public String drmType;
        public List<MgtvDrmParams.DrmInfo> drmInfoList;

        public SessionConfig(String string, String string2) {
            this.drmToken = string;
            this.drmCid = string2;
        }

        public SessionConfig(String string, String string2, String string3, List<MgtvDrmParams.DrmInfo> list) {
            this.drmToken = string;
            this.drmCid = string2;
            this.drmType = string3;
            this.drmInfoList = list;
            if (STR_DRM_TYPE_MARLIN_BBTS.equalsIgnoreCase(string3) && list != null && list.size() > 0) {
                for (MgtvDrmParams.DrmInfo drmInfo : list) {
                    if (!STR_DRM_TYPE_MARLIN_BBTS.equalsIgnoreCase(drmInfo.drmSolution)) continue;
                    this.drmToken = drmInfo.drmToken;
                    this.drmCid = drmInfo.drmCid;
                }
            }
        }

        public String toString() {
            return "SessionConfig{drmToken='" + this.drmToken + '\'' + ", drmCid='" + this.drmCid + '\'' + ", drmVendor='" + this.drmType + '\'' + ", drmLicenseList=" + this.drmInfoList + '}';
        }
    }

    public static class InitConfig {
        public String initDirPath;
        public boolean enableRoot;

        public InitConfig(String string, boolean bl) {
            this.initDirPath = string;
            this.enableRoot = bl;
        }
    }
}

