/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.drm.cenc;

import android.media.MediaDrm;
import android.os.Build;
import android.util.Base64;
import com.hunantv.media.drm.MgtvDrmParams;
import com.hunantv.media.drm.cenc.CencDrmConstans;
import com.hunantv.media.drm.utils.CencDrmTools;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.report.b.a;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CencCoreDrmSession {
    private static final String TAG = "CencCoreDrmSession";
    public static final int STATUS_NONE = 0;
    public static final int STATUS_FAILED = 1;
    Map<UUID, CencDrmTools.PSSH> psshMap;
    List<MgtvDrmParams.DrmInfo> drmInfoList;
    UUID selectedUUID;
    CencDrmTools.PSSH selectedPssh;
    String selectedLicenseUrl;
    MediaDrm drm;
    byte[] drmSessionId;
    Object locker = new Object();
    volatile int status = 0;
    private OnDoLicenseListener licenseListener;

    public CencCoreDrmSession(Map<UUID, CencDrmTools.PSSH> map, List<MgtvDrmParams.DrmInfo> list) {
        this.psshMap = map;
        this.drmInfoList = list;
        this.selectDrmSolution(map, list);
    }

    public CencCoreDrmSession(Map<UUID, CencDrmTools.PSSH> map, List<MgtvDrmParams.DrmInfo> list, OnDoLicenseListener onDoLicenseListener) {
        this.psshMap = map;
        this.drmInfoList = list;
        this.licenseListener = onDoLicenseListener;
        this.selectDrmSolution(map, list);
    }

    private void selectDrmSolution(Map<UUID, CencDrmTools.PSSH> map, List<MgtvDrmParams.DrmInfo> list) {
        if (map != null && map.size() > 0) {
            if (map.containsKey(CencDrmConstans.WISEPLAY_UUID)) {
                this.selectedUUID = CencDrmConstans.WISEPLAY_UUID;
                this.selectedPssh = map.get(CencDrmConstans.WISEPLAY_UUID);
                for (MgtvDrmParams.DrmInfo drmInfo : list) {
                    if (drmInfo == null || !"4".equalsIgnoreCase(drmInfo.drmSolution)) continue;
                    this.selectedLicenseUrl = drmInfo.licenseUrl;
                }
                if (StringUtil.isEmpty(this.selectedLicenseUrl)) {
                    this.doLicenseListenerFailed(207, "license url empty");
                }
            }
        } else {
            this.doLicenseListenerFailed(208, "pssh empty");
        }
    }

    private static String getContentType(UUID uUID) {
        String string = CencDrmConstans.PLAYREADY_UUID.equals(uUID) ? "text/xml" : (CencDrmConstans.CLEARKEY_UUID.equals(uUID) || CencDrmConstans.WISEPLAY_UUID.equals(uUID) ? "application/json" : "application/octet-stream");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDoLicenseListener(OnDoLicenseListener onDoLicenseListener) {
        Object object = this.locker;
        synchronized (object) {
            this.licenseListener = onDoLicenseListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLicense() {
        DebugLog.i(TAG, "doLicense in");
        Object object = this.locker;
        synchronized (object) {
            if (this.status == 1) {
                return;
            }
            if (this.selectedUUID == null || this.selectedPssh == null) {
                DebugLog.e(TAG, "drm selected null");
                this.doLicenseListenerFailed(203, "");
                return;
            }
            try {
                if (Build.VERSION.SDK_INT >= 18 && MediaDrm.isCryptoSchemeSupported((UUID)this.selectedUUID)) {
                    this.drm = new MediaDrm(this.selectedUUID);
                    if (this.drm != null) {
                        this.drmSessionId = this.drm.openSession();
                        byte[] byArray = this.selectedPssh.rawData;
                        MediaDrm.KeyRequest keyRequest = this.drm.getKeyRequest(this.drmSessionId, byArray, "video/mp4", 1, new HashMap());
                        if (keyRequest == null) {
                            DebugLog.e(TAG, "doLicense keyRequest is null");
                            this.doLicenseListenerFailed(205, "");
                            return;
                        }
                        String string = null;
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        if (CencDrmConstans.WISEPLAY_UUID.equals(this.selectedUUID) && this.selectedPssh != null && this.selectedPssh.key_ids != null && this.selectedPssh.key_ids.size() > 0) {
                            string = new String(Base64.decode((String)((String)this.selectedPssh.key_ids.get(0)), (int)0));
                            hashMap.put("key", string);
                        }
                        String string2 = CencCoreDrmSession.getContentType(this.selectedUUID);
                        DebugLog.i(TAG, "doLicense selectedUrl:" + this.selectedLicenseUrl + " ,key=" + string);
                        a.a(this.selectedLicenseUrl, hashMap, string2, keyRequest.getData(), true, new a.a(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onSuccess(String string, int n2, String string2) {
                                Object object = CencCoreDrmSession.this.locker;
                                synchronized (object) {
                                    DebugLog.i(CencCoreDrmSession.TAG, "request license onSuccess code:" + n2);
                                    if (!StringUtil.isEmpty(string2)) {
                                        if (CencCoreDrmSession.this.drm != null) {
                                            try {
                                                CencCoreDrmSession.this.drm.provideKeyResponse(CencCoreDrmSession.this.drmSessionId, string2.getBytes());
                                                if (CencCoreDrmSession.this.licenseListener != null) {
                                                    CencCoreDrmSession.this.licenseListener.onSuccess();
                                                }
                                            }
                                            catch (Exception exception) {
                                                DebugLog.e(CencCoreDrmSession.TAG, "error: provideKeyResponse exception " + exception.getMessage());
                                                CencCoreDrmSession.this.doLicenseListenerFailed(202, exception.getMessage() + " url:" + string);
                                            }
                                        } else {
                                            CencCoreDrmSession.this.doLicenseListenerFailed(204, "url:" + string);
                                        }
                                    } else {
                                        DebugLog.e(CencCoreDrmSession.TAG, "error: response license empty");
                                        CencCoreDrmSession.this.doLicenseListenerFailed(201, "url:" + string);
                                    }
                                }
                            }

                            @Override
                            public void onFailed(String string, int n2) {
                                DebugLog.e(CencCoreDrmSession.TAG, "request license onFailed err:" + n2);
                                CencCoreDrmSession.this.doLicenseListenerFailed(n2, "url:" + string);
                            }
                        });
                    }
                } else {
                    DebugLog.e(TAG, "error: request license not support yet");
                    this.doLicenseListenerFailed(206, "");
                }
            }
            catch (Exception exception) {
                DebugLog.e(TAG, "error: dolicense exception " + exception.getMessage());
                this.doLicenseListenerFailed(200, exception.getMessage());
            }
        }
        DebugLog.i(TAG, "doLicense out");
    }

    public byte[] getDrmSessionId() {
        return this.drmSessionId;
    }

    public UUID getSelectedUUID() {
        return this.selectedUUID;
    }

    private synchronized void doLicenseListenerFailed(int n2, String string) {
        if (this.status != 1) {
            this.status = 1;
            if (this.licenseListener != null) {
                this.licenseListener.onFailed(n2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DebugLog.i(TAG, "close in");
        Object object = this.locker;
        synchronized (object) {
            if (this.drm != null) {
                if (Build.VERSION.SDK_INT >= 18) {
                    this.drm.closeSession(this.getDrmSessionId());
                    this.drm.release();
                }
                this.licenseListener = null;
                this.drm = null;
            }
        }
        DebugLog.i(TAG, "close out");
    }

    public static interface OnDoLicenseListener {
        public void onSuccess();

        public void onFailed(int var1, String var2);
    }
}

