/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.drm.strategy;

import android.app.Application;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.drm.IDrmManager;
import com.hunantv.media.drm.IDrmSession;
import com.hunantv.media.drm.cenc.CencDrmManager;
import com.hunantv.media.drm.cenc.CencDrmStrategy;
import com.hunantv.media.player.pragma.DebugLog;

public class StrategyDrmManager
implements IDrmManager {
    private static final String TAG = "StrategyDrmManager";
    private static IDrmManager sInstance;
    private IDrmManager cencDrmManager = CencDrmManager.getInstance();
    private IDrmManager currentDrmManager;
    private volatile IDrmManager.OnInitListener mOnInitListener;
    private Application application;
    private IDrmManager.InitConfig initConfig;

    public static synchronized IDrmManager getInstance() {
        if (sInstance == null) {
            sInstance = new StrategyDrmManager();
        }
        return sInstance;
    }

    private StrategyDrmManager() {
    }

    private void setCurrentInitListener() {
        if (this.currentDrmManager != null) {
            this.currentDrmManager.setOnInitListener(new IDrmManager.OnInitListener(){

                @Override
                public void onInitSuccess() {
                    if (StrategyDrmManager.this.mOnInitListener != null) {
                        StrategyDrmManager.this.mOnInitListener.onInitSuccess();
                    }
                }

                @Override
                public void onInitError(String string, String string2) {
                    if (StrategyDrmManager.this.mOnInitListener != null) {
                        StrategyDrmManager.this.mOnInitListener.onInitError(string, string2);
                    }
                }
            });
        }
    }

    @Override
    public int init(Application application, IDrmManager.InitConfig initConfig) {
        this.application = application;
        this.initConfig = initConfig;
        if (CencDrmStrategy.isCencSupported() && (NetPlayConfig.getPreferDrmType() == 4 || NetPlayConfig.getPreferDrmType() == 5)) {
            this.currentDrmManager = this.cencDrmManager;
        }
        if (this.currentDrmManager != null) {
            DebugLog.i(TAG, "init currentDrmManager " + this.currentDrmManager.getClass().getSimpleName());
        }
        this.setCurrentInitListener();
        this.cencDrmManager.init(application, initConfig);
        return 0;
    }

    @Override
    public void setOnInitListener(IDrmManager.OnInitListener onInitListener) {
        this.mOnInitListener = onInitListener;
    }

    @Override
    public boolean isInited() {
        if (this.currentDrmManager != null) {
            return this.currentDrmManager.isInited();
        }
        return false;
    }

    @Override
    public boolean isIniting() {
        return this.currentDrmManager.isIniting();
    }

    @Override
    public String getErrorCode() {
        return this.currentDrmManager.getErrorCode();
    }

    @Override
    public int getCurrentStatus() {
        return this.currentDrmManager.getCurrentStatus();
    }

    @Override
    public IDrmSession genDrmSession(IDrmManager.SessionConfig sessionConfig) {
        if (sessionConfig != null && ("4".equals(sessionConfig.drmType) || "5".equals(sessionConfig.drmType)) && sessionConfig.drmInfoList != null && sessionConfig.drmInfoList.size() > 0) {
            this.currentDrmManager = this.cencDrmManager;
        }
        DebugLog.i(TAG, "genDrmSession " + sessionConfig);
        if (this.currentDrmManager != null) {
            DebugLog.i(TAG, "genDrmSession currentDrmManager " + this.currentDrmManager.getClass().getSimpleName());
        }
        this.setCurrentInitListener();
        return this.currentDrmManager.genDrmSession(sessionConfig);
    }

    @Override
    public String getVersion() {
        return this.currentDrmManager.getVersion();
    }

    @Override
    public int release() {
        this.cencDrmManager.release();
        return 0;
    }
}

