/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.drm.utils;

import android.media.MediaDrm;
import android.os.Build;
import android.util.Log;
import com.google.gson.Gson;
import com.hunantv.media.drm.cenc.CencDrmConstans;
import com.hunantv.media.player.pragma.DebugLog;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CencDrmTools {
    private static final String TAG = "DrmTools";

    private static String arrToHex(byte[] byArray) {
        String string = "0x";
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            string = string + String.format("%02x", byArray[i2]);
        }
        return string;
    }

    private static UUID bytesToUUID(byte[] byArray) {
        long l2 = 0L;
        long l3 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            l2 |= ((long)byArray[i2] & 0xFFL) << 8 * (7 - i2);
            l3 |= ((long)byArray[i2 + 8] & 0xFFL) << 8 * (7 - i2);
        }
        return new UUID(l2, l3);
    }

    public static Map<UUID, PSSH> parsePSSH(byte[] byArray) {
        int n2 = 16;
        if (byArray == null || byArray.length < 16) {
            DebugLog.e(TAG, "parsePSSH invalid pssh");
            return null;
        }
        HashMap<UUID, PSSH> hashMap = new HashMap<UUID, PSSH>();
        try {
            PSSH pSSH = new PSSH();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n3 = byteBuffer.getInt();
            DebugLog.i(TAG, "pssh_size_bytes: " + n3);
            boolean bl = false;
            while (byteBuffer.remaining() > 0) {
                Object object;
                if (byteBuffer.remaining() < 16) {
                    Log.w((String)TAG, (String)("parsePSSH: len is too short to parse UUID: (" + byteBuffer.remaining() + " < 16)"));
                    return null;
                }
                int n4 = byteBuffer.getInt();
                int n5 = byteBuffer.getInt();
                int n6 = byteBuffer.getInt();
                int n7 = byteBuffer.getInt();
                pSSH.system_id = new byte[n4];
                byteBuffer.get(pSSH.system_id);
                for (int i2 = 0; i2 < n5; ++i2) {
                    object = new byte[n6];
                    byteBuffer.get((byte[])object);
                    pSSH.key_ids.add(object);
                }
                pSSH.data = new byte[n7];
                byteBuffer.get(pSSH.data);
                pSSH.rawData = CencDrmTools.createPsshRawData(pSSH);
                if (n4 != 16) continue;
                UUID uUID = CencDrmTools.bytesToUUID(pSSH.system_id);
                if (CencDrmConstans.WISEPLAY_UUID.equals(uUID)) {
                    DebugLog.i(TAG, "this is wiseplay uuid parse it");
                    pSSH.key_ids.clear();
                    object = (WisePlayPsshJson)new Gson().fromJson(new String(pSSH.data), WisePlayPsshJson.class);
                    pSSH.key_ids = object.kids;
                }
                hashMap.put(uUID, pSSH);
            }
            return hashMap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] createPsshRawData(PSSH pSSH) {
        if (pSSH == null || pSSH.system_id == null || pSSH.data == null) {
            return null;
        }
        int n2 = 8;
        int n3 = 1;
        int n4 = 3;
        int n5 = 4;
        int n6 = n2 + n3 + n4 + pSSH.system_id.length + n5 + pSSH.data.length;
        byte[] byArray = new byte[n6];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(n6);
        byte[] byArray2 = "pssh".getBytes();
        byteBuffer.put(byArray2, 0, byArray2.length);
        byteBuffer.putInt(0);
        byteBuffer.put(pSSH.system_id, 0, pSSH.system_id.length);
        byteBuffer.putInt(pSSH.data.length);
        byteBuffer.put(pSSH.data, 0, pSSH.data.length);
        return byArray;
    }

    public static boolean isCryptoSchemeSupported(UUID uUID) {
        try {
            if (Build.VERSION.SDK_INT >= 18 && uUID != null) {
                return MediaDrm.isCryptoSchemeSupported((UUID)uUID);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    private static class WisePlayPsshJson {
        public String version;
        public String contentID;
        public List<String> kids;
        public String enschema;
        public String playIndex;
        public String exts;

        private WisePlayPsshJson() {
        }
    }

    public static class PSSH {
        public byte[] system_id;
        public List key_ids = new LinkedList();
        public byte[] data;
        public byte[] rawData;
    }
}

