/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.drm.utils;

import java.nio.ByteBuffer;
import java.security.InvalidParameterException;

public class Hex {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static char[] encodeHex(byte[] byArray) {
        return Hex.encodeHex(byArray, true);
    }

    public static char[] encodeHex(byte[] byArray, boolean bl) {
        return Hex.encodeHex(byArray, bl ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static char[] encodeHex(ByteBuffer byteBuffer, boolean bl) {
        return Hex.encodeHex(byteBuffer, bl ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(ByteBuffer byteBuffer, char[] cArray) {
        return Hex.encodeHex(byteBuffer.array(), cArray);
    }

    protected static char[] encodeHex(byte[] byArray, char[] cArray) {
        int n2 = byArray.length;
        char[] cArray2 = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray2[n3++] = cArray[(0xF0 & byArray[i2]) >>> 4];
            cArray2[n3++] = cArray[0xF & byArray[i2]];
        }
        return cArray2;
    }

    public static byte[] decodeHex(char[] cArray) throws InvalidParameterException {
        int n2 = cArray.length;
        if ((n2 & 1) != 0) {
            throw new InvalidParameterException("Odd number of characters.");
        }
        byte[] byArray = new byte[n2 >> 1];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = Hex.toDigit(cArray[n4], n4) << 4;
            n5 |= Hex.toDigit(cArray[++n4], n4);
            ++n4;
            byArray[n3] = (byte)(n5 & 0xFF);
            ++n3;
        }
        return byArray;
    }

    protected static int toDigit(char c2, int n2) throws InvalidParameterException {
        int n3 = Character.digit(c2, 16);
        if (n3 == -1) {
            throw new InvalidParameterException("Illegal hexadecimal character " + c2 + " at index " + n2);
        }
        return n3;
    }
}

