/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.gif;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.hunantv.media.player.MgtvMediaPlayer;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.report.ReportParams;
import com.hunantv.media.report.a;

public class GifFramesProducer {
    public static final int ERROR_GIF_PREVIEW_IMAGE = 7001998;
    private Config mConfig;
    private Context mContext;
    private MgtvMediaPlayer mMediaPlayer;
    private Uri mCurrentUri;
    private Callback mCallback;
    private a mReporter;

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public GifFramesProducer(Context context, Config config) {
        this.mContext = context;
        this.mConfig = config;
        this.mReporter = new a(context, null);
        this.mReporter.a(new ReportParams().setVideoType(ReportParams.VideoType.GIF_PREVIEW_IMAGE));
        DebugLog.i(this.getLogTagKey(), "VideoFrameCapture " + config);
    }

    public Config getConfig() {
        return this.mConfig;
    }

    public String getLogTagKey() {
        return this.getClass().getSimpleName() + "-" + this.hashCode();
    }

    private void initListener() {
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mMediaPlayer.setPrepared4StartMode(MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_AUTOPLAY);
        this.mMediaPlayer.setOnPreparedListener(new MgtvPlayerListener.OnPreparedListener(){

            @Override
            public void onPrepared() {
                DebugLog.i(GifFramesProducer.this.getLogTagKey(), "onPrepared in");
                if (GifFramesProducer.this.mCallback != null) {
                    GifFramesProducer.this.mCallback.onStart();
                }
                if (GifFramesProducer.this.mMediaPlayer.getPrepared4StartMode() != MgtvMediaPlayer.Prepared4StartMode.MODE_PREPARED4START_AUTOPLAY) {
                    GifFramesProducer.this.mMediaPlayer.start();
                }
                DebugLog.i(GifFramesProducer.this.getLogTagKey(), "onPrepared out");
            }
        });
        this.mMediaPlayer.setOnGetFrameImageListener(new MgtvPlayerListener.OnGetFrameImageListener(){

            @Override
            public void onGetFrameImageStatus(int n2, int n3) {
                DebugLog.i(GifFramesProducer.this.getLogTagKey(), "onGetFrameImageStatus what:" + n2 + ", extra:" + n3);
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (GifFramesProducer.this.mReporter != null) {
                            GifFramesProducer.this.mReporter.b();
                        }
                        if (GifFramesProducer.this.mMediaPlayer != null) {
                            GifFramesProducer.this.mMediaPlayer.stop();
                        }
                        if (GifFramesProducer.this.mCallback == null) break;
                        GifFramesProducer.this.mCallback.onSuccess();
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (GifFramesProducer.this.mCallback == null) break;
                        GifFramesProducer.this.preOnError(7001998, n3);
                        GifFramesProducer.this.mCallback.onError(7001998, n3);
                    }
                }
            }

            @Override
            public void onGetFrameImageInfo(int n2, int n3, String string) {
                DebugLog.i(GifFramesProducer.this.getLogTagKey(), "onGetFrameImageInfo result_code:" + n2 + ", timestamp:" + n3 + ", file_name:" + string);
                if (GifFramesProducer.this.mCallback != null) {
                    GifFramesProducer.this.mCallback.onImage(n3, string);
                }
            }
        });
        this.mMediaPlayer.setOnErrorListener(new MgtvPlayerListener.OnErrorListener(){

            @Override
            public boolean onError(int n2, int n3) {
                if (GifFramesProducer.this.mCallback != null) {
                    GifFramesProducer.this.preOnError(n2, n3);
                    GifFramesProducer.this.mCallback.onError(n2, n3);
                }
                return false;
            }
        });
        this.mMediaPlayer.setOnCompletionListener(new MgtvPlayerListener.OnCompletionListener(){

            @Override
            public void onCompletion(int n2, int n3) {
            }
        });
    }

    private void preOnError(int n2, int n3) {
        if (this.mReporter != null) {
            this.mReporter.a(n2, n3, "");
        }
    }

    public void process() {
        if (this.mConfig == null) {
            return;
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.reset();
        }
        try {
            if (this.mMediaPlayer == null) {
                Bundle bundle = new Bundle();
                bundle.putString("BUNDLE_KEY_LOG_TAG_KEY", this.getLogTagKey());
                bundle.putBoolean("BUNDLE_KEY_BOOLEAN_ENABLE_REPORT", false);
                this.mMediaPlayer = new MgtvMediaPlayer(1, this.mContext, bundle);
                this.mMediaPlayer.setConfig(2020021001, 1);
                this.initListener();
            }
            if (this.mConfig != null && this.mConfig.fileStartTimeFloatS >= 0.0f) {
                this.mMediaPlayer.setPlayerFileStartTimeFloatS(this.mConfig.fileStartTimeFloatS);
            }
            this.mMediaPlayer.setReportParams(new ReportParams().setVideoType(ReportParams.VideoType.GIF_PREVIEW_IMAGE));
            this.mMediaPlayer.setPlayerSeekAtStartPosMs(this.mConfig.startMs);
            this.mMediaPlayer.setFrameImageAtTime(this.mConfig.imageDir, this.mConfig.startMs, this.mConfig.endMs, this.mConfig.num, this.mConfig.imgW, this.mConfig.imgH);
            this.mCurrentUri = Uri.parse((String)this.mConfig.url.trim());
            this.mMediaPlayer.setDataSource(this.mCurrentUri.toString());
            this.mMediaPlayer.prepareAsync();
            if (this.mReporter != null) {
                this.mReporter.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cancel() {
        if (this.mReporter != null) {
            this.mReporter.c();
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
        }
    }

    public void release() {
        if (this.mReporter != null) {
            this.mReporter.c();
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public long getPropertyLong(int n2, long l2) {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.getPropertyLong(n2, l2);
        }
        return l2;
    }

    public static interface Callback {
        public void onStart();

        public void onImage(int var1, String var2);

        public void onSuccess();

        public void onError(int var1, int var2);
    }

    public static class Config {
        public String url;
        public int startMs;
        public int endMs;
        public int num;
        public int imgW = -1;
        public int imgH = -1;
        public float fileStartTimeFloatS = -1.0f;
        public String imageDir;

        public Config(String string, int n2, int n3, int n4, String string2) {
            this.url = string;
            this.startMs = n2;
            this.endMs = n3;
            this.num = n4;
            this.imageDir = string2;
        }

        public Config(String string, int n2, int n3, int n4, int n5, int n6, String string2) {
            this.url = string;
            this.startMs = n2;
            this.endMs = n3;
            this.num = n4;
            this.imgW = n5;
            this.imgH = n6;
            this.imageDir = string2;
        }

        public float getFileStartTimeFloatS() {
            return this.fileStartTimeFloatS;
        }

        public Config setFileStartTimeFloatS(float f2) {
            this.fileStartTimeFloatS = f2;
            return this;
        }

        public String toString() {
            return "Config{url='" + this.url + '\'' + ", startMs=" + this.startMs + ", endMs=" + this.endMs + ", num=" + this.num + ", imgW=" + this.imgW + ", imgH=" + this.imgH + ", imageDir='" + this.imageDir + '\'' + '}';
        }
    }
}

