/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.gif;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.hunantv.media.player.e.a;
import com.hunantv.media.player.libnative.FFmpegApi;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.FileUtil;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.report.ReportParams;
import java.io.File;
import java.lang.ref.WeakReference;

public class GifProcessor {
    private static String TAG = GifProcessor.class.getSimpleName();
    private static GifProcessor sInstance;
    private static Application sApplication;
    public static final int ERROR_GIF = 7001999;
    private HandlerThread mGifProcessThread;
    private GifProcessHandler mGifProcessHandler;
    private Object mSafeLocker = new Object();
    private WeakReference<Callback> mWeakCallback;
    private com.hunantv.media.report.a mReporter;

    public static synchronized GifProcessor getInstance() {
        if (sInstance == null) {
            sInstance = new GifProcessor();
        }
        return sInstance;
    }

    private GifProcessor() {
        this.init();
    }

    private void init() {
        if (this.mGifProcessThread == null) {
            this.mGifProcessThread = new HandlerThread("MgtvGifProcessThread");
            this.mGifProcessThread.start();
        }
        if (this.mGifProcessHandler == null) {
            this.mGifProcessHandler = new GifProcessHandler(this, this.mGifProcessThread.getLooper());
        }
    }

    public boolean isSupported() {
        return a.b();
    }

    public void bindApplication(Application application) {
        sApplication = application;
        this.mReporter = new com.hunantv.media.report.a((Context)sApplication, null);
        this.mReporter.a(new ReportParams().setVideoType(ReportParams.VideoType.GIF_CREATOR));
    }

    public void setWeakCallback(Callback callback) {
        this.mWeakCallback = new WeakReference<Callback>(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAsync(Task task) {
        this.cancel();
        Object object = this.mSafeLocker;
        synchronized (object) {
            DebugLog.i(TAG, "processAsync in. " + task);
            if (this.mGifProcessHandler == null || this.mGifProcessThread == null) {
                this.callbackFailure(-100, task);
                return;
            }
            if (!this.validTask(task)) {
                this.callbackFailure(-101, task);
                return;
            }
            this.mGifProcessHandler.removeMessages(100);
            Message message = new Message();
            message.what = 100;
            message.obj = task;
            this.mGifProcessHandler.sendMessage(message);
            DebugLog.i(TAG, "processAsync out.");
        }
    }

    private boolean validTask(Task task) {
        return task != null && !StringUtil.isEmpty(task.url) && task.startS >= 0 && task.durationS > 0 && task.fps > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.mSafeLocker;
        synchronized (object) {
            DebugLog.i(TAG, "cancel in");
            try {
                FFmpegApi.fftool_process_interrupt();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            DebugLog.i(TAG, "cancel out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.mSafeLocker;
        synchronized (object) {
            DebugLog.i(TAG, "release in");
            try {
                FFmpegApi.fftool_process_interrupt();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (this.mGifProcessHandler != null) {
                this.mGifProcessHandler.removeMessages(100);
                this.mGifProcessHandler = null;
            }
            if (this.mGifProcessThread != null) {
                this.mGifProcessThread.quit();
                this.mGifProcessThread = null;
            }
            DebugLog.i(TAG, "release out");
        }
    }

    private void callbackSuccess(String string, Task task) {
        DebugLog.i(TAG, "callbackSuccess targetFile=" + string + ", " + task);
        Callback callback = (Callback)this.mWeakCallback.get();
        if (callback != null) {
            callback.onSuccess(string, task);
        }
    }

    private synchronized void callbackFailure(int n2, Task task) {
        Callback callback;
        DebugLog.i(TAG, "callbackFailure ret:" + n2 + ", " + task);
        if (task != null && !StringUtil.isEmpty(task.targetFile)) {
            try {
                FileUtil.deleteFile(new File(task.targetFile));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((callback = (Callback)this.mWeakCallback.get()) != null) {
            callback.onFailure(n2, task);
        }
    }

    public static interface Callback {
        public void onSuccess(String var1, Task var2);

        public void onFailure(int var1, Task var2);
    }

    private static class GifProcessHandler
    extends Handler {
        public static final int MSG_GIF_PROCESS = 100;
        private WeakReference<GifProcessor> mWeakProcessor;

        public GifProcessHandler(GifProcessor gifProcessor, Looper looper) {
            super(looper);
            this.mWeakProcessor = new WeakReference<GifProcessor>(gifProcessor);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 100: {
                    this.processGif(message);
                }
            }
        }

        private void processGif(Message message) {
            this.reportPV();
            if (message == null) {
                this.callbackFail(-200, null);
                return;
            }
            Task task = (Task)message.obj;
            DebugLog.i(TAG, "processGif in. " + task);
            if (task == null) {
                this.callbackFail(-201, null);
                return;
            }
            String string = "gif_" + System.currentTimeMillis() + ".gif";
            task.targetFile = task.targetDir + "/" + string;
            int n2 = a.a((Context)sApplication, task.url, task.startS, task.durationS, task.w, task.h, task.fps, task.targetFile);
            DebugLog.i(TAG, "processGif out. ret=" + n2);
            if (n2 == 0) {
                this.callbackSuc(task);
            } else {
                this.callbackFail(n2, task);
            }
        }

        private void callbackFail(int n2, Task task) {
            this.reportErr(7001999, n2);
            GifProcessor gifProcessor = (GifProcessor)this.mWeakProcessor.get();
            if (gifProcessor != null) {
                gifProcessor.callbackFailure(n2, task);
            }
        }

        private void callbackSuc(Task task) {
            this.reportVV();
            GifProcessor gifProcessor = (GifProcessor)this.mWeakProcessor.get();
            if (gifProcessor != null) {
                gifProcessor.callbackSuccess(task.targetFile, task);
            }
        }

        private void reportPV() {
            GifProcessor gifProcessor = (GifProcessor)this.mWeakProcessor.get();
            if (gifProcessor != null && gifProcessor.mReporter != null) {
                gifProcessor.mReporter.a();
            }
        }

        private void reportVV() {
            GifProcessor gifProcessor = (GifProcessor)this.mWeakProcessor.get();
            if (gifProcessor != null && gifProcessor.mReporter != null) {
                gifProcessor.mReporter.b();
            }
        }

        private void reportErr(int n2, int n3) {
            GifProcessor gifProcessor = (GifProcessor)this.mWeakProcessor.get();
            if (gifProcessor != null && gifProcessor.mReporter != null) {
                gifProcessor.mReporter.a(n2, n3, "");
            }
        }
    }

    public static class Task {
        public String url;
        public int startS;
        public int durationS;
        public int w;
        public int h;
        public int fps = 10;
        public String targetDir;
        private String targetFile;

        public Task(String string, int n2, int n3, int n4, int n5, int n6, String string2) {
            this.url = string;
            this.startS = n2;
            this.durationS = n3;
            this.w = n4;
            this.h = n5;
            this.fps = n6;
            this.targetDir = string2;
        }

        public void autoSize(int n2, int n3) {
            Size size = Task.getAutoSize(n2, n3);
            if (size != null) {
                this.w = size.width;
                this.h = size.height;
            }
        }

        public static Size getAutoSize(int n2, int n3) {
            boolean bl;
            if (n2 <= 0 || n3 <= 0) {
                return new Size(0, 0);
            }
            int n4 = n2;
            int n5 = n3;
            DebugLog.i(TAG, "getAutoSize in." + n4 + "-" + n5);
            boolean bl2 = bl = n2 < n3;
            if (bl) {
                if (n3 >= 480) {
                    n5 = 480;
                    n4 = n2 * 480 / n3;
                }
            } else if (n2 >= 480) {
                n4 = 480;
                n5 = n3 * 480 / n2;
            }
            DebugLog.i(TAG, "getAutoSize out." + n4 + "-" + n5);
            return new Size(n4, n5);
        }

        public String toString() {
            return "Task{url='" + this.url + '\'' + ", startS=" + this.startS + ", durationS=" + this.durationS + ", w=" + this.w + ", h=" + this.h + ", fps=" + this.fps + ", targetDir='" + this.targetDir + '\'' + ", targetFile='" + this.targetFile + '\'' + '}';
        }

        public String getTargetFile() {
            return this.targetFile;
        }

        public static class Size {
            public int width;
            public int height;

            public Size(int n2, int n3) {
                this.width = n2;
                this.height = n3;
            }

            public String toString() {
                return "Size{width=" + this.width + ", height=" + this.height + '}';
            }
        }
    }
}

