/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.global;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.player.helper.MediaCodecHelp;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.Size;
import java.util.ArrayList;

public class MgtvPlayerCapabilities {
    private static AlphaCapabilities sAlphaCapabilities;
    public static ExDef sExDef;

    public static synchronized AlphaCapabilities getAlphaCapabilities(Context context) {
        if (sAlphaCapabilities == null) {
            sAlphaCapabilities = new AlphaCapabilities(MgtvPlayerCapabilities.getExDef(context));
        }
        return sAlphaCapabilities;
    }

    public static synchronized ExDef getExDef(Context context) {
        String string = MgtvPlayerCapabilities.sExDef.support = NetPlayConfig.isExDefEnable() ? "1" : "0";
        if (MgtvPlayerCapabilities.sExDef.sceen_size == null || MgtvPlayerCapabilities.sExDef.sceen_fps == null || MgtvPlayerCapabilities.sExDef.screen_hdr_type == null) {
            MgtvPlayerCapabilities.fillScreenInfo(context);
        }
        if (MgtvPlayerCapabilities.sExDef.h264 == null) {
            MgtvPlayerCapabilities.sExDef.h264 = MgtvPlayerCapabilities.getH264Info();
        }
        if (MgtvPlayerCapabilities.sExDef.h265 == null) {
            MgtvPlayerCapabilities.sExDef.h265 = MgtvPlayerCapabilities.getH265Info();
        }
        DebugLog.i("MgtvCore", "sExDef: " + sExDef.toString());
        return sExDef;
    }

    public static synchronized void fillScreenInfo(Context context) {
        if (context == null) {
            return;
        }
        MgtvPlayerCapabilities.sExDef.sceen_size = "0x0";
        MgtvPlayerCapabilities.sExDef.sceen_fps = "0";
        MgtvPlayerCapabilities.sExDef.screen_hdr_type = "0";
        MgtvPlayerCapabilities.sExDef.support_wanos = NetPlayConfig.isWanosAudioInnerEnable() ? "1" : "0";
        try {
            int[] nArray;
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics displayMetrics = new DisplayMetrics();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealMetrics(displayMetrics);
            } else {
                display.getMetrics(displayMetrics);
            }
            int n2 = displayMetrics.widthPixels;
            int n3 = displayMetrics.heightPixels;
            int n4 = (int)display.getRefreshRate();
            MgtvPlayerCapabilities.sExDef.sceen_size = n2 + "x" + n3;
            MgtvPlayerCapabilities.sExDef.sceen_fps = n4 + "";
            if (Build.VERSION.SDK_INT >= 24 && (nArray = display.getHdrCapabilities().getSupportedHdrTypes()) != null) {
                for (int n5 : nArray) {
                    switch (n5) {
                        case 2: 
                        case 4: {
                            MgtvPlayerCapabilities.sExDef.screen_hdr_type = "1";
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized ExDef.H264 getH264Info() {
        ExDef.H264 h264 = new ExDef.H264();
        ArrayList<MediaCodecHelp.CodecPerformance> arrayList = MediaCodecHelp.sCodecPerformanceList.isEmpty() ? MediaCodecHelp.getCodecPerformanceList(false) : MediaCodecHelp.sCodecPerformanceList;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string = arrayList.get((int)i2).mimeType;
            if (!string.equals(MediaCodecHelp.AMIME_VIDEO_AVC)) continue;
            h264.support = "1";
            h264.sdr.max_def = arrayList.get((int)i2).max_def;
            h264.sdr.max_def_fps = arrayList.get((int)i2).max_def_fps;
            String string2 = h264.hdr.support = arrayList.get((int)i2).hdr_support && NetPlayConfig.isHdrOpen() ? "1" : "0";
            if (!"1".equals(h264.hdr.support)) continue;
            h264.hdr.max_def = arrayList.get((int)i2).max_def;
            h264.hdr.max_def_fps = arrayList.get((int)i2).max_def_fps;
        }
        return h264;
    }

    public static synchronized ExDef.H265 getH265Info() {
        ExDef.H265 h265 = new ExDef.H265();
        ArrayList<MediaCodecHelp.CodecPerformance> arrayList = MediaCodecHelp.sCodecPerformanceList.isEmpty() ? MediaCodecHelp.getCodecPerformanceList(false) : MediaCodecHelp.sCodecPerformanceList;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string = arrayList.get((int)i2).mimeType;
            if (!string.equals(MediaCodecHelp.AMIME_VIDEO_HEVC)) continue;
            h265.support = "1";
            h265.sdr.max_def = arrayList.get((int)i2).max_def;
            h265.sdr.max_def_fps = arrayList.get((int)i2).max_def_fps;
            String string2 = h265.hdr.support = arrayList.get((int)i2).hdr_support && NetPlayConfig.isHdrOpen() ? "1" : "0";
            if (!"1".equals(h265.hdr.support)) continue;
            h265.hdr.max_def = arrayList.get((int)i2).max_def;
            h265.hdr.max_def_fps = arrayList.get((int)i2).max_def_fps;
        }
        return h265;
    }

    static {
        sExDef = new ExDef();
    }

    public static class ExDef {
        public String support = "1";
        public String sceen_size;
        public String sceen_fps;
        public String screen_hdr_type;
        public String support_wanos;
        public H264 h264;
        public H265 h265;

        public String toString() {
            return "ExDef{support='" + this.support + '\'' + ", sceen_size='" + this.sceen_size + '\'' + ", sceen_fps='" + this.sceen_fps + '\'' + ", screen_hdr_type='" + this.screen_hdr_type + '\'' + ", support_wanos='" + this.support_wanos + '\'' + ", h264=" + this.h264 + ", h265=" + this.h265 + '}';
        }

        static class Hdr {
            public String support = "0";
            public String bit_depth = "10";
            public String max_def = "0x0";
            public String max_def_fps = "0";

            Hdr() {
            }

            public String toString() {
                return "Hdr{support='" + this.support + '\'' + ", bit_depth='" + this.bit_depth + '\'' + ", max_def='" + this.max_def + '\'' + ", max_def_fps='" + this.max_def_fps + '\'' + '}';
            }
        }

        static class Sdr {
            public String max_def = "0x0";
            public String max_def_fps = "0";

            Sdr() {
            }

            public String toString() {
                return "Sdr{max_def='" + this.max_def + '\'' + ", max_def_fps='" + this.max_def_fps + '\'' + '}';
            }
        }

        static class H265 {
            public String support = "0";
            Sdr sdr = new Sdr();
            Hdr hdr = new Hdr();

            H265() {
            }

            public String toString() {
                return "H265{support='" + this.support + '\'' + ", sdr=" + this.sdr + ", hdr=" + this.hdr + '}';
            }
        }

        static class H264 {
            public String support = "0";
            Sdr sdr = new Sdr();
            Hdr hdr = new Hdr();

            H264() {
            }

            public String toString() {
                return "H264{support='" + this.support + '\'' + ", sdr=" + this.sdr + ", hdr=" + this.hdr + '}';
            }
        }
    }

    public static class AlphaCapabilities {
        private Size h264MaxSize;
        private Size h265MaxSize;

        public AlphaCapabilities(ExDef exDef) {
            try {
                if (exDef != null) {
                    this.h264MaxSize = Size.parseSize(exDef.h264.sdr.max_def);
                    this.h265MaxSize = Size.parseSize(exDef.h265.sdr.max_def);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public Size getH264MaxSize() {
            return this.h264MaxSize;
        }

        public Size getH265MaxSize() {
            return this.h265MaxSize;
        }
    }
}

