/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.config.NetPlayConfigHelper;
import com.hunantv.media.drm.IDrmSession;
import com.hunantv.media.global.Constants;
import com.hunantv.media.global.PlayerReferenceObserver;
import com.hunantv.media.p2p.IP2pTask;
import com.hunantv.media.p2p.P2pMgr;
import com.hunantv.media.player.IMgtvRenderView;
import com.hunantv.media.player.MgtvMediaSource;
import com.hunantv.media.player.MgtvPlayerDataSource;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.a.a;
import com.hunantv.media.player.a.d;
import com.hunantv.media.player.a.e;
import com.hunantv.media.player.a.f;
import com.hunantv.media.player.b.a;
import com.hunantv.media.player.d;
import com.hunantv.media.player.flow.FlowReportProcessor;
import com.hunantv.media.player.flow.entity.FlowReportEntity;
import com.hunantv.media.player.h;
import com.hunantv.media.player.helper.BuildHelper;
import com.hunantv.media.player.helper.MediaCodecHelp;
import com.hunantv.media.player.j;
import com.hunantv.media.player.libnative.FFmpegApi;
import com.hunantv.media.player.loader.ImgoLibLoader;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.pragma.PlayerConfig;
import com.hunantv.media.player.smooth.SmoothMediaSource;
import com.hunantv.media.player.statistic.FlowDataStatistic;
import com.hunantv.media.player.subtitle.SubtitleSource;
import com.hunantv.media.player.subtitle.b;
import com.hunantv.media.player.subtitle.c;
import com.hunantv.media.player.subtitle.d;
import com.hunantv.media.player.utils.CodeUtil;
import com.hunantv.media.player.utils.ExTicker;
import com.hunantv.media.player.utils.FileUtil;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.player.utils.SyncStateMachine;
import com.hunantv.media.player.utils.UrlUtil;
import com.hunantv.media.recoder.GifRecorder;
import com.hunantv.media.report.ReportParams;
import com.hunantv.media.utils.AudioUtil;
import com.hunantv.media.utils.KeyFrameInfoUtils;
import com.hunantv.media.utils.MgtvPlayerBroadcastObserver;
import com.hunantv.media.utils.NumericUtil;
import com.hunantv.media.widget.ISubtitle;
import com.mgtv.easydatasource.FlowReporter;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.InvalidParameterException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class MgtvMediaPlayer
implements SubtitleSource.SubtitleSourceHolder {
    private static final String TAG = MgtvMediaPlayer.class.getSimpleName();
    public static final int PLAYER_TYPE_SYSTEM = 0;
    public static final int PLAYER_TYPE_FFPLAYER = 1;
    public static final int PLAYER_TYPE_CODECPLAYER = 2;
    public static final int ENABLE_PLAYER_MODE_NORMAL = 0;
    public static final int ENABLE_PLAYER_MODE_LIVE = 1;
    public static final int ENABLE_PLAYER_MODE_LOOP = 2;
    public static final int ENABLE_PLAYER_MODE_SMOOTH = 3;
    public static final int READ_DATASOURCE_TYPE_NORMAL = 0;
    public static final int READ_DATASOURCE_TYPE_PROXY = 1;
    public static final int READ_DATASOURCE_TYPE_P2P_DIRECT = 2;
    public static final int READ_DATASOURCE_TYPE_DATA_SOURCE = 3;
    public static final int MEDIA_INFO_UNKNOWN = 1;
    public static final int MEDIA_INFO_STARTED_AS_NEXT = 2;
    public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3;
    public static final int MEDIA_INFO_VV_BUFFER_PREPARED = 9;
    public static final int MEDIA_INFO_AUDIO_RENDERING_START = 4;
    public static final int MEDIA_INFO_DECODER_TYPE_CHANGED = 5;
    public static final int MEDIA_INFO_SEI_SYS_TIMESTAMP = 2860;
    public static final int MEDIA_INFO_VIDEO_STREAM_CODEC_INFO = 2870;
    public static final int MEDIA_INFO_FILE_START_TIME = 2891;
    public static final int MEDIA_INFO_LOOPSEEK_POS_ZERO = 2892;
    public static final int MEDIA_INFO_NONET_BUFFER_NOENOUGH = 2893;
    public static final int MEDIA_INFO_MEDIACODEC_COLOR_FORMAT = 2900;
    public static final int MEDIA_INFO_FILE_ENCODE_INFO = 2901;
    public static final int MEDIA_INFO_WANOS_EFFECT_INFO = 2902;
    public static final int MEDIA_INFO_DECODER_HW_TO_SW = 501;
    public static final int MEDIA_INFO_DECODER_SW_TO_HW = 502;
    public static final int MEDIA_INFO_DECODER_HW_RESET_TO_SW = 503;
    public static final int MEDIA_INFO_DECODER_HW_TO_SW_DATA = 504;
    public static final int MEDIA_INFO_DECODER_HW_TO_SW_INNER = 505;
    public static final int MEDIA_INFO_DECODER_HW_TO_SW_HEVC = 506;
    public static final int MEDIA_INFO_VIDEO_DECODER_OPEN = 6;
    public static final int MEDIA_INFO_VIDEO_DECODER_EXTRA_SW = 0;
    public static final int MEDIA_INFO_VIDEO_DECODER_EXTRA_HW = 1;
    public static final int MEDIA_INFO_DL_SPEED_UPDATE = 7;
    public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700;
    public static final int MEDIA_INFO_BUFFERING_START = 701;
    public static final int MEDIA_INFO_BUFFERING_END = 702;
    public static final int MEDIA_INFO_NETWORK_BANDWIDTH = 703;
    public static final int MEDIA_INFO_BAD_INTERLEAVING = 800;
    public static final int MEDIA_INFO_NOT_SEEKABLE = 801;
    public static final int MEDIA_INFO_METADATA_UPDATE = 802;
    public static final int MEDIA_INFO_DATA_PROTOCOL = 2803;
    public static final int MEDIA_INFO_ACCURATE_SEEK_COMPLETE = 2804;
    public static final int MEDIA_INFO_ACODEC_RECONFIGURE = 2805;
    public static final int MEDIA_INFO_VIDEO_FPS = 2810;
    public static final int MEDIA_INFO_STREAM_TYPE = 2806;
    public static final int MEDIA_INFO_STREAM_FORMAT_TYPE_EXTRA_OTHER = 0;
    public static final int MEDIA_INFO_STREAM_FORMAT_TYPE_EXTRA_HLS = 1;
    public static final int MEDIA_INFO_STREAM_FORMAT_TYPE_EXTRA_TS = 2;
    public static final int MEDIA_INFO_STREAM_FORMAT_TYPE_EXTRA_MP4 = 3;
    public static final int MEDIA_INFO_STREAM_FORMAT_TYPE_EXTRA_FLV = 4;
    public static final int MEDIA_INFO_PREPARE_WILL_PLAYING = 2820;
    public static final int PREPARE_WILL_PLAYING_OPEN_INPUT = 82001;
    public static final int PREPARE_WILL_PLAYING_FIND_STREAM_INFO = 82002;
    public static final int PREPARE_WILL_PLAYING_COMPONENT_OPEN = 82003;
    public static final int PREPARE_WILL_PLAYING_VIDEO_DECODED_START = 82004;
    public static final int PREPARE_WILL_PLAYING_AUDIO_DECODED_START = 82005;
    public static final int MEDIA_INFO_PLAYBACK_STATE_CHANGED = 2830;
    public static final int MEDIA_INFO_VIDEO_STREAM_TYPE = 2840;
    public static final int MEDIA_INFO_VIDEO_STREAM_TYPE_EXTRA_H264 = 0;
    public static final int MEDIA_INFO_VIDEO_STREAM_TYPE_EXTRA_H265 = 1;
    public static final int MEDIA_INFO_VIDEO_STREAM_TYPE_EXTRA_MPEG2 = 2;
    public static final int MEDIA_INFO_VIDEO_STREAM_TYPE_EXTRA_MPEG4 = 3;
    public static final int MEDIA_INFO_VIDEO_STREAM_TYPE_EXTRA_OTHER = 10;
    public static final int MEDIA_INFO_AV_SYNC_ERROR = 2850;
    public static final int MEDIA_INFO_STREAM_INFO_HLS_SEG_SIZE_INFO = 810;
    public static final int MEDIA_INFO_SPEED_RENDER_DISABLE = 10010;
    public static final int MEDIA_INFO_SPEED_RENDER_WARNING = 10011;
    public static final int MEDIA_INFO_AUDIO_IS_EXIST = 10020;
    public static final int MEDIA_INFO_VSR_IS_OPEN = 10024;
    public static final int MEDIA_INFO_LOAD_DATA_STATUS = 10021;
    public static final int MEDIA_INFO_WANOS_AUDIO_EFFECT = 10022;
    public static final int MEDIA_INFO_WANOS_AUDIO_DLOPEN = 10023;
    public static final int MEDIA_INFO_PREPARED_WATER_MARK_MS = 10030;
    public static final int MEDIA_INFO_EXTERNAL_METADATA_UPDATE = 803;
    public static final int MEDIA_INFO_TIMED_TEXT_ERROR = 900;
    public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901;
    public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902;
    public static final int MEDIA_INFO_VIDEO_ROTATION_CHANGED = 10001;
    public static final int MEDIA_INFO_RESET_RENDER_VIEW = 200001;
    public static final int INFO_EXTRA_BUFFER_FIRST_LOAD = 0;
    public static final int INFO_EXTRA_BUFFER_NORMAL = 1;
    public static final int INFO_EXTRA_BUFFER_SEEK = 2;
    public static final int INFO_EXTRA_BUFFER_SPEED = 3;
    public static final int INFO_EXTRA_BUFFER_SWITCH = 4;
    public static final int INFO_EXTRA_BUFFER_ACCSEEK = 5;
    public static final int MEDIA_ERROR_UNKNOWN = 1;
    public static final int MEDIA_ERROR_SERVER_DIED = 100;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 200;
    public static final int MEDIA_ERROR_IO = -1004;
    public static final int MEDIA_ERROR_MALFORMED = -1007;
    public static final int MEDIA_ERROR_UNSUPPORTED = -1010;
    public static final int MEDIA_ERROR_TIMED_OUT = -110;
    public static final int MGTVMEDIA_ERROR_100001 = 100001;
    public static final int MGTVMEDIA_ERROR_100002 = 100002;
    public static final int MGTVMEDIA_ERROR_100003 = 100003;
    public static final int MGTVMEDIA_ERROR_100004 = 100004;
    public static final int MGTVMEDIA_ERROR_200001 = 200001;
    public static final int MGTVMEDIA_ERROR_200002 = 200002;
    public static final int MGTVMEDIA_ERROR_200003 = 200003;
    public static final int MGTVMEDIA_ERROR_VIDEO_DATA_AMCDECODER_FAILED = 100606;
    public static final int MGTVMEDIA_ERROR_VIDEO_DATA_FFDECODER_FAILED = 100607;
    public static final int MGTVMEDIA_ERROR_WHAT_200100 = 200100;
    public static final int MGTVMEDIA_ERROR_EXTRA_400100 = 400100;
    public static final int MGTVMEDIA_ERROR_EXTRA_400198 = 400198;
    public static final int MGTVMEDIA_ERROR_EXTRA_400199 = 400199;
    public static final int MGTVMEDIA_ERROR_300001 = 300001;
    public static final int MGTVMEDIA_ERROR_300002 = 300002;
    public static final int MGTVMEDIA_ERROR_300003 = 300003;
    public static final int MGTVMEDIA_ERROR_300004 = 300004;
    public static final int MGTVMEDIA_ERROR_400400 = 400400;
    public static final int MGTVMEDIA_ERROR_400401 = 400401;
    public static final int MGTVMEDIA_ERROR_400402 = 400402;
    public static final int MGTVMEDIA_ERROR_400403 = 400403;
    public static final int MGTVMEDIA_ERROR_400404 = 400404;
    public static final int MGTVMEDIA_ERROR_400407 = 400407;
    public static final int MGTVMEDIA_ERROR_400408 = 400408;
    public static final int MGTVMEDIA_ERROR_400410 = 400410;
    public static final int MGTVMEDIA_ERROR_400416 = 400416;
    public static final int MGTVMEDIA_ERROR_4004XX = 400499;
    public static final int MGTVMEDIA_ERROR_400500 = 400500;
    public static final int MGTVMEDIA_ERROR_400501 = 400501;
    public static final int MGTVMEDIA_ERROR_400502 = 400502;
    public static final int MGTVMEDIA_ERROR_400503 = 400503;
    public static final int MGTVMEDIA_ERROR_400504 = 400504;
    public static final int MGTVMEDIA_ERROR_4005XX = 400599;
    public static final int MGTVMEDIA_ERROR_400600 = 400600;
    public static final int MGTVMEDIA_ERROR_400601 = 400601;
    public static final int MGTVMEDIA_ERROR_400602 = 400602;
    public static final int MGTVMEDIA_ERROR_400802 = 400802;
    public static final int MGTVMEDIA_ERROR_500001 = 500001;
    public static final int MGTVMEDIA_ERROR_500002 = 500002;
    public static final int MGTVMEDIA_ERROR_500003 = 500003;
    public static final int MGTVMEDIA_ERROR_500004 = 500004;
    public static final int MGTVMEDIA_ERROR_500999 = 500999;
    public static final int MGTVMEDIA_ERROR_EXTRA_100900 = 100900;
    public static final int MGTVMEDIA_ERROR_EXTRA_100903 = 100903;
    public static final int MGTVMEDIA_ERROR_EXTRA_100906 = 100906;
    public static final int MGTVMEDIA_ERROR_EXTRA_100907 = 100907;
    public static final int MGTVMEDIA_ERROR_EXTRA_100701 = 100701;
    public static final int MGTVMEDIA_ERROR_EXTRA_400201 = 400201;
    public static final int MGTVMEDIA_ERROR_EXTRA_400202 = 400202;
    public static final int MGTVMEDIA_WARNING_BASE = 800000;
    public static final int MGTVMEDIA_WARNING_DS_LOAD_ERROR = 800003;
    public static final int MGTVMEDIA_WARNING_INVALID_THREAD = 800005;
    public static final int MGTVMEDIA_WARNING_BACKUP_LOAD_SUCCESS = 800006;
    public static final int MGTVMEDIA_WARNING_TS_CACHE_SKIP = 800007;
    public static final int MGTVMEDIA_WARNING_RENDER_DISABLE = 800008;
    public static final int MGTVMEDIA_WARNING_ERROR_COMPLETION = 800009;
    public static final int MGTVMEDIA_WARNING_LEAVE_TIME_INVALID = 800010;
    public static final int MGTVMEDIA_WARNING_LIVE_IN_VOD = 800020;
    public static final int MGTVMEDIA_WARNING_LIVE_IN_VOD_COMPLETE = 800021;
    public static final int MGTVMEDIA_WARNING_IP_IS_LAN = 800101;
    public static final int MGTVMEDIA_WARNING_DNS_ABORT = 800102;
    public static final int MGTVMEDIA_WARNING_DNS_SYNC_IN_ASYNC = 800105;
    public static final int MGTVMEDIA_WARNING_HTTPDNS_REPORT_PV = 800200;
    public static final int MGTVMEDIA_WARNING_HTTPDNS_REPORT_SUC = 800201;
    public static final int MGTVMEDIA_WARNING_HTTPDNS_REPORT_ERR = 800202;
    public static final int MGTVMEDIA_WARNING_EXTRA_300301 = 800301;
    public static final int MGTVMEDIA_WARNING_403_PRE_PLAY = 800403;
    public static final int MGTVMEDIA_WARNING_410_PRE_PLAY = 800410;
    public static final int MGTVMEDIA_WARNING_AV_SYNC_ERR = 800500;
    public static final int MGTVMEDIA_WARNING_AV_SYNC_SUM_ERR = 800501;
    public static final int MGTVMEDIA_WARNING_LOW_MEMORY = 800600;
    public static final int MGTVMEDIA_WARNING_HTTP_ERROR_PV = 800901;
    public static final int MGTVMEDIA_WARNING_HTTP_ERROR_ERR = 800902;
    public static final int MGTVMEDIA_WARNING_TS_ERROR = 800905;
    public static final int MGTVMEDIA_WARNING_JAVA_OPENGL = 801001;
    public static final int MGTVMEDIA_WARNING_TARGET_ERROR = 801010;
    public static final int MGTVMEDIA_WARNING_P2P_TS_SKIP = 801011;
    public static final int MGTVMEDIA_WARNING_INNER_RETRY_RENDER_START = 801012;
    public static final int MGTVMEDIA_WARNING_LOCAL_100201 = 801201;
    public static final int FFP_PROP_INT64_GETFRAMETIME_T1 = 20501;
    public static final int FFP_PROP_INT64_GETFRAMETIME_T2 = 20502;
    public static final int FFP_PROP_INT64_GETFRAMETIME_T3 = 20503;
    public static final int FFP_PROP_INT64_GETFRAMETIME_T4 = 20504;
    public static final int FFP_PROP_INT64_GETFRAMETIME_DF = 20505;
    public static final int FFP_PROP_INT64_GETFRAMETIME_TD = 20506;
    public static final int FFP_PROP_INT64_GETFRAMETIME_TS = 20507;
    public static final int FFP_PROP_INT64_GETFRAMETIME_TE = 20508;
    public static final int FFP_PROP_INT64_GETFRAMETIME_TF = 20509;
    public static final int FFP_PROP_INT64_GETFRAMETIME_DROP_NUM = 20510;
    public static final int FFP_PROP_INT64_GETFRAMETIME_GEN_NUM = 20511;
    public static final int FFP_PROP_INT64_GETFRAMETIME_FIN = 20512;
    public static final String REPORT_BROADCAST_ACTION = "mgtv.player.action.PLAYER_REPORT_EVENT";
    public static final String EXTRA_REPORT_PARAMS = "EXTRA_REPORT_PARAMS";
    public static final String MGTVPLAYER_VERSION = "MGTV_1.22.0";
    private static final int OFFSET_MS = 5000;
    private static final int INVALID_MS = -1;
    public static final int DATA_PROTOCOL_IMGOCUS = 0;
    public static final int DATA_PROTOCOL_IMGODS = 1;
    public static final int ID_METHOD_GETCURRENTPOSITION = 0;
    public static final int ID_METHOD_RESET = 1;
    public static final int ID_METHOD_RELEASE = 2;
    public static final int ID_METHOD_SETPLAYSPEED = 3;
    public static final int MGTVMEDIA_EXTRA_ERROR_300400 = 300400;
    public static final int MGTVMEDIA_EXTRA_ERROR_3004XX = 300499;
    public static final int MGTVMEDIA_EXTRA_ERROR_301400 = 301400;
    public static final int MGTVMEDIA_EXTRA_ERROR_3014XX = 301499;
    public static final int MGTVMEDIA_EXTRA_ERROR_300500 = 300500;
    public static final int MGTVMEDIA_EXTRA_ERROR_3005XX = 300599;
    public static final int MGTVMEDIA_EXTRA_ERROR_301500 = 301500;
    public static final int MGTVMEDIA_EXTRA_ERROR_3015XX = 301599;
    public static final int DNS_FAMILY_DEFAULT = 0;
    public static final int DNS_FAMILY_ONLY_IPV4 = 1;
    public static final int DNS_FAMILY_ONLY_IPV6 = 2;
    public static final int MGTV_PROP_INT64_DECODER_PLAY_NOTIFY = 90003;
    public static final int TYPE_NO_MEMORY_PLAY = 0;
    public static final int TYPE_NORMAL_MEMORY_PLAY = 1;
    public static final int TYPE_QUICK_MEMORY_PLAY = 2;
    private boolean mDebug = false;
    private int mConnectTimeOutMs;
    private int mReceiveDataTimeOutMs;
    private int mPreBufferTimeoutMs = 1800000;
    private int mBufferTimeoutMs = 180000;
    private boolean mImgoMediaPlayerAudioMode = false;
    private boolean mAccurateSeekEnable = true;
    private int mAccSeekKeyFrameInterval = 1000;
    private boolean mKeyframeSeekEnable = false;
    private boolean mInnerAutoRotateEnable = false;
    private int mWeakTimer;
    private int mWeakBufferSpeedKB = 1;
    private int mWeakBufferTimeoutMs = 120000;
    private boolean mTsNotSkip = false;
    private int mLoadMaxRetryTime = 2;
    private boolean mPrepared = false;
    private boolean mIsBuffering = false;
    private String mErrorUrl = "";
    private String mLastRequestUrl = "";
    private int mLastDlSize = 0;
    private boolean mIsLive = false;
    private int mPlayerMode = 0;
    private volatile boolean mLiveReopen = false;
    private volatile String mLoopPlayerSwitchUrl = "";
    private volatile String mHDJSwitchUrl = "";
    private boolean mIsInitMp4Error;
    private DataSourceType mDataSourceType = DataSourceType.TYPE_DATASOUCE_DEFAULT;
    private static final int NETWORK_RECONNECT_COUNT = 2;
    private static final int NETWORK_RECONNECT_COUNT_MAX_LIMIT = 6;
    private int mErrorExtraCodeStore = -1;
    private SkipLoopFilterType mSkipLoopFilterType = SkipLoopFilterType.TYPE_SKIPLOOPFILTER_ALL;
    private AddrinfoType mAddrinfoType = AddrinfoType.TYPE_ADDRINFO_DEFAULT;
    private boolean mBackJavaDns;
    private int mAddrinfoTimeoutMs = 0;
    private Context mContext;
    private h mMediaPlayer;
    private com.hunantv.media.report.a mReporter;
    private com.hunantv.media.report.a mReporterSL;
    private boolean mSourceSwitching;
    private boolean mSourceSwitchingComplete;
    private boolean mSwitchingPrepared;
    private Prepared4StartMode mPrepared4StartMode = Prepared4StartMode.MODE_PREPARED4START_DEFAULT;
    private MgtvPlayerListener.OnPreparedListener mOnPreparedListener;
    private MgtvPlayerListener.OnStartListener mOnStartListener;
    private MgtvPlayerListener.OnPauseListener mOnPauseListener;
    private MgtvPlayerListener.OnInfoListener mOnInfoListener;
    private MgtvPlayerListener.OnInfoStringListener mOnInfoStringListener;
    private MgtvPlayerListener.OnErrorListener mOnErrorListener;
    private MgtvPlayerListener.OnCompletionListener mOnCompletionListener;
    private MgtvPlayerListener.OnSeekCompleteListener mOnSeekCompleteListener;
    private MgtvPlayerListener.OnSwitchSourceListener mOnSwitchSourceListener;
    private MgtvPlayerListener.OnBufferingTimeoutListener mOnBufferingTimeoutListener;
    private MgtvPlayerListener.OnSourceNetHandledListener mOnSourceNetHandledListener;
    private MgtvPlayerListener.OnWarningListener mOnWarningListener;
    private MgtvPlayerListener.OnRecordVideoListener mOnRecordVideoListener;
    private MgtvPlayerListener.OnLoadDataListener mOnLoadDataListener;
    private MgtvPlayerListener.OnFrameListener mOnFrameListener;
    private MgtvPlayerListener.OnAVPlayListener mOnAVPlayListener;
    private MgtvPlayerListener.OnGetFrameImageListener mOnGetFrameImageListener;
    private MgtvPlayerListener.OnPlayerEventListener mOnPlayerEventListener;
    private MgtvPlayerListener.OnErrorListener mErrorListener = new MgtvPlayerListener.OnErrorListener(){

        private boolean needInnerRetry(int n2, int n3) {
            return !MgtvMediaPlayer.this.mIsInnerRetrying && MgtvMediaPlayer.this.mMediaPlayer.s() == 2 && n2 == 200003 && n3 == 100606;
        }

        @Override
        public boolean onError(int n2, int n3) {
            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onError what:" + n2 + ",extra:" + n3 + ",netType:" + NetPlayConfig.getNetworkType());
            if (MgtvMediaPlayer.this.mGifRecorder != null) {
                MgtvMediaPlayer.this.mGifRecorder.interrupt(101);
            }
            if (MgtvMediaPlayer.this.isDnsCacheEnable()) {
                MgtvMediaPlayer.this.checkAndCleanDnsCache(n2, n3);
            }
            if (this.needInnerRetry(n2, n3)) {
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onError needInnerRetry");
                MgtvMediaPlayer.this.mIsInnerRetrying = true;
                MgtvMediaPlayer.this.mRetryLastErrorCode = n3;
                MgtvMediaPlayer.this.setPlayerReset(true);
                if (MgtvMediaPlayer.this.mMediaPlayer.ag()) {
                    MgtvMediaPlayer.this.mMediaPlayer.a(MgtvMediaPlayer.this.mMediaPlayer.E(), n2, n3, MgtvMediaPlayer.this.mMediaPlayer.s());
                } else {
                    MgtvMediaPlayer.this.mMediaPlayer.a(MgtvMediaPlayer.this.mMediaPlayer.E(), n2, n3);
                }
                return true;
            }
            MgtvMediaPlayer.this.beforeThrowError(n2, n3);
            MgtvMediaPlayer.this.reportErrorWarning(n2, n3);
            if (n2 != 7000006) {
                MgtvMediaPlayer.this.reportError(n2, n3, "");
            }
            MgtvMediaPlayer.this.stopTickers();
            MgtvMediaPlayer.this.mPlayStatus = PlayStatus.ERROR;
            MgtvMediaPlayer.this.mErrorExtraCodeStore = n3;
            if (MgtvMediaPlayer.this.mOnErrorListener != null) {
                return MgtvMediaPlayer.this.mOnErrorListener.onError(n2, n3);
            }
            return true;
        }
    };
    private String mLastErrorTypeCode;
    private boolean mIsGetPositionCallback = false;
    private boolean mIsVideoRendered;
    private PlayStatus mPlayStatus = PlayStatus.IDLE;
    private RenderType mRenderType = RenderType.NATIVE_WINDOW;
    private ExTicker mPlayTicker = new ExTicker(1000).setTypeStr("play");
    private ExTicker mBufferTick = new ExTicker(1000).setTypeStr("buffer");
    private int mPlayerType = 2;
    private ReportParams mReportParams;
    private static final int INVALID_ID = -1;
    private long mMainThreadID = -1L;
    private boolean mCacheEable;
    private String mCacheM3u8Path;
    private volatile String[] mCacheTsPaths;
    private int mTsCacheSkipNum;
    private Map<String, String> mCacheReplaceMap = new LinkedHashMap<String, String>();
    private boolean mIsInnerRetrying = false;
    private int mRetryLastErrorCode = 0;
    private boolean mRenderDisableWarnSended = false;
    private boolean mForceHttpDns = false;
    private boolean mHttpDnsNeedRetry = false;
    private boolean mJavaDnsEnable = false;
    private a.b mJavaDnsType = a.b.b;
    private static final boolean DEFAULT_HTTP_DNS_ENABLE = false;
    private boolean mHttpDnsEnable = false;
    private boolean mPlayerReset = true;
    private boolean mLoopPlayerReset = true;
    private String mLastUri = null;
    private String mLastIP;
    private String mLastP2pCdnIP;
    private String mLastHostIP;
    private String mLastTcpIP;
    private String mLastHostErr = "00";
    private String mLastTcpErr = "00";
    private String[] mLastIps;
    private int mLastIpCount = 0;
    private int mLastIpIndex = -1;
    private int mLastDnsType = -1;
    private int mSourceRetryCount;
    private int mSourceRetryCode;
    public long mSmt;
    public long mDlt;
    private static final String DNS_NATIVE = "native";
    private static final String DNS_JAVA_NORMAL = "java_normal";
    private static final String DNS_JAVA_HTTPDNS = "java_httpdns";
    private String mCurrentDnsDsc = "native";
    private boolean mEnableP2PHttpDns = false;
    private boolean mForceP2pHttpDns = false;
    private d mDnsThreadManager = new d().a(new d.b(){

        @Override
        public void updateIPs(String string, List<String> list) {
            P2pMgr.YfAddBackupIps(string, list, MgtvMediaPlayer.this.mForceP2pHttpDns);
        }
    });
    private boolean mAVSyncErrReported = false;
    private boolean mAVSyncErrSumReported = false;
    private int mAVSyncErrSum = 0;
    private long mAVSyncStartTimestamp = 0L;
    private long mPrepareAsyncTimeStampMs = 0L;
    private static final int PRE_BUFFER_MAX_S = 5;
    private static final int PRE_BUFFER_DEFAULT = 1;
    private static final int PRE_BUFFER_LIMIT = 2;
    private static final int PRE_BUFFER_UNLIMIT = 3;
    private SyncStateMachine mPreBufferState = new SyncStateMachine(1);
    private int mPreBufferMaxS = 5;
    private int mIsAudioExist = -1;
    private int mIsVsrOpen = -1;
    private int mIsNativePausedLoadData = 0;
    private boolean mIsWanosAudioEffectValid = false;
    private int mLastPosition = 0;
    private boolean mPositionLoged = false;
    private DataSourceInfo mDataSourceInfo;
    private int mRealEncodeType = -1;
    private int mStreamFormatType = -1;
    private MainNotifyHandler mNotifyHandler = new MainNotifyHandler(this);
    private String mWillOpenUrl = "";
    private boolean mReportedTSLAN = false;
    private Object mDnsLock = new Object();
    private boolean mIsP2pTSSkipReport = false;
    private String mCodecName = "n";
    private MgtvPlayerBroadcastObserver mObserver;
    private int mVVbuft = -1;
    private static final String USER_MSG_FLAG_DEFAULT = "init";
    private static final String USER_MSG_FLAG_USE_CACHE = "usecache";
    private boolean mEnableJAVAIPCacheMap = false;
    private Map<String, IPList> mIPCacheMap = new HashMap<String, IPList>();
    private volatile int mVideoFrameClockNotifyMs = -1;
    private volatile int mVideoFrameClockNotifyType = -1;
    private volatile long mVideoFrameClockNotifyTimeStart = -1L;
    private volatile long mVideoFrameClockNotifyTimeEnd = -1L;
    private static final String DEFAULT_CACHE_REPORT_TAG = "default";
    private String mCacheReportTag = "default";
    private int mCacheReportLerr = 0;
    private boolean mEnableDnsNoNetStrategy = false;
    private Object mDnsNoNetWaiter = new Object();
    private boolean mLastIsNetworkAvailableNNS = true;
    private int mDnsNoNetMaxRetry = 20;
    int mLastTsSkipErrExtra = 0;
    String mLastTsSkipErrFileName;
    NetPlayConfig mNetPlayConfig;
    private int mpx;
    private int imp4dh;
    private String fstime = "n/n";
    private String mcColorFormat = "n_n";
    private FlowReportProcessor mMainFlowReportProcessor;
    private boolean isFlowReportEnable = false;
    private boolean isExAudioEnable;
    private boolean isUserAudioEnable;
    public String waev;
    public int wadls;
    public String hdrInfo;
    private MgtvPlayerListener.OnSourceNetHandledListener mSourceNetListner = new MgtvPlayerListener.OnSourceNetHandledListener(){
        private boolean mIsPauseLoad = false;
        public static final int REPORT_HTTP_DNS_PV = 0;
        public static final int REPORT_HTTP_DNS_INTERRUPT = -2;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onSourceNetCtrl(int n2, Bundle bundle) {
            com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "OnSourceNetHandledListener.onSourceNetCtrl 0x%5x", n2);
            switch (n2) {
                case 131078: {
                    return this.doWillHostAddr(bundle);
                }
                case 131075: {
                    return this.doWillHttpOpen(bundle);
                }
                case 131073: {
                    this.willTcpOpen(bundle);
                    break;
                }
                case 131074: {
                    this.didTcpOpen(bundle);
                    break;
                }
                case 131077: {
                    return this.didLiveOpen(bundle);
                }
                case 131081: {
                    return this.didLiveReopen(bundle);
                }
                case 131088: {
                    return this.didLoopOpen(bundle);
                }
                case 131089: {
                    return this.didLoopReopen(bundle);
                }
                case 131104: {
                    return this.doWillGetEnv(bundle);
                }
                case 131120: {
                    IP2pTask iP2pTask;
                    if (MgtvMediaPlayer.this.mPreBufferState.isEnable() && MgtvMediaPlayer.this.mPreBufferState.getState() == 2) {
                        this.mIsPauseLoad = true;
                        return true;
                    }
                    if (!(MgtvMediaPlayer.this.isSourceSwitching() || MgtvMediaPlayer.this.mMediaPlayer == null || MgtvMediaPlayer.this.mMediaPlayer.j() != 2 && MgtvMediaPlayer.this.mMediaPlayer.j() != 1 || (iP2pTask = MgtvMediaPlayer.this.mMediaPlayer.af()) == null || iP2pTask.getStatus() == 0)) {
                        if (!this.mIsPauseLoad) {
                            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "CTRL_WILL_CHECK_PAUSE_LOAD will return true. will pause load");
                        }
                        this.mIsPauseLoad = true;
                        return true;
                    }
                    if (this.mIsPauseLoad) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "CTRL_WILL_CHECK_PAUSE_LOAD will return false. will resume load");
                    }
                    this.mIsPauseLoad = false;
                    return false;
                }
                case 131090: {
                    return this.didHDJSwitch(bundle);
                }
                case 131184: {
                    Object object = MgtvMediaPlayer.this.mSwitchSmoothSourceLocker;
                    synchronized (object) {
                        if (bundle != null) {
                            Object object2;
                            int n3 = bundle.getInt("smooth_switch_need_retry");
                            if (n3 == 1) {
                                if (MgtvMediaPlayer.this.mReporter != null) {
                                    MgtvMediaPlayer.this.mReporter.c();
                                }
                                int n4 = (int)bundle.getLong("smooth_switch_retry_key");
                                SmoothMediaSource smoothMediaSource = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get(n4);
                                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "smooth need_retry == 1 find:" + n4);
                                if (smoothMediaSource != null) {
                                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "smooth need_retry == 1 , will retry use :" + smoothMediaSource.getUrl());
                                    bundle.putString("smooth_switch_url", smoothMediaSource.getUrl());
                                    if (smoothMediaSource.getReporter() != null) {
                                        smoothMediaSource.getReporter().a();
                                    }
                                } else {
                                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "smooth need_retry == 1, not found source");
                                }
                                bundle.putInt("smooth_switch_need_retry", 0);
                                return true;
                            }
                            int n5 = (int)bundle.getLong("smooth_switch_key");
                            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "smooth CTRL_WILL_SMOOTH_SWITCH switch_key:" + n5);
                            SmoothMediaSource smoothMediaSource = MgtvMediaPlayer.this.matchLastKeySource(n5);
                            if (smoothMediaSource != null) {
                                if (smoothMediaSource.isLastRetry() && MgtvMediaPlayer.this.mReportParams != null && (MgtvMediaPlayer.this.mReportParams.getProxyType() == ReportParams.ProxyType.ONLY_P2P || MgtvMediaPlayer.this.mReportParams.getProxyType() == ReportParams.ProxyType.P2P_DRM)) {
                                    object2 = new SmoothMediaSource(MgtvMediaPlayer.this.getPlayingOriginUrl());
                                    ((SmoothMediaSource)object2).setReportParams(MgtvMediaPlayer.this.mReportParams);
                                    ((SmoothMediaSource)object2).bind(MgtvMediaPlayer.this);
                                    ((SmoothMediaSource)object2).setThrowErrorIfSwitchFailed(true);
                                    MgtvMediaPlayer.this.mSmoothSourcesRecord.put(((MgtvMediaSource)object2).getKey(), object2);
                                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "smooth is last retry. will retry key:" + ((MgtvMediaSource)object2).getKey());
                                    bundle.putInt("smooth_switch_need_retry", 1);
                                    bundle.putLong("smooth_switch_retry_key", (long)((MgtvMediaSource)object2).getKey());
                                }
                                if (!smoothMediaSource.isLastRetry()) {
                                    object2 = bundle.getString("smooth_switch_url");
                                    bundle.putString("smooth_switch_url", (String)object2);
                                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "smooth CTRL_WILL_SMOOTH_SWITCH switch_url:" + (String)object2);
                                    if (!StringUtil.isEmpty((String)object2)) {
                                        String string = ",mgtvjsource:";
                                        String string2 = "";
                                        int n6 = ((String)object2).indexOf(string);
                                        if (n6 >= 0) {
                                            string2 = ((String)object2).substring(n6);
                                        }
                                        boolean bl = false;
                                        if (MgtvMediaPlayer.this.mOnSwitchSmoothSourceListener != null) {
                                            bl = MgtvMediaPlayer.this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceWillUpdate(smoothMediaSource);
                                        }
                                        if (smoothMediaSource.getReadType() != 2 && bl && !StringUtil.isEmpty(smoothMediaSource.useUpdateUrl())) {
                                            String string3 = smoothMediaSource.useUpdateUrl() + string2;
                                            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "smooth CTRL_WILL_SMOOTH_SWITCH will update url:" + string3);
                                            bundle.putString("smooth_switch_url", string3);
                                        }
                                    }
                                }
                            }
                            if ((object2 = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get(n5)) != null && ((SmoothMediaSource)object2).getReporter() != null) {
                                ((SmoothMediaSource)object2).getReporter().a();
                            }
                            return true;
                        }
                        break;
                    }
                }
            }
            return false;
        }

        private void willTcpOpen(Bundle bundle) {
            if (bundle == null) {
                return;
            }
            String string = bundle.getString("tcp_hostname");
            String string2 = bundle.getString("ip");
            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "callback willTcpOpen tcp_hostname:" + string + ",tcp_ip:" + string2);
            MgtvMediaPlayer.this.mLastHostIP = string2;
            this.updateIp(string2);
            if (string2 != null && string2.length() > 1 && e.d(string2)) {
                this.notifyIpIsLAN("1", MgtvMediaPlayer.this.getCurrentDnsDsc() + "_hostip_" + string2);
            }
        }

        private void didTcpOpen(Bundle bundle) {
            if (bundle == null) {
                return;
            }
            int n2 = bundle.getInt("port");
            int n3 = bundle.getInt("family");
            int n4 = bundle.getInt("error");
            String string = bundle.getString("ip");
            String string2 = bundle.getString("tcp_hostname");
            long l2 = bundle.getLong("switch_key");
            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "didTcpOpen switch_key:" + l2);
            if (MgtvMediaPlayer.this.mMediaPlayer != null && MgtvMediaPlayer.this.mMediaPlayer.F() != null) {
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "didTcpOpen origin:" + MgtvMediaPlayer.this.mMediaPlayer.F());
            }
            if (n4 != 0) {
                DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "chodison didTcpOpen port:" + n2 + ",family:" + n3 + ",error_code:" + n4 + ",ip:" + string + ",hostname:" + string2);
            } else {
                DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "chodison didTcpOpen port:" + n2 + ",family:" + n3 + ",ip:" + string + ",hostname:" + string2);
            }
            MgtvMediaPlayer.this.mLastTcpErr = n4 + "";
            MgtvMediaPlayer.this.mLastTcpIP = string;
            MgtvMediaPlayer.this.mLastIpIndex++;
            if (MgtvMediaPlayer.this.mEnableJAVAIPCacheMap) {
                try {
                    IPList iPList;
                    String string3 = string2;
                    if (MgtvMediaPlayer.this.mIPCacheMap.containsKey(string3) && (iPList = (IPList)MgtvMediaPlayer.this.mIPCacheMap.get(string3)) != null) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback ipcache didTcpOpen remove " + string + " from " + string3);
                        iPList.nUseList.remove(string);
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback ipcache didTcpOpen rest ip:" + IPList.formatIPList(iPList.nUseList));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        private void updateIp(String string) {
            if (MgtvMediaPlayer.this.mMediaPlayer != null && (MgtvMediaPlayer.this.mMediaPlayer.j() == 2 || MgtvMediaPlayer.this.mMediaPlayer.j() == 1) && MgtvMediaPlayer.this.mMediaPlayer.af() != null) {
                IP2pTask iP2pTask = MgtvMediaPlayer.this.mMediaPlayer.af();
                DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "didTcpOpen p2p QueryTaskInfo cdnIp:" + MgtvMediaPlayer.this.mLastIP);
            } else {
                if (MgtvMediaPlayer.this.mMediaPlayer != null && (MgtvMediaPlayer.this.mMediaPlayer.j() == 2 || MgtvMediaPlayer.this.mMediaPlayer.j() == 1) && MgtvMediaPlayer.this.mMediaPlayer.af() == null) {
                    MgtvMediaPlayer.this.mLastIP = "0.0.0.1";
                } else {
                    MgtvMediaPlayer.this.mLastIP = string;
                }
                DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "didTcpOpen tcp_ip:" + MgtvMediaPlayer.this.mLastIP);
            }
        }

        private boolean onLiveWillOpen(Bundle bundle) {
            int n2 = bundle.getInt("live_error_type");
            int n3 = bundle.getInt("live_error_code");
            MgtvMediaPlayer.this.mLastRequestUrl = UrlUtil.getValidUrl(bundle.getString("live_src_url"));
            if (n3 != 0) {
                MgtvMediaPlayer.this.mErrorUrl = UrlUtil.getValidUrl(bundle.getString("live_src_url"));
                int n4 = bundle.getInt("live_retry_counter");
                int n5 = bundle.getInt("live_io_type");
                com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "onLiveWillOpen url:%s,iotype:%d, RetryCount:%d,error_code:%d-%d", MgtvMediaPlayer.this.mErrorUrl, n5, n4, n2, n3);
                if (this.isENETUNREACHcode(n2, n3) || MgtvMediaPlayer.this.mPrepared && this.isDnsError(n2, n3)) {
                    com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "onLiveWillOpen network broken,RetryCount:%d,error_code:%d-%d", n4, n2, n3);
                    return true;
                }
                DebugLog.ifmt(MgtvMediaPlayer.this.getLogTag(), "OnSourceNetHandledListener.CTRL_WILL_LIVE_OPEN %d-%d-%d-%d-%s", n4, n5, n2, n3, MgtvMediaPlayer.this.mErrorUrl);
                return !MgtvMediaPlayer.this.isSkipRetryCode(n2, n3) && n4 < 2;
            }
            return false;
        }

        private boolean didLiveOpen(Bundle bundle) {
            if (bundle == null) {
                return false;
            }
            return this.onLiveWillOpen(bundle);
        }

        private boolean didLiveReopen(Bundle bundle) {
            boolean bl = MgtvMediaPlayer.this.mLiveReopen;
            if (MgtvMediaPlayer.this.mLiveReopen) {
                MgtvMediaPlayer.this.mLiveReopen = false;
            }
            return bl;
        }

        private boolean onLoopWillOpen(Bundle bundle) {
            int n2 = bundle.getInt("loop_error_type");
            int n3 = bundle.getInt("loop_error_code");
            if (n3 != 0) {
                MgtvMediaPlayer.this.mErrorUrl = UrlUtil.getValidUrl(bundle.getString("loop_src_url"));
                int n4 = bundle.getInt("loop_retry_counter");
                int n5 = bundle.getInt("loop_io_type");
                com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "onLoopWillOpen url:%s,iotype:%d, RetryCount:%d,error_code:%d-%d", MgtvMediaPlayer.this.mErrorUrl, n5, n4, n2, n3);
                if (this.isENETUNREACHcode(n2, n3) || MgtvMediaPlayer.this.mPrepared && this.isDnsError(n2, n3)) {
                    com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "onLoopWillOpen network broken,RetryCount:%d,error_code:%d-%d", n4, n2, n3);
                    return true;
                }
                DebugLog.ifmt(MgtvMediaPlayer.this.getLogTag(), "OnSourceNetHandledListener.CTRL_WILL_LOOP_OPEN %d-%d-%d-%d-%s", n4, n5, n2, n3, MgtvMediaPlayer.this.mErrorUrl);
                return !MgtvMediaPlayer.this.isSkipRetryCode(n2, n3) && n4 < 2;
            }
            return false;
        }

        private boolean didLoopOpen(Bundle bundle) {
            if (bundle == null) {
                return false;
            }
            return this.onLiveWillOpen(bundle);
        }

        private boolean didLoopReopen(Bundle bundle) {
            if (MgtvMediaPlayer.this.mLoopPlayerSwitchUrl.length() > 0) {
                bundle.putString("loop_url", MgtvMediaPlayer.this.mLoopPlayerSwitchUrl);
                MgtvMediaPlayer.this.mLoopPlayerSwitchUrl = "";
                return true;
            }
            return false;
        }

        private boolean didHDJSwitch(Bundle bundle) {
            if (MgtvMediaPlayer.this.mHDJSwitchUrl.length() > 0 && bundle != null) {
                bundle.putString("loop_url", MgtvMediaPlayer.this.mHDJSwitchUrl);
                bundle.putInt("loop_is_last", 1);
                MgtvMediaPlayer.this.mHDJSwitchUrl = "";
                return true;
            }
            return false;
        }

        @Override
        public void onSourceNetEvent(int n2, Bundle bundle) {
            switch (n2) {
                case 78338: {
                    this.didHostAddr(bundle);
                    break;
                }
            }
        }

        private void didHostAddr(Bundle bundle) {
            if (bundle == null) {
                return;
            }
            int n2 = bundle.getInt("host_error");
            int n3 = bundle.getInt("host_family");
            String string = bundle.getString("host_hostname");
            String string2 = bundle.getString("host_ip");
            int n4 = bundle.getInt("host_port");
            int n5 = MgtvMediaPlayer.this.mLastDnsType = bundle.getInt("host_dns_type");
            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "callback didHostAddr error:" + n2 + ",family:" + n3 + ",hostname:" + string + ",ip_list:" + string2 + ",port:" + n4 + ",hostDnsType:" + n5);
            MgtvMediaPlayer.this.mLastHostErr = n2 + "";
            MgtvMediaPlayer.this.mLastIpIndex = 0;
            try {
                String[] stringArray = string2.split(";");
                MgtvMediaPlayer.this.mLastIpCount = 0;
                if (stringArray != null) {
                    for (String string3 : stringArray) {
                        if (!e.e(string3)) continue;
                        MgtvMediaPlayer.this.mLastIpCount++;
                    }
                }
                MgtvMediaPlayer.access$4202(MgtvMediaPlayer.this, stringArray);
                if (MgtvMediaPlayer.this.mEnableJAVAIPCacheMap && n2 == 0 && !MgtvMediaPlayer.this.mIPCacheMap.containsKey(string) && stringArray != null && stringArray.length > 0) {
                    IPList iPList = new IPList(string, stringArray);
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback ipcache didHostAddr put:" + string + "-" + IPList.formatIPList(iPList.nUseList));
                    MgtvMediaPlayer.this.mIPCacheMap.put(string, iPList);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private boolean resolveStrategy(@NonNull com.hunantv.media.player.a.a a2, @NonNull String string, Bundle bundle) {
            return this.resolveStrategy(a2, string, bundle, false, false);
        }

        private boolean resolveStrategy(@NonNull com.hunantv.media.player.a.a a2, @NonNull String string, Bundle bundle, boolean bl, boolean bl2) {
            if (bl) {
                a2.b(1);
                a2.a(string, a.b.b, bl2);
                return true;
            }
            if (bundle != null && bundle.getInt("addr_handle") == 1 && MgtvMediaPlayer.this.mBackJavaDns) {
                a2.b(1);
                a2.a(string, a.b.b, bl2);
                return true;
            }
            if (MgtvMediaPlayer.this.isDnsCacheEnable()) {
                if (MgtvMediaPlayer.this.mHttpDnsEnable) {
                    String string2 = null;
                    if (!StringUtil.isEmpty(MgtvMediaPlayer.this.mLastUri)) {
                        string2 = f.b(MgtvMediaPlayer.this.mLastUri);
                    }
                    if (string2 == null || string2.trim().equals("")) {
                        a2.a(string, MgtvMediaPlayer.this.mJavaDnsType, bl2);
                        return true;
                    }
                    DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "resolveStrategy cache valid");
                } else {
                    DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "resolveStrategy cache valid and httpdns not open");
                }
            } else {
                a2.a(string, MgtvMediaPlayer.this.mJavaDnsType, bl2);
                return true;
            }
            return false;
        }

        private void updateCurrentDnsDsc(a.b b2) {
            switch (b2) {
                case a: {
                    MgtvMediaPlayer.this.mCurrentDnsDsc = MgtvMediaPlayer.DNS_JAVA_NORMAL;
                    break;
                }
                case b: {
                    MgtvMediaPlayer.this.mCurrentDnsDsc = MgtvMediaPlayer.DNS_JAVA_HTTPDNS;
                }
            }
        }

        private void notifyHttpDnsReport(a.b b2, int n2, int n3) {
            this.notifyHttpDnsReport(b2, n2, n3, "");
        }

        private void notifyHttpDnsReport(a.b b2, int n2, int n3, String string) {
            if (b2 == a.b.b && MgtvMediaPlayer.this.mOnWarningListener != null) {
                this.notifyMessage(n2, n3, string);
            }
        }

        private void notifyIpIsLAN(String string, String string2) {
            if (MgtvMediaPlayer.this.mOnWarningListener != null && MgtvMediaPlayer.this.mReportParams != null && MgtvMediaPlayer.this.mReportParams.getVideoType() == ReportParams.VideoType.VOD) {
                if (!MgtvMediaPlayer.this.mReportedTSLAN) {
                    this.notifyMessage(1002, string, string2 + "_suffix_" + UrlUtil.getSuffix(MgtvMediaPlayer.this.mWillOpenUrl));
                }
                if (!UrlUtil.isM3u8(MgtvMediaPlayer.this.mWillOpenUrl)) {
                    MgtvMediaPlayer.this.mReportedTSLAN = true;
                }
            }
        }

        private void notifyMessage(int n2, int n3, String string) {
            Message message = new Message();
            message.what = n2;
            message.arg1 = n3;
            message.obj = string;
            MgtvMediaPlayer.this.mNotifyHandler.sendMessage(message);
        }

        private void notifyMessage(int n2, String string, String string2) {
            Message message = new Message();
            message.what = n2;
            Bundle bundle = new Bundle();
            bundle.putString("bundle_str_info1", string);
            bundle.putString("bundle_str_info2", string2);
            message.setData(bundle);
            MgtvMediaPlayer.this.mNotifyHandler.sendMessage(message);
        }

        private boolean isJavaDnsInterrupt() {
            return this.isPlayerReset();
        }

        private boolean isPlayerReset() {
            return MgtvMediaPlayer.this.mPlayerReset || MgtvMediaPlayer.this.mPlayerMode == 2 && MgtvMediaPlayer.this.mLoopPlayerReset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void domainResolve(String string, Bundle bundle, boolean bl) {
            if (string == null || bundle == null) {
                DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "skip domainResolve hostname or args is null");
                return;
            }
            com.hunantv.media.player.a.a a2 = new com.hunantv.media.player.a.a();
            a2.a(new a.a(){

                @Override
                public void onDnsStart(com.hunantv.media.player.a.a a2) {
                }

                @Override
                public void onDnsSuc(com.hunantv.media.player.a.a a2, String[] stringArray) {
                }

                @Override
                public void onDnsFail(com.hunantv.media.player.a.a a2) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onDnsFinish(com.hunantv.media.player.a.a a2) {
                    Object object = MgtvMediaPlayer.this.mDnsLock;
                    synchronized (object) {
                        MgtvMediaPlayer.this.mDnsLock.notifyAll();
                    }
                }
            });
            boolean bl2 = this.resolveStrategy(a2, string, bundle, bl, MgtvMediaPlayer.this.mHttpDnsNeedRetry);
            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "domainResolve use:" + bl2);
            if (bl2) {
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "domainResolve use type:" + (Object)((Object)a2.d()));
                this.notifyHttpDnsReport(a2.d(), 2000, 0);
            }
            String[] stringArray = MgtvMediaPlayer.this.mDnsLock;
            synchronized (stringArray) {
                while (a2.a() && !this.isJavaDnsInterrupt()) {
                    DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "domainResolve wait in");
                    try {
                        MgtvMediaPlayer.this.mDnsLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "domainResolve wait out. resolving:" + a2.a() + ",isJavaDnsInterrupt:" + this.isJavaDnsInterrupt());
            stringArray = e.a(a2.b());
            a2.c();
            String string2 = "costMs:" + a2.f() + ";ips:" + com.hunantv.media.utils.StringUtil.formatArrayString(stringArray) + ";net:" + NetPlayConfig.getNetworkType() + ";";
            String string3 = IPList.formatIPList(stringArray);
            String string4 = null;
            if (stringArray != null && stringArray.length > 0) {
                string4 = stringArray[0];
            }
            int n2 = 5;
            switch (a2.d()) {
                case a: {
                    n2 = 4;
                }
            }
            if (!this.isJavaDnsInterrupt() && e.e(string4)) {
                if (bl2) {
                    this.updateCurrentDnsDsc(a2.d());
                    if (e.d(string4)) {
                        this.notifyHttpDnsReport(a2.d(), 2001, 100, string2);
                    } else {
                        this.notifyHttpDnsReport(a2.d(), 2001, 0, string2);
                    }
                }
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "domainResolve put iplist:" + string3);
                bundle.putString("addr_hostname", string3);
                if (e.e(string4)) {
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "domainResolve put firstIP:" + string4);
                    bundle.putString("addr_ip", string4);
                }
                bundle.putInt("addr_dns_type", n2);
                bundle.putInt("addr_error", 0);
            } else {
                if (bl2) {
                    if (this.isJavaDnsInterrupt() && a2.e() == 0) {
                        this.notifyHttpDnsReport(a2.d(), 2002, -2, string2);
                    } else {
                        this.notifyHttpDnsReport(a2.d(), 2002, a2.e(), string2);
                    }
                    if (!this.isJavaDnsInterrupt()) {
                        int n3 = a2.a(199);
                        if (a2.e() != 0) {
                            n3 = a2.e();
                        } else if (string4 != null && !e.a(string4)) {
                            n3 = a2.a(107);
                        }
                        n3 = -n3;
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), (Object)((Object)a2.d()) + "resolve putInt error:" + n3);
                        bundle.putInt("addr_dns_type", n2);
                        bundle.putInt("addr_error", n3);
                    }
                }
                MgtvMediaPlayer.this.mCurrentDnsDsc = MgtvMediaPlayer.DNS_NATIVE;
            }
        }

        private boolean doWillHostAddr(Bundle bundle) {
            String string;
            Object object;
            if (bundle == null) {
                return false;
            }
            int n2 = bundle.getInt("addr_handle");
            String string2 = bundle.getString("player_hash");
            int n3 = bundle.getInt("retry_counter");
            String string3 = bundle.getString("user_msg");
            String string4 = bundle.getString("addr_hostname");
            long l2 = bundle.getLong("switch_key");
            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "callback doWillHostAddr is_handle:" + n2 + ",hash:" + string2 + ",count_int:" + n3 + ",user_msg:" + string3 + ",hostname:" + string4 + ",switch_key:" + l2);
            if (MgtvMediaPlayer.this.mEnableJAVAIPCacheMap && n2 != 1 && MgtvMediaPlayer.USER_MSG_FLAG_USE_CACHE.equals(string3) && !e.a(string4) && MgtvMediaPlayer.this.mIPCacheMap.containsKey(string4)) {
                try {
                    object = (IPList)MgtvMediaPlayer.this.mIPCacheMap.get(string4);
                    if (object != null && ((IPList)object).nUseList != null && ((IPList)object).nUseList.size() > 0 && ((IPList)object).checkTTL() && e.e(string = ((IPList)object).nUseList.get(0))) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback ipcache doWillHostAddr put chooseip:" + string);
                        String string5 = IPList.formatIPList(((IPList)object).nUseList);
                        if (!StringUtil.isEmpty(string5)) {
                            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "callback ipcache doWillHostAddr put srcIPListStr:" + string5);
                            bundle.putString("addr_hostname", string5);
                        }
                        bundle.putString("addr_ip", string);
                        bundle.putInt("addr_error", 0);
                        return false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            object = bundle.getString("addr_uri");
            if (e.d(string4)) {
                string = MgtvMediaPlayer.this.mReporter != null ? MgtvMediaPlayer.this.mReporter.g() : "0";
                this.notifyIpIsLAN(string, "hostname_" + string4);
            }
            boolean bl = e.a(string4);
            boolean bl2 = com.hunantv.media.report.c.d.c(MgtvMediaPlayer.this.mContext);
            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "doWillHostAddr hostname:" + string4 + ",isIp:" + bl);
            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "doWillHostAddr is_handle=" + n2 + ",mBackJavaDns=" + MgtvMediaPlayer.this.mBackJavaDns + ",isIp=" + bl + ",mForceHttpDns:" + MgtvMediaPlayer.this.mForceHttpDns);
            if (MgtvMediaPlayer.this.mForceHttpDns && !bl || MgtvMediaPlayer.this.mJavaDnsEnable && !bl || n2 == 1 && MgtvMediaPlayer.this.mBackJavaDns && !bl) {
                if (bl2) {
                    MgtvMediaPlayer.this.mLastUri = (String)object;
                    this.domainResolve(string4, bundle, MgtvMediaPlayer.this.mForceHttpDns);
                } else {
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "skip domainResolve cause net not available");
                }
                return MgtvMediaPlayer.this.mPlayerReset;
            }
            if (n2 == 1 && bl && bundle != null) {
                bundle.putString("addr_ip", string4);
                bundle.putInt("addr_dns_type", 0);
                bundle.putInt("addr_error", 0);
            }
            return false;
        }

        private boolean doWillGetEnv(Bundle bundle) {
            String string = bundle.getString("env_key");
            if (string != null && string.length() > 0) {
                String string2 = System.getenv(string);
                bundle.putString("env_value", string2);
                return true;
            }
            return false;
        }

        private boolean doWillHttpOpen(Bundle bundle) {
            if (bundle != null) {
                MgtvMediaPlayer.this.mLastRequestUrl = UrlUtil.getValidUrl(bundle.getString("url"));
            }
            if (MgtvMediaPlayer.this.mReportParams != null && (MgtvMediaPlayer.this.mReportParams.getVideoType().equals((Object)ReportParams.VideoType.AD_PRE) || MgtvMediaPlayer.this.mReportParams.getVideoType().equals((Object)ReportParams.VideoType.AD_MID))) {
                return this.onNormalHttpWillOpen(bundle);
            }
            if (bundle != null) {
                MgtvMediaPlayer.this.mWillOpenUrl = bundle.getString("url");
            }
            return this.doNewHttpWillOpen(bundle);
        }

        private boolean isDnsError(int n2, int n3) {
            return n3 == 300600 || n2 == 400605;
        }

        private boolean onNormalHttpWillOpen(Bundle bundle) {
            int n2 = bundle.getInt("error_type");
            int n3 = bundle.getInt("error_code");
            if (n3 != 0) {
                this.checkErrorCode(n2, n3, bundle);
                MgtvMediaPlayer.this.mErrorUrl = UrlUtil.getValidUrl(bundle.getString("url"));
                String string = bundle.getString("player_hash");
                String string2 = bundle.getString("user_msg");
                int n4 = bundle.getInt("retry_counter");
                int n5 = bundle.getInt("io_type");
                long l2 = bundle.getLong("switch_key");
                com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "onSourceNetCtrl url:%s,iotype:%d, RetryCount:%d,error_code:%d-%d", MgtvMediaPlayer.this.mErrorUrl, n5, n4, n2, n3);
                DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "onSourceNetCtrl switch_key:" + l2);
                if (this.isENETUNREACHcode(n2, n3) || MgtvMediaPlayer.this.mPrepared && this.isDnsError(n2, n3)) {
                    com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "onSourceNetCtrl network broken,RetryCount:%d,error_code:%d-%d", n4, n2, n3);
                    return true;
                }
                if (!MgtvMediaPlayer.this.mIsLive) {
                    if (MgtvMediaPlayer.this.mIsBuffering || !MgtvMediaPlayer.this.mPrepared) {
                        MgtvMediaPlayer.this.callbackTsSkip(MgtvMediaPlayer.this.mErrorUrl, n2, n3);
                        return false;
                    }
                } else {
                    if (MgtvMediaPlayer.this.mIsBuffering && MgtvMediaPlayer.this.isHLSPlayingUrl() && UrlUtil.isSegment(MgtvMediaPlayer.this.mErrorUrl) || !MgtvMediaPlayer.this.mPrepared) {
                        MgtvMediaPlayer.this.callbackTsSkip(MgtvMediaPlayer.this.mErrorUrl, n2, n3);
                        return false;
                    }
                    if (UrlUtil.isM3u8(MgtvMediaPlayer.this.mErrorUrl)) {
                        // empty if block
                    }
                }
                DebugLog.ifmt(MgtvMediaPlayer.this.getLogTag(), "OnSourceNetHandledListener.CTRL_WILL_HTTP_OPEN %d-%d-%d-%d-%s", n4, n5, n2, n3, MgtvMediaPlayer.this.mErrorUrl);
                if (MgtvMediaPlayer.this.isSkipRetryCode(n2, n3) || n4 >= 2) {
                    MgtvMediaPlayer.this.callbackTsSkip(MgtvMediaPlayer.this.mErrorUrl, n2, n3);
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean replaceUrlFromCache(Bundle bundle) {
            String[] stringArray;
            String string = bundle.getString("url");
            if (UrlUtil.isFilePrefix(string) || UrlUtil.isLocal(string)) {
                return false;
            }
            String[] stringArray2 = null;
            String string2 = UrlUtil.getFileName(string);
            if (StringUtil.isEmpty(string2)) {
                return false;
            }
            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "replaceUrlFromCache try to find replace cache:" + string);
            if (UrlUtil.isM3u8(string)) {
                stringArray = MgtvMediaPlayer.this.mCacheM3u8Path;
                String string3 = UrlUtil.getFileName((String)stringArray);
                if (!StringUtil.isEmpty((String)stringArray) && !StringUtil.isEmpty(string3) && string3.equals(string2)) {
                    stringArray2 = stringArray;
                }
            } else if (MgtvMediaPlayer.this.isHLSPlayingUrl() && UrlUtil.isSegment(string)) {
                stringArray = MgtvMediaPlayer.this.mCacheTsPaths;
                stringArray2 = this.findTsCachPath(string, stringArray);
            }
            if (FileUtil.exist(stringArray2) && !StringUtil.isEmpty((String)(stringArray = UrlUtil.addLocalPrefix(stringArray2)))) {
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "replaceUrlFromCache from " + string);
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "replaceUrlFromCache to " + (String)stringArray);
                bundle.putString("url", (String)stringArray);
                if (UrlUtil.isM3u8(string)) {
                    DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "replaceUrlFromCache put SRC_URL " + string);
                    bundle.putString("src_url", string);
                }
                MgtvMediaPlayer.this.mCacheReplaceMap.put(stringArray, string);
                return true;
            }
            return false;
        }

        private String findTsCachPath(String string, String[] stringArray) {
            if (stringArray == null) {
                return null;
            }
            try {
                String string2 = UrlUtil.getFileName(string);
                for (String string3 : stringArray) {
                    if (string3 == null || !new File(string3).getName().equals(string2)) continue;
                    return string3;
                }
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }

        private boolean doNewHttpWillOpen(Bundle bundle) {
            int n2 = bundle.getInt("error_type");
            int n3 = bundle.getInt("error_code");
            int n4 = bundle.getInt("retry_counter");
            int n5 = bundle.getInt("reset_iplist");
            MgtvMediaPlayer.this.mLastDlSize = bundle.getInt("cur_dl_dize");
            bundle.putString("user_msg", MgtvMediaPlayer.USER_MSG_FLAG_DEFAULT);
            if (MgtvMediaPlayer.this.mEnableJAVAIPCacheMap && n5 == 1) {
                MgtvMediaPlayer.this.clearIPCache();
            }
            DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "doNewHttpWillOpen in error_what:" + n2 + ",error_extra:" + n3 + ",reset_iplist:" + n5 + ",mLastDlSize:" + MgtvMediaPlayer.this.mLastDlSize);
            bundle.putInt("reset_iplist", 0);
            if (n3 != 0) {
                boolean bl = this.doNetHttpWillOpenFailed(n2, n3, bundle);
                DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed return " + bl + "," + n2 + "-" + n3 + "-" + MgtvMediaPlayer.this.mErrorUrl);
                return bl;
            }
            MgtvMediaPlayer.this.mIsInitMp4Error = false;
            if (n3 == 0 && MgtvMediaPlayer.this.mCacheEable) {
                this.replaceUrlFromCache(bundle);
            }
            return false;
        }

        private void checkErrorCode(int n2, int n3, Bundle bundle) {
            if (bundle == null) {
                return;
            }
            int n4 = bundle.getInt("retry_counter");
            MgtvMediaPlayer.this.mSourceRetryCount = n4;
            MgtvMediaPlayer.this.mSourceRetryCode = n3;
            if (MgtvMediaPlayer.this.isDnsCacheEnable() && n4 >= 1 && MgtvMediaPlayer.this.checkAndCleanDnsCache(n2, n3)) {
                MgtvMediaPlayer.this.mHttpDnsEnable = true;
            }
        }

        private boolean isENETUNREACHcode(int n2, int n3) {
            return n3 == 300005;
        }

        private boolean isInitMp4(String string) {
            return MgtvMediaPlayer.this.isHLSPlayingUrl() && UrlUtil.isSuffixUrl(string, ".mp4");
        }

        private void reportHttpErrorPV(int n2, String string, int n3, String string2) {
            if (n2 == 0) {
                MgtvMediaPlayer.this.mCacheReportTag = MgtvMediaPlayer.DEFAULT_CACHE_REPORT_TAG;
                MgtvMediaPlayer.this.mCacheReportLerr = 0;
            }
            if (n2 == 0 && (this.isInitMp4(string) || UrlUtil.isM3u8(string)) && MgtvMediaPlayer.this.mReportParams != null && MgtvMediaPlayer.this.mReportParams.getVideoType() == ReportParams.VideoType.VOD && MgtvMediaPlayer.this.mReportParams.getProxyType() == ReportParams.ProxyType.NO_PROXY && MgtvMediaPlayer.this.mOnWarningListener != null) {
                String string3 = "00";
                if (MgtvMediaPlayer.this.mReporter != null) {
                    string3 = MgtvMediaPlayer.this.mReporter.g();
                }
                MgtvMediaPlayer.this.mCacheReportTag = string2;
                MgtvMediaPlayer.this.mCacheReportLerr = n3;
                MgtvMediaPlayer.this.mOnWarningListener.onWarning(800901, n3 + "", "psuuid_" + string3 + "_render_" + (MgtvMediaPlayer.this.isRendered() ? "1" : "0") + "_url_" + string + "_type_" + string2, null);
            }
        }

        private void reportHttpErrorErr(int n2, String string) {
            if ((this.isInitMp4(string) || UrlUtil.isM3u8(string)) && MgtvMediaPlayer.this.mReportParams != null && MgtvMediaPlayer.this.mReportParams.getVideoType() == ReportParams.VideoType.VOD && MgtvMediaPlayer.this.mReportParams.getProxyType() == ReportParams.ProxyType.NO_PROXY && MgtvMediaPlayer.this.mOnWarningListener != null) {
                String string2 = "00";
                if (MgtvMediaPlayer.this.mReporter != null) {
                    string2 = MgtvMediaPlayer.this.mReporter.g();
                }
                MgtvMediaPlayer.this.mOnWarningListener.onWarning(800902, n2 + "." + MgtvMediaPlayer.this.mCacheReportLerr, "psuuid_" + string2 + "_render_" + (MgtvMediaPlayer.this.isRendered() ? "1" : "0") + "_url_" + string + "_type_" + MgtvMediaPlayer.this.mCacheReportTag, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doNetHttpWillOpenFailed(int n2, int n3, Bundle bundle) {
            String string;
            this.checkErrorCode(n2, n3, bundle);
            MgtvMediaPlayer.this.mErrorUrl = UrlUtil.getValidUrl(bundle.getString("url"));
            int n4 = bundle.getInt("cur_dl_dize");
            if (this.isInitMp4(MgtvMediaPlayer.this.mErrorUrl)) {
                MgtvMediaPlayer.this.mIsInitMp4Error = true;
            } else {
                MgtvMediaPlayer.this.mIsInitMp4Error = false;
            }
            int n5 = bundle.getInt("retry_counter");
            if (UrlUtil.isFilePrefix(MgtvMediaPlayer.this.mErrorUrl) && !MgtvMediaPlayer.this.mCacheReplaceMap.isEmpty()) {
                if (MgtvMediaPlayer.this.mOnWarningListener != null) {
                    MgtvMediaPlayer.this.mOnWarningListener.onWarning(800007, n3 + "", MgtvMediaPlayer.this.mErrorUrl, null);
                }
                if ((string = (String)MgtvMediaPlayer.this.mCacheReplaceMap.get(MgtvMediaPlayer.this.mErrorUrl)) != null) {
                    MgtvMediaPlayer.this.mTsCacheSkipNum++;
                    MgtvMediaPlayer.this.mErrorUrl = string;
                    bundle.putString("url", string);
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed replace local_url to " + string);
                }
            }
            string = bundle.getString("player_hash");
            int n6 = bundle.getInt("io_type");
            com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed url:%s,iotype:%d, RetryCount:%d,error_code:%d-%d", MgtvMediaPlayer.this.mErrorUrl, n6, n5, n2, n3);
            if (this.isENETUNREACHcode(n2, n3) || MgtvMediaPlayer.this.mPrepared && this.isDnsError(n2, n3)) {
                com.hunantv.media.report.c.c.a(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed network broken,RetryCount:%d,error_code:%d-%d", n5, n2, n3);
                return true;
            }
            boolean bl = false;
            Object object = MgtvMediaPlayer.this.mDnsNoNetWaiter;
            synchronized (object) {
                if (!this.isPlayerReset() && MgtvMediaPlayer.this.mEnableDnsNoNetStrategy && this.isDnsError(n2, n3)) {
                    boolean bl2 = com.hunantv.media.report.c.d.c(MgtvMediaPlayer.this.mContext);
                    if (!bl2) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed DnsNetStrategy mDnsNoNetWaiter wait 1000 in");
                        bl = true;
                        try {
                            MgtvMediaPlayer.this.mDnsNoNetWaiter.wait(1000L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed DnsNetStrategy mDnsNoNetWaiter wait 1000 out");
                    } else if (bl2 && !MgtvMediaPlayer.this.mLastIsNetworkAvailableNNS) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed DnsNetStrategy mDnsNoNetWaiter wait 3000 in");
                        bl = true;
                        try {
                            MgtvMediaPlayer.this.mDnsNoNetWaiter.wait(3000L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed DnsNetStrategy mDnsNoNetWaiter wait 3000 out");
                    }
                    MgtvMediaPlayer.this.mLastIsNetworkAvailableNNS = bl2;
                }
            }
            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed mIsLive:" + MgtvMediaPlayer.this.mIsLive + ",mPlayerMode:" + MgtvMediaPlayer.this.mPlayerMode + ",mPrepared:" + MgtvMediaPlayer.this.mPrepared + ",mIsBuffering:" + MgtvMediaPlayer.this.mIsBuffering + ",mTsNotSkip:" + MgtvMediaPlayer.this.mTsNotSkip + ",mLoadMaxRetryTime:" + MgtvMediaPlayer.this.mLoadMaxRetryTime + ",mPlayStatus:" + (Object)((Object)MgtvMediaPlayer.this.mPlayStatus) + ",lip:" + MgtvMediaPlayer.this.getLastIP());
            DebugLog.ifmt(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed %d-%d-%d-%d-%s", n5, n6, n2, n3, MgtvMediaPlayer.this.mErrorUrl);
            if (MgtvMediaPlayer.this.mIsLive && !MgtvMediaPlayer.this.isVod() || MgtvMediaPlayer.this.mPlayerMode == 1) {
                if (!MgtvMediaPlayer.this.mPrepared) {
                    if (UrlUtil.isM3u8(MgtvMediaPlayer.this.mErrorUrl)) {
                        return n5 < 2;
                    }
                    MgtvMediaPlayer.this.callbackTsSkip(MgtvMediaPlayer.this.mErrorUrl, n2, n3);
                    return false;
                }
                if (MgtvMediaPlayer.this.mIsBuffering && MgtvMediaPlayer.this.isHLSPlayingUrl() && n5 >= 1) {
                    if (UrlUtil.isSegment(MgtvMediaPlayer.this.mErrorUrl)) {
                        MgtvMediaPlayer.this.callbackTsSkip(MgtvMediaPlayer.this.mErrorUrl, n2, n3);
                    }
                    return false;
                }
            } else {
                if (MgtvMediaPlayer.this.mEnableJAVAIPCacheMap && (n3 == 100911 || n3 == 300021 || CodeUtil.isHttp4XX(n2, n3) || CodeUtil.isHttp5XX(n2, n3)) && !StringUtil.isEmpty((String)(object = UrlUtil.getHostName(UrlUtil.getValidHttpUrl(bundle.getString("url"))))) && !e.a((String)object) && MgtvMediaPlayer.this.mIPCacheMap.containsKey(object)) {
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback ipcache will http contains host:" + (String)object);
                    IPList iPList = (IPList)MgtvMediaPlayer.this.mIPCacheMap.get(object);
                    if (iPList != null && iPList.checkTTL() && iPList.nUseList != null && iPList.nUseList.size() > 0) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback ipcache will http check ttl success." + iPList);
                        if (n5 >= 6) {
                            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback ipcache will http return false.not retry");
                            this.reportHttpErrorErr(n3, MgtvMediaPlayer.this.mErrorUrl);
                            return false;
                        }
                        bundle.putString("user_msg", MgtvMediaPlayer.USER_MSG_FLAG_USE_CACHE);
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback ipcache will http return true.try to goto ip choose");
                        this.reportHttpErrorPV(n5, MgtvMediaPlayer.this.mErrorUrl, n3, "ipcache");
                        return true;
                    }
                }
                this.reportHttpErrorPV(n5, MgtvMediaPlayer.this.mErrorUrl, n3, MgtvMediaPlayer.DEFAULT_CACHE_REPORT_TAG);
                if (bl) {
                    if (n5 >= MgtvMediaPlayer.this.mDnsNoNetMaxRetry) {
                        this.reportHttpErrorErr(n3, MgtvMediaPlayer.this.mErrorUrl);
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed DnsNetStrategy skip retry cause by errorRetryCount >= mDnsNoNetMaxRetry");
                        return false;
                    }
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "doNetHttpWillOpenFailed DnsNetStrategy retry cause by inDnsNetStrategy");
                    return true;
                }
                if (!MgtvMediaPlayer.this.mPrepared) {
                    if (UrlUtil.isM3u8(MgtvMediaPlayer.this.mErrorUrl)) {
                        if (n5 >= 2) {
                            this.reportHttpErrorErr(n3, MgtvMediaPlayer.this.mErrorUrl);
                            return false;
                        }
                        return true;
                    }
                    if (!MgtvMediaPlayer.this.isSkipRetryCode(n2, n3) && this.isInitMp4(MgtvMediaPlayer.this.mErrorUrl) && n4 > 0 && n5 < 10) {
                        return true;
                    }
                    if (MgtvMediaPlayer.this.isSkipRetryCode(n2, n3) || n5 >= MgtvMediaPlayer.this.mLoadMaxRetryTime) {
                        MgtvMediaPlayer.this.callbackTsSkip(MgtvMediaPlayer.this.mErrorUrl, n2, n3);
                        this.reportHttpErrorErr(n3, MgtvMediaPlayer.this.mErrorUrl);
                        return false;
                    }
                    return true;
                }
                if (MgtvMediaPlayer.this.mTsNotSkip && MgtvMediaPlayer.this.isRendered()) {
                    return true;
                }
            }
            if (MgtvMediaPlayer.this.isSkipRetryCode(n2, n3) || n5 >= 2) {
                if (UrlUtil.isSegment(MgtvMediaPlayer.this.mErrorUrl)) {
                    MgtvMediaPlayer.this.callbackTsSkip(MgtvMediaPlayer.this.mErrorUrl, n2, n3);
                }
                this.reportHttpErrorErr(n3, MgtvMediaPlayer.this.mErrorUrl);
                return false;
            }
            return true;
        }
    };
    public static final String BUNDLE_KEY_LOG_TAG_KEY = "BUNDLE_KEY_LOG_TAG_KEY";
    public static final String BUNDLE_KEY_BOOLEAN_AUDIO_MODE = "BUNDLE_KEY_BOOLEAN_AUDIO_MODE";
    public static final String BUNDLE_KEY_BOOLEAN_ENABLE_REPORT = "BUNDLE_KEY_BOOLEAN_ENABLE_REPORT";
    @Nullable
    private Bundle mBundle;
    @Nullable
    private String mLogTagKey = "";
    private boolean mEnableReport = true;
    private boolean mNetworkChangeWhilePlaying;
    private Object p2pLocker = new Object();
    private long mSeekStartMs = -1L;
    private Hw2SwType mHw2SwType = Hw2SwType.NONE;
    private float mPlaybackSpeed = 1.0f;
    private MgtvPlayerListener.OnFrameListener mFrameListener = new MgtvPlayerListener.OnFrameListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVFrameClockCome(MgtvPlayerListener.FrameClock frameClock) {
            Object object = MgtvMediaPlayer.this.ptsLocker;
            synchronized (object) {
                if (MgtvMediaPlayer.this.ptsWeakHandler != null) {
                    MgtvMediaPlayer.this.ptsWeakHandler.removeMessages(256);
                    Message message = new Message();
                    message.what = 256;
                    message.obj = frameClock;
                    MgtvMediaPlayer.this.ptsWeakHandler.sendMessage(message);
                }
                if (MgtvMediaPlayer.this.mOnFrameListener != null) {
                    MgtvMediaPlayer.this.mOnFrameListener.onVFrameClockCome(frameClock);
                }
            }
        }
    };
    private FlowDataStatistic mFlowDataStatistic;
    private FlowDataStatistic mInnerFlowDataStatistic = new FlowDataStatistic();
    private long mNetdSVCTimeMs;
    public static final int OPPO_FUNC_SR = 1;
    public static final int OPPO_FUNC_OSIE = 2;
    private static final int START_RECORD = 0;
    private static final int STOP_RECORD = 1;
    private GifRecorder mGifRecorder;
    private AtomicInteger mLoopSourceKey = new AtomicInteger(1);
    public static final String MEDIA_MIMETYPE_TEXT_SUBRIP = "application/x-subrip";
    public static final String MEDIA_MIMETYPE_TEXT_VTT = "text/vtt";
    private com.hunantv.media.player.subtitle.e mTimeProvider;
    private b mSubtitleController;
    private List<SubtitleSource> mSubtitleSources = new ArrayList<SubtitleSource>();
    private ISubtitle.SubtitleCallback mSubtitleCallback;
    private IMgtvRenderView mRenderView;
    private int avdiffS;
    private int sfps;
    private int dfps;
    private int vfps;
    private int rfps;
    private int rfpsLowCounter;
    private boolean rfpsLowFilterChanged;
    HandlerThread ptsHandlerThread = null;
    WeakHandler ptsWeakHandler = null;
    Set<MgtvPlayerListener.OnVideoPTSListener> ptsListeners = new HashSet<MgtvPlayerListener.OnVideoPTSListener>();
    Object ptsLocker = new Object();
    private d.n mSmoothSourceListener = new d.n(){
        int lastSwitchingKey = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSmoothSwitchSourceInfo(com.hunantv.media.player.d d2, int n2, int n3, String string) {
            Object object = MgtvMediaPlayer.this.mSwitchSmoothSourceLocker;
            synchronized (object) {
                Object object2;
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceInfo (event:" + n3 + ",key:" + n2 + ",msg:" + string + ")");
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceInfo current: " + MgtvMediaPlayer.this.getCurrentSmoothSourceKey());
                SmoothMediaSource smoothMediaSource = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get(n2);
                if (smoothMediaSource != null) {
                    switch (n3) {
                        case 0: {
                            smoothMediaSource.s_event_0_timestamp = System.currentTimeMillis();
                            break;
                        }
                        case 2: {
                            if (MgtvMediaPlayer.this.isFlowReportEnable) {
                                smoothMediaSource.genFlowReporter();
                            }
                            smoothMediaSource.s_event_2_timestamp = System.currentTimeMillis();
                            break;
                        }
                        case 3: {
                            if (MgtvMediaPlayer.this.isFlowReportEnable && MgtvMediaPlayer.this.mMainFlowReportProcessor != null) {
                                MgtvMediaPlayer.this.mMainFlowReportProcessor.stop();
                            }
                            for (Map.Entry object3 : MgtvMediaPlayer.this.mSmoothSourcesRecord.entrySet()) {
                                if ((Integer)object3.getKey() >= smoothMediaSource.getKey()) continue;
                                SmoothMediaSource smoothMediaSource2 = (SmoothMediaSource)object3.getValue();
                                if (!MgtvMediaPlayer.this.isFlowReportEnable || smoothMediaSource2 == null || smoothMediaSource2.getFlowReportProcessor() == null) continue;
                                smoothMediaSource2.getFlowReportProcessor().stop();
                            }
                            smoothMediaSource.s_event_3_timestamp = System.currentTimeMillis();
                            break;
                        }
                        case 11: {
                            smoothMediaSource.s_event_11_timestamp = System.currentTimeMillis();
                        }
                    }
                }
                if (n3 == 3) {
                    object2 = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get(this.lastSwitchingKey);
                    if (object2 != null && ((SmoothMediaSource)object2).getReporter() != null) {
                        ((SmoothMediaSource)object2).getReporter().c();
                    }
                    this.lastSwitchingKey = n2;
                    SmoothMediaSource smoothMediaSource3 = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get(n2);
                    if (smoothMediaSource3 != null && MgtvMediaPlayer.this.mOnSwitchSmoothSourceListener != null) {
                        MgtvMediaPlayer.this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceInfo(smoothMediaSource3, n3);
                    }
                    return;
                }
                object2 = MgtvMediaPlayer.this.matchLastKeySource(n2);
                if (object2 == null) {
                    DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceInfo matchKeySource failed");
                    return;
                }
                switch (n3) {
                    case 0: {
                        MgtvMediaPlayer.this.mSourceSwitching = true;
                        break;
                    }
                    case 7: {
                        break;
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSmoothSwitchSourceComplete(com.hunantv.media.player.d d2, int n2, int n3, String string) {
            Object object = MgtvMediaPlayer.this.mSwitchSmoothSourceLocker;
            synchronized (object) {
                Object object2;
                Map.Entry entry;
                DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceComplete (type:" + n3 + ",key:" + n2 + ",msg:" + string + ")");
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceComplete current: " + MgtvMediaPlayer.this.getCurrentSmoothSourceKey());
                Object object3 = MgtvMediaPlayer.this.mSmoothSourcesRecord.entrySet().iterator();
                while (object3.hasNext()) {
                    entry = object3.next();
                    if ((Integer)entry.getKey() >= n2 || (object2 = (SmoothMediaSource)entry.getValue()) == null || ((MgtvMediaSource)object2).isReleased()) continue;
                    ((SmoothMediaSource)object2).release();
                }
                MgtvMediaPlayer.this.mSmoothUseP2pFailed = false;
                if (MgtvMediaPlayer.this.mMediaPlayer != null) {
                    MgtvMediaPlayer.this.mMediaPlayer.c(false);
                }
                if ((object3 = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get(n2)) != null) {
                    if (MgtvMediaPlayer.this.mReporter != null) {
                        MgtvMediaPlayer.this.mReporter.c();
                    }
                    MgtvMediaPlayer.this.mReporter = ((SmoothMediaSource)object3).getReporter();
                    if (MgtvMediaPlayer.this.mMediaPlayer != null) {
                        MgtvMediaPlayer.this.mMediaPlayer.a(MgtvMediaPlayer.this.mReporter);
                        MgtvMediaPlayer.this.mMediaPlayer.a(((MgtvMediaSource)object3).getReadType(), ((MgtvMediaSource)object3).getUrl(), ((MgtvMediaSource)object3).getPlayingUrl());
                    }
                    if (MgtvMediaPlayer.this.mDataSourceInfo != null) {
                        MgtvMediaPlayer.this.mDataSourceInfo.setVideoFormat(((MgtvMediaSource)object3).getVideoFormat());
                        MgtvMediaPlayer.this.mDataSourceInfo.setAudioFormat(((MgtvMediaSource)object3).getAudioFormat());
                        MgtvMediaPlayer.this.mDataSourceInfo.setFileFormat(((MgtvMediaSource)object3).getFileFormat());
                    }
                    if (MgtvMediaPlayer.this.mReporter != null) {
                        MgtvMediaPlayer.this.mReportParams.deepCopy(((SmoothMediaSource)object3).getReportParams());
                        MgtvMediaPlayer.this.mReporter.a(MgtvMediaPlayer.this.mReportParams);
                        MgtvMediaPlayer.this.mReporter.b();
                    }
                    if (MgtvMediaPlayer.this.mSmoothKeyFrameMap.containsKey(entry = MgtvMediaPlayer.this.getKeyFrameMapKey(((SmoothMediaSource)object3).getVid(), ((SmoothMediaSource)object3).getDef()))) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "find smoothKeyFrameKey :" + (String)((Object)entry) + " set to player");
                        object2 = MgtvMediaPlayer.this.mSmoothKeyFrameMap.get(entry);
                        if (KeyFrameInfoUtils.isKeyFrameDataValid((byte[])object2, ((SmoothMediaSource)object3).videoFileHash) == 0) {
                            MgtvMediaPlayer.this.setKeyFrameInfoFileBuf((byte[])object2);
                        }
                    }
                }
                if ((entry = MgtvMediaPlayer.this.matchLastKeySource(n2)) == null) {
                    DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceComplete matchKeySource failed");
                    return;
                }
                if (((SmoothMediaSource)((Object)entry)).getSwitchMod() == 1) {
                    MgtvMediaPlayer.this.mMediaPlayer.d(true);
                }
                MgtvMediaPlayer.this.mSwitchedSmoothSource = (SmoothMediaSource)((Object)entry);
                MgtvMediaPlayer.this.mSourceSwitchingComplete = true;
                MgtvMediaPlayer.this.mSourceSwitching = false;
                if (MgtvMediaPlayer.this.mMediaPlayer != null) {
                    MgtvMediaPlayer.this.mMainFlowReportProcessor = ((SmoothMediaSource)((Object)entry)).getFlowReportProcessor();
                    MgtvMediaPlayer.this.mMediaPlayer.a(((MgtvMediaSource)((Object)entry)).getP2pTask());
                    MgtvMediaPlayer.this.mMediaPlayer.b(((MgtvMediaSource)((Object)entry)).getReadType());
                }
                MgtvMediaPlayer.this.mSmoothKeyFrameMap.clear();
                if (MgtvMediaPlayer.this.mOnSwitchSmoothSourceListener != null) {
                    MgtvMediaPlayer.this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceSuccess((SmoothMediaSource)((Object)entry));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSmoothSwitchSourceFailed(com.hunantv.media.player.d d2, int n2, int n3, String string) {
            Object object = MgtvMediaPlayer.this.mSwitchSmoothSourceLocker;
            synchronized (object) {
                Object object2;
                DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceFailed (type:" + n3 + ",key:" + n2 + ",msg:" + string + ")");
                DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceFailed current: " + MgtvMediaPlayer.this.getCurrentSmoothSourceKey());
                int n4 = 400710;
                int n5 = -1;
                try {
                    if (!StringUtil.isEmpty(string) && (object2 = string.split("-")) != null && ((String[])object2).length >= 2) {
                        n4 = NumericUtil.parseInt(object2[0]);
                        n5 = NumericUtil.parseInt((String)object2[1]);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                object2 = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get(n2);
                if (object2 != null) {
                    if (((SmoothMediaSource)object2).getReporter() != null) {
                        ((SmoothMediaSource)object2).getReporter().a(n4, n5, "");
                    }
                    if (MgtvMediaPlayer.this.mReportParams != null) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceFailed mReportParams:" + (Object)((Object)MgtvMediaPlayer.this.mReportParams.getProxyType()) + "-" + MgtvMediaPlayer.this.mReportParams.getP2ps());
                    }
                    if (((SmoothMediaSource)object2).getReportParams() != null) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceFailed currentSource.getReportParams():" + (Object)((Object)((SmoothMediaSource)object2).getReportParams().getProxyType()) + "-" + ((SmoothMediaSource)object2).getReportParams().getP2ps());
                    }
                    if (MgtvMediaPlayer.this.mReportParams != null && MgtvMediaPlayer.this.mReportParams.isP2p() && ((SmoothMediaSource)object2).getReportParams() != null && ((SmoothMediaSource)object2).getReportParams().isP2p()) {
                        MgtvMediaPlayer.this.mSmoothUseP2pFailed = true;
                        if (MgtvMediaPlayer.this.mMediaPlayer != null) {
                            MgtvMediaPlayer.this.mMediaPlayer.c(true);
                        }
                    }
                    if (((SmoothMediaSource)object2).isThrowErrorIfSwitchFailed()) {
                        MgtvMediaPlayer.this.mErrorListener.onError(400711, n5);
                        return;
                    }
                }
                if (n3 == 1) {
                    MgtvMediaPlayer.this.mErrorListener.onError(n4, n5);
                    return;
                }
                SmoothMediaSource smoothMediaSource = MgtvMediaPlayer.this.matchLastKeySource(n2);
                if (smoothMediaSource == null) {
                    DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "onSmoothSwitchSourceFailed matchKeySource failed");
                    return;
                }
                MgtvMediaPlayer.this.notifySwitchSmoothSourceFail(smoothMediaSource, n4, n5);
            }
        }
    };
    private static final int WHAT_SMOOTHSOURCE_FAIL = 400710;
    private static final int WHAT_SMOOTHSOURCE_EX_ERROR = 400711;
    private Map<Integer, SmoothMediaSource> mSmoothSourcesRecord = new HashMap<Integer, SmoothMediaSource>();
    private Object mSwitchSmoothSourceLocker = new Object();
    private volatile SmoothMediaSource mSwitchingSmoothSource;
    private volatile SmoothMediaSource mSwitchedSmoothSource;
    private boolean mSmoothUseP2pFailed = false;
    private MgtvPlayerListener.OnSwitchSmoothSourceListener mOnSwitchSmoothSourceListener;
    Map<String, byte[]> mSmoothKeyFrameMap = Collections.synchronizedMap(new HashMap());
    public boolean isBackground = false;
    public static final int MGTV_LOG_DEBUG_NONE = 0;
    public static final int MGTV_LOG_DEBUG_BRIEF = 1;
    public static final int MGTV_LOG_DEBUG_DETAIL = 2;
    public static final int MGTV_LOG_LEVEL_SILENT = 8;
    public static final int MGTV_LOG_LEVEL_FATAL = 7;
    public static final int MGTV_LOG_LEVEL_ERROR = 6;
    public static final int MGTV_LOG_LEVEL_WARN = 5;
    public static final int MGTV_LOG_LEVEL_INFO = 4;
    public static final int MGTV_LOG_LEVEL_DEBUG = 3;
    public static final int MGTV_LOG_LEVEL_VERBOSE = 2;
    public static final int MGTV_LOG_LEVEL_DEFAULT = 1;
    public static final int MGTV_LOG_LEVEL_UNKNOWN = 0;

    private void beforeThrowError(int n2, int n3) {
        this.mLastErrorTypeCode = MgtvMediaPlayer.getErrorCodeType(this.isRendered(), n2, n3);
        DebugLog.d(this.getLogTag(), "beforeThrowError mLastErrorTypeCode:" + this.mLastErrorTypeCode);
    }

    public String getLastErrorTypeCode() {
        return this.mLastErrorTypeCode;
    }

    public static boolean isTimeoutError(int n2, int n3) {
        return com.hunantv.media.report.a.b(n2, n3);
    }

    public static String getErrorCodeType(boolean bl, int n2, int n3) {
        String string = "";
        if (!bl) {
            string = string + "3.";
            string = MgtvMediaPlayer.isTimeoutError(n2, n3) ? string + "103" : string + "105";
        } else {
            string = string + "4.";
            string = MgtvMediaPlayer.isTimeoutError(n2, n3) ? string + "103" : string + "106";
        }
        return string;
    }

    private void callbackTsSkip(String string, int n2, int n3) {
        if (this.mReportParams != null && this.mReportParams.getVideoType() == ReportParams.VideoType.LOCAL) {
            return;
        }
        this.mLastTsSkipErrExtra = n3;
        this.mLastTsSkipErrFileName = UrlUtil.getFileName(string);
        if (this.mOnWarningListener != null && this.isHLSPlayingUrl() && UrlUtil.isSegment(string)) {
            DebugLog.i(this.getLogTag(), "callbackTsSkip what:" + n2 + ",extra:" + n3);
            this.mOnWarningListener.onTsSkip(string, n2, n3);
            if (!this.mIsP2pTSSkipReport) {
                String string2 = "00";
                String string3 = "00";
                String string4 = "00";
                if (this.mMediaPlayer != null) {
                    if (this.mMediaPlayer.af() != null) {
                        string2 = this.mMediaPlayer.af().getStrHash();
                        string3 = P2pMgr.isTaskExistInt(this.mMediaPlayer.af()) + "";
                        string4 = this.mMediaPlayer.af().getStatus() + "";
                    } else {
                        string2 = "22";
                    }
                } else {
                    string2 = "11";
                }
                this.mOnWarningListener.onWarning(801011, n3 + "", "hash_" + string2 + "_taskcode_" + string3 + "_taskStatus_" + string4 + "_errorUrl_" + string, null);
                this.mIsP2pTSSkipReport = true;
            }
        }
    }

    private boolean isSkipRetryCode(int n2, int n3) {
        return CodeUtil.isHttp4XX(n2, n3) || CodeUtil.isHttp5XX(n2, n3) || !this.isDnsCacheEnable() && !this.mBackJavaDns && n3 == 100701;
    }

    public MgtvMediaPlayer(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, OutOfMemoryError {
        this.mMediaPlayer = new h(2, context);
        this.initData(context);
        this.initConfig();
        this.initReporter(context);
        this.initListener();
    }

    public MgtvMediaPlayer(int n2, Context context, Bundle bundle) throws UnsatisfiedLinkError, SecurityException, NullPointerException, OutOfMemoryError {
        this.mBundle = bundle;
        this.extractBundleData();
        this.init(n2, context);
    }

    private void extractBundleData() {
        if (this.mBundle != null) {
            this.mLogTagKey = this.mBundle.getString(BUNDLE_KEY_LOG_TAG_KEY);
            this.mImgoMediaPlayerAudioMode = this.mBundle.getBoolean(BUNDLE_KEY_BOOLEAN_AUDIO_MODE);
            this.mEnableReport = this.mBundle.getBoolean(BUNDLE_KEY_BOOLEAN_ENABLE_REPORT, true);
            DebugLog.i(this.getLogTag(), "extractBundleData bundle not null");
        }
        DebugLog.i(this.getLogTag(), "extractBundleData mLogTagKey:" + this.mLogTagKey + ",mImgoMediaPlayerAudioMode:" + this.mImgoMediaPlayerAudioMode + ",mEnableReport:" + this.mEnableReport);
    }

    public MgtvMediaPlayer(int n2, Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, OutOfMemoryError {
        this.init(n2, context);
    }

    private void init(int n2, Context context) {
        if (n2 < 0 || n2 > 2) {
            n2 = 2;
        }
        this.mMediaPlayer = new h(n2, context, this.mBundle);
        this.mPlayerType = n2;
        this.initData(context);
        this.initConfig();
        this.initReporter(context);
        this.initListener();
    }

    public MgtvMediaPlayer(int n2, Context context, boolean bl, Bundle bundle) throws UnsatisfiedLinkError, SecurityException, NullPointerException, OutOfMemoryError {
        this.mBundle = bundle;
        this.extractBundleData();
        this.init(n2, context, bl);
    }

    public MgtvMediaPlayer(int n2, Context context, boolean bl, int n3, Bundle bundle) throws UnsatisfiedLinkError, SecurityException, NullPointerException, OutOfMemoryError {
        this.mBundle = bundle;
        this.mPlayerMode = n3;
        this.extractBundleData();
        this.init(n2, context, bl);
    }

    public MgtvMediaPlayer(int n2, Context context, boolean bl) throws UnsatisfiedLinkError, SecurityException, NullPointerException {
        this.init(n2, context, bl);
    }

    private void init(int n2, Context context, boolean bl) {
        DebugLog.i(this.getLogTag(), "init playerType:" + n2 + ", enableTexture:" + bl);
        if (n2 < 0 || n2 > 2) {
            n2 = 2;
        }
        if (this.mPlayerMode < 0 || this.mPlayerMode > 2) {
            this.mPlayerMode = 0;
        }
        if (BuildHelper.isApi14_IceCreamSandwichOrLater()) {
            this.mMediaPlayer = new h(n2, context, bl, this.mPlayerMode, this.mBundle);
        } else {
            if (bl) {
                DebugLog.e(this.getLogTag(), "it isn't supported under 4.0 for setting TextureView");
            }
            this.mMediaPlayer = new h(n2, context, false, this.mPlayerMode, this.mBundle);
        }
        this.mPlayerType = n2;
        this.initData(context);
        this.initConfig();
        this.initReporter(context);
        this.initListener();
    }

    private void initData(Context context) {
        this.mContext = context;
        PlayerReferenceObserver.add(this.hashCode() + "", "", this.getLogTag());
        if (this.mLogTagKey != null && this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2018042501, this.mLogTagKey);
        }
        try {
            this.mMainThreadID = Thread.currentThread().getId();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mObserver = new MgtvPlayerBroadcastObserver(context);
        this.mObserver.setOnNetworkChangeListener(new MgtvPlayerBroadcastObserver.OnNetworkChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNetworkChanged(int n2, int n3) {
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onNetworkChanged " + n2 + "->" + n3);
                if (!MgtvMediaPlayer.this.isSystemPlayer()) {
                    FFmpegApi.remove_all_dns_cache();
                }
                if (MgtvMediaPlayer.this.isPlaying()) {
                    MgtvMediaPlayer.this.mNetworkChangeWhilePlaying = true;
                }
                Object object = MgtvMediaPlayer.this.mDnsNoNetWaiter;
                synchronized (object) {
                    if (n3 != -1) {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onNetworkChanged DnsNetStrategy mDnsNoNetWaiter notifyAll");
                        MgtvMediaPlayer.this.mDnsNoNetWaiter.notifyAll();
                    }
                }
            }
        });
        this.mObserver.setOnHeadsetListener(new MgtvPlayerBroadcastObserver.OnHeadsetListener(){

            @Override
            public void onHeadsetStateChange(int n2) {
                if (n2 == 0) {
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "\u8033\u673a\u62d4\u51fa");
                    MgtvMediaPlayer.this.setWanosAudioEffectChoice(3);
                } else if (n2 == 1) {
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "\u8033\u673a\u63d2\u5165");
                    MgtvMediaPlayer.this.setWanosAudioEffectChoice(4);
                }
            }
        });
        this.mObserver.setOnBluetoothHeadsetListener(new MgtvPlayerBroadcastObserver.OnBluetoothHeadsetListener(){

            @Override
            public void onBluetoothHeadsetStateChange(int n2) {
                switch (n2) {
                    case 0: 
                    case 2: {
                        if (n2 == 2) {
                            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "BluetoothHeadset connected");
                        } else {
                            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "BluetoothHeadset disconnected");
                        }
                        if (MgtvMediaPlayer.this.mMediaPlayer == null) break;
                        MgtvMediaPlayer.this.mMediaPlayer.ao();
                        break;
                    }
                }
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setDisplay(SurfaceHolder surfaceHolder) throws InvalidParameterException {
        this.mMediaPlayer.a(surfaceHolder);
    }

    public void setDisplay(SurfaceHolder surfaceHolder, int n2) throws InvalidParameterException {
        this.mMediaPlayer.a(surfaceHolder, n2);
    }

    public void setDataSourceBefore(String string, IP2pTask iP2pTask) {
        if (this.mMainFlowReportProcessor != null) {
            this.mMainFlowReportProcessor.stop();
        }
        this.isFlowReportEnable = FlowReportProcessor.isEnable() && !FlowReportProcessor.isInvalidVideoType(this.mReportParams);
        this.mMediaPlayer.a(2021031501, this.isFlowReportEnable ? 1 : 0);
        if (this.isFlowReportEnable && this.mReportParams != null) {
            boolean bl = false;
            if (iP2pTask != null && (this.mReportParams.getProxyType() == ReportParams.ProxyType.ONLY_P2P || this.mReportParams.getProxyType() == ReportParams.ProxyType.P2P_DRM)) {
                bl = true;
            }
            this.mMainFlowReportProcessor = new FlowReportProcessor(string, this.mReportParams.getVid(), NumericUtil.parseInt(this.mReportParams.getDef()), this.mReportParams.getVideoSession(), bl, "main");
        } else {
            this.mMainFlowReportProcessor = null;
            DebugLog.i(this.getLogTag(), "no FlowReportProcessor. isFlowReportEnable:" + this.isFlowReportEnable);
            if (!this.isFlowReportEnable) {
                DebugLog.i(this.getLogTag(), "no FlowReportProcessor. isInited:" + FlowReporter.isInited() + ",mode:" + NetPlayConfig.getFlowReportMode());
            }
            if (this.mReportParams == null) {
                DebugLog.i(this.getLogTag(), "no FlowReportProcessor. mReportParams is null.");
            }
        }
    }

    public void setDataSource(String string) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mSourceSwitching = false;
        this.mSourceSwitchingComplete = false;
        this.mHw2SwType = Hw2SwType.NONE;
        this.setPlayerReset(false);
        this.mMediaPlayer.b(0);
        string = FlowReportProcessor.replaceUrlSftcNoP2p(string, this.mReportParams);
        this.setDataSourceBefore(string, null);
        this.mMediaPlayer.a(string);
        if (this.mReporter != null) {
            this.mReporter.a();
        }
    }

    public void setReadDataSourceType(int n2) {
        this.mMediaPlayer.b(n2);
    }

    public int getReadDataSourceType() {
        return this.mMediaPlayer.j();
    }

    public h getImgoMediaPlayer() {
        return this.mMediaPlayer;
    }

    public void setP2pDataSource(String string, @Nullable IP2pTask iP2pTask, @Nullable String string2, int n2) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        this.mSourceSwitching = false;
        this.mSourceSwitchingComplete = false;
        this.mHw2SwType = Hw2SwType.NONE;
        this.setPlayerReset(false);
        if (this.mEnableP2PHttpDns) {
            this.mDnsThreadManager.a();
            this.mDnsThreadManager.a(this.mHttpDnsNeedRetry);
            this.mDnsThreadManager.a(UrlUtil.getHostName(string));
        }
        string = FlowReportProcessor.replaceUrlSftcNoP2p(string, this.mReportParams);
        string2 = FlowReportProcessor.replaceUrlSftcNoP2p(string2, this.mReportParams);
        this.setDataSourceBefore(string, iP2pTask);
        this.mMediaPlayer.a(string, iP2pTask, string2, n2);
        if (this.mReporter != null) {
            this.mReporter.a();
        }
    }

    public void setDataSource(MgtvPlayerDataSource mgtvPlayerDataSource) throws IllegalArgumentException, SecurityException, IllegalStateException, IOException {
        this.mSourceSwitching = false;
        this.mSourceSwitchingComplete = false;
        this.mHw2SwType = Hw2SwType.NONE;
        this.setPlayerReset(false);
        this.mMediaPlayer.b(0);
        this.setDataSourceBefore("", null);
        this.mMediaPlayer.a(mgtvPlayerDataSource);
        if (this.mReporter != null) {
            this.mReporter.a();
        }
    }

    public void prepareAsync() throws IllegalStateException {
        DebugLog.i(this.getLogTag(), "prepareAsync in");
        this.mPlayStatus = PlayStatus.PREPARING;
        this.mIsVideoRendered = false;
        this.mPreBufferState.reset();
        if (this.isDnsCacheEnable() && this.mReportParams != null && this.mReportParams.getRetryIndex() >= 2 && this.mReportParams.getLastErrorCodeExtra() == 100701) {
            this.mHttpDnsEnable = true;
        }
        this.mPrepareAsyncTimeStampMs = System.currentTimeMillis();
        this.printErrorMd5();
        if (this.mObserver != null) {
            this.mObserver.register();
        }
        this.mInnerFlowDataStatistic.reset();
        if (!this.isSystemPlayer()) {
            FFmpegApi.remove_all_dns_cache();
        }
        this.mMediaPlayer.i();
        this.autoWanosAudioEffectChoice();
        DebugLog.i(this.getLogTag(), "prepareAsync out");
    }

    public void start() throws IllegalStateException {
        com.hunantv.media.player.subtitle.e e2;
        DebugLog.i(this.getLogTag(), "start player");
        this.mMediaPlayer.c();
        this.mPreBufferState.changeState(3);
        if (!this.mIsBuffering) {
            this.mPlayTicker.resume();
        }
        this.mBufferTick.resume();
        if (this.mGifRecorder != null) {
            this.mGifRecorder.resume();
        }
        if ((e2 = this.mTimeProvider) != null) {
            e2.a(false);
        }
        this.mPlayStatus = PlayStatus.PLAYING;
    }

    public void pause() throws IllegalStateException {
        com.hunantv.media.player.subtitle.e e2;
        DebugLog.i(this.getLogTag(), "pause player");
        if (this.mEnableDnsNoNetStrategy && this.mContext != null && !com.hunantv.media.report.c.d.c(this.mContext)) {
            this.pauseLoadData();
        }
        this.mMediaPlayer.a();
        this.mPlayTicker.pause();
        this.mBufferTick.pause();
        this.mPlayStatus = PlayStatus.PAUSED;
        if (this.mGifRecorder != null) {
            this.mGifRecorder.pause();
        }
        if ((e2 = this.mTimeProvider) != null) {
            e2.a(true);
        }
    }

    public void stop() throws IllegalStateException {
        DebugLog.i(this.getLogTag(), "stop player");
        if (this.mReporter != null) {
            this.mReporter.c();
        }
        this.resetData();
        this.mIsVideoRendered = false;
        this.mMediaPlayer.b();
        this.stopTickers();
    }

    public void setScreenOnWhilePlaying(boolean bl) {
        DebugLog.i(this.getLogTag(), "setScreenOnWhilePlaying in. screenOn:" + bl);
        this.mMediaPlayer.a(bl);
        DebugLog.i(this.getLogTag(), "setScreenOnWhilePlaying out.");
    }

    public int getVideoWidth() {
        return this.mMediaPlayer.e();
    }

    public int getVideoHeight() {
        return this.mMediaPlayer.f();
    }

    public boolean isPlaying() {
        return this.mMediaPlayer.g();
    }

    private int validSeekPosition(int n2) {
        int n3 = n2;
        int n4 = this.getDuration();
        if (this.mPlayStatus == PlayStatus.PREPARED) {
            if (n2 >= n4 - 1000) {
                DebugLog.i(this.getLogTag(), "validSeekPos seekTo failed, pos >=  duration - 1 * 1000, return -1");
                return -1;
            }
            if (n2 > n4 - 5000) {
                n3 = n4 - 5000;
            }
        }
        DebugLog.i(this.getLogTag(), "validSeekPos seekTo newMs:" + n3 + ",origMs:" + n2);
        return n3;
    }

    private void preSeekTo(int n2, boolean bl) {
        this.mSeekStartMs = System.currentTimeMillis();
        if (this.mMediaPlayer.j() == 1 || this.mMediaPlayer.j() == 2) {
            P2pMgr.setPlayingTimepoint(this.mMediaPlayer.af(), n2, true);
        }
        if (!this.mMediaPlayer.an()) {
            this.mpx = bl ? 10 : 9;
        }
    }

    public void seekTo(int n2) throws IllegalStateException {
        this.preSeekTo(n2, false);
        if (this.mReporter != null) {
            this.mReporter.d();
        }
        if ((n2 = this.validSeekPosition(n2)) >= 0) {
            this.mMediaPlayer.a(n2);
        }
    }

    public void seekTo(int n2, boolean bl) throws IllegalStateException {
        this.seekTo(n2, bl, false);
    }

    public void seekTo(int n2, boolean bl, boolean bl2) throws IllegalStateException {
        this.preSeekTo(n2, bl2);
        if (this.mReporter != null) {
            this.mReporter.d();
        }
        if ((n2 = this.validSeekPosition(n2)) >= 0) {
            this.mMediaPlayer.a(n2, bl);
        }
    }

    private int legalPosition(int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (this.getDuration() > 0 && n2 > this.getDuration()) {
            n2 = this.getDuration();
        }
        return n2;
    }

    public int getCurrentPosition() {
        try {
            if (this.checkInvalidThread(0, "getCurrentPosition")) {
                return 0;
            }
            return this.getCurrentPositionUnSafe();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugLog.e(this.getLogTag(), "getCurrentPosition Exception return 0");
            return 0;
        }
    }

    public int getCurrentPositionUnSafe() {
        try {
            int n2 = this.mMediaPlayer.k();
            if (this.mLastPosition > 0 && n2 == 0 && !this.mPositionLoged) {
                this.mPositionLoged = true;
                DebugLog.e(this.getLogTag(), "getCurrentPosition warning position mLastPosition:" + this.mLastPosition + ",position:" + n2 + " check it");
            }
            if (this.mPlayStatus == PlayStatus.ERROR && (this.mErrorExtraCodeStore == 100607 || this.mErrorExtraCodeStore == 100606)) {
                n2 -= 5000;
            }
            this.mLastPosition = this.legalPosition(n2);
            return this.mLastPosition;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DebugLog.e(this.getLogTag(), "getCurrentPositionUnSafe Exception return 0");
            return 0;
        }
    }

    private boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mPlayStatus != PlayStatus.ERROR && this.mPlayStatus != PlayStatus.IDLE && this.mPlayStatus != PlayStatus.PREPARING;
    }

    public int getDuration() {
        if (this.mPlayerType == 0) {
            if (this.isInPlaybackState()) {
                return this.mMediaPlayer.d();
            }
        } else {
            return this.mMediaPlayer.d();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        DebugLog.i(this.getLogTag(), "release player");
        if (this.mReporter != null) {
            this.mReporter.c();
            this.mReporter.f();
        }
        this.resetData();
        this.stopTickers();
        this.mIsVideoRendered = false;
        this.mPlayStatus = PlayStatus.IDLE;
        this.mErrorExtraCodeStore = -1;
        this.checkInvalidThread(2, "release");
        this.stop();
        this.mMediaPlayer.l();
        Object object = this.ptsLocker;
        synchronized (object) {
            this.ptsListeners.clear();
            if (this.ptsHandlerThread != null) {
                this.ptsHandlerThread.quitSafely();
                this.ptsHandlerThread = null;
            }
            if (this.ptsWeakHandler != null) {
                this.ptsWeakHandler.removeMessages(256);
                this.ptsWeakHandler = null;
            }
        }
        this.resetDataAfter();
    }

    public boolean reset() {
        DebugLog.i(this.getLogTag(), "reset player in");
        long l2 = System.currentTimeMillis();
        if (this.mReporter != null) {
            this.mReporter.c();
        }
        this.resetData();
        this.stopTickers();
        this.mIsVideoRendered = false;
        this.mPlayStatus = PlayStatus.IDLE;
        this.mHw2SwType = Hw2SwType.NONE;
        this.mErrorExtraCodeStore = -1;
        this.checkInvalidThread(1, "reset");
        this.stop();
        boolean bl = this.mMediaPlayer.h();
        this.resetDataAfter();
        DebugLog.i(this.getLogTag(), "reset player out cost:" + (System.currentTimeMillis() - l2) + " ms");
        return bl;
    }

    private boolean checkInvalidThread(int n2, String string) {
        if (this.mMainThreadID != -1L && this.mMainThreadID != Thread.currentThread().getId()) {
            if (this.mOnWarningListener != null) {
                String string2 = "";
                if (this.mReportParams != null) {
                    string2 = string2 + "videotype:" + this.mReportParams.getVideoType().ordinal();
                }
                string2 = string2 + string + " invalid thread. MainThread:" + this.mMainThreadID + ",CurrentThread:" + Thread.currentThread().getId();
                if (n2 == 0) {
                    if (this.mIsGetPositionCallback) {
                        return true;
                    }
                    this.mIsGetPositionCallback = true;
                    DebugLog.i(this.getLogTag(), "checkInvalidThread " + n2 + string2);
                    return true;
                }
                this.mOnWarningListener.onWarning(800005, n2 + "", string2, null);
            }
            return true;
        }
        return false;
    }

    private void setPlayerReset(boolean bl) {
        this.mPlayerReset = bl;
        this.mLoopPlayerReset = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLoopDataImpl() {
        this.mSeekStartMs = -1L;
        this.imp4dh = 0;
        this.mpx = 0;
        this.fstime = "n";
        this.mcColorFormat = "n_n";
        this.mLastTsSkipErrExtra = 0;
        this.mLastTsSkipErrFileName = null;
        this.mLastIsNetworkAvailableNNS = true;
        if (this.mGifRecorder != null) {
            this.mGifRecorder.reset();
        }
        this.mIsVideoRendered = false;
        this.mSourceSwitching = false;
        this.mSourceSwitchingComplete = false;
        this.mErrorUrl = "";
        this.mLastRequestUrl = "";
        this.mIsBuffering = false;
        this.mIsLive = false;
        this.mCacheM3u8Path = null;
        this.mCacheTsPaths = null;
        this.mCacheReplaceMap.clear();
        this.mTsCacheSkipNum = 0;
        this.mIsInnerRetrying = false;
        this.mRetryLastErrorCode = 0;
        this.mLoopPlayerReset = true;
        Object object = this.mDnsLock;
        synchronized (object) {
            this.mDnsLock.notifyAll();
        }
        this.mHttpDnsEnable = false;
        this.mLastUri = null;
        this.mCurrentDnsDsc = DNS_NATIVE;
        this.mLastIP = null;
        this.mLastP2pCdnIP = null;
        this.mLastHostIP = null;
        this.mLastTcpIP = null;
        this.mLastHostErr = "00";
        this.mLastTcpErr = "00";
        this.mLastIpCount = 0;
        this.mLastIpIndex = -1;
        this.mLastDnsType = -1;
        this.mSourceRetryCount = 0;
        this.mSourceRetryCode = 0;
        this.mAVSyncErrReported = false;
        this.mAVSyncErrSumReported = false;
        this.mAVSyncErrSum = 0;
        this.mPrepareAsyncTimeStampMs = 0L;
        this.mReportedTSLAN = false;
        this.mIsAudioExist = -1;
        this.mIsInitMp4Error = false;
        this.mPlaybackSpeed = 1.0f;
        this.clearIPCache();
        this.mCodecName = "n";
        this.hdrInfo = "n";
        this.mVideoFrameClockNotifyMs = -1;
        this.mNetworkChangeWhilePlaying = false;
        this.mInnerFlowDataStatistic.reset();
        this.mLastPosition = 0;
        this.mPositionLoged = false;
        this.mVVbuft = -1;
        object = this.mDnsNoNetWaiter;
        synchronized (object) {
            DebugLog.i(this.getLogTag(), "resetLoopData DnsNetStrategy mDnsNoNetWaiter notifyAll");
            this.mDnsNoNetWaiter.notifyAll();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        PlayerReferenceObserver.remove(this.hashCode() + "");
        if (this.mObserver != null) {
            this.mObserver.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDataAfter() {
        if (this.isFlowReportEnable && this.mMainFlowReportProcessor != null) {
            this.mMainFlowReportProcessor.stop();
        }
        for (Map.Entry<Integer, SmoothMediaSource> entry : this.mSmoothSourcesRecord.entrySet()) {
            SmoothMediaSource smoothMediaSource = entry.getValue();
            if (!this.isFlowReportEnable || smoothMediaSource == null || smoothMediaSource.getFlowReportProcessor() == null) continue;
            smoothMediaSource.getFlowReportProcessor().stop();
        }
        Object object = this.mSwitchSmoothSourceLocker;
        synchronized (object) {
            this.mSwitchingSmoothSource = null;
            this.mSwitchedSmoothSource = null;
            this.mSmoothSourcesRecord.clear();
            this.mSmoothKeyFrameMap.clear();
            this.mReporter = new com.hunantv.media.report.a(this.mContext, this);
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.a(this.mReporter);
                this.mMediaPlayer.c(false);
            }
            this.mSmoothUseP2pFailed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetData() {
        this.isExAudioEnable = NetPlayConfig.isWanosAudioEnable();
        this.waev = null;
        this.mSeekStartMs = -1L;
        this.imp4dh = 0;
        this.mpx = 0;
        this.fstime = "n";
        this.mcColorFormat = "n_n";
        this.mLastTsSkipErrExtra = 0;
        this.mLastTsSkipErrFileName = null;
        this.mLastIsNetworkAvailableNNS = true;
        if (this.isRfpsLow() && this.rfpsLowFilterChanged) {
            DebugLog.e(this.getLogTag(), "resetData rfps too low, close opengl next time");
            j.a = true;
        }
        if (this.mGifRecorder != null) {
            this.mGifRecorder.reset();
        }
        this.removeSubtitleSources();
        this.mIsGetPositionCallback = false;
        this.mSourceSwitching = false;
        this.mSourceSwitchingComplete = false;
        this.mPrepared = false;
        this.mErrorUrl = "";
        this.mLastRequestUrl = "";
        this.mIsBuffering = false;
        this.mIsLive = false;
        this.mWeakTimer = 0;
        this.mCacheM3u8Path = null;
        this.mCacheTsPaths = null;
        this.mCacheReplaceMap.clear();
        this.mTsCacheSkipNum = 0;
        this.mIsInnerRetrying = false;
        this.mRetryLastErrorCode = 0;
        this.mRenderDisableWarnSended = false;
        this.mRealEncodeType = -1;
        this.setPlayerReset(true);
        Iterator<Map.Entry<Integer, SmoothMediaSource>> iterator = this.mDnsLock;
        synchronized (iterator) {
            this.mDnsLock.notifyAll();
        }
        this.mHttpDnsEnable = false;
        this.mLastUri = null;
        this.mCurrentDnsDsc = DNS_NATIVE;
        this.mLastIP = null;
        this.mLastP2pCdnIP = null;
        this.mLastHostIP = null;
        this.mLastTcpIP = null;
        this.mLastHostErr = "00";
        this.mLastTcpErr = "00";
        this.mLastIpCount = 0;
        this.mLastIpIndex = -1;
        this.mLastDnsType = -1;
        this.mSourceRetryCount = 0;
        this.mSourceRetryCode = 0;
        this.mAVSyncErrReported = false;
        this.mAVSyncErrSumReported = false;
        this.mAVSyncErrSum = 0;
        this.mPrepareAsyncTimeStampMs = 0L;
        this.mReportedTSLAN = false;
        this.mIsAudioExist = -1;
        this.mIsP2pTSSkipReport = false;
        this.mIsInitMp4Error = false;
        this.mSmt = 0L;
        this.mDlt = 0L;
        this.mPlaybackSpeed = 1.0f;
        this.clearIPCache();
        this.mCodecName = "n";
        this.hdrInfo = "n";
        this.mVideoFrameClockNotifyMs = -1;
        if (this.mObserver != null) {
            this.mObserver.unregister();
        }
        this.mNetworkChangeWhilePlaying = false;
        this.mCacheReportTag = DEFAULT_CACHE_REPORT_TAG;
        this.mInnerFlowDataStatistic.reset();
        this.mPreBufferState.reset();
        this.avdiffS = 0;
        this.sfps = 0;
        this.vfps = 0;
        this.rfps = 0;
        this.rfpsLowCounter = 0;
        this.rfpsLowFilterChanged = false;
        this.mLastPosition = 0;
        this.mPositionLoged = false;
        this.mVVbuft = -1;
        this.mDnsThreadManager.b();
        iterator = this.mDnsNoNetWaiter;
        synchronized (iterator) {
            DebugLog.i(this.getLogTag(), "resetData DnsNetStrategy mDnsNoNetWaiter notifyAll");
            this.mDnsNoNetWaiter.notifyAll();
        }
        for (Map.Entry<Integer, SmoothMediaSource> entry : this.mSmoothSourcesRecord.entrySet()) {
            SmoothMediaSource smoothMediaSource = entry.getValue();
            if (smoothMediaSource == null || smoothMediaSource.isReleased()) continue;
            smoothMediaSource.release();
        }
    }

    private void clearIPCache() {
        if (this.mIPCacheMap != null && !this.mIPCacheMap.isEmpty()) {
            DebugLog.i(this.getLogTag(), "callback ipcache clear");
            this.mIPCacheMap.clear();
        }
    }

    public int getBufferingPercent() {
        return this.mMediaPlayer.o();
    }

    public int getBufferedPercentage() {
        return this.mMediaPlayer.p();
    }

    public long getBufferedPositionMs() {
        return this.mMediaPlayer.q();
    }

    public void setOnPreparedListener(MgtvPlayerListener.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setOnStartListener(MgtvPlayerListener.OnStartListener onStartListener) {
        this.mOnStartListener = onStartListener;
    }

    public void setOnPauseListener(MgtvPlayerListener.OnPauseListener onPauseListener) {
        this.mOnPauseListener = onPauseListener;
    }

    public void setOnCompletionListener(MgtvPlayerListener.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnBufferingUpdateListener(MgtvPlayerListener.OnBufferingUpdateListener onBufferingUpdateListener) {
        this.mMediaPlayer.a(onBufferingUpdateListener);
    }

    public void setOnSeekCompleteListener(MgtvPlayerListener.OnSeekCompleteListener onSeekCompleteListener) {
        this.mOnSeekCompleteListener = onSeekCompleteListener;
    }

    public void setOnVideoSizeChangedListener(MgtvPlayerListener.OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.mMediaPlayer.a(onVideoSizeChangedListener);
    }

    public void setOnErrorListener(MgtvPlayerListener.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnInfoListener(MgtvPlayerListener.OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    public void setOnInfoStringListener(MgtvPlayerListener.OnInfoStringListener onInfoStringListener) {
        this.mOnInfoStringListener = onInfoStringListener;
    }

    public void setOnBufferingTimeoutListener(MgtvPlayerListener.OnBufferingTimeoutListener onBufferingTimeoutListener) {
        this.mOnBufferingTimeoutListener = onBufferingTimeoutListener;
    }

    @TargetApi(value=14)
    public void setSurface(Surface surface) {
        this.mMediaPlayer.a(surface);
    }

    private void initReporter(Context context) {
        if (this.mEnableReport) {
            this.mReporter = new com.hunantv.media.report.a(context, this);
            this.mReporterSL = new com.hunantv.media.report.a(context, this, true);
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.a(this.mReporter);
            }
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.b(this.mReporterSL);
            }
        }
    }

    public void setReportParams(ReportParams reportParams) {
        this.mReportParams = reportParams;
        DebugLog.i(this.getLogTag(), "setReportParams params:" + reportParams);
        if (this.mReporter != null) {
            this.mReporter.a(reportParams);
        }
        if (this.mReporterSL != null) {
            this.mReporterSL.a(reportParams);
        }
        if (this.mMediaPlayer != null && reportParams != null) {
            this.mMediaPlayer.b(String.valueOf(reportParams.getProxyType().ordinal()));
        }
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(reportParams);
        }
        if (this.mReportParams != null && (this.mReportParams.getVideoType().equals((Object)ReportParams.VideoType.AD_PRE) || this.mReportParams.getVideoType().equals((Object)ReportParams.VideoType.AD_MID))) {
            this.mWeakBufferTimeoutMs = 60000;
        }
    }

    private boolean onRenderStart() {
        if (!this.isRendered()) {
            this.mIsVideoRendered = true;
            this.mPlayTicker.start();
            if (this.mReporter != null) {
                this.mReporter.b();
            }
            return false;
        }
        if (this.mIsInnerRetrying && this.mOnWarningListener != null) {
            this.mOnWarningListener.onWarning(801012, this.getRetryLastErrorCode() + "", "", null);
        }
        return true;
    }

    private boolean onBufferStart(String string) {
        DebugLog.i(this.getLogTag(), "onBufferStart");
        com.hunantv.media.player.subtitle.e e2 = this.mTimeProvider;
        if (e2 != null) {
            e2.b(true);
        }
        if (this.mGifRecorder != null) {
            this.mGifRecorder.pause();
        }
        this.mIsBuffering = true;
        this.mPlayTicker.pause();
        if (!this.isLoadDataPaused() && !UrlUtil.isLocal(this.getPlayingUrl())) {
            this.mBufferTick.start();
        }
        if (this.mReporter != null) {
            this.mReporter.a(string);
        }
        return false;
    }

    public boolean isLoadDataPaused() {
        return this.mMediaPlayer != null && !this.mMediaPlayer.y();
    }

    private boolean onBufferEnd(String string) {
        DebugLog.i(this.getLogTag(), "onBufferEnd");
        com.hunantv.media.player.subtitle.e e2 = this.mTimeProvider;
        if (e2 != null) {
            e2.b(false);
        }
        if (this.mGifRecorder != null) {
            this.mGifRecorder.resume();
        }
        this.mWeakTimer = 0;
        this.mIsBuffering = false;
        this.mBufferTick.stop();
        if (this.isPlaying()) {
            this.mPlayTicker.resume();
        }
        if (this.mReporter != null) {
            this.mReporter.b(string);
        }
        return false;
    }

    private void initListener() {
        if (this.mMediaPlayer == null) {
            return;
        }
        this.mMediaPlayer.a(new MgtvPlayerListener.OnPreparedListener(){

            @Override
            public void onPrepared() {
                if (MgtvMediaPlayer.this.mMainFlowReportProcessor != null) {
                    MgtvMediaPlayer.this.mMainFlowReportProcessor.setDuration(MgtvMediaPlayer.this.getDuration());
                }
                if (MgtvMediaPlayer.this.mIsInnerRetrying && MgtvMediaPlayer.this.mPrepared) {
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onPrepared mIsInnerRetrying:" + MgtvMediaPlayer.this.mIsInnerRetrying + ",mPrepared:" + MgtvMediaPlayer.this.mPrepared + ",isPlaying:" + MgtvMediaPlayer.this.isPlaying());
                    if (MgtvMediaPlayer.this.mPlayStatus == PlayStatus.PLAYING) {
                        MgtvMediaPlayer.this.start();
                    }
                    return;
                }
                MgtvMediaPlayer.this.mPlayStatus = PlayStatus.PREPARED;
                MgtvMediaPlayer.this.mPrepared = true;
                if (MgtvMediaPlayer.this.mSubtitleController != null) {
                    MgtvMediaPlayer.this.mSubtitleController.b();
                }
                if (MgtvMediaPlayer.this.mOnPreparedListener != null) {
                    MgtvMediaPlayer.this.mOnPreparedListener.onPrepared();
                }
                if (MgtvMediaPlayer.this.mReportParams != null && MgtvMediaPlayer.this.mReportParams.getVideoType() == ReportParams.VideoType.VOD && ImgoLibLoader.getInstance().isBackUpLoaderSuccess() && MgtvMediaPlayer.this.mOnWarningListener != null) {
                    MgtvMediaPlayer.this.mOnWarningListener.onWarning(800006, "0", ImgoLibLoader.getInstance().getBackUpLoaderSoMsg(), null);
                    ImgoLibLoader.getInstance().setBackUpLoaderSuccess(false);
                }
            }
        });
        this.mMediaPlayer.a(new MgtvPlayerListener.OnInfoListener(){

            @Override
            public boolean onInfo(int n2, int n3) {
                block0 : switch (n2) {
                    case 3: {
                        if (!MgtvMediaPlayer.this.onRenderStart()) break;
                        return false;
                    }
                    case 5: {
                        if (n3 == 503) {
                            MgtvMediaPlayer.this.mHw2SwType = Hw2SwType.HW_2_SW_RESET;
                            break;
                        }
                        if (n3 == 501 || n3 == 504 || n3 == 505 || n3 == 506) {
                            MgtvMediaPlayer.this.mHw2SwType = Hw2SwType.HW_2_SW_DEFAULT;
                            break;
                        }
                        MgtvMediaPlayer.this.mHw2SwType = Hw2SwType.HW_2_SW_OTHER;
                        break;
                    }
                    case 701: {
                        if (!MgtvMediaPlayer.this.onBufferStart(String.valueOf(n3))) break;
                        return false;
                    }
                    case 702: {
                        if (!MgtvMediaPlayer.this.onBufferEnd(String.valueOf(n3))) break;
                        return false;
                    }
                    case 2803: {
                        switch (n3) {
                            default: {
                                MgtvMediaPlayer.this.mDataSourceType = DataSourceType.TYPE_DATASOUCE_DEFAULT;
                                break block0;
                            }
                            case 1: 
                        }
                        MgtvMediaPlayer.this.mDataSourceType = DataSourceType.TYPE_DATASOUCE_IMGO;
                        break;
                    }
                    case 801: {
                        n2 = 801;
                        if (n3 == 1) {
                            MgtvMediaPlayer.this.mIsLive = true;
                            if (MgtvMediaPlayer.this.mOnWarningListener == null || MgtvMediaPlayer.this.mReportParams == null || MgtvMediaPlayer.this.mReportParams.getVideoType() != ReportParams.VideoType.VOD) break;
                            String string = MgtvMediaPlayer.this.mReportParams != null ? MgtvMediaPlayer.this.mReportParams.getP2ps() + "" : "00";
                            MgtvMediaPlayer.this.mOnWarningListener.onWarning(800020, string, "psuuid_" + MgtvMediaPlayer.this.mReporter.g(), null);
                            break;
                        }
                        MgtvMediaPlayer.this.mIsLive = false;
                        break;
                    }
                    case 2830: {
                        if (n3 == d.t.e.ordinal()) {
                            if (MgtvMediaPlayer.this.mOnStartListener == null) break;
                            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback onStart threadId:" + Thread.currentThread().getId());
                            MgtvMediaPlayer.this.mOnStartListener.onStart();
                            break;
                        }
                        if (n3 != d.t.f.ordinal() || MgtvMediaPlayer.this.mOnPauseListener == null) break;
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "callback onPause threadId:" + Thread.currentThread().getId());
                        MgtvMediaPlayer.this.mOnPauseListener.onPause();
                        break;
                    }
                    case 2840: {
                        DebugLog.w(MgtvMediaPlayer.this.getLogTag(), "encode type extra:" + n3);
                        MgtvMediaPlayer.this.mRealEncodeType = n3;
                        break;
                    }
                    case 2806: {
                        DebugLog.w(MgtvMediaPlayer.this.getLogTag(), "stream format type extra:" + n3);
                        MgtvMediaPlayer.this.mStreamFormatType = n3;
                        break;
                    }
                    case 10010: {
                        DebugLog.w(MgtvMediaPlayer.this.getLogTag(), "speed play error,will disable video render!");
                        if (MgtvMediaPlayer.this.mRenderDisableWarnSended || MgtvMediaPlayer.this.mOnWarningListener == null) break;
                        MgtvMediaPlayer.this.mRenderDisableWarnSended = true;
                        MgtvMediaPlayer.this.mOnWarningListener.onWarning(800008, n3 + "", "", null);
                        break;
                    }
                    case 10020: {
                        DebugLog.w(MgtvMediaPlayer.this.getLogTag(), "audio stream is exist:" + n3);
                        MgtvMediaPlayer.this.mIsAudioExist = n3;
                        break;
                    }
                    case 10024: {
                        DebugLog.w(MgtvMediaPlayer.this.getLogTag(), "vsr is open:" + n3);
                        MgtvMediaPlayer.this.mIsVsrOpen = n3;
                        break;
                    }
                    case 10022: {
                        DebugLog.w(MgtvMediaPlayer.this.getLogTag(), "wanos audio effect valid:" + n3);
                        MgtvMediaPlayer.this.mIsWanosAudioEffectValid = n3 == 1;
                        break;
                    }
                    case 10023: {
                        DebugLog.w(MgtvMediaPlayer.this.getLogTag(), "wanos dlopen status:" + n3);
                        MgtvMediaPlayer.this.wadls = n3;
                        break;
                    }
                    case 10021: {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "native load data is paused:" + n3);
                        MgtvMediaPlayer.this.mIsNativePausedLoadData = n3;
                        if (n3 != 1 || MgtvMediaPlayer.this.mOnLoadDataListener == null) break;
                        MgtvMediaPlayer.this.mOnLoadDataListener.onAfterLoadDataPaused();
                        break;
                    }
                    case 2850: {
                        if (MgtvMediaPlayer.this.mOnWarningListener == null) break;
                        MgtvMediaPlayer.this.updateFpsInfo();
                        String string = n3 + "_" + (MgtvMediaPlayer.this.isHardware() ? 1 : 0) + "_" + MgtvMediaPlayer.this.getResolution() + "_" + MgtvMediaPlayer.this.getFpsMsg();
                        if (!MgtvMediaPlayer.this.mAVSyncErrReported) {
                            MgtvMediaPlayer.this.mOnWarningListener.onWarning(800500, string, "", null);
                            MgtvMediaPlayer.this.mAVSyncStartTimestamp = System.currentTimeMillis();
                            MgtvMediaPlayer.this.mAVSyncErrReported = true;
                        }
                        if (MgtvMediaPlayer.this.mAVSyncErrSumReported) break;
                        MgtvMediaPlayer.this.mAVSyncErrSum++;
                        if (System.currentTimeMillis() - MgtvMediaPlayer.this.mAVSyncStartTimestamp < 10000L) break;
                        MgtvMediaPlayer.this.mOnWarningListener.onWarning(800501, string + "_" + MgtvMediaPlayer.this.mAVSyncErrSum, "", null);
                        MgtvMediaPlayer.this.mAVSyncErrSumReported = true;
                        break;
                    }
                    case 810: {
                        DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "MEDIA_INFO_STREAM_INFO_HLS_SEG_SIZE_INFO:" + n3);
                        break;
                    }
                    case 8: {
                        int n4;
                        if (MgtvMediaPlayer.this.mFlowDataStatistic != null) {
                            MgtvMediaPlayer.this.mFlowDataStatistic.addBytes(n3);
                        }
                        MgtvMediaPlayer.this.mInnerFlowDataStatistic.addBytes(n3);
                        if (MgtvMediaPlayer.this.mMainFlowReportProcessor != null) {
                            MgtvMediaPlayer.this.mMainFlowReportProcessor.getFlowStatistic().addBytes(n3);
                        }
                        if ((n4 = (int)(MgtvMediaPlayer.this.mMediaPlayer.ai() / 1000L)) > MgtvMediaPlayer.this.mPreBufferMaxS && MgtvMediaPlayer.this.mPreBufferState.getState() == 1) {
                            MgtvMediaPlayer.this.mPreBufferState.changeState(1, 2);
                        }
                        return false;
                    }
                    case 10030: {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "native prepared change water mark ms:" + n3);
                        MgtvMediaPlayer.this.mVVbuft = n3 / 1000;
                        return false;
                    }
                    case 2890: {
                        DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "MEDIA_INFO_M3U8_EXIST_DATA:" + n3);
                        MgtvMediaPlayer.this.imp4dh = n3;
                        return false;
                    }
                    case 2880: {
                        MgtvMediaPlayer.this.mpx = n3;
                        return false;
                    }
                }
                if (MgtvMediaPlayer.this.mOnInfoListener != null) {
                    return MgtvMediaPlayer.this.mOnInfoListener.onInfo(n2, n3);
                }
                return false;
            }
        });
        this.mMediaPlayer.a(new MgtvPlayerListener.OnInfoStringListener(){

            @Override
            public boolean onInfo(int n2, String string) {
                switch (n2) {
                    case 2860: {
                        if (StringUtil.isEmpty(string)) break;
                        String[] stringArray = string.split("-");
                        if (stringArray != null && stringArray.length >= 2) {
                            MgtvMediaPlayer.this.mSmt = NumericUtil.parseLong(stringArray[0], -1L);
                            MgtvMediaPlayer.this.mDlt = NumericUtil.parseLong(stringArray[1], -1L);
                            break;
                        }
                        MgtvMediaPlayer.this.mSmt = -2L;
                        MgtvMediaPlayer.this.mDlt = -2L;
                        break;
                    }
                    case 2870: {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "MEDIA_INFO_VIDEO_STREAM_CODEC_NAME:" + string);
                        if (StringUtil.isEmpty(string)) break;
                        try {
                            String[] stringArray = string.split("-");
                            if (stringArray == null || stringArray.length < 3) break;
                            MgtvMediaPlayer.this.mCodecName = stringArray[1];
                            MgtvMediaPlayer.this.hdrInfo = stringArray[2];
                            DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "MEDIA_INFO_VIDEO_STREAM_CODEC_NAME mCodecName:" + MgtvMediaPlayer.this.mCodecName + ",hdrInfo:" + MgtvMediaPlayer.this.hdrInfo);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 2891: {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "MEDIA_INFO_FILE_START_TIME value:" + string);
                        MgtvMediaPlayer.this.fstime = string;
                        break;
                    }
                    case 2900: {
                        MgtvMediaPlayer.this.mcColorFormat = string;
                        break;
                    }
                    case 2901: {
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "MEDIA_INFO_FILE_ENCODE_INFO value:" + string);
                        if (StringUtil.isEmpty(string) || string.length() <= 0) break;
                        try {
                            SmoothMediaSource smoothMediaSource;
                            String[] stringArray = string.split(",");
                            if (stringArray == null || stringArray.length < 6) break;
                            int n3 = NumericUtil.parseInt(StringUtil.parseValue(stringArray[0], ":"), -1);
                            int n4 = NumericUtil.parseInt(StringUtil.parseValue(stringArray[1], ":"), 0);
                            String string2 = StringUtil.parseValue(stringArray[2], ":");
                            int n5 = NumericUtil.parseInt(StringUtil.parseValue(stringArray[3], ":"), 0);
                            int n6 = NumericUtil.parseInt(StringUtil.parseValue(stringArray[4], ":"), 0);
                            int n7 = NumericUtil.parseInt(StringUtil.parseValue(stringArray[5], ":"));
                            FlowReportProcessor flowReportProcessor = null;
                            if (MgtvMediaPlayer.this.isFlowReportEnable) {
                                flowReportProcessor = MgtvMediaPlayer.this.mMainFlowReportProcessor;
                            }
                            if ((smoothMediaSource = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get(n3)) != null) {
                                ReportParams reportParams = smoothMediaSource.getReportParams();
                                if (reportParams != null) {
                                    reportParams.setEncinfo(string2);
                                }
                                if (MgtvMediaPlayer.this.isFlowReportEnable) {
                                    if (smoothMediaSource.getFlowReportProcessor() == null) {
                                        smoothMediaSource.genFlowReporter();
                                    }
                                    flowReportProcessor = smoothMediaSource.getFlowReportProcessor();
                                }
                            } else if (MgtvMediaPlayer.this.mReportParams != null) {
                                MgtvMediaPlayer.this.mReportParams.setEncinfo(string2);
                            }
                            if (!MgtvMediaPlayer.this.isFlowReportEnable || flowReportProcessor == null) break;
                            flowReportProcessor.start(n4, n5, n6, string2, n7);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    case 2902: {
                        MgtvMediaPlayer.this.waev = string;
                        DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "MEDIA_INFO_WANOS_EFFECT_INFO value:" + string);
                    }
                }
                if (MgtvMediaPlayer.this.mOnInfoStringListener != null) {
                    return MgtvMediaPlayer.this.mOnInfoStringListener.onInfo(n2, string);
                }
                return false;
            }
        });
        this.mMediaPlayer.a(this.mErrorListener);
        this.mMediaPlayer.a(new MgtvPlayerListener.OnCompletionListener(){

            @Override
            public void onCompletion(int n2, int n3) {
                if (MgtvMediaPlayer.this.mGifRecorder != null) {
                    MgtvMediaPlayer.this.mGifRecorder.interrupt(102);
                }
                MgtvMediaPlayer.this.stopTickers();
                if (MgtvMediaPlayer.this.mReporter != null) {
                    MgtvMediaPlayer.this.mReporter.a(n2, n3);
                }
                if (n2 != 0 && MgtvMediaPlayer.this.mReportParams != null && MgtvMediaPlayer.this.mReportParams.getVideoType() == ReportParams.VideoType.VOD && MgtvMediaPlayer.this.mOnWarningListener != null) {
                    MgtvMediaPlayer.this.mOnWarningListener.onWarning(800009, n3 + "", "", null);
                }
                MgtvMediaPlayer.this.mPlayStatus = PlayStatus.COMPLETED;
                if (MgtvMediaPlayer.this.mOnCompletionListener != null) {
                    MgtvMediaPlayer.this.mOnCompletionListener.onCompletion(n2, n3);
                }
            }
        });
        this.mMediaPlayer.a(new MgtvPlayerListener.OnSeekCompleteListener(){

            @Override
            public void onSeekComplete(int n2, int n3) {
                com.hunantv.media.player.subtitle.e e2;
                if (MgtvMediaPlayer.this.mSeekStartMs > 0L) {
                    DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "onSeekComplete cost:" + (System.currentTimeMillis() - MgtvMediaPlayer.this.mSeekStartMs) + " ms");
                }
                if ((e2 = MgtvMediaPlayer.this.mTimeProvider) != null) {
                    e2.onSeekComplete(n2, n3);
                }
                if (MgtvMediaPlayer.this.mReporter != null) {
                    MgtvMediaPlayer.this.mReporter.e();
                }
                if (MgtvMediaPlayer.this.mOnSeekCompleteListener != null) {
                    MgtvMediaPlayer.this.mOnSeekCompleteListener.onSeekComplete(n2, n3);
                }
            }
        });
        this.mMediaPlayer.a(new MgtvPlayerListener.OnSwitchSourceListener(){

            @Override
            public void onSwitchSourceInfo(String string, int n2, int n3) {
                if (n2 == 2) {
                    MgtvMediaPlayer.this.mSwitchingPrepared = true;
                }
                if (MgtvMediaPlayer.this.mOnSwitchSourceListener != null) {
                    MgtvMediaPlayer.this.mOnSwitchSourceListener.onSwitchSourceInfo(string, n2, n3);
                }
            }

            @Override
            public void onSwitchSourceComplete(String string, int n2, int n3) {
                if (MgtvMediaPlayer.this.mReporterSL != null) {
                    MgtvMediaPlayer.this.mReporterSL.b();
                    MgtvMediaPlayer.this.mSourceSwitchingComplete = true;
                    MgtvMediaPlayer.this.mSourceSwitching = false;
                    if (n2 == 0) {
                        if (MgtvMediaPlayer.this.mReportParams != null) {
                            MgtvMediaPlayer.this.mReportParams.setP2ps(MgtvMediaPlayer.this.mMediaPlayer.v());
                        }
                        if (MgtvMediaPlayer.this.mReporter != null) {
                            MgtvMediaPlayer.this.mReporter.c(MgtvMediaPlayer.this.mReporterSL.g());
                        }
                    }
                }
                if (MgtvMediaPlayer.this.mOnSwitchSourceListener != null) {
                    MgtvMediaPlayer.this.mOnSwitchSourceListener.onSwitchSourceComplete(string, n2, n3);
                }
            }

            @Override
            public void onSwitchSourceFailed(String string, int n2, int n3) {
                MgtvMediaPlayer.this.reportError(n2, n3, "");
                if (MgtvMediaPlayer.this.mOnSwitchSourceListener != null) {
                    MgtvMediaPlayer.this.mOnSwitchSourceListener.onSwitchSourceFailed(string, n2, n3);
                }
            }
        });
        this.mMediaPlayer.a(new MgtvPlayerListener.OnBufferingTimeoutListener(){

            @Override
            public boolean onBufferingTimeout(int n2, int n3) {
                return MgtvMediaPlayer.this.callBufferingTimeout(n2, n3, "");
            }
        });
        this.mMediaPlayer.a(this.mSourceNetListner);
        this.mMediaPlayer.a(new MgtvPlayerListener.OnPlayerEventListener(){

            @Override
            public void onInfo(int n2, int n3) {
                switch (n2) {
                    case 3: {
                        DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "chodison player event oninfo MEDIA_INFO_VIDEO_RENDERING_START: t6:" + n3);
                        break;
                    }
                    case 9: {
                        DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "chodison player event oninfo MEDIA_INFO_VV_BUFFER_PREPARED: VVBT:" + n3);
                        break;
                    }
                    default: {
                        DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "chodison player event oninfo what: " + n2 + ",extra:" + n3);
                    }
                }
                if (MgtvMediaPlayer.this.mOnPlayerEventListener != null) {
                    MgtvMediaPlayer.this.mOnPlayerEventListener.onInfo(n2, n3);
                }
            }
        });
        this.mMediaPlayer.a(new MgtvPlayerListener.OnRecordVideoListener(){

            @Override
            public void onRecordVideoInfo(int n2, int n3) {
                MgtvMediaPlayer.this.callbackRecordInfo(n2, n3);
            }

            @Override
            public void onRecordVideoErr(int n2, int n3) {
                MgtvMediaPlayer.this.callbackRecordError(n2, n3);
            }
        });
        this.mMediaPlayer.a(this.mSmoothSourceListener);
        this.mMediaPlayer.a(new MgtvPlayerListener.OnGetFrameImageListener(){

            @Override
            public void onGetFrameImageStatus(int n2, int n3) {
                if (MgtvMediaPlayer.this.mOnGetFrameImageListener != null) {
                    MgtvMediaPlayer.this.mOnGetFrameImageListener.onGetFrameImageStatus(n2, n3);
                }
            }

            @Override
            public void onGetFrameImageInfo(int n2, int n3, String string) {
                if (MgtvMediaPlayer.this.mOnGetFrameImageListener != null) {
                    MgtvMediaPlayer.this.mOnGetFrameImageListener.onGetFrameImageInfo(n2, n3, string);
                }
            }
        });
        this.mMediaPlayer.a(new MgtvPlayerListener.OnSourceFlowHandledListener(){

            @Override
            public void onSourceFlowInfoEvent(int n2, Bundle bundle) {
                if (n2 == 78593 && bundle != null) {
                    String string = bundle.getString("flow_switch_url");
                    long l2 = bundle.getLong("flow_switch_key");
                    long l3 = bundle.getLong("flow_seg_index");
                    long l4 = bundle.getLong("flow_seg_nums");
                    long l5 = bundle.getLong("flow_seg_starttime");
                    long l6 = bundle.getLong("flow_seg_dur");
                    long l7 = bundle.getLong("flow_cur_dl_size");
                    long l8 = bundle.getLong("flow_file_size");
                    int n3 = bundle.getInt("flow_stream_type");
                    int n4 = bundle.getInt("flow_error_type");
                    int n5 = bundle.getInt("flow_error_code");
                    DebugLog.ifmt(MgtvMediaPlayer.this.getLogTag(), "onSourceFlowInfoEvent: flow_stream_type:%d, flow_error_type:%d, flow_error_code:%d, flow_switch_key:%d, flow_seg_index:%d, flow_seg_nums:%d, flow_seg_starttime:%d, flow_seg_dur:%d, flow_cur_dl_size:%d, flow_file_size:%d, flow_swithc_url:%s ", n3, n4, n5, l2, l3, l4, l5, l6, l7, l8, string);
                    FlowReportEntity flowReportEntity = new FlowReportEntity();
                    flowReportEntity.url = string;
                    flowReportEntity.file_size = l8;
                    flowReportEntity.down_size = l7;
                    flowReportEntity.error_type = n4;
                    flowReportEntity.error_code = n5;
                    flowReportEntity.file_dur = new DecimalFormat("0.000000").format((float)l6 / 1000000.0f) + "";
                    flowReportEntity.file_seq = l3 + "";
                    if (MgtvMediaPlayer.this.isFlowReportEnable) {
                        FlowReportProcessor flowReportProcessor = MgtvMediaPlayer.this.mMainFlowReportProcessor;
                        SmoothMediaSource smoothMediaSource = (SmoothMediaSource)MgtvMediaPlayer.this.mSmoothSourcesRecord.get((int)l2);
                        if (smoothMediaSource != null) {
                            flowReportProcessor = smoothMediaSource.getFlowReportProcessor();
                        }
                        if (flowReportProcessor != null) {
                            flowReportProcessor.pushPlayerFlowInfo(flowReportEntity);
                        }
                    }
                }
            }
        });
        this.mPlayTicker.setHostLogTag(this.getLogTag());
        this.mPlayTicker.setCallback(new ExTicker.onTickListener(){

            @Override
            public void onTick(int n2) {
                DebugLog.d(MgtvMediaPlayer.this.getLogTag(), "PlayTicker onTick: " + n2 + ",fps:" + MgtvMediaPlayer.this.getFpsMsg());
                if (MgtvMediaPlayer.this.mReporter != null) {
                    MgtvMediaPlayer.this.mReporter.a(n2);
                }
            }
        });
        this.mPlayTicker.setExCallback(new ExTicker.OnExTickListener(){

            @Override
            public void onTick(int n2, int n3) {
                if (n3 > 2) {
                    MgtvMediaPlayer.this.updateFpsInfo();
                    if (MgtvMediaPlayer.this.isRfpsLow()) {
                        MgtvMediaPlayer.this.rfpsLowCounter++;
                    } else {
                        MgtvMediaPlayer.this.rfpsLowCounter = 0;
                    }
                    if (MgtvMediaPlayer.this.rfpsLowCounter > 5 && MgtvMediaPlayer.this.mRenderView != null && !MgtvMediaPlayer.this.rfpsLowFilterChanged) {
                        DebugLog.e(MgtvMediaPlayer.this.getLogTag(), "rfps too low change to normal filter");
                        MgtvMediaPlayer.this.rfpsLowFilterChanged = true;
                        MgtvMediaPlayer.this.mRenderView.setRenderFilter(0);
                    }
                }
            }

            @Override
            public void onPlayOrPause(boolean bl) {
                if (MgtvMediaPlayer.this.mRenderView != null) {
                    if (bl) {
                        MgtvMediaPlayer.this.mRenderView.startFps();
                    } else {
                        MgtvMediaPlayer.this.mRenderView.stopFps();
                    }
                }
            }
        });
        this.mBufferTick.setHostLogTag(this.getLogTag());
        this.mBufferTick.setCallback(new ExTicker.onTickListener(){

            @Override
            public void onTick(int n2) {
                DebugLog.i(MgtvMediaPlayer.this.getLogTag(), "BufferTick onTick: " + n2 + ",getDLSpeed:" + MgtvMediaPlayer.this.getNetSpeedStr());
                MgtvMediaPlayer.this.doBufferTick(n2);
            }
        });
    }

    private void reportErrorWarning(int n2, int n3) {
        String string;
        String string2;
        long l2;
        if (this.mOnWarningListener == null) {
            return;
        }
        if (!this.isRendered() && this.mReportParams != null && (l2 = this.mReportParams.getRouterTimeStamp()) > 0L && this.mPrepareAsyncTimeStampMs > 0L) {
            int n4 = (int)((this.mPrepareAsyncTimeStampMs - l2) / 1000L);
            string2 = this.mReporter.g();
            int n5 = n4 / 1800;
            if (CodeUtil.isHttp410(n2, n3)) {
                this.mOnWarningListener.onWarning(800410, string2 + "." + n5, "_prepareasync_" + this.mPrepareAsyncTimeStampMs + "_routerTimeMs_" + l2 + "_duration_" + n4, null);
            } else if (CodeUtil.isHttp403(n2, n3)) {
                this.mOnWarningListener.onWarning(800403, string2 + "." + n5, "_prepareasync_" + this.mPrepareAsyncTimeStampMs + "_routerTimeMs_" + l2 + "_duration_" + n4, null);
            }
        }
        if (n3 == 300301) {
            this.mOnWarningListener.onWarning(800301, this.mReporter.g(), "", null);
        }
        if (n3 == 101905 || n3 == 100400 || n3 == 100401) {
            String[] stringArray;
            String string3 = this.mMediaPlayer != null ? this.mMediaPlayer.n() : "";
            string = "";
            if (string3 != null && (stringArray = string3.split("/")) != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            this.mOnWarningListener.onWarning(800905, n3 + "." + string, string3, null);
        }
        if (this.mReportParams != null && this.mReportParams.getVideoType() == ReportParams.VideoType.LOCAL && n3 == 100201) {
            this.mOnWarningListener.onWarning(801201, "0", "url:" + this.getPlayingUrl(), null);
        }
        String string4 = "00";
        string = "00";
        String string5 = "00";
        string2 = UrlUtil.getHostName(this.getPlayingOriginUrl());
        if (this.mReportParams != null) {
            string4 = this.mReportParams.getP2ps() + "";
            string = this.mReportParams.getRetryIndex() + "";
            string5 = this.mReportParams.getProxyType().ordinal() + "";
        }
        String string6 = "psuuid_" + this.mReporter.g() + "_playsta_" + (Object)((Object)this.mPlayStatus) + "_p2ps_" + string4 + "_rdst_" + this.getReadDataSourceType() + "_p2psta_" + (this.mMediaPlayer.af() != null ? Integer.valueOf(this.mMediaPlayer.af().getStatus()) : "00") + "_pdsn_" + this.mIsNativePausedLoadData + "_pdsj_" + this.isLoadDataPaused() + "_live_" + this.mIsLive + "_dsty_" + (Object)((Object)this.mDataSourceType) + "_retry_" + string + "_sr_" + this.mSourceRetryCount + "_err_" + UrlUtil.getFileName(this.mErrorUrl) + "_last_" + UrlUtil.getFileName(this.mLastRequestUrl) + "_cip_" + this.getLastIP() + "_pcip_" + this.mLastP2pCdnIP + "_proxy_" + string5 + "_v_" + PlayerConfig.getLibFullVersion() + "_herr_" + this.mLastHostErr + "_terr_" + this.mLastTcpErr + "_hip_" + this.mLastHostIP + "_tip_" + this.mLastTcpIP + "_lhost_" + string2 + "_ipn_" + this.getLastIPCount() + "_" + this.getLastIpArrayStr() + "_ipt_" + this.getLastDnsType();
        this.mOnWarningListener.onWarning(801010, n2 + "_" + n3, string6, null);
    }

    private void reportError(int n2, int n3, String string) {
        if (this.mSourceSwitching) {
            if (this.mReporterSL != null) {
                this.mReporterSL.a(n2, n3, string);
            }
            this.mSourceSwitching = false;
        } else {
            this.printErrorMd5();
            if (this.mReporter != null) {
                this.mReporter.a(n2, n3, string);
            }
        }
    }

    private void printErrorMd5() {
        if (this.mReportParams != null && ReportParams.VideoType.LOCAL.equals((Object)this.mReportParams.getVideoType())) {
            DebugLog.e(this.getLogTag(), "\u79bb\u7ebf\u64ad\u653eURL:" + this.getPlayingUrl());
            DebugLog.e(this.getLogTag(), "\u79bb\u7ebf\u64ad\u653emd5:[status-remote][" + this.mReportParams.getLocalMd5() + "-" + this.mReportParams.getRemoteMd5() + "]");
        }
    }

    private boolean callBufferingTimeout(int n2, int n3, String string) {
        this.beforeThrowError(n2, n3);
        this.reportErrorWarning(n2, n3);
        this.reportError(n2, n3, string);
        this.mPlayStatus = PlayStatus.ERROR;
        if (this.mOnBufferingTimeoutListener != null) {
            IP2pTask iP2pTask;
            if (this.mMediaPlayer != null && this.mMediaPlayer.j() == 2 && (iP2pTask = this.mMediaPlayer.af()) != null && iP2pTask.getStatus() != 0) {
                n3 = 100907;
            }
            return this.mOnBufferingTimeoutListener.onBufferingTimeout(n2, n3);
        }
        return false;
    }

    private void doBufferTick(int n2) {
        int n3;
        int n4 = this.getCurDLSpeed();
        if (n4 <= (n3 = this.mWeakBufferSpeedKB * 1024)) {
            ++this.mWeakTimer;
            this.doBufferTickWeakNet(this.mWeakTimer * this.mBufferTick.getTickTime() / 1000);
        } else {
            this.mWeakTimer = 0;
            this.doBufferTickNormalNet(n2 * this.mBufferTick.getTickTime() / 1000);
        }
    }

    private void doBufferTickWeakNet(int n2) {
        DebugLog.d(this.getLogTag(), "doBufferTickWeakNet s:" + n2);
        if (!this.isRendered()) {
            if (n2 >= this.mPreBufferTimeoutMs / 1000) {
                DebugLog.d(this.getLogTag(), "doBufferTickWeakNet >= " + this.mPreBufferTimeoutMs);
                this.callBufferingTimeout(300004, 100906, "");
            }
        } else if (n2 >= this.mWeakBufferTimeoutMs / 1000) {
            DebugLog.d(this.getLogTag(), "mWeakBufferTimeoutS >= " + this.mWeakBufferTimeoutMs);
            this.callBufferingTimeout(300004, 100906, "");
        }
    }

    private void doBufferTickNormalNet(int n2) {
        DebugLog.d(this.getLogTag(), "doBufferTickNormalNet s:" + n2);
        if (!this.isRendered()) {
            if (n2 >= this.mPreBufferTimeoutMs / 1000) {
                DebugLog.d(this.getLogTag(), "doBufferTickNormalNet >= " + this.mPreBufferTimeoutMs / 1000);
                this.callBufferingTimeout(300004, 100900, "");
            }
        } else if (n2 >= this.mBufferTimeoutMs / 1000) {
            DebugLog.d(this.getLogTag(), "doBufferTickNormalNet >= " + this.mBufferTimeoutMs / 1000);
            this.callBufferingTimeout(300004, 100903, "");
        }
    }

    private void initConfig() {
        this.mMediaPlayer.a(this);
        this.mMediaPlayer.a(201507063, 2);
        if (this.mImgoMediaPlayerAudioMode) {
            this.mMediaPlayer.a(201507067, 1);
        } else {
            this.mMediaPlayer.a(201507067, 0);
        }
        this.mMediaPlayer.a(2016060201, 1);
        this.mMediaPlayer.a(2016060202, 1);
        this.setDataSourceType(this.mDataSourceType);
        this.setSkipLoopFilter(this.mSkipLoopFilterType);
        this.setAccurateSeekEnable(true);
        if (Constants.FOR_OTT) {
            this.setRenderType(RenderType.NATIVE_WINDOW);
            this.setNetAddrinfo(AddrinfoType.TYPE_ADDRINFO_DEFAULT, -1, true, a.b.a, true);
            this.setForceKeyframeSeekEnable(true);
        } else if (NetPlayConfig.isNativeOpenglEnable()) {
            this.setRenderType(RenderType.OPENGL_ES);
        } else {
            this.setRenderType(RenderType.NATIVE_WINDOW);
        }
        this.isExAudioEnable = NetPlayConfig.isWanosAudioEnable();
    }

    public void setAudioStreamType(int n2) {
        DebugLog.i(this.getLogTag(), "prepareAsync in. streamtype:" + n2);
        this.mMediaPlayer.d(n2);
        DebugLog.i(this.getLogTag(), "prepareAsync out");
    }

    public boolean isHardware() {
        return this.mMediaPlayer.r();
    }

    public float getPlaybackSpeed() {
        return this.mMediaPlayer.u();
    }

    public void setPlaybackSpeed(float f2) {
        if (this.checkInvalidThread(3, "setPlaybackSpeed")) {
            return;
        }
        if (f2 > 0.0f) {
            this.mPlaybackSpeed = f2;
            if (this.mTimeProvider != null) {
                this.mTimeProvider.a(f2);
            }
            this.mMediaPlayer.a(f2);
        }
    }

    public void switchVideoSource(String string, int n2, int n3, int n4) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mMediaPlayer.b(string, n2, n3, n4);
        this.mSourceSwitching = true;
        this.mSourceSwitchingComplete = false;
        this.mSwitchingPrepared = false;
        if (this.mReporterSL != null) {
            this.mReporterSL.a();
        }
    }

    public void switchP2pVideoSource(int n2, String string, IP2pTask iP2pTask, String string2, int n3, int n4, int n5) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mMediaPlayer.a(n2, string, iP2pTask, string2, n3, n4, n5);
        this.mSourceSwitching = true;
        this.mSourceSwitchingComplete = false;
        this.mSwitchingPrepared = false;
        if (this.mReporterSL != null) {
            this.mReporterSL.a();
        }
    }

    public void setOnSwitchSourceListener(MgtvPlayerListener.OnSwitchSourceListener onSwitchSourceListener) {
        this.mOnSwitchSourceListener = onSwitchSourceListener;
    }

    public void setOnSourceNetHandledListener(MgtvPlayerListener.OnSourceNetHandledListener onSourceNetHandledListener) {
        this.mOnSourceNetHandledListener = onSourceNetHandledListener;
    }

    public void setOnRecordVideoListener(MgtvPlayerListener.OnRecordVideoListener onRecordVideoListener) {
        this.mOnRecordVideoListener = onRecordVideoListener;
    }

    public void setOnLoadDataListener(MgtvPlayerListener.OnLoadDataListener onLoadDataListener) {
        this.mOnLoadDataListener = onLoadDataListener;
    }

    public void setOnFrameListener(MgtvPlayerListener.OnFrameListener onFrameListener) {
        this.mOnFrameListener = onFrameListener;
    }

    public MgtvPlayerListener.OnFrameListener getOnFrameListener() {
        return this.mOnFrameListener;
    }

    public MgtvPlayerListener.OnFrameListener getInnerFrameListener() {
        return this.mFrameListener;
    }

    public void setOnAVPlayListener(MgtvPlayerListener.OnAVPlayListener onAVPlayListener) {
        this.mOnAVPlayListener = onAVPlayListener;
    }

    public MgtvPlayerListener.OnAVPlayListener getOnAVPlayListener() {
        return this.mOnAVPlayListener;
    }

    public MgtvPlayerListener.OnPlayerEventListener getOnPlayerEventListener() {
        return this.mOnPlayerEventListener;
    }

    public void setOnPlayerEventListener(MgtvPlayerListener.OnPlayerEventListener onPlayerEventListener) {
        this.mOnPlayerEventListener = onPlayerEventListener;
    }

    public void setNETIsBroken(boolean bl) {
        this.mMediaPlayer.e(bl);
    }

    public void setVideoFrameClockNotifyMs(int n2) {
        this.mVideoFrameClockNotifyMs = n2;
        if (n2 > 0) {
            this.mMediaPlayer.g(n2);
        }
    }

    public int getVideoFrameClockNotifyMs() {
        this.mVideoFrameClockNotifyType = 1;
        return this.mVideoFrameClockNotifyMs;
    }

    public void setVideoFrameClockNotifyPts(long l2, long l3) {
        this.mVideoFrameClockNotifyType = 2;
        this.mVideoFrameClockNotifyTimeStart = l2;
        this.mVideoFrameClockNotifyTimeEnd = l3;
        this.mMediaPlayer.a(l2, l3);
    }

    public int getVideoFrameClockNotifyType() {
        return this.mVideoFrameClockNotifyType;
    }

    public long getmVideoFrameClockNotifyTimeStart() {
        return this.mVideoFrameClockNotifyTimeStart;
    }

    public long getmVideoFrameClockNotifyTimeEnd() {
        return this.mVideoFrameClockNotifyTimeEnd;
    }

    private void preLoopSeek(boolean bl) {
        if (this.mMediaPlayer.j() == 1 || this.mMediaPlayer.j() == 2) {
            if (bl) {
                P2pMgr.setPlaySpeed(30.0f);
            } else {
                float f2 = this.getPlaybackSpeed();
                if (f2 > 0.0f) {
                    P2pMgr.setPlaySpeed(f2);
                } else {
                    P2pMgr.setPlaySpeed(1.0f);
                }
            }
        }
    }

    public void setLoopSeekPlay(boolean bl, int n2) {
        this.preLoopSeek(bl);
        this.mMediaPlayer.a(bl, n2);
    }

    public void setLoopABPlay(boolean bl, long l2, long l3) {
        this.mMediaPlayer.a(bl, l2, l3);
    }

    public void setConfig(int n2, int n3) {
        this.mMediaPlayer.a(n2, n3);
    }

    public void pauseLoadData() {
        if (!this.isLoadDataPaused()) {
            this.mMediaPlayer.z();
        }
    }

    public void resumeLoadData() {
        if (this.isLoadDataPaused()) {
            if (this.mOnLoadDataListener != null) {
                this.mOnLoadDataListener.onBeforeLoadDataResume();
            }
            this.mMediaPlayer.A();
        }
    }

    public void setDrmLicensePrepared() {
        this.mMediaPlayer.B();
    }

    public void setPreBufferTimeoutMs(int n2) {
        if (n2 > 0) {
            DebugLog.i(this.getLogTag(), "setPreBufferTimeoutMs:" + n2);
            this.mPreBufferTimeoutMs = n2;
        }
    }

    public void setTimeout(int n2, int n3, int n4) {
        if (n2 > 0) {
            this.mConnectTimeOutMs = n2;
        }
        if (n3 > 0) {
            this.mReceiveDataTimeOutMs = n3;
        }
        if (n4 > 0) {
            this.mBufferTimeoutMs = n4;
        }
        if (this.mConnectTimeOutMs > 0) {
            this.mMediaPlayer.a(201507061, this.mConnectTimeOutMs);
        }
        if (this.mReceiveDataTimeOutMs > 0) {
            this.mMediaPlayer.a(201507062, this.mReceiveDataTimeOutMs);
        }
    }

    public void setAccurateSeekEnable(boolean bl) {
        this.mAccurateSeekEnable = bl;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2017031302, this.mAccurateSeekEnable ? 1 : 0);
        }
    }

    public void setAccSeekKeyFrameInterval(int n2) {
        this.mAccSeekKeyFrameInterval = n2;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2017051801, this.mAccSeekKeyFrameInterval);
        }
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.mDataSourceType = dataSourceType;
        switch (this.mDataSourceType) {
            case TYPE_DATASOUCE_IMGO: {
                this.mMediaPlayer.a(2016070401, 1);
                this.mMediaPlayer.a(2016021705, 1);
                break;
            }
            default: {
                this.mMediaPlayer.a(2016070401, 0);
                this.mMediaPlayer.a(2016021705, 0);
            }
        }
    }

    public int getDataSourceTypeOrdinal() {
        return this.mDataSourceType.ordinal();
    }

    public DataSourceType getDataSourceType() {
        return this.mDataSourceType;
    }

    public void setSkipLoopFilter(SkipLoopFilterType skipLoopFilterType) {
        this.mSkipLoopFilterType = skipLoopFilterType;
        switch (this.mSkipLoopFilterType) {
            case TYPE_SKIPLOOPFILTER_NONE: {
                this.mMediaPlayer.a(2016021701, 0);
                break;
            }
            case TYPE_SKIPLOOPFILTER_NONREF: {
                this.mMediaPlayer.a(2016021701, 8);
                break;
            }
            case TYPE_SKIPLOOPFILTER_BIDIR: {
                this.mMediaPlayer.a(2016021701, 16);
                break;
            }
            case TYPE_SKIPLOOPFILTER_NONKEY: {
                this.mMediaPlayer.a(2016021701, 32);
                break;
            }
            case TYPE_SKIPLOOPFILTER_ALL: {
                this.mMediaPlayer.a(2016021701, 48);
                break;
            }
        }
    }

    public void setRenderType(RenderType renderType) {
        this.mRenderType = renderType;
        switch (renderType) {
            case OPENGL_ES: {
                this.mMediaPlayer.a(201507065, 1);
                break;
            }
            default: {
                this.mMediaPlayer.a(201507065, 0);
            }
        }
    }

    public RenderType getRenderType() {
        return this.mRenderType;
    }

    public ReportParams.VideoType getVideoType() {
        return this.mReportParams != null ? this.mReportParams.getVideoType() : ReportParams.VideoType.NONE;
    }

    public AddrinfoType getAddrinfoType() {
        return this.mAddrinfoType;
    }

    public void setNetAddrinfo(AddrinfoType addrinfoType, int n2, boolean bl) {
        this.setNetAddrinfo(addrinfoType, n2, bl, a.b.a, false, false);
    }

    public void setNetAddrinfo(AddrinfoType addrinfoType, int n2, boolean bl, a.b b2, boolean bl2) {
        this.setNetAddrinfo(addrinfoType, n2, bl, b2, bl2, false);
    }

    public void setNetAddrinfo(AddrinfoType addrinfoType, int n2, boolean bl, a.b b2, boolean bl2, boolean bl3) {
        this.mAddrinfoType = addrinfoType;
        this.mAddrinfoTimeoutMs = n2;
        this.setAsyncDns(bl, b2);
        this.mBackJavaDns = bl3;
        if (this.mMediaPlayer != null) {
            if (this.mAddrinfoType != AddrinfoType.TYPE_DNS_CACHE) {
                this.mMediaPlayer.a(2018022701, 0);
            } else {
                this.mMediaPlayer.a(2018022701, 1);
                if (this.mAddrinfoTimeoutMs > 0) {
                    this.mMediaPlayer.a(2018022702, this.mAddrinfoTimeoutMs);
                }
            }
            this.mMediaPlayer.a(2018110701, bl2 ? 1 : 0);
        }
    }

    private void setAsyncDns(boolean bl, a.b b2) {
        this.mJavaDnsEnable = bl;
        this.mJavaDnsType = b2;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(this.mJavaDnsEnable, this.mJavaDnsType);
        }
    }

    private boolean isDnsCacheEnable() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.Y();
        }
        return false;
    }

    public void setForceKeyframeSeekEnable(boolean bl) {
        this.mKeyframeSeekEnable = bl;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2017080701, this.mKeyframeSeekEnable ? 1 : 0);
        }
    }

    public void setInnerAutoRotateEnable(boolean bl) {
        this.mInnerAutoRotateEnable = bl;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2018042401, this.mInnerAutoRotateEnable ? 1 : 0);
        }
    }

    public void setEnablePlayerMode(PlayerModeType playerModeType) {
        if (this.mMediaPlayer != null) {
            if (playerModeType == PlayerModeType.TYPE_PLAYER_MODE_LIVE) {
                this.mPlayerMode = 1;
                this.mMediaPlayer.a(2018100801, 1);
            } else if (playerModeType == PlayerModeType.TYPE_PLAYER_MODE_LOOP) {
                this.mPlayerMode = 2;
                this.mMediaPlayer.a(2018100801, 2);
            } else if (playerModeType == PlayerModeType.TYPE_PLAYER_MODE_SMOOTH) {
                this.mPlayerMode = 3;
                this.mMediaPlayer.a(2018100801, 3);
            } else {
                this.mPlayerMode = 0;
                this.mMediaPlayer.a(2018100801, 0);
            }
        }
    }

    public void setLiveStartIndex(int n2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2018091302, n2);
        }
    }

    public void setPlayerPrepareStartPosMs(int n2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2018112702, n2);
        }
    }

    public void setPlayerSeekAtStartPosMs(int n2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2016032101, n2);
        }
    }

    public void setPlayerFileStartTimeFloatS(float f2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2019081201, f2);
        }
    }

    public float getPlayerFileStartTimeFloatS() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.aj();
        }
        return -1.0f;
    }

    public void enableMgtvMediaCodec(boolean bl) {
        if (bl) {
            if (this.mReportParams != null && this.mReportParams.getVideoType() == ReportParams.VideoType.VOD && this.mMediaPlayer != null) {
                this.mMediaPlayer.a(2019053101, 1);
            }
        } else if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2019053101, 0);
        }
    }

    public boolean isEnableDnsNoNetStrategy() {
        return this.mEnableDnsNoNetStrategy;
    }

    public void setEnableDnsNoNetStrategy(boolean bl) {
        this.mEnableDnsNoNetStrategy = bl;
    }

    public void setEnableVideoStartTime(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.f(bl);
        }
    }

    public void setDnsFamilyType(int n2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2017061201, n2);
        }
    }

    public void setAMCKeyFrameBackMode(int n2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2018091301, n2);
        }
    }

    public boolean isSupportAMCKeyFrameBackup() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.ae();
        }
        return true;
    }

    public void setSurfaceHolder(IMgtvRenderView.ISurfaceHolder iSurfaceHolder) throws InvalidParameterException {
        this.setSurfaceHolder(iSurfaceHolder, -1);
    }

    public void setSurfaceHolder(IMgtvRenderView.ISurfaceHolder iSurfaceHolder, int n2) throws InvalidParameterException {
        this.mMediaPlayer.a(iSurfaceHolder, n2);
    }

    public boolean isSupportedSnapshot() {
        return this.mMediaPlayer.C() && !this.isHDR();
    }

    public boolean isMediaCodecSWRender() {
        return this.mMediaPlayer.D();
    }

    public Bitmap getSnapshot(int n2, int n3) {
        return this.mMediaPlayer.b(n2, n3);
    }

    public boolean clearSurface(Surface surface) {
        return true;
    }

    public void setPlaybackStep(int n2) {
        this.mMediaPlayer.e(n2);
    }

    public void setPlaybackStep() {
        this.mMediaPlayer.e(0);
    }

    public void nativeCrashTest(NativeSoType nativeSoType) {
        int n2 = -1;
        switch (nativeSoType) {
            case TYPE_NATIVESO_IMGOFFMPEG: {
                n2 = 0;
                break;
            }
            case TYPE_NATIVESO_IMGOHELP: {
                n2 = 1;
                break;
            }
            case TYPE_NATIVESO_IMGOMEDIAPLAYER: {
                n2 = 2;
                break;
            }
            case TYPE_NATIVESO_IMGODS: {
                n2 = 3;
                break;
            }
        }
        this.mMediaPlayer.f(n2);
    }

    public void enableFramePTSNotify(boolean bl) {
        this.mMediaPlayer.b(bl);
    }

    public void enableP2PSmoothFailMode(boolean bl) {
        this.mMediaPlayer.c(bl);
    }

    public Prepared4StartMode getPrepared4StartMode() {
        return this.mPrepared4StartMode;
    }

    public void setPrepared4StartMode(Prepared4StartMode prepared4StartMode) {
        boolean bl = false;
        this.mPrepared4StartMode = prepared4StartMode;
        int n2 = 0;
        switch (prepared4StartMode) {
            case MODE_PREPARED4START_DEFAULT: {
                n2 = 0;
                break;
            }
            case MODE_PREPARED4START_AUTOPLAY: {
                n2 = 1;
                break;
            }
            case MODE_PREPARED4START_LOADDATA: 
            case MODE_PREPARED4START_LOADDATA_DISAV: {
                n2 = 2;
                bl = true;
                break;
            }
        }
        this.mPreBufferState.setEnable(bl);
        this.mMediaPlayer.a(2017112301, n2);
    }

    public void setDisableAVDecoderStart(boolean bl) {
        this.mMediaPlayer.a(2020072201, bl ? 1 : 0);
    }

    public String getErrorUrl() {
        return this.mErrorUrl;
    }

    public int getLastDlSize() {
        return this.mLastDlSize;
    }

    public void configTsNotSkip(boolean bl) {
        DebugLog.d(this.getLogTag(), "configTsNotSkip " + bl);
        this.mTsNotSkip = bl;
    }

    public void configLoadMaxRetryTime(int n2) {
        DebugLog.d(this.getLogTag(), "configLoadMaxRetryTime " + n2);
        if (n2 > 0) {
            this.mLoadMaxRetryTime = n2;
        }
    }

    public void configWeakBufferSpeed(int n2) {
        DebugLog.d(this.getLogTag(), "configWeakBufferSpeed " + n2);
        if (n2 > 0) {
            this.mWeakBufferSpeedKB = n2;
        }
    }

    public void configWeakBufferTimeout(int n2) {
        DebugLog.d(this.getLogTag(), "configWeakBufferTimeout " + n2);
        if (n2 > 0) {
            this.mWeakBufferTimeoutMs = n2;
        }
    }

    public void configDSMemoryKeepSize(int n2, int n3) {
        DebugLog.d(this.getLogTag(), "configDSMemoryKeepSize, BW_SIZE_KB:" + n2 + ",FW_SIZE_KB:" + n3);
        if (n2 > 0) {
            this.mMediaPlayer.a(2017122201, n2);
        }
        if (n3 > 0) {
            this.mMediaPlayer.a(2017122202, n3);
        }
    }

    public String getPlayingUrl() {
        return this.mMediaPlayer.E();
    }

    public String getLastRequestUrl() {
        return this.mLastRequestUrl;
    }

    public String getPlayingOriginUrl() {
        return this.mMediaPlayer.F();
    }

    public boolean isRendered() {
        return this.mIsVideoRendered;
    }

    public static String getH264Decoder() {
        if (BuildHelper.isApi16_JellyBeanOrLater()) {
            return MediaCodecHelp.getH264Decoder();
        }
        return "none";
    }

    public static String getH265Decoder(boolean bl) {
        if (BuildHelper.isApi16_JellyBeanOrLater()) {
            return MediaCodecHelp.getH265Decoder(bl);
        }
        return "none";
    }

    public void setDebug(boolean bl) {
        this.mDebug = bl;
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public Hw2SwType getHw2SwType() {
        return this.mHw2SwType;
    }

    public ExTicker getPlayTicker() {
        return this.mPlayTicker;
    }

    public void setOnWarningListener(MgtvPlayerListener.OnWarningListener onWarningListener) {
        this.mOnWarningListener = onWarningListener;
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(onWarningListener);
        }
    }

    public void enableM3u8Cache(boolean bl) {
        this.mCacheEable = bl;
    }

    public void setM3u8Caches(String string, String[] stringArray) {
        DebugLog.i(this.getLogTag(), "setM3u8Caches m3u8:" + string);
        if (stringArray != null && stringArray.length > 0) {
            for (String string2 : stringArray) {
                DebugLog.i(this.getLogTag(), "setM3u8Caches ts:" + string2);
            }
        }
        this.mCacheM3u8Path = string;
        this.mCacheTsPaths = stringArray;
    }

    public void setDataSourceInfo(DataSourceInfo dataSourceInfo) {
        this.mDataSourceInfo = dataSourceInfo;
        if (this.mDataSourceInfo != null) {
            DebugLog.i(this.getLogTag(), "setDataSourceInfo VideoFormat:" + this.mDataSourceInfo.getVideoFormat() + "AudioFormat:" + this.mDataSourceInfo.getAudioFormat() + ",FileFormat:" + this.mDataSourceInfo.getFileFormat() + ",bitRate:" + this.mDataSourceInfo.getBitRate());
        } else {
            DebugLog.i(this.getLogTag(), "setDataSourceInfo null");
        }
    }

    public DataSourceInfo getDataSourceInfo() {
        return this.mDataSourceInfo;
    }

    public void setHlsCheckMD5(int n2) {
        this.mMediaPlayer.a(2019052701, n2);
    }

    public String getCodecName() {
        return this.mCodecName;
    }

    public String getHdrInfo() {
        return this.hdrInfo;
    }

    public boolean isHDR() {
        try {
            String[] stringArray;
            String string = this.getHdrInfo();
            DebugLog.i(this.getLogTag(), "isHDR hdrInfo" + string);
            if (!StringUtil.isEmpty(string) && (stringArray = string.split(":")) != null && stringArray.length >= 1 && "1".equalsIgnoreCase(stringArray[0])) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean isForceHttpDns() {
        return this.mForceHttpDns;
    }

    public MgtvMediaPlayer setForceHttpDns(boolean bl) {
        this.mForceHttpDns = bl;
        return this;
    }

    public void setP2pHttpDns(boolean bl, boolean bl2) {
        this.mEnableP2PHttpDns = bl;
        this.mForceP2pHttpDns = bl2;
    }

    public int getVideoFPS() {
        return this.mMediaPlayer.J();
    }

    public long getVideoBitRate() {
        return this.mMediaPlayer.M();
    }

    public int getCurDLSpeed() {
        return this.mMediaPlayer.t();
    }

    public int getPlayerType() {
        return this.mPlayerType;
    }

    public String getVideoFormat() {
        if (this.mDataSourceInfo != null) {
            return this.mDataSourceInfo.videoFormat;
        }
        return null;
    }

    public String getAudioFormat() {
        if (this.mDataSourceInfo != null) {
            return this.mDataSourceInfo.audioFormat;
        }
        return null;
    }

    public String getFileFormat() {
        if (this.mDataSourceInfo != null) {
            return this.mDataSourceInfo.fileFormat;
        }
        return null;
    }

    public String getCurrentVideoDecoderName() {
        return this.mMediaPlayer.U();
    }

    public String getCurrentAudioDecoderName() {
        return this.mMediaPlayer.V();
    }

    public long getMaxDnsMs() {
        return this.mMediaPlayer.W();
    }

    public long getMaxDnsType() {
        return this.mMediaPlayer.X();
    }

    public boolean isSourceSwitching() {
        return this.mSourceSwitching;
    }

    public boolean isSwitchingPrepared() {
        return this.mSwitchingPrepared;
    }

    public boolean isSourceSwitchingComplete() {
        return this.mSourceSwitchingComplete;
    }

    public int getRetryLastErrorCode() {
        return this.mRetryLastErrorCode;
    }

    private String getNetSpeedStr() {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        float f2 = (float)this.getCurDLSpeed() / 1000.0f;
        return decimalFormat.format(f2) + "KB/S";
    }

    private void stopTickers() {
        this.mPlayTicker.stop();
        this.mBufferTick.stop();
    }

    public void setVolume(float f2, float f3) {
        DebugLog.i(this.getLogTag(), "setVolume leftVolume:" + f2 + ",rightVolume:" + f3);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(f2, f3);
        }
    }

    public void configForceHW(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2018051001, bl ? 1 : 0);
        }
    }

    public void enableJAVAIPCacheMap(boolean bl) {
        this.mEnableJAVAIPCacheMap = bl;
    }

    public void enableTsSkipError(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2019050601, bl ? 1 : 0);
        }
    }

    public String[] getCacheTsPaths() {
        return this.mCacheTsPaths;
    }

    public Map<String, String> getCacheReplaceMap() {
        return this.mCacheReplaceMap;
    }

    public int getTsCacheSkipNum() {
        return this.mTsCacheSkipNum;
    }

    public boolean isMgtvCore() {
        return this.mMediaPlayer.T();
    }

    private String getLogTag() {
        return "[" + this.mLogTagKey + "][" + this.getClass().getSimpleName() + "]";
    }

    public String getCurrentDnsDsc() {
        return this.mCurrentDnsDsc;
    }

    public String getLastIP() {
        if (this.mMediaPlayer != null && (this.mMediaPlayer.j() == 2 || this.mMediaPlayer.j() == 1) && this.mMediaPlayer.af() != null) {
            IP2pTask iP2pTask = this.mMediaPlayer.af();
            DebugLog.d(this.getLogTag(), "getLastIP update cdnIp:" + this.mLastIP);
        }
        return this.mLastIP;
    }

    public void setLastIP(String string) {
        this.mLastIP = string;
    }

    public int getLastIPCount() {
        return this.mLastIpCount;
    }

    public String getLastIpArrayStr() {
        String string = "";
        if (this.mLastIps != null) {
            for (String string2 : this.mLastIps) {
                string = string + string2 + "_";
            }
        }
        return string;
    }

    public int getLastDnsType() {
        return this.mLastDnsType;
    }

    public int getLastIpIndex() {
        return this.mLastIpIndex;
    }

    public int getSourceRetryCount() {
        return this.mSourceRetryCount;
    }

    public int getSourceRetryCode() {
        return this.mSourceRetryCode;
    }

    public int getSwitchP2ps() {
        return this.mMediaPlayer.v();
    }

    private boolean checkAndCleanDnsCache(int n2, int n3) {
        if (n2 == 400602 || n2 == 100002 || n3 == 300600 || n3 == 100901 || n3 == 100910 || n3 == 100911 || n3 == 100701 || CodeUtil.isHttp4XX(n2, n3) || CodeUtil.isHttp5XX(n2, n3)) {
            if (this.mLastUri != null && !this.mLastUri.trim().equals("")) {
                f.a(this.mLastUri);
            }
            return true;
        }
        return false;
    }

    public boolean isHLSPlayingUrl() {
        return this.mMediaPlayer.G();
    }

    public boolean isInitMp4Error() {
        return this.mIsInitMp4Error;
    }

    public PlayerExtraInfo getPlayerExtraInfo() {
        PlayerExtraInfo playerExtraInfo = new PlayerExtraInfo();
        if (this.mReporter != null) {
            playerExtraInfo.playSessionID = this.mReporter.g();
        }
        playerExtraInfo.lastIP = this.getLastIP();
        playerExtraInfo.smt = this.mSmt;
        playerExtraInfo.dlt = this.mDlt;
        if (this.mMediaPlayer != null) {
            playerExtraInfo.buftimeMs = this.mMediaPlayer.ai();
            playerExtraInfo.bufsizeByte = this.mMediaPlayer.ah();
        }
        return playerExtraInfo;
    }

    public FlowDataStatistic getInnerFlowDataStatistic() {
        return this.mInnerFlowDataStatistic;
    }

    public String getCurrentDrmMetodName() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.ad();
        }
        return null;
    }

    public int getIsAudioExist() {
        return this.mIsAudioExist;
    }

    public boolean isNativePausedLoadData() {
        return this.mIsNativePausedLoadData == 1;
    }

    public boolean isWanosAudioEffectValid() {
        return this.mIsWanosAudioEffectValid;
    }

    public void setEnableWanosAudioEffect(boolean bl) {
        this.isUserAudioEnable = bl;
        if (bl) {
            this.autoWanosAudioEffectChoice();
        } else if (this.mMediaPlayer != null) {
            this.mMediaPlayer.h(0);
        }
    }

    public boolean isLive() {
        return this.mIsLive;
    }

    public boolean isVod() {
        return this.mReportParams != null && this.mReportParams.getVideoType() == ReportParams.VideoType.VOD;
    }

    public void setFlowDataStatistic(FlowDataStatistic flowDataStatistic) {
        this.mFlowDataStatistic = flowDataStatistic;
    }

    public boolean isNetworkChangeWhilePlaying() {
        return this.mNetworkChangeWhilePlaying;
    }

    public long getNetdSVCTimeMs() {
        return this.mNetdSVCTimeMs;
    }

    public void setNetdSVCTimeMs(long l2) {
        this.mNetdSVCTimeMs = l2;
    }

    public int getVVbuft() {
        return this.mVVbuft;
    }

    public boolean isHttpDnsNeedRetry() {
        return this.mHttpDnsNeedRetry;
    }

    public MgtvMediaPlayer setHttpDnsNeedRetry(boolean bl) {
        this.mHttpDnsNeedRetry = bl;
        return this;
    }

    public int getLastTsSkipErrExtra() {
        return this.mLastTsSkipErrExtra;
    }

    public String getLastTsSkipErrFileName() {
        return this.mLastTsSkipErrFileName;
    }

    public void setEnableMediacodecSWRender(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2020072001, bl ? 1 : 0);
        }
    }

    public void setMarkMediacodecSWRender(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(2020072002, bl ? 1 : 0);
        }
    }

    public void setNetPlayConfig(NetPlayConfig netPlayConfig) {
        this.mNetPlayConfig = netPlayConfig;
    }

    public void setFrameImageAtTime(String string, long l2, long l3, int n2, int n3, int n4) {
        DebugLog.i(this.getLogTag(), "setFrameImageAtTime " + string + "-" + l2 + "-" + l3 + "-" + n2 + "-" + n3 + "-" + n4);
        this.mMediaPlayer.a(string, l2, l3, n2, n3, n4);
    }

    public void setOnGetFrameImageListener(MgtvPlayerListener.OnGetFrameImageListener onGetFrameImageListener) {
        this.mOnGetFrameImageListener = onGetFrameImageListener;
    }

    public int getMpx() {
        return this.mpx;
    }

    public int getImp4dh() {
        return this.imp4dh;
    }

    public String getFstime() {
        return this.fstime;
    }

    public String getMediaCodecColorFormat() {
        return this.mcColorFormat;
    }

    public void setMgtvFastMode(int n2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.i(n2);
        }
    }

    public int getMgtvFastMode() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.ak();
        }
        return 0;
    }

    public void setMediacodecRecreateformat(boolean bl, boolean bl2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.a(bl, bl2);
        }
    }

    public synchronized int setKeyFrameInfoFileBuf(byte[] byArray) {
        DebugLog.i(this.getLogTag(), "setKeyFrameInfoFileBuf success");
        return this.mMediaPlayer.a(byArray);
    }

    public void bindDrmSession(IDrmSession iDrmSession) {
        this.mMediaPlayer.a(iDrmSession);
    }

    public IDrmSession getDrmSession() {
        return this.mMediaPlayer.ap();
    }

    public void enableOppoFunc(int n2, boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.b(n2, bl);
        }
    }

    public boolean isOppoExFunEnable() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.N() || this.mMediaPlayer.O();
        }
        return false;
    }

    public void enableLiveLowLatency(boolean bl) {
        this.setConfig(2021030401, bl ? 1 : 0);
    }

    public int getMemoryPlayType() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.aq();
        }
        return 0;
    }

    private String getResolution() {
        return this.getVideoWidth() + "x" + this.getVideoHeight();
    }

    public void startRecVideo(String string) {
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        try {
            this.mMediaPlayer.c(string);
        }
        catch (IOException iOException) {
            this.callbackRecordError(10001, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.callbackRecordError(10002, 0);
        }
        catch (IllegalStateException illegalStateException) {
            this.callbackRecordError(10003, 0);
        }
        catch (Exception exception) {
            this.callbackRecordError(10000, 0);
        }
    }

    public void stopRecVideo() {
        try {
            this.mMediaPlayer.ab();
        }
        catch (IOException iOException) {
            this.callbackRecordError(10001, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.callbackRecordError(10002, 1);
        }
        catch (IllegalStateException illegalStateException) {
            this.callbackRecordError(10003, 1);
        }
        catch (Exception exception) {
            this.callbackRecordError(10000, 1);
        }
    }

    public boolean isRecording() {
        return this.mMediaPlayer.ac();
    }

    private void callbackRecordInfo(int n2, int n3) {
        if (this.mOnRecordVideoListener != null) {
            this.mOnRecordVideoListener.onRecordVideoInfo(n2, n3);
        }
    }

    private void callbackRecordError(int n2, int n3) {
        if (this.mOnRecordVideoListener != null) {
            this.mOnRecordVideoListener.onRecordVideoErr(n2, n3);
        }
    }

    public synchronized GifRecorder bindGifRecorder(GifRecorder gifRecorder) {
        if (this.mGifRecorder != null) {
            this.mGifRecorder.reset();
        }
        this.mGifRecorder = gifRecorder;
        this.mGifRecorder.bindMediaPlayer(this);
        return this.mGifRecorder;
    }

    public void setLiveReopen() {
        if (this.mPlayerMode == 1) {
            this.mLiveReopen = true;
        }
    }

    public void resetLoopPlay() {
        this.resetLoopDataImpl();
        if (this.mReporter != null) {
            this.mReporter.c();
        }
    }

    public boolean isLoopSwitching() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.m();
        }
        return false;
    }

    public void switchLoopSource(String string, int n2) {
        this.switchLoopSource(0, string, null, null, n2);
    }

    public void switchLoopSource(int n2, String string, IP2pTask iP2pTask, String string2, int n3) {
        if (this.mPlayerMode == 2) {
            try {
                if (this.mReporter != null) {
                    this.mReporter.a();
                }
                string = FlowReportProcessor.replaceUrlSftcNoP2p(string, this.mReportParams);
                string2 = FlowReportProcessor.replaceUrlSftcNoP2p(string2, this.mReportParams);
                this.setDataSourceBefore(string, iP2pTask);
                int n4 = this.mMediaPlayer.a(n2, string, iP2pTask, string2, this.mLoopSourceKey.incrementAndGet(), n3);
                if (n4 != 0) {
                    this.mErrorListener.onError(200100, 400100 + Math.abs(n4));
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
                this.mErrorListener.onError(200100, 400198);
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
                this.mErrorListener.onError(200100, 400199);
                return;
            }
        }
    }

    public int getPlayerMode() {
        return this.mPlayerMode;
    }

    public float getFileStartTimeFloatS() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.I();
        }
        return -1.0f;
    }

    public void startAVDecoder() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.b(90003, 1L);
        }
    }

    public long getPropertyLong(int n2, long l2) {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.a(n2, l2);
        }
        return l2;
    }

    public void setPropertyLong(int n2, long l2) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.b(n2, l2);
        }
    }

    public float getPropertyFloat(int n2, float f2) {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.b(n2, f2);
        }
        return f2;
    }

    public ReportParams getReportParams() {
        return this.mReportParams;
    }

    public a getMediaTimeProvider() {
        if (this.mTimeProvider == null) {
            this.mTimeProvider = new com.hunantv.media.player.subtitle.e(this);
        }
        this.mTimeProvider.a(this.mPlaybackSpeed);
        this.mTimeProvider.a(!this.isPlaying());
        if (this.mIsBuffering) {
            this.mTimeProvider.b(this.mIsBuffering);
        }
        return this.mTimeProvider;
    }

    public void removeSubtitleSources() {
        c.b("subtitle", "removeSubtitleSources in");
        com.hunantv.media.player.subtitle.e e2 = this.mTimeProvider;
        if (e2 != null) {
            e2.b();
        }
        if (this.mSubtitleSources != null && !this.mSubtitleSources.isEmpty()) {
            for (SubtitleSource subtitleSource : this.mSubtitleSources) {
                subtitleSource.unBindHolder();
            }
            this.mSubtitleSources.clear();
        }
        if (this.mSubtitleController != null) {
            this.mSubtitleController.c();
            this.mSubtitleController = null;
        }
        if (this.mTimeProvider != null) {
            this.mTimeProvider.a();
            this.mTimeProvider = null;
        }
    }

    public void addSubtitleSource(d.c c2, final SubtitleSource subtitleSource) throws IllegalStateException {
        if (subtitleSource == null || !subtitleSource.isValid()) {
            DebugLog.e(TAG, "addSubtitleSource called with invalid source");
            if (this.mSubtitleCallback != null) {
                this.mSubtitleCallback.onError(subtitleSource);
            }
            return;
        }
        if (subtitleSource.isBinded()) {
            return;
        }
        subtitleSource.bindHolder(this);
        this.mSubtitleSources.add(subtitleSource);
        c.b("subtitle", "addSubtitleSource in");
        this.getMediaTimeProvider();
        if (this.mSubtitleController == null) {
            this.setSubtitleAnchor();
        }
        com.hunantv.media.player.subtitle.d d2 = this.mSubtitleController.a(c2, subtitleSource.getFormat());
        subtitleSource.setCallback(new SubtitleSource.SubtitleSourceCallback(){

            @Override
            public void onSuccess(com.hunantv.media.player.subtitle.d d2, SubtitleSource subtitleSource2) {
                block4: {
                    try {
                        MgtvMediaPlayer.this.sendContent2Track(d2, subtitleSource2);
                        if (MgtvMediaPlayer.this.mSubtitleController != null) {
                            MgtvMediaPlayer.this.mSubtitleController.b();
                        }
                        if (MgtvMediaPlayer.this.mSubtitleCallback != null) {
                            MgtvMediaPlayer.this.mSubtitleCallback.onSuccess(subtitleSource2);
                        }
                    }
                    catch (Exception exception) {
                        if (MgtvMediaPlayer.this.mSubtitleCallback == null) break block4;
                        MgtvMediaPlayer.this.mSubtitleCallback.onError(subtitleSource2);
                    }
                }
            }

            @Override
            public void onFailed(int n2) {
                if (MgtvMediaPlayer.this.mSubtitleCallback != null) {
                    MgtvMediaPlayer.this.mSubtitleCallback.onError(subtitleSource);
                }
            }
        });
        subtitleSource.readSource(d2, subtitleSource);
    }

    public void setSubtitleCallback(ISubtitle.SubtitleCallback subtitleCallback) {
        this.mSubtitleCallback = subtitleCallback;
    }

    private void sendContent2Track(com.hunantv.media.player.subtitle.d d2, SubtitleSource subtitleSource) {
        if (subtitleSource == null) {
            return;
        }
        if (this.mTimeProvider != null && this.mTimeProvider.a != null) {
            Handler handler = this.mTimeProvider.a;
            int n2 = 4;
            Pair pair = Pair.create((Object)d2, (Object)subtitleSource);
            Message message = handler.obtainMessage(n2, (Object)pair);
            handler.sendMessage(message);
        }
    }

    private synchronized void setSubtitleAnchor() {
        if (this.mSubtitleController == null) {
            this.mSubtitleController = new b(this.mContext, this.mTimeProvider, new b.b(){

                @Override
                public void onSubtitleTrackSelected(com.hunantv.media.player.subtitle.d d2) {
                }
            });
            this.mSubtitleController.a(new b.a(){

                @Override
                public void setSubtitleWidget(d.c c2) {
                }

                @Override
                public Looper getSubtitleLooper() {
                    return Looper.getMainLooper();
                }
            });
        }
    }

    public void bindRenderView(IMgtvRenderView iMgtvRenderView) {
        this.mRenderView = iMgtvRenderView;
    }

    public int getAvdiffS() {
        return this.avdiffS;
    }

    public int getSfps() {
        return this.sfps;
    }

    public int getDfps() {
        return this.dfps;
    }

    public int getVfps() {
        return this.vfps;
    }

    public int getRfps() {
        return this.rfps;
    }

    public boolean isVfpsLow() {
        return this.getSfps() > 15 && this.getVfps() > 0 && this.getVfps() < 15;
    }

    public boolean isRfpsLow() {
        return this.getSfps() > 15 && this.getRfps() > 0 && this.getRfps() < 12;
    }

    public String getFpsMsg() {
        int n2 = 0;
        if (this.isVfpsLow() || this.isRfpsLow()) {
            n2 = 1;
        }
        String string = this.getAvdiffS() + "_" + this.getSfps() + "_" + this.getDfps() + "_" + this.getVfps() + "_" + this.getRfps() + "_" + this.getPlaybackSpeed() + "_" + (this.isRfpsLowFilterChanged() ? 1 : 0) + "_" + n2;
        return string.replace("-", "_");
    }

    public boolean isRfpsLowFilterChanged() {
        return this.rfpsLowFilterChanged;
    }

    private void updateFpsInfo() {
        if (this.mMediaPlayer != null) {
            this.avdiffS = (int)this.mMediaPlayer.H();
            this.sfps = this.mMediaPlayer.J();
            this.dfps = (int)this.mMediaPlayer.L();
            this.vfps = (int)this.mMediaPlayer.K();
            if (this.mRenderView != null) {
                this.rfps = this.mRenderView.getFps();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int setWanosAudioEffectConfig(byte[] byArray) {
        if (Constants.FOR_OTT) {
            if (this.mMediaPlayer == null) return -999;
            if (byArray == null) {
                DebugLog.i(this.getLogTag(), "setWanosAudioEffectConfig null");
                return -999;
            }
            DebugLog.i(this.getLogTag(), "setWanosAudioEffectConfig size:" + byArray.length);
            return this.mMediaPlayer.b(byArray);
        }
        if (!this.isExAudioEnable) return -999;
        if (this.mMediaPlayer == null) return -999;
        if (byArray == null) {
            DebugLog.i(this.getLogTag(), "setWanosAudioEffectConfig null");
            return -999;
        }
        DebugLog.i(this.getLogTag(), "setWanosAudioEffectConfig size:" + byArray.length);
        int n2 = this.mMediaPlayer.b(byArray);
        this.autoWanosAudioEffectChoice();
        return n2;
    }

    public void autoWanosAudioEffectChoice() {
        if (this.isExAudioEnable || this.isUserAudioEnable) {
            DebugLog.i(this.getLogTag(), "autoWanosAudioEffectChoice in");
            if (AudioUtil.isWired(this.getContext())) {
                this.setWanosAudioEffectChoice(4);
            } else {
                this.setWanosAudioEffectChoice(3);
            }
            DebugLog.i(this.getLogTag(), "autoWanosAudioEffectChoice out");
        }
    }

    public synchronized void setWanosAudioEffectChoice(int n2) {
        if ((this.isExAudioEnable || this.isUserAudioEnable) && this.mMediaPlayer != null) {
            DebugLog.i(this.getLogTag(), "setWanosAudioEffectChoice value:" + n2);
            this.mMediaPlayer.h(n2);
        }
    }

    public int getWanosAudioEffectChoice() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.S();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVideoPTSListener(MgtvPlayerListener.OnVideoPTSListener onVideoPTSListener) {
        Object object = this.ptsLocker;
        synchronized (object) {
            if (onVideoPTSListener == null) {
                return;
            }
            if (this.ptsHandlerThread == null) {
                this.ptsHandlerThread = new HandlerThread("mgtvmp_jPts");
                this.ptsHandlerThread.start();
                if (this.ptsWeakHandler == null) {
                    this.ptsWeakHandler = new WeakHandler(this.ptsHandlerThread.getLooper(), this);
                }
            }
            this.ptsListeners.add(onVideoPTSListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVideoPTSListener(MgtvPlayerListener.OnVideoPTSListener onVideoPTSListener) {
        Object object = this.ptsLocker;
        synchronized (object) {
            if (onVideoPTSListener == null) {
                return;
            }
            this.ptsListeners.remove(onVideoPTSListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVideoPTSListener() {
        Object object = this.ptsLocker;
        synchronized (object) {
            this.ptsListeners.clear();
        }
    }

    public void setSeekAutoStartAfterComplete(boolean bl) {
        this.setConfig(2020080601, bl ? 1 : 0);
    }

    private int getCurrentSmoothSourceKey() {
        return this.mSwitchingSmoothSource != null ? this.mSwitchingSmoothSource.getKey() : -1;
    }

    private SmoothMediaSource matchLastKeySource(int n2) {
        if (this.mSwitchingSmoothSource != null && this.mSwitchingSmoothSource.getKey() == n2) {
            return this.mSwitchingSmoothSource;
        }
        return null;
    }

    public void setOnSwitchSmoothSourceListener(MgtvPlayerListener.OnSwitchSmoothSourceListener onSwitchSmoothSourceListener) {
        this.mOnSwitchSmoothSourceListener = onSwitchSmoothSourceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchSmoothSource(SmoothMediaSource smoothMediaSource) {
        Object object = this.mSwitchSmoothSourceLocker;
        synchronized (object) {
            if (smoothMediaSource == null) {
                DebugLog.e(this.getLogTag(), "switchSmoothSource is null");
                return;
            }
            smoothMediaSource.bind(this);
            DebugLog.e(this.getLogTag(), "switchSmoothSource key is:" + smoothMediaSource.getKey());
            int n2 = this.mMediaPlayer.a(smoothMediaSource);
            if (n2 == 0) {
                this.mSourceSwitching = true;
                this.mSmoothSourcesRecord.put(smoothMediaSource.getKey(), smoothMediaSource);
                this.mSwitchingSmoothSource = smoothMediaSource;
                this.mSourceSwitchingComplete = false;
                this.mSwitchingPrepared = false;
            } else {
                this.notifySwitchSmoothSourceFail(smoothMediaSource, 400710, n2);
            }
        }
    }

    private void notifySwitchSmoothSourceFail(SmoothMediaSource smoothMediaSource, int n2, int n3) {
        DebugLog.e(this.getLogTag(), "notifySwitchSmoothSourceFail " + n2 + "-" + n3);
        if (this.mOnSwitchSmoothSourceListener != null) {
            this.mOnSwitchSmoothSourceListener.onSwitchSmoothSourceFail(smoothMediaSource, 400710, n3);
        }
    }

    private String getKeyFrameMapKey(String string, String string2) {
        return string + "_" + string2;
    }

    private boolean matchSwitchedSmoothSource(String string) {
        return this.mSwitchedSmoothSource != null && !StringUtil.isEmpty(this.mSwitchedSmoothSource.getVid()) && !StringUtil.isEmpty(this.mSwitchedSmoothSource.getDef()) && string.equalsIgnoreCase(this.getKeyFrameMapKey(this.mSwitchedSmoothSource.getVid(), this.mSwitchedSmoothSource.getDef()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setSmoothKeyFrameInfo(byte[] byArray, String string, String string2) {
        DebugLog.i(this.getLogTag(), "setSmoothKeyFrameInfoBuf in");
        if (StringUtil.isEmpty(string) || StringUtil.isEmpty(string2) || byArray == null || byArray.length <= 0) {
            DebugLog.i(this.getLogTag(), "setSmoothKeyFrameInfoBuf info error");
            return -1;
        }
        Object object = this.mSwitchSmoothSourceLocker;
        synchronized (object) {
            String string3 = this.getKeyFrameMapKey(string, string2);
            if (this.matchSwitchedSmoothSource(string3)) {
                DebugLog.i(this.getLogTag(), "setSmoothKeyFrameInfoBuf matchSwitchedSmoothSource key:" + string3);
                if (KeyFrameInfoUtils.isKeyFrameDataValid(byArray, this.mSwitchedSmoothSource.videoFileHash) != 0) {
                    DebugLog.i(this.getLogTag(), "setSmoothKeyFrameInfoBuf isKeyFrameDataValid error");
                    return -2;
                }
                int n2 = this.setKeyFrameInfoFileBuf(byArray);
                this.mSmoothKeyFrameMap.clear();
                return n2;
            }
            DebugLog.i(this.getLogTag(), "setSmoothKeyFrameInfoBuf not matchSwitchedSmoothSource key:" + string3 + " put into map size:" + this.mSmoothKeyFrameMap.size());
            this.mSmoothKeyFrameMap.put(string3, byArray);
            return 0;
        }
    }

    public com.hunantv.media.player.f getMediaInfo() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.R();
        }
        return null;
    }

    public void setTsFlowTag(String string) {
        if (StringUtil.isEmpty(string)) {
            string = "";
        }
        if (this.mReportParams != null) {
            this.mReportParams.setFlowt(string);
        }
        this.mMediaPlayer.a(2021031001, string);
    }

    public void setBackground(boolean bl) {
        this.isBackground = bl;
        if (this.isBackground && this.mMainFlowReportProcessor != null) {
            this.mMainFlowReportProcessor.forceTrigger();
        }
    }

    public boolean isBackground() {
        return this.isBackground;
    }

    public boolean isSystemPlayer() {
        return this.mPlayerType == 0;
    }

    public void enableImgoVSR(boolean bl) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.g(bl);
        }
    }

    public static void setPlayerDebug(boolean bl) {
        PlayerConfig.setPlayerDebug(bl);
    }

    public static void setPlayerDebugLog(int n2, int n3) {
        PlayerConfig.setPlayerDebugInfo(n2);
        PlayerConfig.setPlayerDebugLogLevel(n3);
    }

    static /* synthetic */ String[] access$4202(MgtvMediaPlayer mgtvMediaPlayer, String[] stringArray) {
        mgtvMediaPlayer.mLastIps = stringArray;
        return stringArray;
    }

    static {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                DebugLog.i(TAG, "DeviceInfo======\nCputy:" + NetPlayConfigHelper.getCputy() + "\nOmxcn:" + NetPlayConfigHelper.getOmxcn() + "\nMod:" + NetPlayConfigHelper.getMod() + "\n======DeviceInfo");
                DebugLog.d(TAG, "async getH265Decoder & getH264Decoder in");
                MediaCodecHelp.getH265Decoder(true);
                MediaCodecHelp.getH264Decoder(true);
                MediaCodecHelp.getALLAV1Decoder(true);
                DebugLog.d(TAG, "async getH265Decoder & getH264Decoder out");
            }
        });
        thread.setName("mgtvmp_jPreInfo");
        thread.start();
    }

    private static class WeakHandler
    extends Handler {
        public static final int MSG_PTS = 256;
        private WeakReference<MgtvMediaPlayer> mWeakPlayer;

        public WeakHandler(Looper looper, MgtvMediaPlayer mgtvMediaPlayer) {
            super(looper);
            this.mWeakPlayer = new WeakReference<MgtvMediaPlayer>(mgtvMediaPlayer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) {
            MgtvMediaPlayer mgtvMediaPlayer = (MgtvMediaPlayer)this.mWeakPlayer.get();
            if (mgtvMediaPlayer == null) {
                return;
            }
            switch (message.what) {
                case 256: {
                    MgtvPlayerListener.FrameClock frameClock = (MgtvPlayerListener.FrameClock)message.obj;
                    Object object = mgtvMediaPlayer.ptsLocker;
                    synchronized (object) {
                        for (MgtvPlayerListener.OnVideoPTSListener onVideoPTSListener : mgtvMediaPlayer.ptsListeners) {
                            onVideoPTSListener.onVideoPTS(frameClock);
                        }
                        break;
                    }
                }
            }
        }
    }

    public static class PlayerExtraInfo {
        public String playSessionID;
        public String lastIP;
        public long smt;
        public long dlt;
        public long buftimeMs;
        public long bufsizeByte;
    }

    public static enum Hw2SwType {
        NONE,
        HW_2_SW_RESET,
        HW_2_SW_DEFAULT,
        HW_2_SW_OTHER;

    }

    public static class IPList {
        public String hostName;
        public List<String> srcList = new ArrayList<String>();
        public List<String> nUseList = new ArrayList<String>();
        public List<String> errList = new ArrayList<String>();
        public long startTimeMs;
        public int ttlMs;
        private boolean isIPValid = true;

        public IPList(String string, String[] stringArray) {
            this.hostName = string;
            if (stringArray != null && stringArray.length > 0) {
                for (String string2 : stringArray) {
                    if (!e.e(string2)) continue;
                    this.srcList.add(string2);
                    this.nUseList.add(string2);
                }
            }
            this.startTimeMs = System.currentTimeMillis();
            this.ttlMs = 45000;
        }

        public static String formatIPList(List<String> list) {
            String string = "";
            if (list != null && list.size() > 0) {
                for (String string2 : list) {
                    string = string + string2 + ";";
                }
            }
            return string;
        }

        public static String formatIPList(String[] stringArray) {
            String string = "";
            if (stringArray != null && stringArray.length > 0) {
                for (String string2 : stringArray) {
                    string = string + string2 + ";";
                }
            }
            return string;
        }

        public boolean checkTTL() {
            if (this.isIPValid) {
                long l2 = 0L;
                l2 = System.currentTimeMillis() - this.startTimeMs;
                this.isIPValid = l2 > 0L && l2 < (long)this.ttlMs;
            }
            return this.isIPValid;
        }

        public String toString() {
            return "nUseList:" + IPList.formatIPList(this.nUseList);
        }
    }

    private static final class MainNotifyHandler
    extends Handler {
        public static final int MSG_IP_IS_LAN = 1002;
        public static final int MSG_HTTPDNS_REPORT_PV = 2000;
        public static final int MSG_HTTPDNS_REPORT_SUC = 2001;
        public static final int MSG_HTTPDNS_REPORT_ERR = 2002;
        public static final String BUNDLE_STR_INFO1 = "bundle_str_info1";
        public static final String BUNDLE_STR_INFO2 = "bundle_str_info2";
        private WeakReference<MgtvMediaPlayer> mWeakObj;

        public MainNotifyHandler(MgtvMediaPlayer mgtvMediaPlayer) {
            super(Looper.getMainLooper());
            this.mWeakObj = new WeakReference<MgtvMediaPlayer>(mgtvMediaPlayer);
        }

        public void handleMessage(Message message) {
            MgtvMediaPlayer mgtvMediaPlayer = (MgtvMediaPlayer)this.mWeakObj.get();
            if (mgtvMediaPlayer == null) {
                return;
            }
            Bundle bundle = message.getData();
            switch (message.what) {
                case 2000: {
                    if (mgtvMediaPlayer.mOnWarningListener == null) break;
                    mgtvMediaPlayer.mOnWarningListener.onWarning(800200, message.arg1 + "", String.valueOf(message.obj), null);
                    break;
                }
                case 2001: {
                    if (mgtvMediaPlayer.mOnWarningListener == null) break;
                    mgtvMediaPlayer.mOnWarningListener.onWarning(800201, message.arg1 + "", String.valueOf(message.obj), null);
                    break;
                }
                case 2002: {
                    if (mgtvMediaPlayer.mOnWarningListener == null) break;
                    mgtvMediaPlayer.mOnWarningListener.onWarning(800202, message.arg1 + "", String.valueOf(message.obj), null);
                    break;
                }
                case 1002: {
                    if (bundle == null || mgtvMediaPlayer.mOnWarningListener == null) break;
                    mgtvMediaPlayer.mOnWarningListener.onWarning(800101, bundle.getString(BUNDLE_STR_INFO1), bundle.getString(BUNDLE_STR_INFO2), null);
                }
            }
        }
    }

    public static class DataSourceInfo {
        public static final String H264 = "h264";
        public static final String H265 = "h265";
        public static final String MPEG2 = "mpeg2";
        public static final String MPEG4 = "mpeg4";
        public static final String OTHER = "other";
        public static final String FILE_FORMAT_FMP4 = "fmp4";
        public static final String INIT_VALUE = "init";
        private String videoFormat;
        private String audioFormat;
        private String bitRate;
        private String fileFormat;
        private int videoWidth;
        private int videoHeight;

        public String getVideoFormat() {
            return this.videoFormat;
        }

        public DataSourceInfo setVideoFormat(String string) {
            this.videoFormat = string;
            return this;
        }

        public String getAudioFormat() {
            return this.audioFormat;
        }

        public DataSourceInfo setAudioFormat(String string) {
            this.audioFormat = string;
            return this;
        }

        public String getBitRate() {
            return this.bitRate;
        }

        public DataSourceInfo setBitRate(String string) {
            this.bitRate = string;
            return this;
        }

        public String getFileFormat() {
            return this.fileFormat;
        }

        public DataSourceInfo setFileFormat(String string) {
            this.fileFormat = string;
            return this;
        }

        public int getVideoWidth() {
            return this.videoWidth;
        }

        public DataSourceInfo setVideoWidth(int n2) {
            this.videoWidth = n2;
            return this;
        }

        public int getVideoHeight() {
            return this.videoHeight;
        }

        public DataSourceInfo setVideoHeight(int n2) {
            this.videoHeight = n2;
            return this;
        }

        public String toString() {
            return "DataSourceInfo{videoFormat='" + this.videoFormat + '\'' + ", bitRate='" + this.bitRate + '\'' + ", fileFormat='" + this.fileFormat + '\'' + ", videoWidth=" + this.videoWidth + ", videoHeight=" + this.videoHeight + '}';
        }
    }

    public static enum EncodeType {
        H264,
        H265,
        MPEG2,
        MPEG4,
        OTHER;

    }

    public static enum RenderType {
        NATIVE_WINDOW,
        OPENGL_ES;

    }

    public static enum PlayStatus {
        ERROR,
        IDLE,
        PREPARING,
        PREPARED,
        PLAYING,
        PAUSED,
        COMPLETED;

    }

    public static enum Prepared4StartMode {
        MODE_PREPARED4START_DEFAULT,
        MODE_PREPARED4START_AUTOPLAY,
        MODE_PREPARED4START_LOADDATA,
        MODE_PREPARED4START_LOADDATA_DISAV;

    }

    public static enum NativeSoType {
        TYPE_NATIVESO_IMGOFFMPEG,
        TYPE_NATIVESO_IMGOHELP,
        TYPE_NATIVESO_IMGOMEDIAPLAYER,
        TYPE_NATIVESO_IMGODS;

    }

    public static enum PlayerModeType {
        TYPE_PLAYER_MODE_NORMAL,
        TYPE_PLAYER_MODE_LIVE,
        TYPE_PLAYER_MODE_LOOP,
        TYPE_PLAYER_MODE_SMOOTH;

    }

    public static enum AddrinfoType {
        TYPE_ADDRINFO_DEFAULT,
        TYPE_ADDRINFO_THREAD,
        TYPE_ADDRINFO_ONE_BY_ONE,
        TYPE_DNS_CACHE;

    }

    public static enum SkipLoopFilterType {
        TYPE_SKIPLOOPFILTER_NONE,
        TYPE_SKIPLOOPFILTER_NONREF,
        TYPE_SKIPLOOPFILTER_BIDIR,
        TYPE_SKIPLOOPFILTER_NONKEY,
        TYPE_SKIPLOOPFILTER_ALL;

    }

    public static enum DataSourceType {
        TYPE_DATASOUCE_DEFAULT,
        TYPE_DATASOUCE_IMGO;

    }
}

