/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.view.TextureView;
import android.view.View;
import com.hunantv.media.player.IMgtvRenderView;
import com.hunantv.media.player.MgtvPlayerListener;
import com.hunantv.media.player.c;
import com.hunantv.media.player.d.d;
import com.hunantv.media.player.d.f;
import com.hunantv.media.player.j;
import com.hunantv.media.player.l;
import com.hunantv.media.report.c.h;
import com.hunantv.media.widget.IVideoView;

public class MgtvRenderView {
    public static final int MGTV_AR_ASPECT_FIT_PARENT = 0;
    public static final int MGTV_AR_ASPECT_FILL_PARENT = 1;
    public static final int MGTV_AR_ASPECT_WRAP_CONTENT = 2;
    public static final int MGTV_AR_MATCH_PARENT = 3;
    public static final int MGTV_AR_16_9_FIT_PARENT = 4;
    public static final int MGTV_AR_4_3_FIT_PARENT = 5;
    public static final int MGTV_RENDER_SURFACE_VIEW = 0;
    public static final int MGTV_RENDER_TEXTURE_VIEW = 1;
    private j mRenderView;
    private c mFakeFrameView;

    public MgtvRenderView(Context context) {
        this.mRenderView = new j(context);
    }

    public MgtvRenderView(Context context, int n2, boolean bl, MgtvPlayerListener.OnWarningListener onWarningListener, f.a a2) {
        if (!d.a && (Build.VERSION.SDK_INT < 23 || d.a(h.c()))) {
            bl = false;
        }
        this.mRenderView = new j(context, n2, bl, onWarningListener, a2);
    }

    public void bind(IVideoView iVideoView) {
        this.mRenderView.a(iVideoView);
    }

    public void bindFakeFrameView(c c2) {
        this.mFakeFrameView = c2;
    }

    public void bindResizableFrameView(l l2) {
        this.mRenderView.a(l2);
    }

    public IMgtvRenderView getRenderView() {
        return this.mRenderView.a();
    }

    public int getRenderViewType() {
        return this.mRenderView.b();
    }

    public View getView() {
        return this.mRenderView.c();
    }

    public boolean shouldWaitForResize() {
        return this.mRenderView.d();
    }

    public void setVideoSize(int n2, int n3) {
        this.mRenderView.a(n2, n3);
        if (this.mFakeFrameView != null) {
            this.mFakeFrameView.a(n2, n3);
        }
    }

    public void setVideoSampleAspectRatio(int n2, int n3) {
        this.mRenderView.b(n2, n3);
    }

    public void setVideoRotation(int n2) {
        this.mRenderView.a(n2);
        if (this.mFakeFrameView != null) {
            this.mFakeFrameView.setVideoRotation(n2);
        }
    }

    public void setAspectRatio(int n2) {
        this.mRenderView.b(n2);
        if (this.mFakeFrameView != null) {
            this.mFakeFrameView.setAspectRatio(n2);
        }
    }

    public void addRenderCallback(IMgtvRenderView.IRenderCallback iRenderCallback) {
        this.mRenderView.a(iRenderCallback);
    }

    public void removeRenderCallback(IMgtvRenderView.IRenderCallback iRenderCallback) {
        this.mRenderView.b(iRenderCallback);
    }

    public void setManualRotation(int n2, int n3, int n4, int n5, int n6) {
        this.mRenderView.a(n2, n3, n4, n5, n6);
    }

    public void setAntiAliasing(boolean bl) {
        if (this.mRenderView != null) {
            this.mRenderView.a(bl);
        }
    }

    public void setAntiShake(boolean bl) {
        if (this.mRenderView != null) {
            this.mRenderView.b(bl);
        }
    }

    public void setRenderFilter(int n2) {
        this.mRenderView.c(n2);
    }

    public void setDisplayFloatRect(IMgtvRenderView.FloatRect floatRect) {
        this.mRenderView.a(floatRect);
    }

    public IMgtvRenderView.FloatRect getDisplayCoordinate() {
        return this.mRenderView.e();
    }

    public void release() {
        if (this.mRenderView != null) {
            this.mRenderView.f();
        }
    }

    public void reset() {
        if (this.mRenderView != null) {
            this.mRenderView.g();
        }
    }

    public void saveLastValidFrame() {
        boolean bl;
        View view = this.getView();
        if (this.mFakeFrameView != null && view != null && view instanceof TextureView && (bl = this.checkLastFrameValid((TextureView)view, 160, 90))) {
            this.mFakeFrameView.setImageBitmap(((TextureView)this.mRenderView.c()).getBitmap());
        }
    }

    private boolean checkLastFrameValid(TextureView textureView, int n2, int n3) {
        boolean bl;
        block4: {
            if (textureView == null) {
                return false;
            }
            int[] nArray = new int[n2 * n3];
            bl = false;
            try {
                Bitmap bitmap = textureView.getBitmap(n2, n3);
                if (bitmap == null) break block4;
                bitmap.getPixels(nArray, 0, n2, 0, 0, n2, n3);
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    if (nArray[i2] == nArray[0]) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static String getAspectRatioName(int n2) {
        switch (n2) {
            case 0: {
                return "FIT_PARENT";
            }
            case 1: {
                return "FILL_PARENT";
            }
            case 2: {
                return "WRAP_CONTENT";
            }
            case 3: {
                return "MATCH_PARENT";
            }
            case 4: {
                return "16_9";
            }
            case 5: {
                return "4_3";
            }
        }
        return "unknown";
    }

    public static String getRenderTypeName(int n2) {
        switch (n2) {
            case 0: {
                return "SurfaceView";
            }
            case 1: {
                return "TextureView";
            }
        }
        return "unknown";
    }
}

