/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.flow;

import com.google.gson.Gson;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.player.flow.entity.FlowReportEntity;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.statistic.FlowDataStatistic;
import com.hunantv.media.player.utils.ExTicker;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.player.utils.UrlUtil;
import com.hunantv.media.report.ReportParams;
import com.mgtv.easydatasource.FlowReporter;
import java.text.DecimalFormat;

public class FlowReportProcessor {
    private static final String TAG = "FlowReportProcessor";
    private static final int STATUS_IDLE = 0;
    private static final int STATUS_START = 1;
    private static final int STATUS_STOP = 2;
    String flag;
    String vid;
    int def;
    String suuid;
    boolean isP2p;
    int stream_type = 1;
    int w;
    int h;
    String encodeInfo;
    int file_size;
    FlowReporter reporter;
    volatile int status = 0;
    int duration;
    String url;
    ExTicker pushInfo2Ticker = null;
    FlowDataStatistic flowStatistic = new FlowDataStatistic();
    Object locker = new Object();

    public static String replaceUrlSftcNoP2p(String string, ReportParams reportParams) {
        if (UrlUtil.isLocal(string) || reportParams != null && reportParams.isP2p()) {
            return string;
        }
        return FlowReportProcessor.replaceUrlSftc(string, reportParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replaceUrlSftc(String string, ReportParams reportParams) {
        try {
            DebugLog.i(TAG, "replaceUrlSftc in. url=" + string);
            if (StringUtil.isEmpty(string)) {
                String string2 = string;
                return string2;
            }
            String string3 = ReportParams.GlobalSet.getsAppVersionName();
            string3 = StringUtil.isEmpty(string3) ? "vn" : "v" + string3;
            String string4 = "ds1";
            String string5 = "";
            if (string.contains("drmFlag=1")) {
                string5 = "_drm1";
            }
            String string6 = "";
            if (string.contains("sftc=free")) {
                string6 = "_free";
            }
            String string7 = "_vtp";
            if (reportParams != null) {
                string7 = string7 + ReportParams.getVideoTypeStr(reportParams.getVideoType());
            }
            String string8 = string3 + string4 + string5 + string6 + string7 + "_" + ReportParams.GlobalSet.getsChannelId();
            if (string.contains("sftc=")) {
                String string9 = UrlUtil.getUrlParamsValue(string, "sftc");
                if (StringUtil.isEmpty(string9)) {
                    string9 = "";
                }
                String string10 = string = string.replace("sftc=" + string9, "sftc=" + string8);
                return string10;
            }
            string = string.indexOf("?") >= 0 ? string + "&sftc=" + string8 : string + "?sftc=" + string8;
            String string11 = string;
            return string11;
        }
        finally {
            DebugLog.i(TAG, "replaceUrlSftc out. url=" + string);
        }
    }

    public static boolean isEnable() {
        return FlowReporter.isInited() && NetPlayConfig.getFlowReportMode() != 0;
    }

    public static boolean isInvalidVideoType(ReportParams reportParams) {
        return reportParams != null && reportParams.getVideoType() != null && (reportParams.getVideoType() == ReportParams.VideoType.AD_BOOT || reportParams.getVideoType() == ReportParams.VideoType.AD_PRE || reportParams.getVideoType() == ReportParams.VideoType.AD_MID || reportParams.getVideoType() == ReportParams.VideoType.LIVE || reportParams.getVideoType() == ReportParams.VideoType.LOCAL || reportParams.getVideoType() == ReportParams.VideoType.STAR_ROOM_LIVE || reportParams.getVideoType() == ReportParams.VideoType.GIF_PREVIEW_VIDEO || reportParams.getVideoType() == ReportParams.VideoType.GIF_PREVIEW_IMAGE || reportParams.getVideoType() == ReportParams.VideoType.GIF_CREATOR || reportParams.getVideoType() == ReportParams.VideoType.SOCIAL_AUDIO_CHAT);
    }

    public FlowReportProcessor(String string, String string2, int n2, String string3, boolean bl, String string4) {
        this.url = string;
        this.vid = string2;
        this.def = n2;
        this.suuid = string3;
        this.isP2p = bl;
        this.flag = string4;
        this.reporter = new FlowReporter(string2, n2, string3);
        DebugLog.i(this.getLogTag(), "FlowReporter version: " + FlowReporter.getVersion());
        DebugLog.i(this.getLogTag(), "vid:" + string2 + ",def:" + n2 + ",suuid:" + string3 + ", isP2p:" + bl);
    }

    public void setDuration(int n2) {
        this.duration = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int n2, int n3, int n4, String string, int n5) {
        Object object = this.locker;
        synchronized (object) {
            this.stream_type = n2;
            this.w = n3;
            this.h = n4;
            this.encodeInfo = string;
            this.file_size = n5;
            if (this.status != 0) {
                DebugLog.i(this.getLogTag(), "start return cause current status :" + this.status);
                return;
            }
            DebugLog.i(this.getLogTag(), "start stream_type:" + n2 + ",w:" + n3 + ",h:" + n4 + ",encodeInfo:" + string + ",url:" + this.url);
            this.reporter.setVideoMetadata(n3, n4, string);
            this.reporter.start(this.url);
            if (!this.isHls()) {
                if (this.pushInfo2Ticker != null) {
                    this.pushInfo2Ticker.stop();
                    this.pushInfo2Ticker = null;
                }
                this.pushInfo2Ticker = new ExTicker(10000);
                this.pushInfo2Ticker.setCallback(new ExTicker.onTickListener(){

                    @Override
                    public void onTick(int n2) {
                        if (n2 == 1) {
                            return;
                        }
                        FlowReportProcessor.this.pushCurrentPlayerFlowInfo2();
                    }
                });
                this.pushInfo2Ticker.start();
            }
            this.status = 1;
        }
    }

    private void pushCurrentPlayerFlowInfo2() {
        if (!this.isHls()) {
            FlowReportEntity flowReportEntity = new FlowReportEntity();
            flowReportEntity.url = this.url;
            flowReportEntity.file_size = this.file_size;
            flowReportEntity.down_size = this.flowStatistic.getDynamicIntervalBytes();
            flowReportEntity.error_type = 0;
            flowReportEntity.error_code = 0;
            flowReportEntity.file_dur = new DecimalFormat("0.000000").format((float)this.duration / 1000.0f) + "";
            flowReportEntity.file_seq = "0";
            this.pushPlayerFlowInfo2(flowReportEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.locker;
        synchronized (object) {
            if (this.status == 2) {
                DebugLog.i(this.getLogTag(), "stop return cause already stopped");
                return;
            }
            this.pushCurrentPlayerFlowInfo2();
            DebugLog.i(this.getLogTag(), "stop url:" + this.url);
            this.reporter.start(this.url);
            this.reporter.stop();
            if (this.pushInfo2Ticker != null) {
                this.pushInfo2Ticker.stop();
                this.pushInfo2Ticker = null;
            }
            this.status = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceTrigger() {
        Object object = this.locker;
        synchronized (object) {
            DebugLog.i(this.getLogTag(), "forceTrigger");
            this.reporter.forceTrigger();
        }
    }

    public boolean isP2p() {
        return this.isP2p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHls() {
        Object object = this.locker;
        synchronized (object) {
            return this.stream_type == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPlayerFlowInfo(FlowReportEntity flowReportEntity) {
        Object object = this.locker;
        synchronized (object) {
            if (this.isP2p) {
                return;
            }
            if (!this.isHls()) {
                return;
            }
            if (flowReportEntity != null) {
                String string = new Gson().toJson((Object)flowReportEntity);
                DebugLog.d(this.getLogTag(), "pushPlayerFlowInfo json " + string);
                this.reporter.pushFlowInfo(string, 1, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPlayerFlowInfo2(FlowReportEntity flowReportEntity) {
        Object object = this.locker;
        synchronized (object) {
            if (this.isP2p) {
                return;
            }
            if (this.isHls()) {
                return;
            }
            if (flowReportEntity != null) {
                String string = new Gson().toJson((Object)flowReportEntity);
                DebugLog.d(this.getLogTag(), "pushPlayerFlowInfo2 json " + string);
                this.reporter.pushFlowInfo(string, 1, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushP2pFlowInfo(String string) {
        Object object = this.locker;
        synchronized (object) {
            if (!this.isP2p) {
                return;
            }
            if (!StringUtil.isEmpty(string)) {
                DebugLog.d(this.getLogTag(), "pushP2pFlowInfo json " + string);
                this.reporter.pushFlowInfo(string, 2, 1);
            }
        }
    }

    public FlowDataStatistic getFlowStatistic() {
        return this.flowStatistic;
    }

    private String getLogTag() {
        return "FlowReportProcessor-" + this.hashCode() + "-" + this.flag + "-" + (this.isP2p ? 1 : 0);
    }
}

