/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.helper;

import android.media.CamcorderProfile;
import android.os.Build;
import android.text.TextUtils;
import com.hunantv.media.player.helper.MediaCodecHelp;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.report.c.f;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildHelper {
    public static int FROYO = 8;
    public static int GINGERBREAD = 9;
    public static int GINGERBREAD_MR1 = 10;
    public static int HONEYCOMB = 11;
    public static int HONEYCOMB_MR1 = 12;
    public static int HONEYCOMB_MR2 = 13;
    public static int ICE_CREAM_SANDWICH = 14;
    public static int ICE_CREAM_SANDWICH_MR1 = 15;
    public static int JELLY_BEAN = 16;
    public static int JELLY_BEAN_MR1 = 17;
    public static int JELLY_BEAN_MR2 = 18;
    public static int KITKAT = 19;
    public static int KITKAT_MR1 = 20;
    public static int LOLLIPOP = 21;
    public static int LOLLIPOP_MR1 = 22;
    public static int ANDROID_M = 23;
    public static int ANDROID_N = 24;
    public static int ANDROID_N_MR1 = 25;
    public static int ANDROID_O = 26;
    public static int ANDROID_P = 28;
    public static int ANDROID_Q = 29;
    public static int ANDROID_UNKNOWN = 27;
    public static final String ABI_ARM64_V8A = "arm64-v8a";
    public static final String ABI_ARMv7a = "armeabi-v7a";
    public static final String ABI_ARM = "armeabi";
    public static final String ABI_X86 = "x86";
    private static String[] mBlackListModes = new String[]{"virtual machine", "CHM-TL"};

    public static final String getModel() {
        return Build.MODEL;
    }

    public static final String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static final int getSDKVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static final boolean isApi9_GingerBread() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 >= FROYO && n2 <= GINGERBREAD_MR1;
    }

    public static final boolean isApi9_GingerBreadOrLater() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 >= GINGERBREAD;
    }

    public static final boolean isApi11_HoneyComb() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 >= HONEYCOMB && n2 <= HONEYCOMB_MR2;
    }

    public static final boolean isApi11_HoneyCombOrLater() {
        return BuildHelper.getSDKVersion() >= HONEYCOMB;
    }

    public static final boolean isIceCreamSandwich() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 >= ICE_CREAM_SANDWICH && n2 <= ICE_CREAM_SANDWICH_MR1;
    }

    public static final boolean isApi14_IceCreamSandwich() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == ICE_CREAM_SANDWICH && n2 <= ICE_CREAM_SANDWICH_MR1;
    }

    public static final boolean isApi14_IceCreamSandwichOrLater() {
        return BuildHelper.getSDKVersion() >= ICE_CREAM_SANDWICH;
    }

    public static final boolean isApi16_JellyBean() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == JELLY_BEAN;
    }

    public static final boolean isApi16_JellyBeanOrLater() {
        return BuildHelper.getSDKVersion() >= JELLY_BEAN;
    }

    public static final boolean isApi17_JellyBeanMR1() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == JELLY_BEAN_MR1;
    }

    public static final boolean isApi17_JellyBeanMR1OrLater() {
        return BuildHelper.getSDKVersion() >= JELLY_BEAN_MR1;
    }

    public static final boolean isApi18_JellyBeanMR2() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == JELLY_BEAN_MR2;
    }

    public static final boolean isApiLess18_JellyBeanMR2() {
        return BuildHelper.getSDKVersion() < JELLY_BEAN_MR2;
    }

    public static final boolean isApi18_JellyBeanMR2OrLater() {
        return BuildHelper.getSDKVersion() >= JELLY_BEAN_MR2;
    }

    public static final boolean isApi19_KitKat() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == KITKAT;
    }

    public static final boolean isApi19_KitKatOrLater() {
        return BuildHelper.getSDKVersion() >= KITKAT;
    }

    public static final boolean isApi20_KitKatMR1() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == KITKAT_MR1;
    }

    public static final boolean isApi20_KitKatMR1OrLater() {
        return BuildHelper.getSDKVersion() >= KITKAT_MR1;
    }

    public static final boolean isApi21_LOLLIPOPO() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == LOLLIPOP;
    }

    public static final boolean isApi21_LollipopOrLater() {
        return BuildHelper.getSDKVersion() >= LOLLIPOP;
    }

    public static final boolean isApi22_LollipopMR1() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == LOLLIPOP_MR1;
    }

    public static final boolean isApi22_LollipopMR1OrLater() {
        return BuildHelper.getSDKVersion() >= LOLLIPOP_MR1;
    }

    public static final boolean isApi23_AndroidM() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == ANDROID_M;
    }

    public static final boolean isApi23_AndroidMOrLater() {
        return BuildHelper.getSDKVersion() >= ANDROID_M;
    }

    public static final boolean isApi24_AndroidN() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == ANDROID_N;
    }

    public static final boolean isApi24_AndroidNOrLater() {
        return BuildHelper.getSDKVersion() >= ANDROID_N;
    }

    public static final boolean isApi25_AndroidNMR1() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == ANDROID_N_MR1;
    }

    public static final boolean isApi25_AndroidNMR1OrLater() {
        return BuildHelper.getSDKVersion() >= ANDROID_N_MR1;
    }

    public static final boolean isApi26_AndroidO() {
        int n2 = BuildHelper.getSDKVersion();
        return n2 == ANDROID_O;
    }

    public static final boolean isApi26_AndroidOOrLater() {
        return BuildHelper.getSDKVersion() >= ANDROID_O;
    }

    public static final boolean isApi29_LollipopOrLater() {
        return BuildHelper.getSDKVersion() >= ANDROID_Q;
    }

    public static boolean supportARM64v8a() {
        return BuildHelper.supportABI(ABI_ARM64_V8A);
    }

    public static boolean supportARMv7a() {
        return BuildHelper.supportABI(ABI_ARMv7a);
    }

    private static String parseCpuInfo(String string, String string2) {
        try {
            Pattern pattern = Pattern.compile(string2 + "\\s+\\:\\s*(.*)");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean findX86(String string) {
        String string2 = "";
        try {
            string2 = BuildHelper.parseCpuInfo(string, "model name");
            if (string2 != null && string2.contains("intel")) {
                return true;
            }
            string2 = BuildHelper.parseCpuInfo(string, "vendor_id");
            if (string2 != null && string2.contains("intel")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isX86FromCpuinfo() {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/cpuinfo")), 1000);
            while ((string = bufferedReader.readLine()) != null) {
                if (!BuildHelper.findX86(string = string.toLowerCase())) continue;
                bl = true;
                break;
            }
            f.a(bufferedReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            f.a(bufferedReader);
        }
        return bl;
    }

    public static boolean supportX86() {
        boolean bl = BuildHelper.supportABI(ABI_X86);
        if (!bl && BuildHelper.isApi16_JellyBeanOrLater()) {
            bl = MediaCodecHelp.isIntelMediaCodec();
            if (bl) {
                DebugLog.i("ImgoPlayerLibJava", "isIntelMediaCodec");
            } else if (BuildHelper.isX86FromCpuinfo()) {
                bl = true;
                DebugLog.i("ImgoPlayerLibJava", "isX86FromCpuinfo");
            }
        }
        return bl;
    }

    public static boolean isImgdsBlackList() {
        String string = Build.MODEL;
        if (string != null) {
            for (String string2 : mBlackListModes) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean supportARM() {
        return BuildHelper.supportABI(ABI_ARM);
    }

    public static boolean supportABI(String string) {
        if (Build.VERSION.SDK_INT >= 21 && Build.SUPPORTED_ABIS != null && Build.SUPPORTED_ABIS.length > 0) {
            for (String string2 : Build.SUPPORTED_ABIS) {
                if (TextUtils.isEmpty((CharSequence)string2) || !string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        String string3 = BuildHelper.get_CPU_ABI();
        if (!TextUtils.isEmpty((CharSequence)string3) && string3.equalsIgnoreCase(string)) {
            return true;
        }
        String string4 = BuildHelper.get_CPU_ABI2();
        return !TextUtils.isEmpty((CharSequence)string4) && string4.equalsIgnoreCase(string);
    }

    public static final String getParsedCpuAbiInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = BuildHelper.get_CPU_ABI();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append("CPU ABI : ");
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        String string2 = BuildHelper.get_CPU_ABI2();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append("CPU ABI2 : ");
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static final String get_CPU_ABI() {
        return Build.CPU_ABI;
    }

    public static final String get_CPU_ABI2() {
        try {
            Field field = Build.class.getDeclaredField("CPU_ABI2");
            if (field == null) {
                return null;
            }
            Object object = field.get(null);
            if (field == null || !(object instanceof String)) {
                return null;
            }
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean getNeedSpecialSurface() {
        String string = Build.MODEL;
        return string.startsWith("SM-N900") || string.startsWith("GT-N710") || Build.VERSION.SDK_INT == 14 || Build.VERSION.SDK_INT == 15;
    }

    public static int getDecodeSupportMaxWidth() {
        CamcorderProfile camcorderProfile = CamcorderProfile.get((int)1);
        if (camcorderProfile != null) {
            return camcorderProfile.videoFrameWidth;
        }
        String string = Build.MODEL;
        if (string.startsWith("SM-N900")) {
            return 1920;
        }
        if (string.equals("HTC Desire X")) {
            return 800;
        }
        return 0;
    }

    public static int getDecodeSupportMaxHeight() {
        CamcorderProfile camcorderProfile = CamcorderProfile.get((int)1);
        if (camcorderProfile != null) {
            return camcorderProfile.videoFrameHeight;
        }
        String string = Build.MODEL;
        if (string.startsWith("SM-N900")) {
            return 1080;
        }
        if (string.equals("HTC Desire X")) {
            return 480;
        }
        return 0;
    }

    public static int getNumCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCpuFrequence() {
        BufferedReader bufferedReader = null;
        try {
            String[] stringArray = new String[]{"/system/bin/cat", "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq"};
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = bufferedReader.readLine();
            int n2 = Integer.parseInt(string);
            f.a(bufferedReader);
            return n2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            f.a(bufferedReader);
        }
        return 0;
    }

    public static String[] supportedAbis() {
        if (Build.VERSION.SDK_INT >= 21 && Build.SUPPORTED_ABIS.length > 0) {
            return Build.SUPPORTED_ABIS;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.CPU_ABI2)) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return new String[]{Build.CPU_ABI};
    }
}

