/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.helper;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Range;
import android.util.Size;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.player.helper.BuildHelper;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.ArrayUtil;
import com.hunantv.media.player.utils.PreferencesUtil;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.report.c.f;
import com.hunantv.media.report.c.h;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class MediaCodecHelp {
    public static String AMIME_VIDEO_VP8 = "video/x-vnd.on2.vp8";
    public static String AMIME_VIDEO_VP9 = "video/x-vnd.on2.vp9";
    public static String AMIME_VIDEO_AVC = "video/avc";
    public static String AMIME_VIDEO_HEVC = "video/hevc";
    public static String AMIME_VIDEO_AV1 = "video/av01";
    public static String AMIME_VIDEO_MPEG4 = "video/mp4v-es";
    public static String AMIME_VIDEO_H263 = "video/3gpp";
    public static String AMIME_AUDIO_AMR_NB = "audio/3gpp";
    public static String AMIME_AUDIO_AMR_WB = "audio/amr-wb";
    public static String AMIME_AUDIO_MP3 = "audio/mpeg";
    public static String AMIME_AUDIO_RAW_AAC = "audio/mp4a-latm";
    public static String AMIME_AUDIO_VORBIS = "audio/vorbis";
    public static String AMIME_AUDIO_G711_ALAW = "audio/g711-alaw";
    public static String AMIME_AUDIO_G711_MLAW = "audio/g711-mlaw";
    public static String tag = "MediaCodecHelp";
    public static String UNKOWN = "UnKown";
    public static String UHD_MIN = "UHD_15_BELOW";
    public static String UHD_15 = "UHD_15";
    public static String UHD_20 = "UHD_20";
    public static String UHD_24 = "UHD_24";
    public static String UHD_25 = "UHD_25";
    public static String UHD_30 = "UHD_30";
    public static String UHD_40 = "UHD_40";
    public static String UHD_50 = "UHD_50";
    public static String UHD_60 = "UHD_60";
    public static String UHD_70 = "UHD_70";
    public static String UHD_80 = "UHD_80";
    public static String UHD_90 = "UHD_90";
    public static String UHD_100 = "UHD_100";
    public static String UHD_120 = "UHD_120";
    public static String UHD_MAX = "UHD_120_OVER";
    public static String FHD_MIN = "FHD_15_BELOW";
    public static String FHD_15 = "FHD_15";
    public static String FHD_20 = "FHD_20";
    public static String FHD_24 = "FHD_24";
    public static String FHD_25 = "FHD_25";
    public static String FHD_30 = "FHD_30";
    public static String FHD_40 = "FHD_40";
    public static String FHD_50 = "FHD_50";
    public static String FHD_60 = "FHD_60";
    public static String FHD_70 = "FHD_70";
    public static String FHD_80 = "FHD_80";
    public static String FHD_90 = "FHD_90";
    public static String FHD_100 = "FHD_100";
    public static String FHD_120 = "FHD_120";
    public static String FHD_MAX = "FHD_120_OVER";
    public static String SHD = "SHD";
    public static String UHD = "UHD";
    public static String FHD = "FHD";
    public static String HD = "HD";
    public static String SD = "SD";
    public static String SD_BELOW = "SD_BELOW";
    private static volatile String sAVCDecoder;
    private static volatile String sHEVCDecoder;
    public static ArrayList<CodecPerformance> sCodecPerformanceList;
    private static boolean isHardware;
    private static boolean isConvert;
    private static Map<String, Boolean> sMediaCodecMap;
    private static final String MEDIA_CODEC_XML_FILE = "/etc/media_codecs.xml";
    private static final String VENDOR_MEDIA_CODEC_XML_FILE = "/vendor/etc/media_codecs.xml";
    private static final String ODM_MEDIA_CODEC_XML_FILE = "/odm/etc/media_codecs.xml";
    private static final String[] sCodecFiles;
    private static volatile String sAV1Decoder;
    private static final String[] sH265BlackListMods;
    public static boolean sH265Enable;
    public static Set<String> sCreateCodecBlackList;
    public static Set<String> sFlushCodecBlackList;
    public static volatile String sDisplayPerformance;

    @TargetApi(value=16)
    private static MediaCodecInfo getSelectCodec(String string) {
        try {
            int n2 = MediaCodecList.getCodecCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
                if (mediaCodecInfo.isEncoder()) continue;
                for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    DebugLog.i("ImgoPlayerLibJava", "SelectCodec : " + mediaCodecInfo.getName());
                    return mediaCodecInfo;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @TargetApi(value=21)
    private static String getSelectCodecDecoder21orLater(String string) {
        try {
            MediaCodecInfo[] mediaCodecInfoArray;
            MediaCodecList mediaCodecList = new MediaCodecList(1);
            for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoArray = mediaCodecList.getCodecInfos()) {
                if (mediaCodecInfo.isEncoder()) continue;
                for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string2.equalsIgnoreCase(string) || mediaCodecInfo.getName().startsWith("OMX.google.")) continue;
                    DebugLog.i("ImgoPlayerLibJava", "getSelectCodecDecoder21orLater : " + mediaCodecInfo.getName());
                    return mediaCodecInfo.getName();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @TargetApi(value=21)
    private static String getSelectALLCodecNameDecoder21orLater(String string) {
        String string2 = null;
        try {
            MediaCodecInfo[] mediaCodecInfoArray;
            MediaCodecList mediaCodecList = new MediaCodecList(1);
            for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoArray = mediaCodecList.getCodecInfos()) {
                if (mediaCodecInfo.isEncoder()) continue;
                for (String string3 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string3.equalsIgnoreCase(string)) continue;
                    DebugLog.i("ImgoPlayerLibJava", "getSelectALLCodecNameDecoder21orLater : " + mediaCodecInfo.getName() + ",type:" + string3);
                    if (string2 == null) {
                        string2 = "";
                    }
                    string2 = string2 + mediaCodecInfo.getName() + "_";
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    @TargetApi(value=16)
    private static String getSelectCodecDecoder16orLater(String string) {
        try {
            int n2 = MediaCodecList.getCodecCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
                if (mediaCodecInfo.isEncoder()) continue;
                for (String string2 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string2.equalsIgnoreCase(string) || mediaCodecInfo.getName().startsWith("OMX.google.")) continue;
                    DebugLog.i("ImgoPlayerLibJava", "getSelectCodecDecoder16orLater : " + mediaCodecInfo.getName());
                    return mediaCodecInfo.getName();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static boolean isMTKMediaCodec() {
        return MediaCodecHelp.findMediaCodec("OMX.MTK.");
    }

    public static boolean isIntelMediaCodec() {
        return MediaCodecHelp.findMediaCodec("OMX.Intel.");
    }

    private static File findCodecXmlFile() {
        if (sCodecFiles == null || sCodecFiles.length <= 0) {
            return null;
        }
        try {
            for (String string : sCodecFiles) {
                File file = new File(string);
                if (!file.exists()) continue;
                return file;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean findMediaCodec(String string) {
        FileInputStream fileInputStream;
        boolean bl;
        block13: {
            File file;
            block12: {
                if (sMediaCodecMap.containsKey(string)) {
                    return sMediaCodecMap.get(string);
                }
                bl = false;
                fileInputStream = null;
                file = MediaCodecHelp.findCodecXmlFile();
                if (file != null) break block12;
                boolean bl2 = bl;
                f.a(fileInputStream);
                return bl2;
            }
            try {
                fileInputStream = new FileInputStream(file);
                if (fileInputStream == null) break block13;
                XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
                XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
                xmlPullParser.setInput((InputStream)fileInputStream, "UTF-8");
                int n2 = xmlPullParser.getEventType();
                while (n2 != 1) {
                    String string2 = xmlPullParser.getName();
                    switch (n2) {
                        case 2: {
                            String string3;
                            if (!"MediaCodec".equals(string2) || !(string3 = xmlPullParser.getAttributeValue(0)).startsWith("OMX.") || !string3.startsWith(string)) break;
                            DebugLog.i("ImgoPlayerLibJava", "findMediaCodec : " + string3);
                            bl = true;
                        }
                    }
                    n2 = xmlPullParser.next();
                }
            }
            catch (Exception exception) {
                block14: {
                    try {
                        if (fileInputStream == null) {
                            DebugLog.i("ImgoPlayerLibJava", "findMediaCodec : " + string + " openInputStream failed");
                            break block14;
                        }
                        DebugLog.i("ImgoPlayerLibJava", "findMediaCodec : " + string + " parser failed");
                    }
                    catch (Throwable throwable) {
                        f.a(fileInputStream);
                        throw throwable;
                    }
                }
                f.a(fileInputStream);
            }
        }
        f.a(fileInputStream);
        if (sMediaCodecMap != null) {
            sMediaCodecMap.put(string, bl);
        }
        return bl;
    }

    public static String getH264Decoder() {
        return MediaCodecHelp.getH264Decoder(true);
    }

    public static String getH264Decoder(boolean bl) {
        if (sAVCDecoder == null && bl) {
            sAVCDecoder = BuildHelper.isApi21_LollipopOrLater() ? MediaCodecHelp.getSelectCodecDecoder21orLater(AMIME_VIDEO_AVC) : (BuildHelper.isApi16_JellyBeanOrLater() ? MediaCodecHelp.getSelectCodecDecoder16orLater(AMIME_VIDEO_AVC) : null);
        }
        return sAVCDecoder;
    }

    public static String getH265Decoder() {
        return MediaCodecHelp.getH265Decoder(true);
    }

    public static String getH265Decoder(boolean bl) {
        if (sHEVCDecoder == null && bl) {
            sHEVCDecoder = BuildHelper.isApi21_LollipopOrLater() ? MediaCodecHelp.getSelectCodecDecoder21orLater(AMIME_VIDEO_HEVC) : (BuildHelper.isApi16_JellyBeanOrLater() ? MediaCodecHelp.getSelectCodecDecoder16orLater(AMIME_VIDEO_HEVC) : null);
        }
        return sHEVCDecoder;
    }

    public static String getALLAV1Decoder(boolean bl) {
        if (sAV1Decoder == null && bl && BuildHelper.isApi29_LollipopOrLater()) {
            sAV1Decoder = MediaCodecHelp.getSelectALLCodecNameDecoder21orLater(AMIME_VIDEO_AV1);
        }
        return sAV1Decoder;
    }

    public static boolean inH265BlackListMods(String string) {
        return ArrayUtil.inArrayIgnoreCase(sH265BlackListMods, string);
    }

    public static List<String> getSupportHardDecodeTypes(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PreferencesUtil preferencesUtil = new PreferencesUtil(context);
        if (MediaCodecHelp.getH264Decoder() != null) {
            arrayList.add("h264");
        }
        String string = MediaCodecHelp.getH265Decoder();
        if (sH265Enable && BuildHelper.isApi21_LollipopOrLater() && string != null && !MediaCodecHelp.inCreateCodecBlackList(string) && !MediaCodecHelp.inH265BlackListMods(h.c()) && preferencesUtil.getBoolean("prekey_h265_support", true)) {
            arrayList.add("h265");
        }
        return arrayList;
    }

    public static boolean isH265InCreateCodecBlackList() {
        for (String string : sCreateCodecBlackList) {
            if (string == null || !string.toUpperCase().contains("HEVC") && !string.toUpperCase().contains("H265")) continue;
            return true;
        }
        return false;
    }

    public static boolean inCreateCodecBlackList(String string) {
        try {
            if (!StringUtil.isEmpty(string) && sCreateCodecBlackList != null && sCreateCodecBlackList.contains(string)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getSupportHDST(Context context) {
        String string = "";
        List<String> list = MediaCodecHelp.getSupportHardDecodeTypes(context);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            string = i2 == list.size() - 1 ? string + list.get(i2) : string + list.get(i2) + ",";
        }
        return string;
    }

    public static synchronized String getScreenPerformance(Context context) {
        if (sDisplayPerformance == null) {
            try {
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                DisplayMetrics displayMetrics = new DisplayMetrics();
                if (Build.VERSION.SDK_INT >= 17) {
                    display.getRealMetrics(displayMetrics);
                } else {
                    display.getMetrics(displayMetrics);
                }
                int n2 = displayMetrics.widthPixels;
                int n3 = displayMetrics.heightPixels;
                int n4 = (int)display.getRefreshRate();
                String string = "";
                if (Build.VERSION.SDK_INT >= 24) {
                    int[] nArray = display.getHdrCapabilities().getSupportedHdrTypes();
                    float f2 = display.getHdrCapabilities().getDesiredMinLuminance();
                    float f3 = display.getHdrCapabilities().getDesiredMaxLuminance();
                    float f4 = display.getHdrCapabilities().getDesiredMaxAverageLuminance();
                    if (nArray != null) {
                        block8: for (int n5 : nArray) {
                            switch (n5) {
                                case 1: {
                                    string = string + "_dolby_";
                                    continue block8;
                                }
                                case 2: {
                                    string = string + "_hdr10_";
                                    continue block8;
                                }
                                case 4: {
                                    string = string + "_hdr10p_";
                                    continue block8;
                                }
                                case 3: {
                                    string = string + "_hlg_";
                                }
                            }
                        }
                    }
                    string = string + "_lum_" + f2 + "_" + f3 + "_" + f4;
                }
                sDisplayPerformance = n2 + "x" + n3 + "_" + n4 + "__HDR_" + ("".equals(string) ? "n" : string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return sDisplayPerformance;
    }

    public static void getHardWareperformance(boolean bl) {
        isHardware = bl;
    }

    @RequiresApi(api=21)
    private static String getPerformanceByResolution(MediaCodecInfo.VideoCapabilities videoCapabilities) {
        String string = UNKOWN;
        string = videoCapabilities.isSizeSupported(7680, 4320) ? SHD : (videoCapabilities.isSizeSupported(3840, 2160) ? UHD : (videoCapabilities.isSizeSupported(1920, 1080) ? FHD : (videoCapabilities.isSizeSupported(1280, 720) ? HD : (videoCapabilities.isSizeSupported(720, 480) ? SD : SD_BELOW))));
        return string;
    }

    @RequiresApi(api=21)
    private static Size getMaxResolution(MediaCodecInfo.VideoCapabilities videoCapabilities) {
        if (NetPlayConfig.is4KOpen() && videoCapabilities.isSizeSupported(7680, 4320)) {
            return new Size(7680, 4320);
        }
        if (NetPlayConfig.is4KOpen() && videoCapabilities.isSizeSupported(3840, 2160)) {
            return new Size(3840, 2160);
        }
        if (videoCapabilities.isSizeSupported(1920, 1080)) {
            return new Size(1920, 1080);
        }
        if (videoCapabilities.isSizeSupported(1280, 720)) {
            return new Size(1280, 720);
        }
        if (videoCapabilities.isSizeSupported(720, 480)) {
            return new Size(720, 480);
        }
        return null;
    }

    @RequiresApi(api=21)
    private static int getMaxFps(MediaCodecInfo.VideoCapabilities videoCapabilities, Size size) {
        try {
            Range range = videoCapabilities.getSupportedFrameRatesFor(size.getWidth(), size.getHeight());
            return ((Double)range.getUpper()).intValue() / 1000;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    @RequiresApi(api=21)
    private static double getPerformanceByFrameRate(MediaCodecInfo.VideoCapabilities videoCapabilities, String string) {
        double d2 = string.equals(SHD) ? (Double)videoCapabilities.getSupportedFrameRatesFor(7680, 4320).getUpper() : (string.equals(UHD) ? (Double)videoCapabilities.getSupportedFrameRatesFor(3840, 2160).getUpper() : (string.equals(FHD) ? (Double)videoCapabilities.getSupportedFrameRatesFor(1920, 1080).getUpper() : (string.equals(HD) ? (Double)videoCapabilities.getSupportedFrameRatesFor(1280, 720).getUpper() : (string.equals(SD) ? (Double)videoCapabilities.getSupportedFrameRatesFor(720, 480).getUpper() : 0.0))));
        return d2;
    }

    @RequiresApi(api=21)
    public static void printAllFrameRates(String string, MediaCodecInfo.VideoCapabilities videoCapabilities) {
        DebugLog.i("MediaCodecHelp", "codecName:" + string);
        MediaCodecHelp.printFrameRate(videoCapabilities, 7680, 4320);
        MediaCodecHelp.printFrameRate(videoCapabilities, 3840, 2160);
        MediaCodecHelp.printFrameRate(videoCapabilities, 1920, 1080);
        MediaCodecHelp.printFrameRate(videoCapabilities, 1280, 720);
        MediaCodecHelp.printFrameRate(videoCapabilities, 720, 480);
        DebugLog.i("MediaCodecHelp", "===================================");
    }

    @RequiresApi(api=21)
    private static void printFrameRate(MediaCodecInfo.VideoCapabilities videoCapabilities, int n2, int n3) {
        try {
            if (videoCapabilities.isSizeSupported(n2, n3)) {
                double d2 = (Double)videoCapabilities.getSupportedFrameRatesFor(n2, n3).getUpper();
                DebugLog.i("MediaCodecHelp", n2 + "_" + n3 + "max framerate:" + d2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @RequiresApi(api=21)
    private static String getPerformance(MediaCodecInfo.VideoCapabilities videoCapabilities) {
        String string = MediaCodecHelp.getPerformanceByResolution(videoCapabilities);
        int n2 = (int)MediaCodecHelp.getPerformanceByFrameRate(videoCapabilities, string);
        String string2 = "";
        if (!"FHD".equalsIgnoreCase(string) && videoCapabilities.isSizeSupported(1920, 1080)) {
            string2 = "FHD";
            double d2 = (Double)videoCapabilities.getSupportedFrameRatesFor(1920, 1080).getUpper();
            string2 = string2 + "_" + (int)d2 + "_";
        }
        return string + "_" + n2 + "_" + string2;
    }

    public static synchronized ArrayList<CodecPerformance> getCodecPerformanceList(boolean bl) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                MediaCodecInfo[] mediaCodecInfoArray;
                MediaCodecList mediaCodecList = new MediaCodecList(1);
                for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoArray = mediaCodecList.getCodecInfos()) {
                    String[] stringArray;
                    if (bl != mediaCodecInfo.isEncoder()) continue;
                    for (String string : stringArray = mediaCodecInfo.getSupportedTypes()) {
                        if (!string.contains("video")) continue;
                        CodecPerformance codecPerformance = new CodecPerformance();
                        MediaCodecInfo.VideoCapabilities videoCapabilities = mediaCodecInfo.getCapabilitiesForType((String)string).profileLevels;
                        if (videoCapabilities != null) {
                            for (MediaCodecInfo.VideoCapabilities videoCapabilities2 : videoCapabilities) {
                                if (!(codecPerformance.hdr.contains("_HDR10_") || videoCapabilities2.profile != 4096 && videoCapabilities2.profile != 4096)) {
                                    codecPerformance.hdr_support = true;
                                    codecPerformance.hdr = codecPerformance.hdr + "_HDR10_";
                                    continue;
                                }
                                if (codecPerformance.hdr.contains("_HDR10Plus_") || videoCapabilities2.profile != 8192 && videoCapabilities2.profile != 8192) continue;
                                codecPerformance.hdr_support = true;
                                codecPerformance.hdr = codecPerformance.hdr + "_HDR10Plus_";
                            }
                        }
                        MediaCodecInfo.VideoCapabilities videoCapabilities3 = mediaCodecInfo.getCapabilitiesForType(string).getVideoCapabilities();
                        codecPerformance.codecName = mediaCodecInfo.getName();
                        codecPerformance.mimeType = string;
                        codecPerformance.performance = MediaCodecHelp.getPerformance(videoCapabilities3);
                        if (isHardware) {
                            String string2 = codecPerformance.codecName.toLowerCase();
                            if (!string2.startsWith("omx") || string2.startsWith("omx.google") || string2.contains("secure") || string2.startsWith("omx.ffmpeg")) continue;
                            MediaCodecHelp.printAllFrameRates(string2, videoCapabilities3);
                            Size size = MediaCodecHelp.getMaxResolution(videoCapabilities3);
                            if (size != null) {
                                codecPerformance.max_def = size.getWidth() + "x" + size.getHeight();
                                codecPerformance.max_def_fps = ((Double)videoCapabilities3.getSupportedFrameRatesFor(size.getWidth(), size.getHeight()).getUpper()).intValue() + "";
                            }
                            sCodecPerformanceList.add(codecPerformance);
                            continue;
                        }
                        sCodecPerformanceList.add(codecPerformance);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (Build.VERSION.SDK_INT >= 16) {
            try {
                int n2 = MediaCodecList.getCodecCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String[] stringArray;
                    MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
                    if (bl == mediaCodecInfo.isEncoder()) continue;
                    for (String string : stringArray = mediaCodecInfo.getSupportedTypes()) {
                        if (!string.contains("video")) continue;
                        CodecPerformance codecPerformance = new CodecPerformance();
                        codecPerformance.codecName = mediaCodecInfo.getName();
                        codecPerformance.mimeType = string;
                        codecPerformance.performance = UNKOWN;
                        if (isHardware) {
                            String string3 = codecPerformance.codecName.toLowerCase();
                            if (!string3.startsWith("omx") || string3.startsWith("omx.google") || string3.contains("secure")) continue;
                            sCodecPerformanceList.add(codecPerformance);
                            continue;
                        }
                        sCodecPerformanceList.add(codecPerformance);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return sCodecPerformanceList;
    }

    static {
        sCodecPerformanceList = new ArrayList();
        isHardware = true;
        isConvert = true;
        sMediaCodecMap = new HashMap<String, Boolean>();
        sCodecFiles = new String[]{MEDIA_CODEC_XML_FILE, VENDOR_MEDIA_CODEC_XML_FILE, ODM_MEDIA_CODEC_XML_FILE};
        sH265BlackListMods = new String[]{"OPPO R9s Plus", "OPPO A83t", "V1809A", "ALP-AL00"};
        sH265Enable = true;
        sCreateCodecBlackList = Collections.synchronizedSet(new HashSet());
        sFlushCodecBlackList = Collections.synchronizedSet(new HashSet());
    }

    public static enum performanceLevel {
        SD,
        HD,
        FHD,
        UHD,
        UUHD;

    }

    public static class CodecPerformance {
        public volatile String codecName;
        public volatile String performance;
        public volatile String mimeType;
        public volatile boolean s4k;
        public volatile boolean hdr_support;
        public volatile String hdr = "";
        public volatile String max_def;
        public volatile String max_def_fps;
    }
}

