/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.libnative;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaCrypto;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.Window;
import com.hunantv.media.config.NetPlayConfig;
import com.hunantv.media.drm.utils.CencDrmTools;
import com.hunantv.media.player.a;
import com.hunantv.media.player.c.b;
import com.hunantv.media.player.d;
import com.hunantv.media.player.e;
import com.hunantv.media.player.f;
import com.hunantv.media.player.g;
import com.hunantv.media.player.libnative.IMGTVMediaDataSource;
import com.hunantv.media.player.libnative.IMediaDataSource;
import com.hunantv.media.player.libnative.ImgoReportLog;
import com.hunantv.media.player.loader.ImgoLibLoader;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.pragma.PlayerConfig;
import com.hunantv.media.player.utils.PreferencesUtil;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class ImgoMediaPlayerLib
extends a {
    private static final String TAG = ImgoMediaPlayerLib.class.getSimpleName();
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int MEDIA_INFO_STRING = 201;
    private static final int MEDIA_INFO_DRM = 210;
    private static final int MEDIA_BUFFERING_TIMEOUT = 300;
    private static final int MEDIA_SWITCH_SOURCE_INFO = 400;
    private static final int MEDIA_SWITCH_SOURCE_COMPLETE = 401;
    private static final int MEDIA_SWITCH_SOURCE_FAILED = 402;
    private static final int MEDIA_RECORD_VIDEO_INFO = 500;
    private static final int MEDIA_RECORD_VIDEO_ERR = 501;
    private static final int MEDIA_LOOPSWITCH_SOURCE_INFO = 600;
    private static final int MEDIA_LOOPSWITCH_SOURCE_COMPLETE = 601;
    private static final int MEDIA_LOOPSWITCH_SOURCE_FAILED = 602;
    private static final int MEDIA_SMOOTH_SWITCH_SOURCE_INFO = 603;
    private static final int MEDIA_SMOOTH_SWITCH_SOURCE_COMPLETE = 604;
    private static final int MEDIA_SMOOTH_SWITCH_SOURCE_FAILED = 605;
    private static final int MEDIA_GET_FRAME_IMG_STATUE = 700;
    private static final int MEDIA_GET_FRAME_IMG_INFO = 701;
    protected static final int MEDIA_SET_VIDEO_SAR = 10001;
    protected static final int MEDIA_SET_VIDEO_DAR = 10002;
    protected static final int MEDIA_SET_VIDEO_PAR = 10003;
    public static final int OPT_CATEGORY_FORMAT = 1;
    public static final int OPT_CATEGORY_CODEC = 2;
    public static final int OPT_CATEGORY_SWS = 3;
    public static final int OPT_CATEGORY_PLAYER = 4;
    public static final int SDL_FCC_YV12 = 842094169;
    public static final int SDL_FCC_RV16 = 909203026;
    public static final int SDL_FCC_RV32 = 842225234;
    public static final int SDL_FCC__OPENGLES = 1397050439;
    public static final int FFP_PROP_FLOAT_VIDEO_DECODE_FRAMES_PER_SECOND = 10001;
    public static final int FFP_PROP_FLOAT_VIDEO_OUTPUT_FRAMES_PER_SECOND = 10002;
    public static final int FFP_PROP_FLOAT_PLAYBACK_RATE = 10003;
    public static final int FFP_PROP_FLOAT_AVDELAY = 10004;
    public static final int FFP_PROP_FLOAT_AVDIFF = 10005;
    public static final int FFP_PROP_FLOAT_FILE_START_TIME = 10006;
    public static final int FFP_PROP_FLOAT_AUDIO_LATENCY = 10007;
    public static final int FFP_PROP_INT64_SELECTED_VIDEO_STREAM = 20001;
    public static final int FFP_PROP_INT64_SELECTED_AUDIO_STREAM = 20002;
    public static final int FFP_PROP_INT64_SELECTED_TIMEDTEXT_STREAM = 20011;
    public static final int FFP_PROP_INT64_VIDEO_DECODER = 20003;
    public static final int FFP_PROP_INT64_AUDIO_DECODER = 20004;
    public static final int FFP_PROP_INT64_STEP_PLAYBACK = 30001;
    public static final int FFP_PROP_INT64_WANOS_AUDIO_EFFECT = 30002;
    public static final int FFP_PROP_INT64_CLOCK_NOTIFY = 80001;
    public static final int FFP_PROP_INT64_CLOCK_VPTS_NOTIFY_START = 80002;
    public static final int FFP_PROP_INT64_CLOCK_VPTS_NOTIFY_END = 80003;
    public static final int FFP_PROP_INT64_LOOPAB_TARGET_POS = 80010;
    public static final int FFP_PROP_INT64_LOOP_SEEK = 80020;
    public static final int FFP_PROP_INT64_AUDIO_TIMESTAMP_STATUS = 80021;
    public static final int FFP_PROP_INT64_IS_SUPPORT_SNAPSHOT = 80022;
    public static final int FFP_PROP_INT64_IS_CODEC_SW_RENDER = 80023;
    public static final int FFP_PROP_INT64_CRASH_TEST = 90001;
    public static final int FFP_PROP_INT64_FRAME_PTS_NOTIFY = 90002;
    public static final int FFP_PROP_INT64_DECODER_PLAY_NOTIFY = 90003;
    public static final int FFP_PROP_INT64_P2P_SMOOTH_FAIL = 90010;
    public static final int FFP_PROP_INT64_SMOOTH_ACCSEEK = 90011;
    public static final int FFP_PROP_INT64_NET_BROKEN = 90012;
    public static final int FFP_PROP_INT64_VSR_RUN_EANBLE = 90013;
    public static final int OPPO_FUNC_SR = 1;
    public static final int OPPO_FUNC_OSIE = 2;
    public static final int FFP_PROP_INT64_OPPOSR_ENALBE = 90020;
    public static final int FFP_PROP_INT64_OPPOOSIE_ENALBE = 90021;
    public static final int FFP_PROPV_DECODER_UNKNOWN = 0;
    public static final int FFP_PROPV_DECODER_AVCODEC = 1;
    public static final int FFP_PROPV_DECODER_MEDIACODEC = 2;
    public static final int FFP_PROPV_DECODER_VIDEOTOOLBOX = 3;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_DURATION = 20005;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_DURATION = 20006;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_BYTES = 20007;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_BYTES = 20008;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_PACKETS = 20009;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_PACKETS = 20010;
    public static final int FFP_PROP_INT64_BIT_RATE = 20100;
    public static final int FFP_PROP_INT64_AV_CACHED_BYTES = 20101;
    public static final int FFP_PROP_INT64_AV_CACHED_TIMEMS = 20102;
    public static final int FFP_PROP_INT64_TCP_SPEED = 20200;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_BACKWARDS = 20201;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_FORWARDS = 20202;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_CAPACITY = 20203;
    public static final int FFP_PROP_INT64_TRAFFIC_STATISTIC_BYTE_COUNT = 20204;
    public static final int FFP_PROP_INT64_LATEST_SEEK_LOAD_DURATION = 20300;
    public static final int FFP_PROP_INT64_VVTTIME_T1 = 20401;
    public static final int FFP_PROP_INT64_VVTTIME_T2 = 20402;
    public static final int FFP_PROP_INT64_VVTTIME_T3 = 20403;
    public static final int FFP_PROP_INT64_VVTTIME_T4 = 20404;
    public static final int FFP_PROP_INT64_VVTTIME_T5 = 20405;
    public static final int FFP_PROP_INT64_VVTTIME_T6 = 20406;
    public static final int FFP_PROP_INT64_VVTTIME_VVT = 20407;
    public static final int FFP_PROP_INT64_VVTTIME_VVBT = 20408;
    public static final int FFP_PROP_INT64_VVTTIME_DLPT = 20409;
    public static final int FFP_PROP_INT64_DRM_PREPEARED_STATUE = 20420;
    public static final int FFP_PROP_INT64_AUDIO_TIMESTAMP_POS = 20421;
    public static final int FFP_PROP_INT64_GETFRAMETIME_T1 = 20501;
    public static final int FFP_PROP_INT64_GETFRAMETIME_T2 = 20502;
    public static final int FFP_PROP_INT64_GETFRAMETIME_T3 = 20503;
    public static final int FFP_PROP_INT64_GETFRAMETIME_T4 = 20504;
    public static final int FFP_PROP_INT64_GETFRAMETIME_DF = 20505;
    public static final int FFP_PROP_INT64_GETFRAMETIME_TD = 20506;
    public static final int FFP_PROP_INT64_GETFRAMETIME_TS = 20507;
    public static final int FFP_PROP_INT64_GETFRAMETIME_TE = 20508;
    public static final int FFP_PROP_INT64_GETFRAMETIME_TF = 20509;
    public static final int FFP_PROP_INT64_GETFRAMETIME_DROP_NUM = 20510;
    public static final int FFP_PROP_INT64_GETFRAMETIME_GEN_NUM = 20511;
    public static final int FFP_PROP_INT64_GETFRAMETIME_FIN = 20512;
    private long mNativeMediaPlayer;
    private int mNativeSurfaceTexture;
    private int mListenerContext;
    private WeakReference<ImgoMediaPlayerLib> mWeakImgoPlayer;
    private long mNativeMediaDataSource;
    private long mNativeMGTVMediaDataSource;
    private long mNativeMGTVSMediaDataSource;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private static String mPackageName = "com.hunantv.imgo.activity";
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private int mVideoDarNum;
    private int mVideoDarDen;
    private int mVideoParNum;
    private int mVideoParDen;
    private String mDataSource;
    private int mCurBufferingPercent;
    private int mBufferedPercent;
    private long mBufferedPositionMs;
    private Context mContext;
    private String mCurrentRecFile;
    private boolean mIsReleased = false;
    private static volatile boolean mIsNativeInitialized = false;
    private OnNativeInvokeListener mOnNativeInvokeListener;
    private OnMediaCodecSelectListener mOnMediaCodecSelectListener;

    static void defaultValue(Context context) {
        PreferencesUtil preferencesUtil = new PreferencesUtil(context);
        preferencesUtil.removeKey("prekey_h264_support_base");
        preferencesUtil.removeKey("prekey_h264_support_main");
        preferencesUtil.removeKey("prekey_h264_support_high");
        preferencesUtil.removeKey("prekey_h265_support");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNativeOnce() {
        Class<ImgoMediaPlayerLib> clazz = ImgoMediaPlayerLib.class;
        synchronized (ImgoMediaPlayerLib.class) {
            if (!mIsNativeInitialized) {
                ImgoMediaPlayerLib.native_init(PlayerConfig.use_report_level, PlayerConfig.use_log_level);
                mIsNativeInitialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public ImgoMediaPlayerLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, OutOfMemoryError {
        this.initPlayer(context);
    }

    public ImgoMediaPlayerLib(Context context, Bundle bundle) {
        super(bundle);
        this.initPlayer(context);
    }

    private void initPlayer(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, OutOfMemoryError {
        this.mContext = context;
        mPackageName = context.getPackageName();
        if (ImgoLibLoader.getInstance().syncTryLoadAllLibraries(context)) {
            ImgoMediaPlayerLib.defaultValue(context);
        }
        ImgoMediaPlayerLib.initNativeOnce();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.mWeakImgoPlayer = new WeakReference<ImgoMediaPlayerLib>(this);
        this.native_setup(this.mWeakImgoPlayer);
    }

    private native void _setVideoSurface(Surface var1);

    private native void _setVideoSurfaceKey(Surface var1, int var2);

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = surfaceHolder;
        Surface surface = surfaceHolder != null ? surfaceHolder.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder, int n2) {
        this.mSurfaceHolder = surfaceHolder;
        Surface surface = surfaceHolder != null ? surfaceHolder.getSurface() : null;
        this._setVideoSurfaceKey(surface, n2);
        this.updateSurfaceScreenOn();
    }

    @Override
    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            DebugLog.w(this.getLogTag(), "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    @Override
    public void setSurface(Surface surface, int n2) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            DebugLog.w(this.getLogTag(), "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurfaceKey(surface, n2);
        this.updateSurfaceScreenOn();
    }

    @Override
    public void setDataSource(String string) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mCurBufferingPercent = 0;
        this.mBufferedPercent = 0;
        this.mBufferedPositionMs = 0L;
        this.mDataSource = string;
        this._setDataSource(string, null, null);
    }

    private native void _setDataSource(String var1, String[] var2, String[] var3) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=13)
    public void setDataSource(FileDescriptor fileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        if (Build.VERSION.SDK_INT < 12) {
            int n2 = -1;
            try {
                Field field = fileDescriptor.getClass().getDeclaredField("descriptor");
                field.setAccessible(true);
                n2 = field.getInt(fileDescriptor);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            this._setDataSourceFd(n2);
        } else {
            try (ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.dup((FileDescriptor)fileDescriptor);){
                this._setDataSourceFd(parcelFileDescriptor.getFd());
            }
        }
    }

    private void setDataSource(FileDescriptor fileDescriptor, long l2, long l3) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fileDescriptor);
    }

    private native void _setDataSourceFd(int var1) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    @Override
    public void setDataSource(IMediaDataSource iMediaDataSource) throws IllegalArgumentException, SecurityException, IllegalStateException {
        this._setDataSource(iMediaDataSource);
    }

    private native void _setDataSource(IMediaDataSource var1) throws IllegalArgumentException, SecurityException, IllegalStateException;

    public void setDataSource(IMGTVMediaDataSource iMGTVMediaDataSource) throws IllegalArgumentException, SecurityException, IllegalStateException {
        this._setDataSource(iMGTVMediaDataSource, 0);
    }

    public void setDataSource(IMGTVMediaDataSource iMGTVMediaDataSource, int n2) throws IllegalArgumentException, SecurityException, IllegalStateException {
        this._setDataSource(iMGTVMediaDataSource, n2);
    }

    private native void _setDataSource(IMGTVMediaDataSource var1, int var2) throws IllegalArgumentException, SecurityException, IllegalStateException;

    public String getDataSource() {
        return this.mDataSource;
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        this._prepareAsync();
    }

    public native void _prepareAsync() throws IllegalStateException;

    @Override
    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    private native void _start() throws IllegalStateException;

    @Override
    public void stop() throws IllegalStateException {
        this.mCurBufferingPercent = 0;
        this.mBufferedPercent = 0;
        this.mBufferedPositionMs = 0L;
        this.stayAwake(false);
        try {
            this._stop();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    private native void _stop() throws IllegalStateException;

    @Override
    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    private native void _pause() throws IllegalStateException;

    @SuppressLint(value={"Wakelock"})
    public void setWakeMode(Context context, int n2) {
        boolean bl = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                bl = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(n2 | 0x20000000, ImgoMediaPlayerLib.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (bl) {
            this.mWakeLock.acquire();
        }
    }

    @Override
    public void setScreenOnWhilePlaying(boolean bl) {
        if (this.mScreenOnWhilePlaying != bl) {
            if (bl && this.mSurfaceHolder == null) {
                DebugLog.w(this.getLogTag(), "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = bl;
            this.updateSurfaceScreenOn();
        }
    }

    @SuppressLint(value={"Wakelock"})
    private void stayAwake(boolean bl) {
        if (this.mWakeLock != null) {
            if (bl && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!bl && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = bl;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        try {
            Window window;
            boolean bl = this.mScreenOnWhilePlaying && this.mStayAwake;
            DebugLog.i(this.getLogTag(), "updateSurfaceScreenOn " + bl);
            if (this.mSurfaceHolder != null) {
                this.mSurfaceHolder.setKeepScreenOn(bl);
            } else if (bl && this.mContext != null && this.mContext instanceof Activity && (window = ((Activity)this.mContext).getWindow()) != null) {
                window.addFlags(128);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void selectTrack(int n2) {
        this._setStreamSelected(n2, true);
    }

    public void deselectTrack(int n2) {
        this._setStreamSelected(n2, false);
    }

    private native void _setStreamSelected(int var1, boolean var2);

    @Override
    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    @Override
    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public int getVideoSarNum() {
        return this.mVideoSarNum;
    }

    public int getVideoSarDen() {
        return this.mVideoSarDen;
    }

    public int getVideoDarNum() {
        return this.mVideoDarNum;
    }

    public int getVideoDarDen() {
        return this.mVideoDarDen;
    }

    public int getVideoParNum() {
        return this.mVideoParNum;
    }

    public int getVideoParDen() {
        return this.mVideoParDen;
    }

    @Override
    public native boolean isPlaying();

    @Override
    public void seekTo(long l2) throws IllegalStateException {
        this._seekTo(l2);
    }

    private native void _seekTo(long var1) throws IllegalStateException;

    public void seekTo(long l2, int n2) throws IllegalStateException {
        this._seekTo2(l2, n2);
    }

    private native void _seekTo2(long var1, int var3) throws IllegalStateException;

    @Override
    public native long getCurrentPosition();

    @Override
    public native long getDuration();

    @Override
    public void release() {
        this.mIsReleased = true;
        this.mCurBufferingPercent = 0;
        this.mBufferedPercent = 0;
        this.mBufferedPositionMs = 0L;
        this.mCurrentRecFile = null;
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.resetListeners();
        try {
            this._release();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    private native void _release();

    @Override
    public void reset() throws OutOfMemoryError {
        this.mCurBufferingPercent = 0;
        this.mBufferedPercent = 0;
        this.mBufferedPositionMs = 0L;
        this.mCurrentRecFile = null;
        this.stayAwake(false);
        this._reset(this.mWeakImgoPlayer);
        this.mEventHandler.removeCallbacksAndMessages(null);
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    private native void _reset(Object var1);

    public void setLooping(boolean bl) {
        int n2 = bl ? 0 : 1;
        this.setOption(4, "loop", n2);
        this._setLoopCount(n2);
    }

    private native void _setLoopCount(int var1);

    public boolean isLooping() {
        int n2 = this._getLoopCount();
        return n2 != 1;
    }

    private native int _getLoopCount();

    public boolean isAbortRequest() {
        int n2 = this._isAbortRequest();
        return n2 == 1;
    }

    private native int _isAbortRequest();

    public int setKeyFrameInfoFileBuf(byte[] byArray) {
        try {
            return this._setVideoKeyFrameInfo(byArray);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return -31;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -32;
        }
    }

    private native int _setVideoKeyFrameInfo(byte[] var1);

    public void setFrameImageAtTime(String string, long l2, long l3, int n2, int n3, int n4) {
        this._setFrameImageAtTime(string, l2, l3, n2, n3, n4);
    }

    private native void _setFrameImageAtTime(String var1, long var2, long var4, int var6, int var7, int var8);

    public void setNETIsBroken(boolean bl) {
        this._setPropertyLong(90012, bl ? 1L : 0L);
    }

    public int setWanosAudioEffectConfig(byte[] byArray) {
        return this._setWanosAudioEffectConfig(byArray);
    }

    private native int _setWanosAudioEffectConfig(byte[] var1);

    public void setVideoFrameTimeMsClockNotify(long l2) {
        this._setPropertyLong(80001, l2);
    }

    public void setVideoFrameTimePTSClockNotify(long l2, long l3) {
        this._setPropertyLong(80002, l2);
        this._setPropertyLong(80003, l3);
    }

    public void setVideoFrameTimeClockNotify(long l2, long l3) {
        this.setVideoFrameTimePTSClockNotify(l2, l3);
    }

    public void setLoopABPlay(boolean bl, long l2, long l3) {
        DebugLog.i(this.getLogTag(), "setLoopABPlay enable:" + bl + ",aPos:" + l2 + ",bPos:" + l3);
        this._setPropertyLongab(80010, bl ? l2 : -1L, bl ? l3 : -1L);
    }

    public void setLoopSeekPlay(boolean bl, long l2) {
        this._setPropertyLongab(80020, bl ? 1L : 0L, l2);
    }

    public boolean isSupportedSnapshot() {
        return this._getPropertyLong(80022, 0L) == 1L;
    }

    @Override
    public boolean isMediaCodecSWRender() {
        return this._getPropertyLong(80023, 0L) == 1L;
    }

    public void maybeUpdateAudioTimestamp() {
        this.enableUpdateAudioTimestamp();
    }

    private void enableUpdateAudioTimestamp() {
        int n2 = 1;
        n2 = !NetPlayConfig.isAudioTimestampEnable() || Build.VERSION.SDK_INT < 19 ? 5 : 1;
        this._setPropertyLong(80021, n2);
        DebugLog.i(this.getLogTag(), "enableUpdateAudioTimestamp:" + n2);
    }

    @Override
    public void setPlaybackSpeed(float f2) {
        if (f2 >= 0.25f && f2 <= 4.0f) {
            this._setPropertyFloat(10003, f2);
        } else {
            this._setPropertyFloat(10003, 1.0f);
        }
    }

    @Override
    public float getPlaybackSpeed() {
        return this._getPropertyFloat(10003, 0.0f);
    }

    public int getVideoDecoder() {
        return (int)this._getPropertyLong(20003, 0L);
    }

    public float getVideoOutputFramesPerSecond() {
        return this._getPropertyFloat(10002, 0.0f);
    }

    public float getVideoDecodeFramesPerSecond() {
        return this._getPropertyFloat(10001, 0.0f);
    }

    public float getAVDelay() {
        return this._getPropertyFloat(10004, 0.0f);
    }

    public float getAVDiff() {
        return this._getPropertyFloat(10005, 0.0f);
    }

    public float getFileStartTime() {
        return this._getPropertyFloat(10006, -1.0f);
    }

    public long getVideoCachedDuration() {
        return this._getPropertyLong(20005, 0L);
    }

    public long getAudioCachedDuration() {
        return this._getPropertyLong(20006, 0L);
    }

    public long getVideoCachedBytes() {
        return this._getPropertyLong(20007, 0L);
    }

    public long getAudioCachedBytes() {
        return this._getPropertyLong(20008, 0L);
    }

    public long getVideoCachedPackets() {
        return this._getPropertyLong(20009, 0L);
    }

    public long getAudioCachedPackets() {
        return this._getPropertyLong(20010, 0L);
    }

    public long getBitRate() {
        return this._getPropertyLong(20100, 0L);
    }

    public long getTcpDownloadSpeed() {
        return this._getPropertyLong(20200, 0L);
    }

    public long getAsyncStatisticBufBackwards() {
        return this._getPropertyLong(20201, 0L);
    }

    public long getAsyncStatisticBufForwards() {
        return this._getPropertyLong(20202, 0L);
    }

    public long getAsyncStatisticBufCapacity() {
        return this._getPropertyLong(20203, 0L);
    }

    public long getVVTimeStatisticT1() {
        return this._getPropertyLong(20401, 0L);
    }

    public long getVVTimeStatisticT2() {
        return this._getPropertyLong(20402, 0L);
    }

    public long getVVTimeStatisticT3() {
        return this._getPropertyLong(20403, 0L);
    }

    public long getVVTimeStatisticT4() {
        return this._getPropertyLong(20404, 0L);
    }

    public long getVVTimeStatisticT5() {
        return this._getPropertyLong(20405, 0L);
    }

    public long getVVTimeStatisticT6() {
        return this._getPropertyLong(20406, 0L);
    }

    public long getVVTimeStatisticVVBT() {
        return this._getPropertyLong(20408, 0L);
    }

    public long getVVTimeStatisticVVT() {
        return this._getPropertyLong(20407, 0L);
    }

    public long getVVTimeStatisticDLPT() {
        return this._getPropertyLong(20409, 0L);
    }

    public long getDrmPreparedStatus() {
        return this._getPropertyLong(20420, 0L);
    }

    public long getPropertyLong(int n2, long l2) {
        try {
            return this._getPropertyLong(n2, l2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return l2;
    }

    public long getGenframetimeStatisticT1() {
        return this._getPropertyLong(20501, -1L);
    }

    public long getGenframetimeStatisticT2() {
        return this._getPropertyLong(20502, -1L);
    }

    public long getGenframetimeStatisticT3() {
        return this._getPropertyLong(20503, -1L);
    }

    public long getGenframetimeStatisticT4() {
        return this._getPropertyLong(20504, -1L);
    }

    public long getGenframetimeStatisticDecodeFirstFrame() {
        return this._getPropertyLong(20505, -1L);
    }

    public long getGenframetimeStatisticTotalDecodeTime() {
        return this._getPropertyLong(20506, -1L);
    }

    public long getGenframetimeStatisticTotalScaleTime() {
        return this._getPropertyLong(20507, -1L);
    }

    public long getGenframetimeStatisticTotalEncodeTime() {
        return this._getPropertyLong(20508, -1L);
    }

    public long getGenframetimeStatisticTotalSaveFile() {
        return this._getPropertyLong(20509, -1L);
    }

    public long getGenframetimeStatisticDropFrameNum() {
        return this._getPropertyLong(20510, -1L);
    }

    public long getGenframetimeStatisticGenImageNum() {
        return this._getPropertyLong(20511, -1L);
    }

    public long getGenframetimeStatisticGenFinishTotalTime() {
        return this._getPropertyLong(20512, -1L);
    }

    public void setPropertyLong(int n2, long l2) {
        try {
            this._setPropertyLong(n2, l2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getPropertyFloat(int n2, float f2) {
        try {
            return this._getPropertyFloat(n2, f2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return f2;
    }

    public long getTrafficStatisticByteCount() {
        return this._getPropertyLong(20204, 0L);
    }

    public long getAVCachedBytes() {
        return this._getPropertyLong(20101, 0L);
    }

    @Override
    public long getAVCachedTimeMs() {
        return this._getPropertyLong(20102, 0L);
    }

    public void setWanosAudioEffectChoice(int n2) {
        this._setPropertyLong(30002, n2);
    }

    public int getWanosAudioEffectChoice() {
        return (int)this._getPropertyLong(30002, -1L);
    }

    public void setPlaybackStep(int n2) {
        this._setPropertyLong(30001, n2);
    }

    public void nativeCrashTest(int n2) {
        this._setPropertyLong(90001, n2);
    }

    public void enableFramePTSNotify(boolean bl) {
        int n2 = bl ? 1 : 0;
        this._setPropertyLong(90002, n2);
    }

    public void enableP2PSmoothFailMode(boolean bl) {
        int n2 = bl ? 1 : 0;
        this._setPropertyLong(90010, n2);
    }

    public void enableSmoothAccSeek(boolean bl) {
        int n2 = bl ? 1 : 0;
        this._setPropertyLong(90011, n2);
    }

    public void enableOppoFunc(int n2, boolean bl) {
        int n3;
        int n4 = n3 = bl ? 1 : 0;
        if (n2 == 1) {
            this._setPropertyLong(90020, n3);
        } else if (n2 == 2) {
            this._setPropertyLong(90021, n3);
        }
    }

    private native float _getPropertyFloat(int var1, float var2);

    private native void _setPropertyFloat(int var1, float var2);

    private native long _getPropertyLong(int var1, long var2);

    private native void _setPropertyLong(int var1, long var2);

    private native void _setPropertyLongab(int var1, long var2, long var4);

    @Override
    public native void setVolume(float var1, float var2);

    public native int getAudioSessionId();

    public f getMediaInfo() {
        String[] stringArray;
        f f2 = new f();
        f2.a = "Imgoplayer";
        String string = this._getVideoCodecInfo();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringArray = string.split(",");
            if (stringArray.length >= 2) {
                f2.b = stringArray[0];
                f2.c = stringArray[1];
            } else if (stringArray.length >= 1) {
                f2.b = stringArray[0];
                f2.c = "";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = this._getAudioCodecInfo()))) {
            String[] stringArray2 = stringArray.split(",");
            if (stringArray2.length >= 2) {
                f2.d = stringArray2[0];
                f2.e = stringArray2[1];
            } else if (stringArray2.length >= 1) {
                f2.d = stringArray2[0];
                f2.e = "";
            }
        }
        try {
            f2.f = g.a(this._getMediaMeta());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return f2;
    }

    private native String _getVideoCodecInfo();

    private native String _getAudioCodecInfo();

    public void setOption(int n2, String string, String string2) {
        this._setOption(n2, string, string2);
    }

    public void setOption(int n2, String string, long l2) {
        this._setOption(n2, string, l2);
    }

    private native void _setOption(int var1, String var2, String var3);

    private native void _setOption(int var1, String var2, long var3);

    public Bundle getMediaMeta() {
        return this._getMediaMeta();
    }

    private native Bundle _getMediaMeta();

    public static String getColorFormatName(int n2) {
        return ImgoMediaPlayerLib._getColorFormatName(n2);
    }

    private static final native String _getColorFormatName(int var0);

    @Override
    public void setAudioStreamType(int n2) {
    }

    public int startRecordVideo(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        int n2 = this._recordVideo(string, 1);
        if (n2 == 0) {
            this.mCurrentRecFile = string;
        }
        return n2;
    }

    public int stopRecordVideo() throws IOException, IllegalArgumentException, IllegalStateException {
        return this._recordVideo(this.mCurrentRecFile, 0);
    }

    private native int _recordVideo(String var1, int var2) throws IOException, IllegalArgumentException, IllegalStateException;

    public boolean isVideoRecording() {
        return this._isVideoRecording();
    }

    private native boolean _isVideoRecording();

    public static String getSupportRecVideoformat() {
        return ImgoMediaPlayerLib._getSupportRecVideoformat();
    }

    private static final native String _getSupportRecVideoformat();

    public static String getDlopenStatus() {
        return ImgoMediaPlayerLib.native_getDlopenStatus();
    }

    private static final native String native_getDlopenStatus();

    public static int getTinkerNumber() {
        return ImgoMediaPlayerLib.native_getTinkerNumber();
    }

    private static final native int native_getTinkerNumber();

    private static final native void native_init(int var0, int var1);

    private final native void native_setup(Object var1);

    private final native void native_finalize();

    private final native void native_message_loop(Object var1);

    protected void finalize() throws Throwable {
        super.finalize();
        DebugLog.e(this.getLogTag(), "finalize mIsReleased:" + this.mIsReleased);
    }

    private static void postEventFromNative(Object object, int n2, int n3, int n4, Object object2) {
        if (object == null) {
            return;
        }
        ImgoMediaPlayerLib imgoMediaPlayerLib = (ImgoMediaPlayerLib)((WeakReference)object).get();
        if (imgoMediaPlayerLib == null) {
            return;
        }
        if (n2 == 200 && n3 == 2) {
            imgoMediaPlayerLib.start();
        }
        if (n2 == 200 && n3 == 10002) {
            DebugLog.d(imgoMediaPlayerLib.getLogTag(), "obtainmsg Info (" + n3 + "," + n4 + ")");
        }
        if (imgoMediaPlayerLib.mEventHandler != null) {
            Message message = imgoMediaPlayerLib.mEventHandler.obtainMessage(n2, n3, n4, object2);
            imgoMediaPlayerLib.mEventHandler.sendMessage(message);
        }
    }

    private static boolean onNativeInvoke(Object object, int n2, Bundle bundle) {
        if (object == null || !(object instanceof WeakReference)) {
            throw new IllegalStateException("<null weakThiz>.onNativeInvoke()");
        }
        WeakReference weakReference = (WeakReference)object;
        ImgoMediaPlayerLib imgoMediaPlayerLib = (ImgoMediaPlayerLib)weakReference.get();
        if (imgoMediaPlayerLib == null) {
            throw new IllegalStateException("<null weakPlayer>.onNativeInvoke()");
        }
        switch (n2) {
            case 131073: 
            case 131074: 
            case 131075: 
            case 131076: 
            case 131077: 
            case 131078: 
            case 131079: 
            case 131081: 
            case 131088: 
            case 131089: 
            case 131090: 
            case 131104: 
            case 131120: 
            case 131184: {
                return imgoMediaPlayerLib.notifyOnSourceNetCtrl(n2, bundle);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 78337: 
            case 78338: {
                imgoMediaPlayerLib.notifyOnSourceNetEvent(n2, bundle);
                return false;
            }
            case 78593: {
                imgoMediaPlayerLib.notifyOnSourceFlowInfoEvent(n2, bundle);
                return false;
            }
            case 131152: {
                imgoMediaPlayerLib.notifyOnPlayerEvent(n2, bundle);
                return false;
            }
            case 32: 
            case 33: 
            case 41: 
            case 48: 
            case 49: 
            case 64: 
            case 80: 
            case 74244: {
                imgoMediaPlayerLib.notifyOnStreamInfoEvent(n2, bundle);
                return false;
            }
        }
        return false;
    }

    public void setOnMediaCodecSelectListener(OnMediaCodecSelectListener onMediaCodecSelectListener) {
        this.mOnMediaCodecSelectListener = onMediaCodecSelectListener;
    }

    @Override
    public void resetListeners() {
        super.resetListeners();
        this.mOnMediaCodecSelectListener = null;
    }

    private static String onSelectCodec(Object object, String string, int n2, int n3) {
        if (object == null || !(object instanceof WeakReference)) {
            return null;
        }
        WeakReference weakReference = (WeakReference)object;
        ImgoMediaPlayerLib imgoMediaPlayerLib = (ImgoMediaPlayerLib)weakReference.get();
        if (imgoMediaPlayerLib == null) {
            return null;
        }
        OnMediaCodecSelectListener onMediaCodecSelectListener = imgoMediaPlayerLib.mOnMediaCodecSelectListener;
        if (onMediaCodecSelectListener == null) {
            onMediaCodecSelectListener = DefaultMediaCodecSelector.sInstance;
        }
        return onMediaCodecSelectListener.onMediaCodecSelect(imgoMediaPlayerLib, string, n2, n3);
    }

    private static boolean onCodecIsAdaptive(Object object) {
        if (object == null || !(object instanceof WeakReference)) {
            return false;
        }
        WeakReference weakReference = (WeakReference)object;
        ImgoMediaPlayerLib imgoMediaPlayerLib = (ImgoMediaPlayerLib)weakReference.get();
        if (imgoMediaPlayerLib == null) {
            return false;
        }
        OnMediaCodecSelectListener onMediaCodecSelectListener = imgoMediaPlayerLib.mOnMediaCodecSelectListener;
        if (onMediaCodecSelectListener == null) {
            onMediaCodecSelectListener = DefaultMediaCodecSelector.sInstance;
        }
        return onMediaCodecSelectListener.onCodecIsAdaptive(imgoMediaPlayerLib);
    }

    @Override
    public int getBufferingPercent() {
        return this.mCurBufferingPercent;
    }

    @Override
    public int getBufferedPercentage() {
        return this.mBufferedPercent;
    }

    @Override
    public long getBufferedPositionMs() {
        return this.mBufferedPositionMs;
    }

    public native void setLogReport(int var1, int var2);

    public native void setCrashRecordPath(String var1);

    public void setLogEnabled(boolean bl) {
    }

    public boolean isPlayable() {
        return true;
    }

    public void setKeepInBackground(boolean bl) {
    }

    @Override
    public void switchVideoSource(String string, int n2, int n3, int n4) throws IOException, IllegalArgumentException, IllegalStateException {
        int n5 = this._switchSource(string, n2, n3, n4);
        if (n5 == -1) {
            throw new IllegalArgumentException("imgo data source obj is NULL or not enable imgods");
        }
        if (n5 == -4) {
            throw new IllegalStateException("player object VideoState is NULL");
        }
    }

    private native int _switchSource(String var1, int var2, int var3, int var4) throws IOException, IllegalArgumentException, IllegalStateException;

    public void switchVideoSource(IMGTVMediaDataSource iMGTVMediaDataSource, String string, int n2, int n3, int n4) throws IOException, IllegalArgumentException, IllegalStateException {
        int n5 = this._switchSource(iMGTVMediaDataSource, string, n2, n3, n4);
        if (n5 == -1) {
            throw new IllegalArgumentException("imgo data source obj is NULL or not enable imgods");
        }
        if (n5 == -4) {
            throw new IllegalStateException("player object VideoState is NULL");
        }
    }

    private native int _switchSource(IMGTVMediaDataSource var1, String var2, int var3, int var4, int var5) throws IOException, IllegalArgumentException, IllegalStateException;

    @Override
    public int loopSwitchVideoSource(String string, int n2, int n3, int n4) throws IllegalStateException, OutOfMemoryError {
        return this._loopswitchSource(string, n2, n3, n4);
    }

    @Override
    public int smoothSwitchVideoSource(String string, int n2, int n3, int n4, int n5, String string2) throws IllegalStateException, OutOfMemoryError {
        DebugLog.i(this.getLogTag(), "smoothSwitchVideoSource key:" + n2 + ",switch_mod:" + n3 + ",is_smooth:" + n4 + ",arg:" + n5);
        return this._smoothswitchSource(string, n2, n3, n4, n5, string2);
    }

    private native int _loopswitchSource(String var1, int var2, int var3, int var4) throws IllegalStateException, OutOfMemoryError;

    private native int _smoothswitchSource(String var1, int var2, int var3, int var4, int var5, String var6) throws IllegalStateException, OutOfMemoryError;

    public int loopSwitchVideoSource(IMGTVMediaDataSource iMGTVMediaDataSource, String string, int n2, int n3, int n4) throws IllegalStateException, OutOfMemoryError {
        return this._loopswitchSource(iMGTVMediaDataSource, string, n2, n3, n4);
    }

    public int smoothSwitchVideoSource(IMGTVMediaDataSource iMGTVMediaDataSource, String string, int n2, int n3, int n4, int n5, String string2) throws IllegalStateException, OutOfMemoryError {
        DebugLog.i(this.getLogTag(), "smoothSwitchVideoSource " + iMGTVMediaDataSource + " key:" + n2 + ",switch_mod:" + n3 + ",is_smooth:" + n4 + ",arg:" + n5);
        return this._smoothswitchSource(iMGTVMediaDataSource, string, n2, n3, n4, n5, string2);
    }

    private native int _loopswitchSource(IMGTVMediaDataSource var1, String var2, int var3, int var4, int var5) throws IllegalStateException, OutOfMemoryError;

    private native int _smoothswitchSource(IMGTVMediaDataSource var1, String var2, int var3, int var4, int var5, int var6, String var7) throws IllegalStateException, OutOfMemoryError;

    public b[] getTrackInfo() {
        Bundle bundle = this.getMediaMeta();
        if (bundle == null) {
            return null;
        }
        g g2 = g.a(bundle);
        if (g2 == null || g2.f == null) {
            return null;
        }
        ArrayList<b> arrayList = new ArrayList<b>();
        for (g.a a2 : g2.f) {
            b b2 = new b(a2);
            if (a2.c.equalsIgnoreCase("video")) {
                b2.a(1);
            } else if (a2.c.equalsIgnoreCase("audio")) {
                b2.a(2);
            } else if (a2.c.equalsIgnoreCase("text")) {
                b2.a(3);
            }
            arrayList.add(b2);
        }
        return arrayList.toArray(new b[arrayList.size()]);
    }

    public int getSelectedTrack(int n2) {
        switch (n2) {
            case 1: {
                return (int)this._getPropertyLong(20001, -1L);
            }
            case 2: {
                return (int)this._getPropertyLong(20002, -1L);
            }
            case 3: {
                return (int)this._getPropertyLong(20011, -1L);
            }
        }
        return -1;
    }

    private static String getAppPackageName() {
        return mPackageName;
    }

    public void pauseLoadData(boolean bl) {
        if (bl) {
            this._pauseLoadData(1);
        } else {
            this._pauseLoadData(0);
        }
    }

    private native void _pauseLoadData(int var1);

    public void setDrmLicensePrepared() {
        this._setDrmLicensePrepared(1);
    }

    public void setDrmLicensePrepared(MediaCrypto mediaCrypto) {
        this._setDrmLicensePrepared(1, mediaCrypto);
    }

    private native void _setDrmLicensePrepared(int var1);

    private native void _setDrmLicensePrepared(int var1, MediaCrypto var2);

    public int getPicture32(int n2, int n3, int[] nArray) {
        return this._getPicture32(n2, n3, nArray);
    }

    private native int _getPicture32(int var1, int var2, int[] var3);

    public static class DefaultMediaCodecSelector
    implements OnMediaCodecSelectListener {
        public static DefaultMediaCodecSelector sInstance = new DefaultMediaCodecSelector();
        private boolean mIsAdaptive;

        @Override
        @TargetApi(value=16)
        public String onMediaCodecSelect(d d2, String string, int n2, int n3) {
            if (Build.VERSION.SDK_INT < 16) {
                return null;
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            String string2 = d2 != null ? d2.getLogTag() : TAG;
            ImgoReportLog.ImgoLogReport(1, "11", string2, String.format(Locale.US, "onSelectCodec: mime=%s, profile=%d, level=%d", string, n2, n3));
            ArrayList<e> arrayList = new ArrayList<e>();
            int n4 = MediaCodecList.getCodecCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                String[] stringArray2;
                MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
                DebugLog.d(string2, String.format(Locale.US, "  found codec: %s", mediaCodecInfo.getName()));
                if (mediaCodecInfo.isEncoder() || (stringArray2 = mediaCodecInfo.getSupportedTypes()) == null) continue;
                for (String string3 : stringArray2) {
                    e e2;
                    if (TextUtils.isEmpty((CharSequence)string3)) continue;
                    DebugLog.d(string2, String.format(Locale.US, "    mime: %s", string3));
                    if (!string3.equalsIgnoreCase(string) || (e2 = e.a(mediaCodecInfo, string, n2, n3)) == null) continue;
                    arrayList.add(e2);
                    DebugLog.i(string2, String.format(Locale.US, "candidate codec: %s rank=%d", mediaCodecInfo.getName(), e2.j));
                    e2.a(string);
                }
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            e stringArray = (e)arrayList.get(0);
            for (e e3 : arrayList) {
                if (e3.j <= stringArray.j) continue;
                stringArray = e3;
            }
            if (stringArray.j < e.d) {
                DebugLog.i(string2, String.format(Locale.US, "unaccetable codec: %s(%d)", stringArray.i.getName(), stringArray.j));
                return null;
            }
            if (stringArray.l) {
                DebugLog.i(string2, String.format(Locale.US, "selected codec: %s rank=%d adaptive=1", stringArray.i.getName(), stringArray.j));
            } else {
                DebugLog.i(string2, String.format(Locale.US, "selected codec: %s rank=%d adaptive=0", stringArray.i.getName(), stringArray.j));
            }
            this.mIsAdaptive = stringArray.l;
            return stringArray.i.getName();
        }

        @Override
        @TargetApi(value=16)
        public boolean onCodecIsAdaptive(d d2) {
            String string;
            if (Build.VERSION.SDK_INT < 16) {
                return false;
            }
            String string2 = string = d2 != null ? d2.getLogTag() : TAG;
            if (this.mIsAdaptive) {
                DebugLog.i(string, String.format(Locale.US, "support adaptive", new Object[0]));
            } else {
                DebugLog.i(string, String.format(Locale.US, "not support adaptive", new Object[0]));
            }
            return this.mIsAdaptive;
        }
    }

    public static interface OnMediaCodecSelectListener {
        public String onMediaCodecSelect(d var1, String var2, int var3, int var4);

        public boolean onCodecIsAdaptive(d var1);
    }

    public static interface OnNativeInvokeListener {
        public static final int CTRL_WILL_TCP_OPEN = 131073;
        public static final int CTRL_DID_TCP_OPEN = 131074;
        public static final int CTRL_DID_TCP_CLOSE = 131076;
        public static final int CTRL_WILL_ADDRESS_BYNAME = 131078;
        public static final int CTRL_WILL_GET_ENV = 131104;
        public static final int CTRL_WILL_CHECK_PAUSE_LOAD = 131120;
        public static final int CTRL_WILL_HTTP_OPEN = 131075;
        public static final int CTRL_WILL_LIVE_OPEN = 131077;
        public static final int CTRL_WILL_LIVE_RESET = 131081;
        public static final int CTRL_WILL_LOOP_OPEN = 131088;
        public static final int CTRL_WILL_LOOP_RESET = 131089;
        public static final int CTRL_WILL_HDJ_URL_SWITCH = 131090;
        public static final int CTRL_WILL_CONCAT_RESOLVE_SEGMENT = 131079;
        public static final int PLAYER_EVENT_ONINFO = 131152;
        public static final int CTRL_WILL_SMOOTH_SWITCH = 131184;
        public static final int EVENT_WILL_HTTP_OPEN = 1;
        public static final int EVENT_DID_HTTP_OPEN = 2;
        public static final int EVENT_WILL_HTTP_SEEK = 3;
        public static final int EVENT_DID_HTTP_SEEK = 4;
        public static final int EVENT_WILL_HTTP_CLOSE = 5;
        public static final int EVENT_DID_HTTP_CLOSE = 6;
        public static final int EVENT_TIME_CONSUME_DNS_ANALYZE = 16;
        public static final int EVENT_TIME_CONSUME_TCP_CONNECT = 17;
        public static final int EVENT_TIME_CONSUME_HTTP_RESPONSE = 18;
        public static final int EVENT_TIME_CONSUME_FIND_STREAM = 19;
        public static final int EVENT_TIME_CONSUME_FIRST_BUFFER = 20;
        public static final int EVENT_TIME_CONSUME_PAUSE_NOTIFY = 22;
        public static final int EVENT_AVCODEC_DECORDER_VIDEO_NAME = 32;
        public static final int EVENT_AVCODEC_DECORDER_AUDIO_NAME = 33;
        public static final String ARG_EVENT_AVCODEC_DECORDER_AVNAME_STRING = "codec_name";
        public static final int EVENT_STREAM_INFO_DRM_METHOD_NAME = 41;
        public static final String ARG_EVENT_STREAM_INFO_DRM_METHOD_NAME_STRING = "drm_method";
        public static final int EVENT_STREAM_INFO_HLS_SEG_SIZE_INFO = 48;
        public static final String ARG_EVENT_STREAM_INFO_HLS_SEG_SIZE_INFO_STRING = "seg_size_info";
        public static final int EVENT_STREAM_INFO_DNS_ABORT_INFO = 49;
        public static final String ARG_EVENT_STREAM_INFO_DNS_ABORT_INFO_STRING = "dns_abort_time";
        public static final int EVENT_STREAM_INFO_DNS_SYNC_BEGIN = 64;
        public static final String ARG_EVENT_STREAM_INFO_DNS_SYNC_BEGIN_STRING = "dns_cache_value";
        public static final int EVENT_STREAM_INFO_VFRAME_COMING_CLOCK = 80;
        public static final String ARG_EVENT_STREAM_INFO_VFRAME_COMING_CLOCK_STRING = "vfame_coming_info";
        public static final int EVENT_STREAM_INFO_EVENT_IO_TRAFFIC = 74244;
        public static final String ARG_EVENT_STREAM_INFO_EVENT_IO_TRAFFIC_INT = "update_dl_bytes";
        public static final int EVENT_WILL_HOST_ADDR = 78337;
        public static final int EVENT_DID_HOST_ADDR = 78338;
        public static final int EVENT_FLOW_INFO_REPORT = 78593;
        public static final int MEDIA_ERROR_ENETUNREACH = 300005;
        public static final int MEDIA_ERROR_HTTP_BAD_REQUEST_400 = 300400;
        public static final int MEDIA_ERROR_HTTP_OTHER_4XX = 300499;
        public static final int MEDIA_ERROR_HTTP_SERVER_INTERNAL_ERROR_500 = 300500;
        public static final int MEDIA_ERROR_HTTP_SERVER_OTHER_5XX = 300599;
        public static final int MEDIA_ERROR_TCP_HOSTNAME_RESOLVE_ERROR = 300600;
        public static final String ARG_CRTL_RETRY_URL_STRING = "url";
        public static final String ARG_CRTL_RETRY_SEGMENT_INDEX_INT = "segment_index";
        public static final String ARG_CRTL_RETRY_COUNTER_INT = "retry_counter";
        public static final String ARG_CRTL_RESET_IPLIST_INT = "reset_iplist";
        public static final String ARG_CRTL_RETRY_ERROR_WHAT_INT = "error_type";
        public static final String ARG_CRTL_RETRY_ERROR_EXTRA_INT = "error_code";
        public static final String ARG_CRTL_RETRY_ERR_IO_TYPE_INT = "io_type";
        public static final String ARG_CRTL_RETRY_SRC_URL_STRING = "src_url";
        public static final String ARG_CRTL_RETRY_IS_LAST_INT = "is_last";
        public static final String ARG_CRTL_RETRY_CUR_DL_SIZE = "cur_dl_dize";
        public static final String ARG_TCP_HOSTNAME_STRING = "tcp_hostname";
        public static final String ARG_TCP_ERROR_INT = "error";
        public static final String ARG_TCP_FAMILY_INT = "family";
        public static final String ARG_TCP_IP_STRING = "ip";
        public static final String ARG_TCP_PORT_INT = "port";
        public static final String ARG_TCP_FD_INT = "fd";
        public static final String ARG_HTTP_URL_STRING = "http_url";
        public static final String ARG_HTTP_OFFSET_LONG = "http_offset";
        public static final String ARG_HTTP_ERROR_INT = "http_error";
        public static final String ARG_HTTP_CODE_INT = "http_code";
        public static final String ARG_HTTP_FILESIZE_LONG = "http_filesize";
        public static final String ARG_CTRL_ADDR_ERROR_INT = "addr_error";
        public static final String ARG_CTRL_ADDR_HOSTNAME_STRING = "addr_hostname";
        public static final String ARG_CTRL_ADDR_HANDLE_INT = "addr_handle";
        public static final String ARG_CTRL_ADDR_IP_STRING = "addr_ip";
        public static final String ARG_CTRL_ADDR_URI_STRING = "addr_uri";
        public static final String ARG_CTRL_GET_ENV_KEY = "env_key";
        public static final String ARG_CTRL_GET_ENV_VALUE = "env_value";
        public static final String ARG_HOST_ARRR_ERROR_INT = "host_error";
        public static final String ARG_HOST_ARRR_FAMILY_INT = "host_family";
        public static final String ARG_HOST_ARRR_HOSTNAME_STRING = "host_hostname";
        public static final String ARG_HOST_ARRR_IP_STRING = "host_ip";
        public static final String ARG_HOST_ARRR_PORT_INT = "host_port";
        public static final String ARG_EVENT_TIME_CONSUME_LONG = "time_consume";
        public static final String ARG_COMPAR_PLAYER_HASH_STRING = "player_hash";
        public static final String ARG_COMPAR_RETRY_COUNTER_INT = "retry_counter";
        public static final String ARG_COMPAR_USER_MSG_STRING = "user_msg";
        public static final String ARG_COMPAR_SWITCH_KEY_LONG = "switch_key";
        public static final String ARG_SMOOTH_SWITCH_URL_STRING = "smooth_switch_url";
        public static final String ARG_SMOOTH_SWITCH_KEY_LONG = "smooth_switch_key";
        public static final String ARG_SMOOTH_SWITCH_VID_INT = "smooth_switch_vid";
        public static final String ARG_SMOOTH_SWITCH_STREAM_AUDIO_INT = "smooth_switch_stream_audio";
        public static final String ARG_PLAYER_EVENT_TYPE_INT = "event_type";
        public static final String ARG_PLAYER_EVENT_ARG1_INT = "event_arg1";
        public static final String ARG_PLAYER_EVENT_ARG2_INT = "event_arg2";

        public boolean onNativeInvoke(int var1, Bundle var2);
    }

    private static class EventHandler
    extends Handler {
        private final WeakReference<ImgoMediaPlayerLib> mWeakPlayer;

        public EventHandler(ImgoMediaPlayerLib imgoMediaPlayerLib, Looper looper) {
            super(looper);
            this.mWeakPlayer = new WeakReference<ImgoMediaPlayerLib>(imgoMediaPlayerLib);
        }

        public void handleMessage(Message message) {
            ImgoMediaPlayerLib imgoMediaPlayerLib = (ImgoMediaPlayerLib)this.mWeakPlayer.get();
            if (imgoMediaPlayerLib == null || imgoMediaPlayerLib.mNativeMediaPlayer == 0L) {
                if (imgoMediaPlayerLib != null) {
                    DebugLog.w(TAG, "ImgoMediaPlayerLib went away with unhandled events. mNativeMediaPlayer:" + imgoMediaPlayerLib.mNativeMediaPlayer);
                } else {
                    DebugLog.w(TAG, "ImgoMediaPlayerLib went away with unhandled events. player is null");
                }
                return;
            }
            switch (message.what) {
                case 1: {
                    imgoMediaPlayerLib.notifyOnPrepared();
                    imgoMediaPlayerLib.maybeUpdateAudioTimestamp();
                    return;
                }
                case 2: {
                    imgoMediaPlayerLib.notifyOnCompletion(message.arg1, message.arg2);
                    imgoMediaPlayerLib.stayAwake(false);
                    return;
                }
                case 3: {
                    long l2;
                    int n2 = message.arg2;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n2 >= 100) {
                        n2 = 100;
                    }
                    if (imgoMediaPlayerLib.mCurBufferingPercent != n2 && imgoMediaPlayerLib.mCurBufferingPercent < n2) {
                        imgoMediaPlayerLib.mCurBufferingPercent = n2;
                    }
                    if ((l2 = (long)message.arg1) < 0L) {
                        l2 = 0L;
                    }
                    long l3 = 0L;
                    long l4 = imgoMediaPlayerLib.getDuration();
                    if (l4 > 0L) {
                        l3 = l2 * 100L / l4;
                    }
                    if (l3 >= 100L) {
                        l3 = 100L;
                    }
                    imgoMediaPlayerLib.notifyOnBufferingUpdate((int)l3);
                    imgoMediaPlayerLib.mBufferedPercent = (int)l3;
                    imgoMediaPlayerLib.mBufferedPositionMs = l2;
                    return;
                }
                case 4: {
                    imgoMediaPlayerLib.notifyOnSeekComplete(message.arg1, message.arg2);
                    return;
                }
                case 5: {
                    imgoMediaPlayerLib.mVideoWidth = message.arg1;
                    imgoMediaPlayerLib.mVideoHeight = message.arg2;
                    imgoMediaPlayerLib.notifyOnVideoSizeChanged(imgoMediaPlayerLib.mVideoWidth, imgoMediaPlayerLib.mVideoHeight, imgoMediaPlayerLib.mVideoSarNum, imgoMediaPlayerLib.mVideoSarDen);
                    return;
                }
                case 100: {
                    DebugLog.e(imgoMediaPlayerLib.getLogTag(), "Error (" + message.arg1 + "," + message.arg2 + ")");
                    if (!imgoMediaPlayerLib.notifyOnError(message.arg1, message.arg2)) {
                        imgoMediaPlayerLib.notifyOnCompletion(message.arg1, message.arg2);
                    }
                    imgoMediaPlayerLib.stayAwake(false);
                    return;
                }
                case 200: {
                    if (message.arg1 != 700 && message.arg1 != 7 && message.arg1 != 8) {
                        DebugLog.d(imgoMediaPlayerLib.getLogTag(), "Info (" + message.arg1 + "," + message.arg2 + ")");
                    }
                    if (message.arg1 == 5) {
                        if (message.arg2 == 1) {
                            message.arg2 = 501;
                        } else if (message.arg2 == 2) {
                            message.arg2 = 502;
                        } else if (message.arg2 == 3) {
                            message.arg2 = 504;
                        } else if (message.arg2 == 4) {
                            message.arg2 = 505;
                        } else if (message.arg2 == 5) {
                            message.arg2 = 506;
                        }
                        DebugLog.i(imgoMediaPlayerLib.getLogTag(), "Info MEDIA_INFO_DECODER_TYPE_CHANGED(" + message.arg1 + "," + message.arg2 + ")");
                    }
                    if (message.arg1 == 701) {
                        imgoMediaPlayerLib.mCurBufferingPercent = 0;
                    }
                    if (message.arg1 == 702) {
                        // empty if block
                    }
                    imgoMediaPlayerLib.notifyOnInfo(message.arg1, message.arg2);
                    return;
                }
                case 99: {
                    break;
                }
                case 0: {
                    break;
                }
                case 10001: {
                    imgoMediaPlayerLib.mVideoSarNum = message.arg1;
                    imgoMediaPlayerLib.mVideoSarDen = message.arg2;
                    imgoMediaPlayerLib.notifyOnVideoSizeChanged(imgoMediaPlayerLib.mVideoWidth, imgoMediaPlayerLib.mVideoHeight, imgoMediaPlayerLib.mVideoSarNum, imgoMediaPlayerLib.mVideoSarDen);
                    break;
                }
                case 10002: {
                    imgoMediaPlayerLib.mVideoDarNum = message.arg1;
                    imgoMediaPlayerLib.mVideoDarDen = message.arg2;
                    break;
                }
                case 10003: {
                    imgoMediaPlayerLib.mVideoParNum = message.arg1;
                    imgoMediaPlayerLib.mVideoParDen = message.arg2;
                    break;
                }
                case 300: {
                    DebugLog.e(imgoMediaPlayerLib.getLogTag(), "Error (" + message.arg1 + "," + message.arg2 + ")");
                    if (!imgoMediaPlayerLib.notifyOnBufferingTimeout(message.arg1, message.arg2)) {
                        // empty if block
                    }
                    imgoMediaPlayerLib.stayAwake(false);
                    return;
                }
                case 400: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "switch video source info (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnSwitchSourceInfo((String)message.obj, message.arg1, message.arg2);
                    return;
                }
                case 401: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "switch video source complete (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnSwitchSourceComplete((String)message.obj, message.arg1, message.arg2);
                    return;
                }
                case 402: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "switch video source failed (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnSwitchSourceFailed((String)message.obj, message.arg1, message.arg2);
                    return;
                }
                case 500: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "record video info (" + message.arg1 + "," + message.arg2 + ")");
                    imgoMediaPlayerLib.notifyOnRecordVideoInfo(message.arg1, message.arg2);
                    return;
                }
                case 501: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "record video error (" + message.arg1 + "," + message.arg2 + ")");
                    imgoMediaPlayerLib.notifyOnRecordVideoErr(message.arg1, message.arg2);
                    return;
                }
                case 600: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "loop switch video source info (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnLoopSwitchSourceInfo((String)message.obj, message.arg1, message.arg2);
                    return;
                }
                case 601: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "loop switch video source complete (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnLoopSwitchSourceComplete((String)message.obj, message.arg1, message.arg2);
                    return;
                }
                case 602: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "loop switch video source fail (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnLoopSwitchSourceFail((String)message.obj, message.arg1, message.arg2);
                    return;
                }
                case 603: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "smooth switch video source info (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnSmoothSwitchSourceInfo(message.arg1, message.arg2, (String)message.obj);
                    return;
                }
                case 604: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "smooth switch video source complete (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnSmoothSwitchSourceComplete(message.arg1, message.arg2, (String)message.obj);
                    return;
                }
                case 605: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "smooth switch video source failed (" + message.arg1 + "," + message.arg2 + "," + message.obj + ")");
                    imgoMediaPlayerLib.notifyOnSmoothSwitchSourceFailed(message.arg1, message.arg2, (String)message.obj);
                    return;
                }
                case 201: {
                    imgoMediaPlayerLib.notifyOnInfoString(message.arg1, (String)message.obj);
                    return;
                }
                case 210: {
                    byte[] byArray = (byte[])message.obj;
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "MEDIA_INFO_DRM in" + byArray);
                    Map<UUID, CencDrmTools.PSSH> map = CencDrmTools.parsePSSH(byArray);
                    imgoMediaPlayerLib.notifyOnDrmPsshMap(map);
                    return;
                }
                case 700: {
                    imgoMediaPlayerLib.notifyOnGetFrameImageStatus(message.arg1, message.arg2);
                    return;
                }
                case 701: {
                    imgoMediaPlayerLib.notifyOnGetFrameImageInfo(message.arg1, message.arg2, (String)message.obj);
                    return;
                }
                default: {
                    DebugLog.d(imgoMediaPlayerLib.getLogTag(), "Unknown message type " + message.what);
                    return;
                }
            }
        }
    }
}

