/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.libnative;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import com.hunantv.media.player.helper.MediaCodecHelp;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.utils.StringUtil;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MgtvMediaCodec {
    private static final String TAG = "MgtvMediaCodec";
    private static final int MAX_WAITING_TIME_MS = 1000;
    private MediaCodec mMediaCodec;
    private String mCodecName;
    private static final int STATUS_OK = 0;
    private static final int STATUS_TIMEOUT = 1;
    private volatile int mFlushStatus = 0;
    private static final String OPPO_SR_ENABLE_KEY = "vendor.oplus-sr-enable.value";
    private static final String OPPO_OSIE_ENABLE_KEY = "vendor.oplus-osie-enable.value";

    public static MgtvMediaCodec createByCodecName(String string) throws IOException, NullPointerException {
        MediaCodec mediaCodec = null;
        if (!StringUtil.isEmpty(string) && MediaCodecHelp.sCreateCodecBlackList.contains(string)) {
            DebugLog.e(TAG, "createByCodecName:" + string + " already in blacklist");
            mediaCodec = null;
        } else {
            DebugLog.d(TAG, "createByCodecName:" + string + " not in blacklist.try create");
            CreateCodecRunnable createCodecRunnable = new CreateCodecRunnable(string);
            Thread thread = new Thread(createCodecRunnable);
            thread.setName("mgtvmp_jMCCre");
            thread.start();
            try {
                thread.join(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            mediaCodec = createCodecRunnable.getMediaCodec();
            if (mediaCodec == null) {
                createCodecRunnable.release();
            }
        }
        return new MgtvMediaCodec(mediaCodec, string);
    }

    private MgtvMediaCodec(MediaCodec mediaCodec, String string) throws NullPointerException {
        if (mediaCodec == null) {
            throw new NullPointerException("MediaCodec is NULL");
        }
        this.mMediaCodec = mediaCodec;
        this.mCodecName = string;
    }

    public void configure(MediaFormat mediaFormat, Surface surface, MediaCrypto mediaCrypto, int n2) {
        this.mMediaCodec.configure(mediaFormat, surface, mediaCrypto, n2);
    }

    public final MediaFormat getOutputFormat() {
        return this.mMediaCodec.getOutputFormat();
    }

    public ByteBuffer[] getInputBuffers() {
        return this.mMediaCodec.getInputBuffers();
    }

    @TargetApi(value=21)
    public ByteBuffer getInputBuffer(int n2) {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        return this.mMediaCodec.getInputBuffer(n2);
    }

    public ByteBuffer[] getOutputBuffers() {
        return this.mMediaCodec.getOutputBuffers();
    }

    @TargetApi(value=21)
    public ByteBuffer getOutputBuffer(int n2) {
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        return this.mMediaCodec.getOutputBuffer(n2);
    }

    public final int dequeueInputBuffer(long l2) {
        return this.mMediaCodec.dequeueInputBuffer(l2);
    }

    public final void queueInputBuffer(int n2, int n3, int n4, long l2, int n5) {
        this.mMediaCodec.queueInputBuffer(n2, n3, n4, l2, n5);
    }

    public final void queueSecureInputBuffer(int n2, int n3, MediaCodec.CryptoInfo cryptoInfo, long l2, int n4) {
        this.mMediaCodec.queueSecureInputBuffer(n2, n3, cryptoInfo, l2, n4);
    }

    public final int dequeueOutputBuffer(MediaCodec.BufferInfo bufferInfo, long l2) {
        return this.mMediaCodec.dequeueOutputBuffer(bufferInfo, l2);
    }

    public final void releaseOutputBuffer(int n2, boolean bl) {
        this.mMediaCodec.releaseOutputBuffer(n2, bl);
    }

    public final void start() {
        this.mMediaCodec.start();
    }

    public final void stop() {
        this.mMediaCodec.stop();
    }

    public final synchronized void flush() {
        if (this.mFlushStatus != 0 || MediaCodecHelp.sFlushCodecBlackList.contains(this.mCodecName)) {
            throw new IllegalStateException("flush timeout");
        }
        FlushRunnable flushRunnable = new FlushRunnable(this.mMediaCodec);
        Thread thread = new Thread(flushRunnable);
        thread.setName("mgtvmp_jMCFlush");
        thread.start();
        try {
            thread.join(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (flushRunnable.isFlushing) {
            this.mFlushStatus = 1;
            if (!StringUtil.isEmpty(this.mCodecName)) {
                MediaCodecHelp.sFlushCodecBlackList.add(this.mCodecName);
            }
            DebugLog.i(TAG, "flush add into blacklist");
            throw new IllegalStateException("flush timeout");
        }
    }

    public int getFlushStatus() {
        return this.mFlushStatus;
    }

    public final void release() {
        DebugLog.i(TAG, "release in");
        this.mMediaCodec.release();
        DebugLog.i(TAG, "release out");
    }

    @TargetApi(value=19)
    public void setParameters(Bundle bundle) {
        DebugLog.i(TAG, "setParameters oppo_sr:" + bundle.getInt(OPPO_SR_ENABLE_KEY, -1));
        DebugLog.i(TAG, "setParameters oppo_osie:" + bundle.getInt(OPPO_OSIE_ENABLE_KEY, -1));
        this.mMediaCodec.setParameters(bundle);
    }

    private static class FlushRunnable
    implements Runnable {
        private MediaCodec mMediaCodec;
        private volatile boolean isFlushing;

        public FlushRunnable(MediaCodec mediaCodec) {
            this.mMediaCodec = mediaCodec;
            this.isFlushing = true;
        }

        @Override
        public void run() {
            try {
                this.mMediaCodec.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isFlushing = false;
        }

        public boolean isFlushing() {
            return this.isFlushing;
        }
    }

    private static class CreateCodecRunnable
    implements Runnable {
        private String mName;
        private volatile MediaCodec mMediaCodec;
        private boolean mReleased;

        public CreateCodecRunnable(String string) {
            this.mName = string;
        }

        @Override
        public void run() {
            try {
                DebugLog.i(MgtvMediaCodec.TAG, "createByCodecName:" + this.mName + " IN");
                this.mMediaCodec = MediaCodec.createByCodecName((String)this.mName);
                DebugLog.i(MgtvMediaCodec.TAG, "createByCodecName:" + this.mName + " OUT");
                if (this.mReleased) {
                    DebugLog.i(MgtvMediaCodec.TAG, "createByCodecName:" + this.mName + " already in released status.release in");
                    this.mMediaCodec.release();
                    DebugLog.i(MgtvMediaCodec.TAG, "createByCodecName:" + this.mName + " already in released status.release out");
                    this.mMediaCodec = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                boolean bl;
                if (!StringUtil.isEmpty(this.mName) && (bl = MediaCodecHelp.sCreateCodecBlackList.remove(this.mName))) {
                    DebugLog.i(MgtvMediaCodec.TAG, "createByCodecName:" + this.mName + " remove from blacklist");
                }
            }
        }

        public MediaCodec getMediaCodec() {
            return this.mMediaCodec;
        }

        public void release() {
            this.mReleased = true;
            if (!StringUtil.isEmpty(this.mName)) {
                DebugLog.i(MgtvMediaCodec.TAG, "createByCodecName:" + this.mName + " put into blacklist");
                MediaCodecHelp.sCreateCodecBlackList.add(this.mName);
            }
        }
    }
}

