/*
 * Decompiled with CFR 0.152.
 */
package com.hunantv.media.player.loader;

import android.content.Context;
import com.hunantv.media.player.loader.b;
import com.hunantv.media.player.loader.c;
import com.hunantv.media.player.pragma.DebugLog;
import com.hunantv.media.player.pragma.PlayerConfig;
import com.hunantv.media.player.utils.StringUtil;
import com.hunantv.media.player.utils.SystemUtil;
import java.io.File;

public class ImgoLibLoader {
    private static final String TAG = "ImgoLibLoader";
    private static final String LIB_NAME_FFMEPG = "ImgoFfmpeg";
    private static final String LIB_NAME_FFMEPG4 = "ImgoFfmpeg4";
    private static final String LIB_NAME_HELP = "ImgoHelp";
    private static final String LIB_NAME_DS = "Imgods";
    private static final String LIB_NAME_WANOS_DECODER = "wanosdecoder";
    private static final String LIB_NAME_WANOS_VIRTUAL = "wanosvirtual";
    private static final String LIB_NAME_PLAYER_PRE = "ImgoMediaPlayer_";
    private static final String LIB_NAME_PLAYER_NODRM_PRE = "ImgoMediaPlayer_nodrm_";
    private static final String LIB_NAME_PLAYER_NODS_PRE = "ImgoMediaPlayer_nods_";
    private static final String LIB_NAME_PLAYER_DRM_PRE = "ImgoMediaPlayer_drm_";
    private static final String LIB_NAME_CACHE = "ImgoCache";
    private static final String LIB_NAME_EXS = "Imgoexs";
    private static final String LIB_NAME_WASABI_DRM = "WasabiJni";
    private static final String LIB_NAME_CPP_SHARED = "c++_shared";
    private static final String LIB_NAME_IMGOVSR = "ImgoVsr";
    private static ImgoLibLoader sInstance;
    private volatile boolean mIsAllPlayerLibLoaded = false;
    private volatile boolean mIsHelpLibLoaded = false;
    private volatile boolean mIsDsLibLoaded = false;
    private volatile boolean mIsCacheLibLoaded = false;
    private volatile boolean mIsWanosDecoderLibLoaded = false;
    private volatile boolean mIsWanosVirtualLibLoaded = false;
    private volatile boolean mIsFFmpegLibLoaded = false;
    private volatile boolean mIsExsLibLoaded = false;
    private volatile boolean mIsWasabiDrmLibLoaded = false;
    private volatile boolean mIsCPPSharedLibLoaded = false;
    private volatile boolean mIsImgoVsrLibLoaded = false;
    private volatile boolean mIsPlayerLibLoaded = false;
    private volatile boolean mDsLibLoadError = false;
    private String mDsLibLoadErrorMsg;
    private boolean mDsLibLoadErrorMsgReport = false;
    private String mDrmLibLoadErrorMsg = "n";
    private String mWanosLibLoadErrorMsg = "n";
    private String mCPPSharedLibLoadErrorMsg = "n";
    private String mImgoVsrLibLoadErrorMsg = "n";
    private Object mSync = new Object();
    private boolean mIsBackUpLoaderSuccess = false;
    private String mBackUpLoaderSoMsg = "";
    private static IInjectorCallback sInjectorCallback;
    private static volatile String sInjectLibDirectory;

    public boolean isBackUpLoaderSuccess() {
        return this.mIsBackUpLoaderSuccess;
    }

    public void setBackUpLoaderSuccess(boolean bl) {
        this.mIsBackUpLoaderSuccess = bl;
    }

    public String getBackUpLoaderSoMsg() {
        return this.mBackUpLoaderSoMsg;
    }

    public static synchronized ImgoLibLoader getInstance() {
        if (sInstance == null) {
            sInstance = new ImgoLibLoader();
        }
        return sInstance;
    }

    private ImgoLibLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncTryLoadHelpLib(Context context) {
        Object object = this.mSync;
        synchronized (object) {
            try {
                this.tryLoadHelpLib(context);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncTryLoadFFmpegLib(Context context) {
        Object object = this.mSync;
        synchronized (object) {
            try {
                this.tryLoadFFmpegLib(context);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncTryLoadExsLib(Context context) {
        Object object = this.mSync;
        synchronized (object) {
            try {
                this.tryLoadExsLib(context);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncTryLoadPlayerLib(Context context) {
        Object object = this.mSync;
        synchronized (object) {
            try {
                this.tryLoadPlayerLib(context);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncTryLoadAllLibraries(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException {
        Object object = this.mSync;
        synchronized (object) {
            return this.tryLoadAllLibraries(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncTryLoadDrmLib(Context context) {
        Object object = this.mSync;
        synchronized (object) {
            try {
                this.tryLoadWasabiDrmLib(context);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private void tryLoadHelpLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsHelpLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_HELP);
            this.mIsHelpLibLoaded = true;
        }
    }

    private void tryLoadDsLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsDsLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_DS);
            this.mIsDsLibLoaded = true;
        }
    }

    private void tryLoadWanosDecoderLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsWanosDecoderLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_WANOS_DECODER);
            this.mIsWanosDecoderLibLoaded = true;
        }
    }

    private void tryLoadWanosVirtualLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsWanosVirtualLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_WANOS_VIRTUAL);
            this.mIsWanosVirtualLibLoaded = true;
        }
    }

    private void tryLoadCacheLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsCacheLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_CACHE);
            this.mIsCacheLibLoaded = true;
        }
    }

    private void tryLoadFFmpegLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        this.tryLoadFFmpeg20Lib(context);
    }

    private void tryLoadFFmpeg20Lib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsFFmpegLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_FFMEPG4);
            this.mIsFFmpegLibLoaded = true;
        }
    }

    private void tryLoadExsLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsExsLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_EXS);
            this.mIsExsLibLoaded = true;
        }
    }

    private void tryLoadWasabiDrmLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsWasabiDrmLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_WASABI_DRM);
            this.mIsWasabiDrmLibLoaded = true;
        }
    }

    private void tryLoadCPPSharedLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsCPPSharedLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_CPP_SHARED);
            this.mIsCPPSharedLibLoaded = true;
        }
    }

    private void tryLoadImgoVsrLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsImgoVsrLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, LIB_NAME_IMGOVSR);
            this.mIsImgoVsrLibLoaded = true;
        }
    }

    private void tryLoadPlayerLib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        this.tryLoadPlayer20Lib(context);
    }

    private void tryLoadPlayer20Lib(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsPlayerLibLoaded) {
            ImgoLibLoader.exLoadLibrary(context, "ImgoMediaPlayer_5.2.0");
            this.mIsPlayerLibLoaded = true;
        }
    }

    private boolean tryLoadAllLibraries(Context context) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        if (!this.mIsAllPlayerLibLoaded) {
            if (sInjectorCallback != null && sInjectLibDirectory == null) {
                sInjectLibDirectory = sInjectorCallback.onInjectLibDirectory();
            }
            this.tryLoadFFmpegLib(context);
            this.tryLoadHelpLib(context);
            this.tryLoadExsLib(context);
            try {
                this.tryLoadWanosDecoderLib(context);
                this.tryLoadWanosVirtualLib(context);
            }
            catch (Exception exception) {
                this.mWanosLibLoadErrorMsg = exception.getMessage();
            }
            catch (Error error) {
                this.mWanosLibLoadErrorMsg = error.getMessage();
            }
            catch (Throwable throwable) {
                this.mWanosLibLoadErrorMsg = throwable.getMessage();
            }
            this.tryLoadPlayerLib(context);
            this.mIsAllPlayerLibLoaded = true;
            if (sInjectorCallback != null) {
                String string = "libmediaplayer:" + PlayerConfig.getLibFullVersion();
                DebugLog.i(TAG, "onLoadedLibMeta libmediaplayer:" + PlayerConfig.getLibFullVersion());
                sInjectorCallback.onLoadedLibMeta(string);
            }
        }
        return this.mIsAllPlayerLibLoaded;
    }

    private static int mapID(String string) {
        if (string == null || string.trim().equals("")) {
            return 0;
        }
        if (string.startsWith(LIB_NAME_FFMEPG)) {
            return 100;
        }
        if (string.startsWith(LIB_NAME_HELP)) {
            return 101;
        }
        if (string.startsWith(LIB_NAME_DS)) {
            return 102;
        }
        if (string.startsWith(LIB_NAME_PLAYER_NODS_PRE)) {
            return 103;
        }
        if (string.startsWith(LIB_NAME_PLAYER_PRE)) {
            return 104;
        }
        if (string.startsWith(LIB_NAME_CACHE)) {
            return 105;
        }
        if (string.startsWith(LIB_NAME_PLAYER_NODRM_PRE)) {
            return 106;
        }
        if (string.startsWith(LIB_NAME_WANOS_DECODER)) {
            return 107;
        }
        if (string.startsWith(LIB_NAME_WANOS_VIRTUAL)) {
            return 108;
        }
        if (string.startsWith(LIB_NAME_WASABI_DRM)) {
            return 109;
        }
        return 0;
    }

    public static void setsInjectorCallback(IInjectorCallback iInjectorCallback) {
        sInjectorCallback = iInjectorCallback;
    }

    private static boolean isLegalFilePath(String string) throws SecurityException {
        if (string == null || "".equals(string.trim())) {
            return false;
        }
        File file = new File(string);
        return file.exists() && !file.isDirectory();
    }

    private static boolean preInjectLoad(String string, String string2) throws SecurityException, UnsatisfiedLinkError, NullPointerException {
        if (sInjectLibDirectory == null || sInjectLibDirectory.trim().isEmpty()) {
            return false;
        }
        File file = new File(sInjectLibDirectory);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        String string3 = file.getAbsolutePath() + "/" + string + "/" + System.mapLibraryName(string2);
        if (ImgoLibLoader.isLegalFilePath(string3)) {
            System.load(string3);
            DebugLog.i(TAG, "preInjectLoad load success:" + string3);
            return true;
        }
        DebugLog.i(TAG, "preInjectLoad load failed:" + string3);
        return false;
    }

    public static void exLoadLibrary(Context context, String string) throws UnsatisfiedLinkError, SecurityException, NullPointerException, c {
        DebugLog.i(TAG, "exLoadLibrary: " + string);
        String string2 = "";
        try {
            context.getApplicationInfo();
            if (ImgoLibLoader.preInjectLoad(SystemUtil.getPrimaryCpuAbi(context), string)) {
                return;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            string2 = string2 + "preInjectLoad UnsatisfiedLinkError " + b.a(unsatisfiedLinkError);
        }
        catch (Exception exception) {
            string2 = string2 + "preInjectLoad Exception " + b.a(exception);
        }
        catch (Throwable throwable) {
            string2 = string2 + "preInjectLoad Throwable " + b.a(throwable);
        }
        if (!StringUtil.isEmpty(string2)) {
            DebugLog.e(TAG, string2);
        }
        DebugLog.i(TAG, "no preInjectLoad,use System.loadLibrary");
        try {
            int n2 = b.a(context, string);
            if (n2 == 2) {
                ImgoLibLoader.getInstance().mIsBackUpLoaderSuccess = true;
                ImgoLibLoader.getInstance().mBackUpLoaderSoMsg = ImgoLibLoader.getInstance().mBackUpLoaderSoMsg + string + "_";
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new c(unsatisfiedLinkError.getMessage(), ImgoLibLoader.mapID(string));
        }
    }

    public boolean isAllPlayerLibLoaded() {
        return this.mIsAllPlayerLibLoaded;
    }

    public boolean isHelpLibLoaded() {
        return this.mIsHelpLibLoaded;
    }

    public boolean isDsLibLoaded() {
        return this.mIsDsLibLoaded;
    }

    public boolean isCacheLibLoaded() {
        return this.mIsCacheLibLoaded;
    }

    public boolean isFFmpegLibLoaded() {
        return this.mIsFFmpegLibLoaded;
    }

    public boolean isPlayerLibLoaded() {
        return this.mIsPlayerLibLoaded;
    }

    public boolean isDsLibLoadError() {
        return this.mDsLibLoadError;
    }

    public String getDsLibLoadErrorMsg() {
        return this.mDsLibLoadErrorMsg;
    }

    public boolean isDsLibLoadErrorMsgReport() {
        return this.mDsLibLoadErrorMsgReport;
    }

    public void setDsLibLoadErrorMsgReport(boolean bl) {
        this.mDsLibLoadErrorMsgReport = bl;
    }

    public String getDrmLibLoadErrorMsg() {
        return this.mDrmLibLoadErrorMsg;
    }

    public static interface IInjectorCallback {
        public String onInjectLibDirectory();

        public void onLoadedLibMeta(String var1);
    }
}

